/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.MessageBusImpl;
import io.questdb.Metrics;
import io.questdb.cairo.AlterTableContextException;
import io.questdb.cairo.AttachDetachStatus;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnIndexer;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.ColumnVersionWriter;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.IndexBuilder;
import io.questdb.cairo.LifecycleManager;
import io.questdb.cairo.MapWriter;
import io.questdb.cairo.O3Basket;
import io.questdb.cairo.O3CallbackJob;
import io.questdb.cairo.O3CopyJob;
import io.questdb.cairo.O3MutableAtomicInteger;
import io.questdb.cairo.O3OpenColumnJob;
import io.questdb.cairo.O3PartitionJob;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.SymbolColumnIndexer;
import io.questdb.cairo.SymbolMapDiff;
import io.questdb.cairo.SymbolMapDiffCursor;
import io.questdb.cairo.SymbolMapDiffEntry;
import io.questdb.cairo.SymbolMapWriter;
import io.questdb.cairo.SymbolValueCountCollector;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableSyncModel;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriterMetadata;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.TxWriter;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.cairo.WriterRowUtils;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.cairo.sql.ReaderOutOfDateException;
import io.questdb.cairo.vm.MemoryFCRImpl;
import io.questdb.cairo.vm.MemoryFMCRImpl;
import io.questdb.cairo.vm.NullMapWriter;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.cairo.vm.api.MemoryCMOR;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.cairo.vm.api.MemoryFR;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryMAR;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.vm.api.MemoryMAT;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.cairo.vm.api.NullMemory;
import io.questdb.griffin.DropIndexOperator;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.UpdateOperator;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SOCountDownLatch;
import io.questdb.mp.SOUnboundedCountDownLatch;
import io.questdb.mp.Sequence;
import io.questdb.std.BinarySequence;
import io.questdb.std.Chars;
import io.questdb.std.DirectLongList;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FindVisitor;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.LongIntHashMap;
import io.questdb.std.LongList;
import io.questdb.std.LongLongHashMap;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;
import io.questdb.std.ObjectPool;
import io.questdb.std.Os;
import io.questdb.std.ReadOnlyObjList;
import io.questdb.std.Sinkable;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.WeakClosableObjectPool;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.tasks.ColumnIndexerTask;
import io.questdb.tasks.O3CallbackTask;
import io.questdb.tasks.O3CopyTask;
import io.questdb.tasks.O3OpenColumnTask;
import io.questdb.tasks.O3PartitionTask;
import io.questdb.tasks.O3PartitionUpdateTask;
import io.questdb.tasks.TableWriterTask;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableWriter
implements Closeable {
    public static final int TIMESTAMP_MERGE_ENTRY_BYTES = 16;
    public static final int O3_BLOCK_NONE = -1;
    public static final int O3_BLOCK_O3 = 1;
    public static final int O3_BLOCK_DATA = 2;
    public static final int O3_BLOCK_MERGE = 3;
    private static final int ROW_ACTION_OPEN_PARTITION = 0;
    private static final int ROW_ACTION_NO_PARTITION = 1;
    private static final int ROW_ACTION_NO_TIMESTAMP = 2;
    private static final int ROW_ACTION_O3 = 3;
    private static final int ROW_ACTION_SWITCH_PARTITION = 4;
    private static final Log LOG = LogFactory.getLog(TableWriter.class);
    private static final Runnable NOOP = () -> {};
    private static final ObjectFactory<MemoryCMOR> GET_MEMORY_CMOR = Vm::getMemoryCMOR;
    final ObjList<MemoryMA> columns;
    private final ObjList<MapWriter> symbolMapWriters;
    private final ObjList<MapWriter> denseSymbolMapWriters;
    private final ObjList<ColumnIndexer> indexers;
    private final ObjList<ColumnIndexer> denseIndexers = new ObjList();
    private final Path path;
    private final Path other;
    private final LongList rowValueIsNotNull = new LongList();
    private final Row regularRow = new RowImpl();
    private final int rootLen;
    private final MemoryMR metaMem;
    private final int partitionBy;
    private final LongList columnTops;
    private final FilesFacade ff;
    private final DateFormat partitionDirFmt;
    private final MemoryMAR ddlMem;
    private final int mkDirMode;
    private final int fileOperationRetryCount;
    private final String tableName;
    private final TableWriterMetadata metadata;
    private final CairoConfiguration configuration;
    private final LowerCaseCharSequenceIntHashMap validationMap = new LowerCaseCharSequenceIntHashMap();
    private final FragileCode RECOVER_FROM_META_RENAME_FAILURE = this::recoverFromMetaRenameFailure;
    private final SOCountDownLatch indexLatch = new SOCountDownLatch();
    private final LongList indexSequences = new LongList();
    private final TxReader slaveTxReader;
    private final MessageBus messageBus;
    private final MessageBus ownMessageBus;
    private final boolean parallelIndexerEnabled;
    private final PartitionBy.PartitionFloorMethod partitionFloorMethod;
    private final PartitionBy.PartitionCeilMethod partitionCeilMethod;
    private final int defaultCommitMode;
    private final int o3ColumnMemorySize;
    private final ObjList<Runnable> nullSetters;
    private final ObjList<O3CallbackTask> o3PendingCallbackTasks = new ObjList();
    private final SOUnboundedCountDownLatch o3DoneLatch = new SOUnboundedCountDownLatch();
    private final AtomicLong o3PartitionUpdRemaining = new AtomicLong();
    private final AtomicInteger o3ErrorCount = new AtomicInteger();
    private final MemoryMARW todoMem = Vm.getMARWInstance();
    private final TxWriter txWriter;
    private final LongList o3PartitionRemoveCandidates = new LongList();
    private final ObjectPool<O3MutableAtomicInteger> o3ColumnCounters = new ObjectPool<O3MutableAtomicInteger>(O3MutableAtomicInteger::new, 64);
    private final ObjectPool<O3Basket> o3BasketPool = new ObjectPool<O3Basket>(O3Basket::new, 64);
    private final TxnScoreboard txnScoreboard;
    private final StringSink fileNameSink = new StringSink();
    private final FindVisitor removePartitionDirectories = this::removePartitionDirectories0;
    private final FindVisitor removePartitionDirsNotAttached = this::removePartitionDirsNotAttached;
    private final RingQueue<O3PartitionUpdateTask> o3PartitionUpdateQueue;
    private final MPSequence o3PartitionUpdatePubSeq;
    private final SCSequence o3PartitionUpdateSubSeq;
    private final boolean o3QuickSortEnabled;
    private final LongConsumer appendTimestampSetter;
    private final MemoryMR indexMem = Vm.getMRInstance();
    private final MemoryFR slaveMetaMem = new MemoryFCRImpl();
    private final LongIntHashMap replPartitionHash = new LongIntHashMap();
    private final MemoryFMCRImpl slaveTxMemory = new MemoryFMCRImpl();
    private final LongLongHashMap cmdSequences = new LongLongHashMap();
    private final AlterOperation alterTableStatement = new AlterOperation();
    private final ColumnVersionWriter columnVersionWriter;
    private final Metrics metrics;
    private final RingQueue<TableWriterTask> commandQueue;
    private final SCSequence commandSubSeq;
    private final MPSequence commandPubSeq;
    private final WeakClosableObjectPool<MemoryCMOR> walColumnMemoryPool;
    private final ObjList<MemoryCMOR> walMappedColumns = new ObjList();
    private final IntList symbolRewriteMap = new IntList();
    private MemoryCMR attachMetaMem;
    private TableWriterMetadata attachMetadata;
    private ColumnVersionReader attachColumnVersionReader;
    private IndexBuilder attachIndexBuilder;
    private TxReader attachTxReader;
    private long attachMinTimestamp;
    private long attachMaxTimestamp;
    private ObjList<Runnable> o3NullSetters;
    private ObjList<Runnable> o3NullSetters2;
    private ObjList<MemoryCARW> o3MemColumns;
    private ObjList<MemoryCARW> o3MemColumns2;
    private ReadOnlyObjList<? extends MemoryCR> o3Columns;
    private final O3ColumnUpdateMethod oooSortVarColumnRef = this::o3SortVarColumn;
    private final O3ColumnUpdateMethod oooSortFixColumnRef = this::o3SortFixColumn;
    private Row row = this.regularRow;
    private long todoTxn;
    private MemoryMAT o3TimestampMem;
    private final O3ColumnUpdateMethod o3MoveLagRef = this::o3MoveLag0;
    private MemoryARW o3TimestampMemCpy;
    private long lockFd = -1L;
    private LongConsumer timestampSetter;
    private int columnCount;
    private boolean avoidIndexOnCommit = false;
    private long partitionTimestampHi;
    private long masterRef = 0L;
    private long o3MasterRef = -1L;
    private boolean removeDirOnCancelRow = true;
    private long tempMem16b = Unsafe.malloc(16L, 26);
    private int metaSwapIndex;
    private int metaPrevIndex;
    private final FragileCode RECOVER_FROM_TODO_WRITE_FAILURE = this::recoverFromTodoWriteFailure;
    private final FragileCode RECOVER_FROM_SYMBOL_MAP_WRITER_FAILURE = this::recoverFromSymbolMapWriterFailure;
    private final FragileCode RECOVER_FROM_SWAP_RENAME_FAILURE = this::recoverFromSwapRenameFailure;
    private final FragileCode RECOVER_FROM_COLUMN_OPEN_FAILURE = this::recoverOpenColumnFailure;
    private int indexCount;
    private boolean performRecovery;
    private boolean distressed = false;
    private LifecycleManager lifecycleManager;
    private String designatedTimestampColumnName;
    private long o3RowCount;
    private final O3ColumnUpdateMethod o3MoveUncommittedRef = this::o3MoveUncommitted0;
    private long lastPartitionTimestamp;
    private boolean o3InError = false;
    private ObjList<? extends MemoryA> activeColumns;
    private ObjList<Runnable> activeNullSetters;
    private int rowAction = 0;
    private long committedMasterRef;
    private DirectLongList o3ColumnTopSink;
    private double commitIntervalFraction;
    private long commitIntervalDefault;
    private long commitInterval;
    private UpdateOperator updateOperator;
    private DropIndexOperator dropIndexOperator;

    public TableWriter(CairoConfiguration configuration, CharSequence tableName, MessageBus messageBus, MessageBus ownMessageBus, boolean lock, LifecycleManager lifecycleManager, CharSequence root, Metrics metrics) {
        LOG.info().$("open '").utf8(tableName).$('\'').$();
        this.configuration = configuration;
        this.metrics = metrics;
        this.ownMessageBus = ownMessageBus;
        this.messageBus = ownMessageBus != null ? ownMessageBus : messageBus;
        this.defaultCommitMode = configuration.getCommitMode();
        this.lifecycleManager = lifecycleManager;
        this.parallelIndexerEnabled = configuration.isParallelIndexingEnabled();
        this.ff = configuration.getFilesFacade();
        this.mkDirMode = configuration.getMkDirMode();
        this.fileOperationRetryCount = configuration.getFileOperationRetryCount();
        this.tableName = Chars.toString(tableName);
        this.o3QuickSortEnabled = configuration.isO3QuickSortEnabled();
        this.o3PartitionUpdateQueue = new RingQueue<O3PartitionUpdateTask>(O3PartitionUpdateTask.CONSTRUCTOR, configuration.getO3PartitionUpdateQueueCapacity());
        this.o3PartitionUpdatePubSeq = new MPSequence(this.o3PartitionUpdateQueue.getCycle());
        this.o3PartitionUpdateSubSeq = new SCSequence();
        this.o3PartitionUpdatePubSeq.then(this.o3PartitionUpdateSubSeq).then(this.o3PartitionUpdatePubSeq);
        this.o3ColumnMemorySize = configuration.getO3ColumnMemorySize();
        this.path = new Path().of(root).concat(tableName);
        this.other = new Path().of(root).concat(tableName);
        this.rootLen = this.path.length();
        try {
            if (lock) {
                this.lock();
            } else {
                this.lockFd = -1L;
            }
            long todoCount = this.openTodoMem();
            int todo = todoCount > 0L ? (int)this.todoMem.getLong(40L) : -1;
            if (todo == 2) {
                this.repairMetaRename((int)this.todoMem.getLong(48L));
            }
            this.ddlMem = Vm.getMARInstance();
            this.metaMem = Vm.getMRInstance();
            this.columnVersionWriter = TableWriter.openColumnVersionFile(this.ff, this.path, this.rootLen);
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
            this.metadata = new TableWriterMetadata(this.metaMem);
            this.partitionBy = this.metaMem.getInt(4L);
            this.txWriter = new TxWriter(this.ff).ofRW(this.path.concat("_txn").$(), this.partitionBy);
            this.txnScoreboard = new TxnScoreboard(this.ff, configuration.getTxnScoreboardEntryCount()).ofRW(this.path.trimTo(this.rootLen));
            this.path.trimTo(this.rootLen);
            switch (todo) {
                case 1: {
                    this.repairTruncate();
                    break;
                }
                case -1: 
                case 2: {
                    break;
                }
                default: {
                    LOG.error().$("ignoring unknown *todo* [code=").$(todo).I$();
                }
            }
            this.columnCount = this.metadata.getColumnCount();
            if (this.metadata.getTimestampIndex() > -1) {
                this.designatedTimestampColumnName = this.metadata.getColumnName(this.metadata.getTimestampIndex());
            }
            this.rowValueIsNotNull.extendAndSet(this.columnCount, 0L);
            this.columns = new ObjList(this.columnCount * 2);
            this.o3MemColumns = new ObjList(this.columnCount * 2);
            this.o3MemColumns2 = new ObjList(this.columnCount * 2);
            this.o3Columns = this.o3MemColumns;
            this.activeColumns = this.columns;
            this.symbolMapWriters = new ObjList(this.columnCount);
            this.indexers = new ObjList(this.columnCount);
            this.denseSymbolMapWriters = new ObjList(this.metadata.getSymbolMapCount());
            this.nullSetters = new ObjList(this.columnCount);
            this.o3NullSetters = new ObjList(this.columnCount);
            this.o3NullSetters2 = new ObjList(this.columnCount);
            this.activeNullSetters = this.nullSetters;
            this.columnTops = new LongList(this.columnCount);
            this.partitionFloorMethod = PartitionBy.getPartitionFloorMethod(this.partitionBy);
            this.partitionCeilMethod = PartitionBy.getPartitionCeilMethod(this.partitionBy);
            if (PartitionBy.isPartitioned(this.partitionBy)) {
                this.partitionDirFmt = PartitionBy.getPartitionDirFormatMethod(this.partitionBy);
                this.partitionTimestampHi = this.txWriter.getLastPartitionTimestamp();
            } else {
                this.partitionDirFmt = null;
            }
            this.commitInterval = this.calculateCommitInterval();
            this.configureColumnMemory();
            this.configureTimestampSetter();
            this.appendTimestampSetter = this.timestampSetter;
            this.configureAppendPosition();
            this.purgeUnusedPartitions();
            this.clearTodoLog();
            this.slaveTxReader = new TxReader(this.ff);
            this.commandQueue = new RingQueue<TableWriterTask>(TableWriterTask::new, configuration.getWriterCommandQueueSlotSize(), configuration.getWriterCommandQueueCapacity(), 17);
            this.commandSubSeq = new SCSequence();
            this.commandPubSeq = new MPSequence(this.commandQueue.getCycle());
            this.commandPubSeq.then(this.commandSubSeq).then(this.commandPubSeq);
            this.walColumnMemoryPool = new WeakClosableObjectPool<MemoryCMOR>(GET_MEMORY_CMOR, this.columnCount);
        }
        catch (Throwable e) {
            this.doClose(false);
            throw e;
        }
    }

    public TableWriter(CairoConfiguration configuration, CharSequence tableName, Metrics metrics) {
        this(configuration, tableName, null, new MessageBusImpl(configuration), true, DefaultLifecycleManager.INSTANCE, configuration.getRoot(), metrics);
    }

    public TableWriter(CairoConfiguration configuration, CharSequence tableName, @NotNull MessageBus messageBus, Metrics metrics) {
        this(configuration, tableName, messageBus, true, DefaultLifecycleManager.INSTANCE, metrics);
    }

    TableWriter(CairoConfiguration configuration, CharSequence tableName, @NotNull MessageBus messageBus, boolean lock, LifecycleManager lifecycleManager, Metrics metrics) {
        this(configuration, tableName, messageBus, null, lock, lifecycleManager, configuration.getRoot(), metrics);
    }

    public static int getPrimaryColumnIndex(int index) {
        return index * 2;
    }

    public static int getSecondaryColumnIndex(int index) {
        return TableWriter.getPrimaryColumnIndex(index) + 1;
    }

    public static long getTimestampIndexValue(long timestampIndex, long indexRow) {
        return Unsafe.getUnsafe().getLong(timestampIndex + indexRow * 16L);
    }

    public void addColumn(CharSequence name, int type) {
        this.checkColumnName(name);
        this.addColumn(name, type, this.configuration.getDefaultSymbolCapacity(), this.configuration.getDefaultSymbolCacheFlag(), false, 0, false);
    }

    public void addColumn(CharSequence name, int type, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isSequential) {
        assert (indexValueBlockCapacity == Numbers.ceilPow2(indexValueBlockCapacity)) : "power of 2 expected";
        assert (symbolCapacity == Numbers.ceilPow2(symbolCapacity)) : "power of 2 expected";
        this.checkDistressed();
        this.checkColumnName(name);
        if (TableWriter.getColumnIndexQuiet(this.metaMem, name, this.columnCount) != -1) {
            throw CairoException.duplicateColumn(name);
        }
        this.commit();
        long columnNameTxn = this.getTxn();
        LOG.info().$("adding column '").utf8(name).$('[').$(ColumnType.nameOf(type)).$("], name txn ").$(columnNameTxn).$(" to ").$(this.path).$();
        this.metaSwapIndex = this.addColumnToMeta(name, type, isIndexed, indexValueBlockCapacity, isSequential);
        this.metaMem.close();
        this.validateSwapMeta(name);
        this.renameMetaToMetaPrev(name);
        this.writeRestoreMetaTodo(name);
        this.renameSwapMetaToMeta(name);
        if (ColumnType.isSymbol(type)) {
            try {
                this.createSymbolMapWriter(name, columnNameTxn, symbolCapacity, symbolCacheFlag);
            }
            catch (CairoException e) {
                this.runFragile(this.RECOVER_FROM_SYMBOL_MAP_WRITER_FAILURE, name, e);
            }
        } else {
            this.symbolMapWriters.extendAndSet(this.columnCount, NullMapWriter.INSTANCE);
        }
        this.configureColumn(type, isIndexed, this.columnCount);
        if (isIndexed) {
            this.populateDenseIndexerList();
        }
        ++this.columnCount;
        int columnIndex = this.columnCount - 1;
        this.columnTops.extendAndSet(columnIndex, this.txWriter.getTransientRowCount());
        this.columnVersionWriter.upsertDefaultTxnName(columnIndex, columnNameTxn, this.txWriter.getLastPartitionTimestamp());
        if (this.txWriter.getTransientRowCount() > 0L || !PartitionBy.isPartitioned(this.partitionBy)) {
            try {
                this.openNewColumnFiles(name, isIndexed, indexValueBlockCapacity);
            }
            catch (CairoException e) {
                this.runFragile(this.RECOVER_FROM_COLUMN_OPEN_FAILURE, name, e);
            }
        }
        try {
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
            this.clearTodoLog();
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        this.bumpStructureVersion();
        this.metadata.addColumn(name, this.configuration.getRandom().nextLong(), type, isIndexed, indexValueBlockCapacity, columnIndex);
        LOG.info().$("ADDED column '").utf8(name).$('[').$(ColumnType.nameOf(type)).$("], name txn ").$(columnNameTxn).$(" to ").$(this.path).$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndex(CharSequence columnName, int indexValueBlockSize) {
        assert (indexValueBlockSize == Numbers.ceilPow2(indexValueBlockSize)) : "power of 2 expected";
        this.checkDistressed();
        int columnIndex = TableWriter.getColumnIndexQuiet(this.metaMem, columnName, this.columnCount);
        if (columnIndex == -1) {
            throw CairoException.nonCritical().put("column '").put(columnName).put("' does not exist");
        }
        this.commit();
        if (TableUtils.isColumnIndexed(this.metaMem, columnIndex)) {
            throw CairoException.nonCritical().put("already indexed [column=").put(columnName).put(']');
        }
        int existingType = TableUtils.getColumnType(this.metaMem, columnIndex);
        LOG.info().$("adding index to '").utf8(columnName).$('[').$(ColumnType.nameOf(existingType)).$(", path=").$(this.path).I$();
        if (!ColumnType.isSymbol(existingType)) {
            LOG.error().$("cannot create index for [column='").utf8(columnName).$(", type=").$(ColumnType.nameOf(existingType)).$(", path=").$(this.path).I$();
            throw CairoException.nonCritical().put("cannot create index for [column='").put(columnName).put(", type=").put(ColumnType.nameOf(existingType)).put(", path=").put(this.path).put(']');
        }
        SymbolColumnIndexer indexer = new SymbolColumnIndexer();
        long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(this.txWriter.getLastPartitionTimestamp(), columnIndex);
        try {
            try {
                if (PartitionBy.isPartitioned(this.partitionBy)) {
                    this.indexHistoricPartitions(indexer, columnName, indexValueBlockSize);
                    long timestamp = this.txWriter.getMaxTimestamp();
                    if (timestamp != Long.MIN_VALUE) {
                        this.path.trimTo(this.rootLen);
                        this.setStateForTimestamp(this.path, timestamp, false);
                        this.indexLastPartition(indexer, columnName, columnNameTxn, columnIndex, indexValueBlockSize);
                    }
                } else {
                    this.setStateForTimestamp(this.path, 0L, false);
                    this.indexLastPartition(indexer, columnName, columnNameTxn, columnIndex, indexValueBlockSize);
                }
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
        catch (Throwable e) {
            LOG.error().$("rolling back index created so far [path=").$(this.path).I$();
            this.removeIndexFiles(columnName, columnIndex);
            throw e;
        }
        this.metaSwapIndex = this.copyMetadataAndSetIndexAttrs(columnIndex, 1, indexValueBlockSize);
        this.swapMetaFile(columnName);
        this.indexers.extendAndSet(columnIndex, indexer);
        this.populateDenseIndexerList();
        TableColumnMetadata columnMetadata = this.metadata.getColumnQuick(columnIndex);
        columnMetadata.setIndexed(true);
        columnMetadata.setIndexValueBlockCapacity(indexValueBlockSize);
        LOG.info().$("ADDED index to '").utf8(columnName).$('[').$(ColumnType.nameOf(existingType)).$("]' to ").$(this.path).$();
    }

    public void addPhysicallyWrittenRows(long rows) {
        this.metrics.tableWriter().addPhysicallyWrittenRows(rows);
    }

    public AttachDetachStatus attachPartition(long timestamp) {
        return this.attachPartition(timestamp, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AttachDetachStatus attachPartition(long timestamp, long partitionSize) {
        assert (this.metadata.getTimestampIndex() > -1);
        if (this.txWriter.attachedPartitionsContains(timestamp)) {
            LOG.info().$("partition is already attached [path=").$(this.path).I$();
            return AttachDetachStatus.ATTACH_ERR_PARTITION_EXISTS;
        }
        if (this.inTransaction()) {
            LOG.info().$("committing open transaction before applying attach partition command [table=").$(this.tableName).$(", partition=").$ts(timestamp).I$();
            this.commit();
            if (this.txWriter.attachedPartitionsContains(timestamp)) {
                LOG.info().$("partition is already attached [path=").$(this.path).I$();
                return AttachDetachStatus.ATTACH_ERR_PARTITION_EXISTS;
            }
        }
        TableUtils.setPathForPartition(this.path.trimTo(this.rootLen), this.partitionBy, timestamp, false);
        TableUtils.txnPartitionConditionally(this.path, this.getTxn());
        this.path.slash$();
        if (this.ff.exists(this.path)) {
            return AttachDetachStatus.ATTACH_ERR_DIR_EXISTS;
        }
        Path detachedPath = Path.PATH.get().of(this.configuration.getRoot()).concat(this.tableName);
        TableUtils.setPathForPartition(detachedPath, this.partitionBy, timestamp, false);
        detachedPath.put(this.configuration.getAttachPartitionSuffix()).slash$();
        int detachedRootLen = detachedPath.length();
        boolean validateDataFiles = partitionSize < 0L;
        boolean checkPassed = false;
        try {
            if (this.ff.exists(detachedPath)) {
                String timestampColName = this.metadata.getColumnQuick(this.metadata.getTimestampIndex()).getName();
                if (partitionSize > -1L) {
                    this.readPartitionMinMax(this.ff, timestamp, detachedPath.trimTo(detachedRootLen), timestampColName, partitionSize);
                } else {
                    partitionSize = this.readPartitionSizeMinMax(this.ff, timestamp, detachedPath.trimTo(detachedRootLen), timestampColName);
                }
                if (partitionSize < 1L) {
                    AttachDetachStatus attachDetachStatus = AttachDetachStatus.ATTACH_ERR_EMPTY_PARTITION;
                    return attachDetachStatus;
                }
                if (validateDataFiles && !this.attachPrepare(timestamp, partitionSize, detachedPath, detachedRootLen)) {
                    this.attachValidateMetadata(partitionSize, detachedPath.trimTo(detachedRootLen), timestamp);
                }
                if (validateDataFiles && this.configuration.attachPartitionCopy()) {
                    if (this.ff.copyRecursive(detachedPath.trimTo(detachedRootLen), this.path, this.configuration.getMkDirMode()) != 0) {
                        LOG.error().$("could not copy [errno=").$(this.ff.errno()).$(", from=").$(detachedPath).$(", to=").$(this.path).I$();
                        AttachDetachStatus attachDetachStatus = AttachDetachStatus.ATTACH_ERR_COPY;
                        return attachDetachStatus;
                    }
                    LOG.info().$("copied partition dir [from=").$(detachedPath).$(", to=").$(this.path).I$();
                } else {
                    if (this.ff.rename(detachedPath.trimTo(detachedRootLen).$(), this.path.$()) != 0) {
                        LOG.error().$("could not rename [errno=").$(this.ff.errno()).$(", from=").$(detachedPath).$(", to=").$(this.path).I$();
                        AttachDetachStatus attachDetachStatus = AttachDetachStatus.ATTACH_ERR_RENAME;
                        return attachDetachStatus;
                    }
                    LOG.info().$("renamed partition dir [from=").$(detachedPath).$(", to=").$(this.path).I$();
                }
            } else {
                LOG.info().$("attach partition command failed, partition to attach does not exist [path=").$(detachedPath).I$();
                AttachDetachStatus timestampColName = AttachDetachStatus.ATTACH_ERR_MISSING_PARTITION;
                return timestampColName;
            }
            checkPassed = true;
        }
        finally {
            this.path.trimTo(this.rootLen);
            if (!checkPassed) {
                this.columnVersionWriter.readUnsafe();
            }
        }
        try {
            if (!$assertionsDisabled) {
                if (timestamp > this.attachMinTimestamp) throw new AssertionError();
                if (this.attachMinTimestamp > this.attachMaxTimestamp) {
                    throw new AssertionError();
                }
            }
            long nextMinTimestamp = Math.min(this.attachMinTimestamp, this.txWriter.getMinTimestamp());
            long nextMaxTimestamp = Math.max(this.attachMaxTimestamp, this.txWriter.getMaxTimestamp());
            boolean appendPartitionAttached = this.size() == 0L || this.getPartitionLo(nextMaxTimestamp) > this.getPartitionLo(this.txWriter.getMaxTimestamp());
            this.txWriter.beginPartitionSizeUpdate();
            this.txWriter.updatePartitionSizeByTimestamp(timestamp, partitionSize, this.getTxn());
            this.txWriter.finishPartitionSizeUpdate(nextMinTimestamp, nextMaxTimestamp);
            this.txWriter.bumpTruncateVersion();
            this.columnVersionWriter.commit();
            this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
            this.txWriter.commit(this.defaultCommitMode, this.denseSymbolMapWriters);
            LOG.info().$("partition attached [table=").$(this.tableName).$(", partition=").$ts(timestamp).I$();
            if (!appendPartitionAttached) return AttachDetachStatus.OK;
            LOG.info().$("switch partition after partition attach [tableName=").$(this.tableName).$(", partition=").$ts(timestamp).I$();
            this.freeColumns(true);
            this.configureAppendPosition();
            return AttachDetachStatus.OK;
        }
        catch (Throwable e) {
            LOG.critical().$("failed on attaching partition to the table and rolling back [tableName=").$(this.tableName).$(", error=").$(e).I$();
            this.rollback();
            throw e;
        }
    }

    public void changeCacheFlag(int columnIndex, boolean cache) {
        this.checkDistressed();
        this.commit();
        MapWriter symbolMapWriter = this.symbolMapWriters.getQuick(columnIndex);
        if (symbolMapWriter.isCached() == cache) {
            return;
        }
        symbolMapWriter.updateCacheFlag(cache);
        this.updateMetaStructureVersion();
    }

    public boolean checkScoreboardHasReadersBeforeLastCommittedTxn() {
        long lastCommittedTxn = this.txWriter.getTxn();
        try {
            if (this.txnScoreboard.acquireTxn(lastCommittedTxn)) {
                this.txnScoreboard.releaseTxn(lastCommittedTxn);
            }
        }
        catch (CairoException ex) {
            LOG.error().$("cannot lock last txn in scoreboard, partition purge will be scheduled [table=").$(this.tableName).$(", txn=").$(lastCommittedTxn).$(", error=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
        }
        return this.txnScoreboard.getMin() != lastCommittedTxn;
    }

    @Override
    public void close() {
        if (this.isOpen() && this.lifecycleManager.close()) {
            this.doClose(true);
        }
    }

    public void commit() {
        this.commit(this.defaultCommitMode);
    }

    public void commit(int commitMode) {
        this.commit(commitMode, 0L);
    }

    public void commitWithLag() {
        this.commit(this.defaultCommitMode, this.metadata.getCommitLag());
    }

    public void commitWithLag(long lagMicros) {
        this.commit(this.defaultCommitMode, lagMicros);
    }

    public void commitWithLag(int commitMode) {
        this.commit(commitMode, this.metadata.getCommitLag());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttachDetachStatus detachPartition(long timestamp) {
        long partitionNameTxn;
        block29: {
            int partitionIndex;
            assert (this.metadata.getTimestampIndex() > -1);
            assert (PartitionBy.isPartitioned(this.partitionBy));
            if (this.inTransaction()) {
                LOG.info().$("committing open transaction before applying detach partition command [table=").$(this.tableName).$(", partition=").$ts(timestamp).I$();
                this.commit();
            }
            if ((partitionIndex = this.txWriter.getPartitionIndex(timestamp)) == -1) {
                assert (!this.txWriter.attachedPartitionsContains(timestamp));
                return AttachDetachStatus.DETACH_ERR_MISSING_PARTITION;
            }
            long maxTimestamp = this.txWriter.getMaxTimestamp();
            if (timestamp == this.getPartitionLo(maxTimestamp)) {
                return AttachDetachStatus.DETACH_ERR_ACTIVE;
            }
            long minTimestamp = this.txWriter.getMinTimestamp();
            partitionNameTxn = this.txWriter.getPartitionNameTxn(partitionIndex);
            Path detachedPath = Path.PATH.get();
            try {
                TableUtils.setPathForPartition(this.path, this.rootLen, this.partitionBy, timestamp, partitionNameTxn);
                if (!this.ff.exists(this.path.$())) {
                    LOG.error().$("partition folder does not exist [path=").$(this.path).I$();
                    AttachDetachStatus attachDetachStatus = AttachDetachStatus.DETACH_ERR_MISSING_PARTITION_DIR;
                    return attachDetachStatus;
                }
                detachedPath.of(this.configuration.getRoot()).concat(this.tableName);
                int detachedRootLen = detachedPath.length();
                if (!this.ff.exists(detachedPath.slash$()) && 0 != this.ff.mkdirs(detachedPath, this.mkDirMode)) {
                    LOG.error().$("could no create detached partition folder [errno=").$(this.ff.errno()).$(", path=").$(detachedPath).I$();
                    AttachDetachStatus attachDetachStatus = AttachDetachStatus.DETACH_ERR_MKDIR;
                    return attachDetachStatus;
                }
                TableUtils.setPathForPartition(detachedPath.trimTo(detachedRootLen), this.partitionBy, timestamp, false);
                detachedPath.put(".detached").$();
                int detachedPathLen = detachedPath.length();
                if (this.ff.exists(detachedPath)) {
                    LOG.error().$("detached partition folder already exist [path=").$(detachedPath).I$();
                    AttachDetachStatus attachDetachStatus = AttachDetachStatus.DETACH_ERR_ALREADY_DETACHED;
                    return attachDetachStatus;
                }
                if (this.ff.hardLinkDirRecursive(this.path, detachedPath, this.mkDirMode) != 0) {
                    if (this.ff.isCrossDeviceCopyError(this.ff.errno())) {
                        if (this.ff.copyRecursive(this.path, detachedPath, this.mkDirMode) != 0) {
                            LOG.critical().$("could not copy detached partition [errno=").$(this.ff.errno()).$(", from=").$(this.path).$(", to=").$(detachedPath).I$();
                            AttachDetachStatus attachDetachStatus = AttachDetachStatus.DETACH_ERR_COPY;
                            return attachDetachStatus;
                        }
                    } else {
                        LOG.critical().$("could not create hard link to detached partition [errno=").$(this.ff.errno()).$(", from=").$(this.path).$(", to=").$(detachedPath).I$();
                        AttachDetachStatus attachDetachStatus = AttachDetachStatus.DETACH_ERR_HARD_LINK;
                        return attachDetachStatus;
                    }
                }
                this.other.of(this.path).trimTo(this.rootLen).concat("_meta").$();
                detachedPath.trimTo(detachedPathLen).concat("_meta").$();
                AttachDetachStatus attachDetachStatus = AttachDetachStatus.OK;
                if (-1 == this.copyOverwrite(detachedPath)) {
                    attachDetachStatus = AttachDetachStatus.DETACH_ERR_COPY_META;
                    LOG.critical().$("could not copy [errno=").$(this.ff.errno()).$(", from=").$(this.other).$(", to=").$(detachedPath).I$();
                } else {
                    this.other.parent().concat("_cv").$();
                    detachedPath.parent().concat("_cv").$();
                    if (-1 == this.copyOverwrite(detachedPath)) {
                        attachDetachStatus = AttachDetachStatus.DETACH_ERR_COPY_META;
                        LOG.critical().$("could not copy [errno=").$(this.ff.errno()).$(", from=").$(this.other).$(", to=").$(detachedPath).I$();
                    } else {
                        this.other.parent().concat("_txn").$();
                        detachedPath.parent().concat("_txn").$();
                        if (-1 == this.copyOverwrite(detachedPath)) {
                            attachDetachStatus = AttachDetachStatus.DETACH_ERR_COPY_META;
                            LOG.critical().$("could not copy [errno=").$(this.ff.errno()).$(", from=").$(this.other).$(", to=").$(detachedPath).I$();
                        }
                    }
                }
                if (attachDetachStatus == AttachDetachStatus.OK) {
                    long nextMinTimestamp = minTimestamp;
                    if (timestamp == this.txWriter.getPartitionTimestamp(0)) {
                        this.other.parent();
                        nextMinTimestamp = this.readMinTimestamp(this.txWriter.getPartitionTimestamp(1));
                    }
                    this.txWriter.beginPartitionSizeUpdate();
                    this.txWriter.removeAttachedPartitions(timestamp);
                    this.txWriter.setMinTimestamp(nextMinTimestamp);
                    this.txWriter.finishPartitionSizeUpdate(nextMinTimestamp, this.txWriter.getMaxTimestamp());
                    this.txWriter.bumpTruncateVersion();
                    this.columnVersionWriter.removePartition(timestamp);
                    this.columnVersionWriter.commit();
                    this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
                    this.txWriter.commit(this.defaultCommitMode, this.denseSymbolMapWriters);
                    break block29;
                }
                detachedPath.trimTo(detachedPathLen).slash().$();
                if (this.ff.rmdir(detachedPath) != 0) {
                    LOG.error().$("could not rollback detached copy (rmdir) [errno=").$(this.ff.errno()).$(", undo=").$(detachedPath).$(", original=").$(this.path).I$();
                }
                AttachDetachStatus attachDetachStatus2 = attachDetachStatus;
                return attachDetachStatus2;
            }
            finally {
                this.path.trimTo(this.rootLen);
                this.other.trimTo(this.rootLen);
            }
        }
        this.safeDeletePartitionDir(timestamp, partitionNameTxn);
        return AttachDetachStatus.OK;
    }

    public void dropIndex(CharSequence columnName) {
        this.checkDistressed();
        int columnIndex = TableWriter.getColumnIndexQuiet(this.metaMem, columnName, this.columnCount);
        if (columnIndex == -1) {
            throw CairoException.invalidMetadata("Column does not exist", columnName);
        }
        if (!TableUtils.isColumnIndexed(this.metaMem, columnIndex)) {
            throw CairoException.invalidMetadata("Column is not indexed", columnName);
        }
        int defaultIndexValueBlockSize = Numbers.ceilPow2(this.configuration.getIndexValueBlockSize());
        if (this.inTransaction()) {
            LOG.info().$("committing current transaction before DROP INDEX execution [txn=").$(this.txWriter.getTxn()).$(", table=").$(this.tableName).$(", column=").$(columnName).I$();
            this.commit();
        }
        try {
            LOG.info().$("BEGIN DROP INDEX [txn=").$(this.txWriter.getTxn()).$(", table=").$(this.tableName).$(", column=").$(columnName).I$();
            if (this.dropIndexOperator == null) {
                this.dropIndexOperator = new DropIndexOperator(this.configuration, this.messageBus, this, this.path, this.other, this.rootLen);
            }
            this.dropIndexOperator.executeDropIndex(columnName, columnIndex);
            this.metaSwapIndex = this.copyMetadataAndSetIndexAttrs(columnIndex, 0, defaultIndexValueBlockSize);
            this.swapMetaFile(columnName);
            TableColumnMetadata columnMetadata = this.metadata.getColumnQuick(columnIndex);
            columnMetadata.setIndexed(false);
            columnMetadata.setIndexValueBlockCapacity(defaultIndexValueBlockSize);
            ColumnIndexer columnIndexer = this.indexers.getQuick(columnIndex);
            if (columnIndexer != null) {
                this.indexers.setQuick(columnIndex, null);
                Misc.free(columnIndexer);
                this.populateDenseIndexerList();
            }
            this.dropIndexOperator.purgeOldColumnVersions();
            LOG.info().$("END DROP INDEX [txn=").$(this.txWriter.getTxn()).$(", table=").$(this.tableName).$(", column=").$(columnName).I$();
        }
        catch (Throwable e) {
            throw CairoException.critical(0).put("Cannot DROP INDEX for [txn=").put(this.txWriter.getTxn()).put(", table=").put(this.tableName).put(", column=").put(columnName).put("]: ").put(e.getMessage());
        }
    }

    public int getColumnIndex(CharSequence name) {
        int index = this.metadata.getColumnIndexQuiet(name);
        if (index > -1) {
            return index;
        }
        throw CairoException.critical(0).put("column '").put(name).put("' does not exist");
    }

    public long getColumnNameTxn(long partitionTimestamp, int columnIndex) {
        return this.columnVersionWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
    }

    public long getColumnTop(long partitionTimestamp, int columnIndex, long defaultValue) {
        long colTop = this.columnVersionWriter.getColumnTop(partitionTimestamp, columnIndex);
        return colTop > -1L ? colTop : defaultValue;
    }

    public long getCommitInterval() {
        return this.commitInterval;
    }

    public String getDesignatedTimestampColumnName() {
        return this.designatedTimestampColumnName;
    }

    public FilesFacade getFilesFacade() {
        return this.ff;
    }

    public long getMaxTimestamp() {
        return this.txWriter.getMaxTimestamp();
    }

    public TableWriterMetadata getMetadata() {
        return this.metadata;
    }

    public long getO3RowCount() {
        return this.hasO3() ? this.getO3RowCount0() : 0L;
    }

    public int getPartitionBy() {
        return this.partitionBy;
    }

    public int getPartitionCount() {
        return this.txWriter.getPartitionCount();
    }

    public long getPartitionNameTxn(int partitionIndex) {
        return this.txWriter.getPartitionNameTxn(partitionIndex);
    }

    public long getPartitionSize(int partitionIndex) {
        if (partitionIndex == this.txWriter.getPartitionCount() - 1 || !PartitionBy.isPartitioned(this.partitionBy)) {
            return this.txWriter.getTransientRowCount();
        }
        return this.txWriter.getPartitionSize(partitionIndex);
    }

    public long getPartitionTimestamp(int partitionIndex) {
        return this.txWriter.getPartitionTimestamp(partitionIndex);
    }

    public long getRawMetaMemory() {
        return this.metaMem.getPageAddress(0);
    }

    public long getRawMetaMemorySize() {
        return this.metadata.getFileDataSize();
    }

    public long getRawTxnMemory() {
        return this.txWriter.unsafeGetRawMemory();
    }

    public long getRawTxnMemorySize() {
        return this.txWriter.unsafeGetRawMemorySize();
    }

    public long getRowCount() {
        return this.txWriter.getRowCount();
    }

    public long getStructureVersion() {
        return this.txWriter.getStructureVersion();
    }

    public int getSymbolIndexNoTransientCountUpdate(int columnIndex, CharSequence symValue) {
        return this.symbolMapWriters.getQuick(columnIndex).put(symValue, SymbolValueCountCollector.NOOP);
    }

    public MapWriter getSymbolMapWriter(int columnIndex) {
        return this.symbolMapWriters.getQuick(columnIndex);
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getTransientRowCount() {
        return this.txWriter.getTransientRowCount();
    }

    public long getTruncateVersion() {
        return this.txWriter.getTruncateVersion();
    }

    public long getTxn() {
        return this.txWriter.getTxn();
    }

    public TxnScoreboard getTxnScoreboard() {
        return this.txnScoreboard;
    }

    public long getUncommittedRowCount() {
        return this.masterRef - this.committedMasterRef >> 1;
    }

    public UpdateOperator getUpdateOperator() {
        if (this.updateOperator == null) {
            this.updateOperator = new UpdateOperator(this.configuration, this.messageBus, this, this.path, this.rootLen);
        }
        return this.updateOperator;
    }

    public boolean inTransaction() {
        return this.txWriter != null && (this.txWriter.inTransaction() || this.hasO3() || this.columnVersionWriter.hasChanges());
    }

    public boolean isOpen() {
        return this.tempMem16b != 0L;
    }

    public Row newRow(long timestamp) {
        switch (this.rowAction) {
            case 0: {
                if (timestamp < 0L) {
                    throw CairoException.nonCritical().put("timestamp before 1970-01-01 is not allowed");
                }
                if (this.txWriter.getMaxTimestamp() == Long.MIN_VALUE) {
                    this.txWriter.setMinTimestamp(timestamp);
                    this.openFirstPartition(timestamp);
                }
                this.rowAction = 4;
            }
            default: {
                this.bumpMasterRef();
                if (timestamp > this.partitionTimestampHi || timestamp < this.txWriter.getMaxTimestamp()) {
                    if (timestamp < this.txWriter.getMaxTimestamp()) {
                        return this.newRowO3(timestamp);
                    }
                    if (timestamp > this.partitionTimestampHi && PartitionBy.isPartitioned(this.partitionBy)) {
                        this.switchPartition(timestamp);
                    }
                }
                this.updateMaxTimestamp(timestamp);
                break;
            }
            case 1: {
                if (timestamp < 0L) {
                    throw CairoException.nonCritical().put("timestamp before 1970-01-01 is not allowed");
                }
                if (timestamp < this.txWriter.getMaxTimestamp()) {
                    throw CairoException.nonCritical().put("Cannot insert rows out of order to non-partitioned table. Table=").put(this.path);
                }
                this.bumpMasterRef();
                this.updateMaxTimestamp(timestamp);
                break;
            }
            case 2: {
                this.bumpMasterRef();
                break;
            }
            case 3: {
                this.bumpMasterRef();
                this.o3TimestampSetter(timestamp);
                return this.row;
            }
        }
        this.txWriter.append();
        return this.row;
    }

    public Row newRow() {
        return this.newRow(0L);
    }

    public void o3BumpErrorCount() {
        this.o3ErrorCount.incrementAndGet();
    }

    public void openLastPartition() {
        try {
            this.openPartition(this.txWriter.getLastPartitionTimestamp());
            this.setAppendPosition(this.txWriter.getTransientRowCount(), false);
        }
        catch (Throwable e) {
            this.freeColumns(false);
            throw e;
        }
    }

    public void processCommandQueue(TableWriterTask cmd, Sequence commandSubSeq, long cursor, boolean contextAllowsAnyStructureChanges) {
        if (cmd.getTableId() == (long)this.getMetadata().getId()) {
            switch (cmd.getType()) {
                case 1: {
                    this.processReplSyncCommand(cmd, cursor, commandSubSeq);
                    break;
                }
                case 2: {
                    this.processAsyncWriterCommand(this.alterTableStatement, cmd, cursor, commandSubSeq, contextAllowsAnyStructureChanges);
                    break;
                }
                case 3: {
                    this.processAsyncWriterCommand(cmd.getAsyncWriterCommand(), cmd, cursor, commandSubSeq, false);
                    break;
                }
                default: {
                    LOG.error().$("unknown TableWriterTask type, ignored: ").$(cmd.getType()).$();
                    commandSubSeq.done(cursor);
                    break;
                }
            }
        } else {
            LOG.info().$("not my command [cmdTableId=").$(cmd.getTableId()).$(", cmdTableName=").$(cmd.getTableName()).$(", myTableId=").$(this.getMetadata().getId()).$(", myTableName=").$(this.tableName).I$();
            commandSubSeq.done(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processO3Block(Path walPath, long segmentId, int timestampIndex, boolean ordered, long rowLo, long rowHi, long o3TimestampMin, long o3TimestampMax, SymbolMapDiffCursor mapDiffCursor) {
        this.lastPartitionTimestamp = this.partitionFloorMethod.floor(this.partitionTimestampHi);
        long partitionTimestampHiLimit = this.partitionCeilMethod.ceil(this.partitionTimestampHi) - 1L;
        int walRootPathLen = walPath.length();
        try {
            if (segmentId > -1L) {
                walPath.slash().put(segmentId);
            }
            this.mmapWalColumn(walPath, timestampIndex, rowLo, rowHi);
            try {
                long timestampAddr;
                this.o3Columns = this.walMappedColumns;
                MemoryCR walTimestampColumn = this.walMappedColumns.getQuick(TableWriter.getPrimaryColumnIndex(timestampIndex));
                long o3Lo = rowLo;
                long o3Hi = rowHi;
                if (!ordered) {
                    long timestampMemorySize = rowHi - rowLo << 4;
                    this.o3TimestampMem.jumpTo(timestampMemorySize);
                    long destTimestampAddr = this.o3TimestampMem.getAddress();
                    Vect.memcpy(destTimestampAddr, walTimestampColumn.addressOf(rowLo << 4), timestampMemorySize);
                    if (rowHi - rowLo > 600L || !this.o3QuickSortEnabled) {
                        this.o3TimestampMemCpy.jumpTo(timestampMemorySize);
                        Vect.radixSortLongIndexAscInPlace(destTimestampAddr, this.o3RowCount, this.o3TimestampMemCpy.addressOf(0L));
                    } else {
                        Vect.quickSortLongIndexAscInPlace(destTimestampAddr, this.o3RowCount);
                    }
                    this.o3Sort(destTimestampAddr, timestampIndex, rowHi - rowLo);
                    timestampAddr = destTimestampAddr;
                    o3Hi = rowHi - rowLo;
                    o3Lo = 0L;
                } else {
                    timestampAddr = walTimestampColumn.addressOf(0L);
                }
                this.o3Columns = this.remapWalSymbols(mapDiffCursor, o3Lo, o3Hi, walPath);
                this.processO3Block(0L, timestampIndex, timestampAddr, o3Hi, o3TimestampMin, o3TimestampMax, !ordered, o3Lo);
            }
            finally {
                this.finishO3Append(0L);
                this.o3Columns = this.o3MemColumns;
                int n = this.walMappedColumns.size();
                for (int col = 0; col < n; ++col) {
                    MemoryCMOR mappedColumnMem = this.walMappedColumns.getQuick(col);
                    if (mappedColumnMem == null) continue;
                    Misc.free(mappedColumnMem);
                    this.walColumnMemoryPool.push(mappedColumnMem);
                }
            }
            boolean bl = this.finishO3Commit(partitionTimestampHiLimit);
            return bl;
        }
        finally {
            walPath.trimTo(walRootPathLen);
        }
    }

    public void processWalCommit(Path walPath, long segmentId, boolean inOrder, long rowLo, long rowHi, long o3TimestampMin, long o3TimestampMax, SymbolMapDiffCursor mapDiffCursor) {
        if (this.inTransaction()) {
            throw CairoException.critical(0).put("cannot process WAL while in transaction");
        }
        this.txWriter.beginPartitionSizeUpdate();
        if (this.processO3Block(walPath, segmentId, this.metadata.getTimestampIndex(), inOrder, rowLo, rowHi, o3TimestampMin, o3TimestampMax, mapDiffCursor)) {
            return;
        }
        long committedRowCount = this.txWriter.unsafeCommittedFixedRowCount() + this.txWriter.unsafeCommittedTransientRowCount();
        long rowsAdded = this.txWriter.getRowCount() - committedRowCount;
        this.updateIndexes();
        this.columnVersionWriter.commit();
        this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
        this.txWriter.commit(this.defaultCommitMode, this.denseSymbolMapWriters);
        this.committedMasterRef = this.masterRef;
        this.o3ProcessPartitionRemoveCandidates();
        this.metrics.tableWriter().incrementCommits();
        this.metrics.tableWriter().addCommittedRows(rowsAdded);
    }

    public void publishAsyncWriterCommand(AsyncWriterCommand asyncWriterCommand) {
        while (true) {
            long seq;
            if ((seq = this.commandPubSeq.next()) > -1L) {
                TableWriterTask task = this.commandQueue.get(seq);
                asyncWriterCommand.serialize(task);
                this.commandPubSeq.done(seq);
                return;
            }
            if (seq == -1L) {
                throw CairoException.nonCritical().put("could not publish, command queue is full [table=").put(this.tableName).put(']');
            }
            Os.pause();
        }
    }

    public void removeColumn(CharSequence name) {
        boolean timestamp;
        this.checkDistressed();
        this.checkColumnName(name);
        int index = this.getColumnIndex(name);
        int type = this.metadata.getColumnType(index);
        LOG.info().$("removing column '").utf8(name).$("' from ").$(this.path).$();
        int timestampIndex = this.metaMem.getInt(8L);
        boolean bl = timestamp = index == timestampIndex;
        if (timestamp && PartitionBy.isPartitioned(this.partitionBy)) {
            throw CairoException.nonCritical().put("Cannot remove timestamp from partitioned table");
        }
        this.commit();
        this.metaSwapIndex = this.removeColumnFromMeta(index);
        this.metaMem.close();
        this.renameMetaToMetaPrev(name);
        this.writeRestoreMetaTodo(name);
        this.renameSwapMetaToMeta(name);
        this.removeColumn(index);
        this.removeSymbolMapWriter(index);
        if (timestamp) {
            this.txWriter.resetTimestamp();
            this.timestampSetter = value -> {};
        }
        try {
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
            this.clearTodoLog();
            this.removeColumnFiles(name, index, type);
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        this.bumpStructureVersion();
        this.metadata.removeColumn(index);
        if (timestamp) {
            this.metadata.setTimestampIndex(-1);
        }
        LOG.info().$("REMOVED column '").utf8(name).$("' from ").$(this.path).$();
    }

    public boolean removePartition(long timestamp) {
        if (!PartitionBy.isPartitioned(this.partitionBy)) {
            return false;
        }
        long minTimestamp = this.txWriter.getMinTimestamp();
        long maxTimestamp = this.txWriter.getMaxTimestamp();
        if ((timestamp = this.getPartitionLo(timestamp)) < this.getPartitionLo(minTimestamp) || timestamp > maxTimestamp) {
            LOG.error().$("partition is empty, folder does not exist [path=").$(this.path).I$();
            return false;
        }
        if (timestamp == this.getPartitionLo(maxTimestamp)) {
            LOG.error().$("cannot remove active partition [path=").$(this.path).$(", maxTimestamp=").$ts(maxTimestamp).I$();
            return false;
        }
        if (!this.txWriter.attachedPartitionsContains(timestamp)) {
            LOG.error().$("partition is already detached [path=").$(this.path).I$();
            return false;
        }
        long nextMinTimestamp = minTimestamp;
        if (timestamp == this.txWriter.getPartitionTimestamp(0)) {
            nextMinTimestamp = this.readMinTimestamp(this.txWriter.getPartitionTimestamp(1));
        }
        long partitionNameTxn = this.txWriter.getPartitionNameTxnByPartitionTimestamp(timestamp);
        this.columnVersionWriter.removePartition(timestamp);
        this.txWriter.beginPartitionSizeUpdate();
        this.txWriter.removeAttachedPartitions(timestamp);
        this.txWriter.setMinTimestamp(nextMinTimestamp);
        this.txWriter.finishPartitionSizeUpdate(nextMinTimestamp, this.txWriter.getMaxTimestamp());
        this.txWriter.bumpTruncateVersion();
        this.columnVersionWriter.commit();
        this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
        this.txWriter.commit(this.defaultCommitMode, this.denseSymbolMapWriters);
        this.safeDeletePartitionDir(timestamp, partitionNameTxn);
        return true;
    }

    public void renameColumn(CharSequence currentName, CharSequence newName) {
        this.checkDistressed();
        this.checkColumnName(newName);
        int index = this.getColumnIndex(currentName);
        int type = this.metadata.getColumnType(index);
        LOG.info().$("renaming column '").utf8(currentName).$("' to '").utf8(newName).$("' from ").$(this.path).$();
        this.commit();
        this.metaSwapIndex = this.renameColumnFromMeta(index, newName);
        this.metaMem.close();
        this.renameMetaToMetaPrev(currentName);
        this.writeRestoreMetaTodo(currentName);
        this.renameSwapMetaToMeta(currentName);
        try {
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
            this.clearTodoLog();
            this.renameColumnFiles(currentName, index, newName, type);
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        this.bumpStructureVersion();
        this.metadata.renameColumn(currentName, newName);
        if (index == this.metadata.getTimestampIndex()) {
            this.designatedTimestampColumnName = Chars.toString(newName);
        }
        LOG.info().$("RENAMED column '").utf8(currentName).$("' to '").utf8(newName).$("' from ").$(this.path).$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableSyncModel replCreateTableSyncModel(long slaveTxAddress, long slaveTxDataSize, long slaveMetaData, long slaveMetaDataSize) {
        int theirLast;
        this.replPartitionHash.clear();
        TableSyncModel model = new TableSyncModel();
        model.setMaxTimestamp(this.getMaxTimestamp());
        this.slaveTxMemory.of(slaveTxAddress, slaveTxDataSize);
        this.slaveTxReader.initRO(this.slaveTxMemory, this.partitionBy);
        this.slaveTxReader.unsafeLoadAll();
        if (this.slaveTxReader.getDataVersion() != this.txWriter.getDataVersion()) {
            model.setTableAction(1);
            theirLast = -1;
        } else {
            int partitionCount = this.slaveTxReader.getPartitionCount();
            theirLast = partitionCount - 1;
            for (int i = 0; i < partitionCount; ++i) {
                this.replPartitionHash.put(this.slaveTxReader.getPartitionTimestamp(i), i);
            }
        }
        model.setDataVersion(this.txWriter.getDataVersion());
        int ourPartitionCount = this.txWriter.getPartitionCount();
        int ourLast = ourPartitionCount - 1;
        for (int i = 0; i < ourPartitionCount; ++i) {
            try {
                long theirSize;
                long ts = this.txWriter.getPartitionTimestamp(i);
                long ourSize = i < ourLast ? this.txWriter.getPartitionSize(i) : this.txWriter.transientRowCount;
                long ourColumnVersion = i < ourLast ? this.txWriter.getPartitionColumnVersion(i) : this.txWriter.columnVersion;
                int keyIndex = this.replPartitionHash.keyIndex(ts);
                if (keyIndex < 0) {
                    int slavePartitionIndex = this.replPartitionHash.valueAt(keyIndex);
                    if (this.slaveTxReader.getPartitionNameTxn(slavePartitionIndex) == this.txWriter.getPartitionNameTxn(i)) {
                        long l = theirSize = slavePartitionIndex < theirLast ? this.slaveTxReader.getPartitionSize(slavePartitionIndex) : this.slaveTxReader.getTransientRowCount();
                        if (theirSize > ourSize) {
                            LOG.error().$("slave partition is larger than that on master [table=").$(this.tableName).$(", ts=").$ts(ts).I$();
                        }
                    } else {
                        theirSize = 0L;
                    }
                } else {
                    theirSize = 0L;
                }
                if (theirSize >= ourSize) continue;
                long partitionNameTxn = this.txWriter.getPartitionNameTxn(i);
                model.addPartitionAction(theirSize == 0L ? 0L : 1L, ts, theirSize, ourSize - theirSize, partitionNameTxn, ourColumnVersion);
                TableUtils.setPathForPartition(this.path, this.partitionBy, ts, false);
                if (partitionNameTxn > -1L) {
                    this.path.put('.').put(partitionNameTxn);
                }
                int plen = this.path.length();
                for (int j = 0; j < this.columnCount; ++j) {
                    String columnName = this.metadata.getColumnName(j);
                    long top = this.columnVersionWriter.getColumnTopQuick(ts, j);
                    if (top > 0L) {
                        model.addColumnTop(ts, j, top);
                    }
                    if (!ColumnType.isVariableLength(this.metadata.getColumnType(j))) continue;
                    long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(ts, j);
                    TableUtils.iFile(this.path.trimTo(plen), columnName, columnNameTxn);
                    long sz = TableUtils.readLongAtOffset(this.ff, this.path, this.tempMem16b, ourSize * 8L);
                    model.addVarColumnSize(ts, j, sz);
                }
                continue;
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
        this.slaveMetaMem.of(slaveMetaData, slaveMetaDataSize);
        int slaveColumnCount = this.slaveMetaMem.getInt(0L);
        long offset = TableUtils.getColumnNameOffset(slaveColumnCount);
        int newIndex = 0;
        for (int masterIndex = 0; masterIndex < this.columnCount; ++masterIndex) {
            if (masterIndex < slaveColumnCount) {
                boolean isRename;
                CharSequence slaveName = this.slaveMetaMem.getStr(offset);
                offset += (long)Vm.getStorageLength(slaveName);
                int slaveColumnType = TableUtils.getColumnType(this.slaveMetaMem, masterIndex);
                boolean isSlaveIndexed = TableUtils.isColumnIndexed(this.slaveMetaMem, masterIndex);
                boolean bl = isRename = !Chars.equalsIgnoreCase(slaveName, this.metadata.getColumnName(masterIndex));
                if (slaveColumnType == this.metadata.getColumnType(masterIndex) && !isRename && isSlaveIndexed == this.metadata.isColumnIndexed(masterIndex)) continue;
                model.addColumnMetaAction(3, masterIndex, masterIndex);
                if (this.metadata.getColumnType(masterIndex) <= 0) continue;
                model.addColumnMetadata(this.metadata.getColumnQuick(masterIndex));
                model.addColumnMetaAction(4, newIndex++, masterIndex);
                continue;
            }
            model.addColumnMetadata(this.metadata.getColumnQuick(masterIndex));
            model.addColumnMetaAction(4, newIndex++, masterIndex);
        }
        return model;
    }

    public void rollback() {
        this.checkDistressed();
        if (this.o3InError || this.inTransaction()) {
            try {
                LOG.info().$("tx rollback [name=").$(this.tableName).I$();
                if ((this.masterRef & 1L) != 0L) {
                    ++this.masterRef;
                }
                this.freeColumns(false);
                this.txWriter.unsafeLoadAll();
                this.rollbackIndexes();
                this.rollbackSymbolTables();
                this.columnVersionWriter.readUnsafe();
                this.purgeUnusedPartitions();
                this.configureAppendPosition();
                this.o3InError = false;
                this.o3MasterRef = -1L;
                LOG.info().$("tx rollback complete [name=").$(this.tableName).I$();
                this.processCommandQueue(false);
                this.metrics.tableWriter().incrementRollbacks();
            }
            catch (Throwable e) {
                LOG.critical().$("could not perform rollback [name=").$(this.tableName).$(", msg=").$(e.getMessage()).I$();
                this.distressed = true;
            }
        }
    }

    public void rollbackUpdate() {
        this.columnVersionWriter.readUnsafe();
    }

    public void setExtensionListener(ExtensionListener listener) {
        this.txWriter.setExtensionListener(listener);
    }

    public void setLifecycleManager(LifecycleManager lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaCommitLag(long commitLag) {
        try {
            this.commit();
            long metaSize = this.copyMetadataAndUpdateVersion();
            TableUtils.openMetaSwapFileByIndex(this.ff, this.ddlMem, this.path, this.rootLen, this.metaSwapIndex);
            try {
                this.ddlMem.jumpTo(24L);
                this.ddlMem.putLong(commitLag);
                this.ddlMem.jumpTo(metaSize);
            }
            finally {
                this.ddlMem.close();
            }
            this.finishMetaSwapUpdate();
            this.metadata.setCommitLag(commitLag);
            this.commitInterval = this.calculateCommitInterval();
            this.clearTodoLog();
        }
        finally {
            this.ddlMem.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaMaxUncommittedRows(int maxUncommittedRows) {
        try {
            this.commit();
            long metaSize = this.copyMetadataAndUpdateVersion();
            TableUtils.openMetaSwapFileByIndex(this.ff, this.ddlMem, this.path, this.rootLen, this.metaSwapIndex);
            try {
                this.ddlMem.jumpTo(20L);
                this.ddlMem.putInt(maxUncommittedRows);
                this.ddlMem.jumpTo(metaSize);
            }
            finally {
                this.ddlMem.close();
            }
            this.finishMetaSwapUpdate();
            this.metadata.setMaxUncommittedRows(maxUncommittedRows);
            this.clearTodoLog();
        }
        finally {
            this.ddlMem.close();
        }
    }

    public long size() {
        return this.txWriter.getRowCount() + this.getO3RowCount();
    }

    public void tick() {
        this.tick(false);
    }

    public void tick(boolean contextAllowsAnyStructureChanges) {
        this.processCommandQueue(contextAllowsAnyStructureChanges);
    }

    public String toString() {
        return "TableWriter{name=" + this.tableName + '}';
    }

    public void transferLock(long lockFd) {
        assert (lockFd != -1L);
        this.lockFd = lockFd;
    }

    public final void truncate() {
        int i;
        this.rollback();
        int n = this.denseSymbolMapWriters.size();
        for (i = 0; i < n; ++i) {
            this.denseSymbolMapWriters.getQuick(i).truncate();
        }
        if (this.size() == 0L) {
            return;
        }
        this.todoMem.putLong(0L, ++this.todoTxn);
        Unsafe.getUnsafe().storeFence();
        this.todoMem.putLong(8L, this.configuration.getDatabaseIdLo());
        this.todoMem.putLong(16L, this.configuration.getDatabaseIdHi());
        Unsafe.getUnsafe().storeFence();
        this.todoMem.putLong(24L, this.todoTxn);
        this.todoMem.putLong(32L, 1L);
        this.todoMem.putLong(40L, 1L);
        this.todoMem.jumpTo(48L);
        if (this.partitionBy != 3) {
            this.freeColumns(false);
            if (this.indexers != null) {
                n = this.indexers.size();
                for (i = 0; i < n; ++i) {
                    Misc.free(this.indexers.getQuick(i));
                }
            }
            this.removePartitionDirectories();
            this.rowAction = 0;
        } else {
            for (i = 0; i < this.columnCount; ++i) {
                this.getPrimaryColumn(i).truncate();
                MemoryMA mem = this.getSecondaryColumn(i);
                if (mem == null || !mem.isOpen()) continue;
                mem.truncate();
                mem.putLong(0L);
            }
        }
        this.txWriter.resetTimestamp();
        this.columnVersionWriter.truncate(PartitionBy.isPartitioned(this.partitionBy));
        this.txWriter.truncate(this.columnVersionWriter.getVersion());
        this.row = this.regularRow;
        try {
            this.clearTodoLog();
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        LOG.info().$("truncated [name=").$(this.tableName).I$();
    }

    public void updateCommitInterval(double commitIntervalFraction, long commitIntervalDefault) {
        this.commitIntervalFraction = commitIntervalFraction;
        this.commitIntervalDefault = commitIntervalDefault;
        this.commitInterval = this.calculateCommitInterval();
    }

    public void upsertColumnVersion(long partitionTimestamp, int columnIndex, long columnTop) {
        this.columnVersionWriter.upsert(partitionTimestamp, columnIndex, this.txWriter.txn, columnTop);
        this.txWriter.updatePartitionColumnVersion(partitionTimestamp);
    }

    public void warmUp() {
        Row r = this.newRow(Math.max(0L, this.txWriter.getMaxTimestamp()));
        try {
            for (int i = 0; i < this.columnCount; ++i) {
                r.putByte(i, (byte)0);
            }
        }
        finally {
            r.cancel();
        }
    }

    private static void removeFileAndOrLog(FilesFacade ff, LPSZ name) {
        if (ff.exists(name)) {
            if (ff.remove(name)) {
                LOG.debug().$("removed [file=").utf8(name).I$();
            } else {
                LOG.error().$("could not remove [errno=").$(ff.errno()).$(", file=").utf8(name).I$();
            }
        }
    }

    private static void renameFileOrLog(FilesFacade ff, LPSZ from, LPSZ to) {
        if (ff.exists(from)) {
            if (ff.rename(from, to) == 0) {
                LOG.debug().$("renamed [from=").utf8(from).$(", to=").utf8(to).I$();
            } else {
                LOG.critical().$("could not rename [errno=").$(ff.errno()).$(", from=").utf8(from).$(", to=").utf8(to).I$();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void indexAndCountDown(ColumnIndexer indexer, long lo, long hi, SOCountDownLatch latch) {
        try {
            indexer.refreshSourceAndIndex(lo, hi);
        }
        catch (CairoException e) {
            indexer.distress();
            LOG.critical().$("index error [fd=").$(indexer.getFd()).$(']').$('{').$(e).$('}').$();
        }
        finally {
            latch.countDown();
        }
    }

    private static int getColumnIndexQuiet(MemoryMR metaMem, CharSequence name, int columnCount) {
        long nameOffset = TableUtils.getColumnNameOffset(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            CharSequence col = metaMem.getStr(nameOffset);
            int columnType = TableUtils.getColumnType(metaMem, i);
            if (columnType > 0 && Chars.equalsIgnoreCase(col, name)) {
                return i;
            }
            nameOffset += (long)Vm.getStorageLength(col);
        }
        return -1;
    }

    private static void configureNullSetters(ObjList<Runnable> nullers, int type, MemoryA mem1, MemoryA mem2) {
        switch (ColumnType.tagOf(type)) {
            case 1: 
            case 2: {
                nullers.add(() -> mem1.putByte((byte)0));
                break;
            }
            case 10: {
                nullers.add(() -> mem1.putDouble(Double.NaN));
                break;
            }
            case 9: {
                nullers.add(() -> mem1.putFloat(Float.NaN));
                break;
            }
            case 5: {
                nullers.add(() -> mem1.putInt(Integer.MIN_VALUE));
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                nullers.add(() -> mem1.putLong(Long.MIN_VALUE));
                break;
            }
            case 24: {
                nullers.add(() -> mem1.putLong128LittleEndian(Long.MIN_VALUE, Long.MIN_VALUE));
                break;
            }
            case 13: {
                nullers.add(() -> mem1.putLong256(Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE));
                break;
            }
            case 3: {
                nullers.add(() -> mem1.putShort((short)0));
                break;
            }
            case 4: {
                nullers.add(() -> mem1.putChar('\u0000'));
                break;
            }
            case 11: {
                nullers.add(() -> mem2.putLong(mem1.putNullStr()));
                break;
            }
            case 12: {
                nullers.add(() -> mem1.putInt(Integer.MIN_VALUE));
                break;
            }
            case 18: {
                nullers.add(() -> mem2.putLong(mem1.putNullBin()));
                break;
            }
            case 14: {
                nullers.add(() -> mem1.putByte((byte)-1));
                break;
            }
            case 15: {
                nullers.add(() -> mem1.putShort((short)-1));
                break;
            }
            case 16: {
                nullers.add(() -> mem1.putInt(-1));
                break;
            }
            case 17: {
                nullers.add(() -> mem1.putLong(-1L));
                break;
            }
            default: {
                nullers.add(NOOP);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void openMetaFile(FilesFacade ff, Path path, int rootLen, MemoryMR metaMem) {
        path.concat("_meta").$();
        try {
            metaMem.smallFile(ff, path, 5);
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ColumnVersionWriter openColumnVersionFile(FilesFacade ff, Path path, int rootLen) {
        path.concat("_cv").$();
        try {
            ColumnVersionWriter columnVersionWriter = new ColumnVersionWriter(ff, path, 0L);
            return columnVersionWriter;
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addColumnToMeta(CharSequence name, int type, boolean indexFlag, int indexValueBlockCapacity, boolean sequentialFlag) {
        int index;
        try {
            index = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.configuration.getMaxSwapFileCount());
            int columnCount = this.metaMem.getInt(0L);
            this.ddlMem.putInt(columnCount + 1);
            this.ddlMem.putInt(this.metaMem.getInt(4L));
            this.ddlMem.putInt(this.metaMem.getInt(8L));
            this.copyVersionAndLagValues();
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < columnCount; ++i) {
                this.writeColumnEntry(i, false);
            }
            this.ddlMem.putInt(type);
            long flags = 0L;
            if (indexFlag) {
                flags |= 1L;
            }
            if (sequentialFlag) {
                flags |= 2L;
            }
            this.ddlMem.putLong(flags);
            this.ddlMem.putInt(indexValueBlockCapacity);
            this.ddlMem.putLong(this.configuration.getRandom().nextLong());
            this.ddlMem.skip(8L);
            long nameOffset = TableUtils.getColumnNameOffset(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                this.ddlMem.putStr(columnName);
                nameOffset += (long)Vm.getStorageLength(columnName);
            }
            this.ddlMem.putStr(name);
        }
        finally {
            this.ddlMem.close();
        }
        return index;
    }

    private void attachPartitionCheckFilesMatchFixedColumn(int columnType, long partitionSize, long columnTop, String columnName, long columnNameTxn, Path partitionPath, long partitionTimestamp, int columnIndex) {
        long columnSize = partitionSize - columnTop;
        if (columnSize == 0L) {
            return;
        }
        TableUtils.dFile(partitionPath, columnName, columnNameTxn);
        if (!this.ff.exists(partitionPath.$())) {
            LOG.info().$("attaching partition with missing column [path=").$(partitionPath).I$();
            this.columnVersionWriter.upsertColumnTop(partitionTimestamp, columnIndex, partitionSize);
        } else {
            long fileSize = this.ff.length(partitionPath);
            if (fileSize < columnSize << ColumnType.pow2SizeOf(columnType)) {
                throw CairoException.critical(0).put("Column file is too small. ").put("Partition files inconsistent [file=").put(partitionPath).put(", expectedSize=").put(columnSize << ColumnType.pow2SizeOf(columnType)).put(", actual=").put(fileSize).put(']');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void attachValidateMetadata(long partitionSize, Path partitionPath, long partitionTimestamp) throws CairoException {
        rootLen = partitionPath.length();
        size = this.metadata.getColumnCount();
        block9: for (columnIndex = 0; columnIndex < size; ++columnIndex) {
            try {
                columnName = this.metadata.getColumnName(columnIndex);
                columnType = this.metadata.getColumnType(columnIndex);
                if ((long)columnType <= -1L || (columnTop = this.columnVersionWriter.getColumnTop(partitionTimestamp, columnIndex)) < 0L || columnTop == partitionSize) continue;
                columnNameTxn = this.columnVersionWriter.getDefaultColumnNameTxn(columnIndex);
                switch (ColumnType.tagOf(columnType)) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        this.attachPartitionCheckFilesMatchFixedColumn(columnType, partitionSize, columnTop, columnName, columnNameTxn, partitionPath, partitionTimestamp, columnIndex);
                        ** break;
lbl13:
                        // 1 sources

                        continue block9;
                    }
                    case 11: 
                    case 18: {
                        this.attachPartitionCheckFilesMatchVarLenColumn(partitionSize, columnTop, columnName, columnNameTxn, partitionPath, partitionTimestamp, columnIndex);
                        ** break;
lbl17:
                        // 1 sources

                        continue block9;
                    }
                    case 12: {
                        this.attachPartitionCheckSymbolColumn(partitionSize, columnTop, columnName, columnNameTxn, partitionPath, partitionTimestamp, columnIndex);
                        continue block9;
                    }
                    ** default:
lbl22:
                    // 1 sources

                    continue block9;
                }
            }
            finally {
                partitionPath.trimTo(rootLen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachPartitionCheckFilesMatchVarLenColumn(long partitionSize, long columnTop, String columnName, long columnNameTxn, Path partitionPath, long partitionTimestamp, int columnIndex) throws CairoException {
        block12: {
            long columnSize = partitionSize - columnTop;
            if (columnSize == 0L) {
                return;
            }
            int pathLen = partitionPath.length();
            TableUtils.dFile(partitionPath, columnName, columnNameTxn);
            long dataLength = this.ff.length(partitionPath.$());
            if (dataLength > 0L) {
                partitionPath.trimTo(pathLen);
                TableUtils.iFile(partitionPath, columnName, columnNameTxn);
                int typeSize = 8;
                long indexFd = TableUtils.openRO(this.ff, partitionPath, LOG);
                try {
                    long fileSize = this.ff.length(indexFd);
                    long expectedFileSize = (columnSize + 1L) * (long)typeSize;
                    if (fileSize < expectedFileSize) {
                        throw CairoException.critical(0).put("Column file is too small. ").put("Partition files inconsistent [file=").put(partitionPath).put(",expectedSize=").put(expectedFileSize).put(",actual=").put(fileSize).put(']');
                    }
                    long mappedAddr = TableUtils.mapRO(this.ff, indexFd, expectedFileSize, 0);
                    try {
                        long prevDataAddress = dataLength;
                        for (long offset = columnSize * (long)typeSize; offset >= 0L; offset -= (long)typeSize) {
                            long dataAddress = Unsafe.getUnsafe().getLong(mappedAddr + offset);
                            if (dataAddress < 0L || dataAddress > dataLength) {
                                throw CairoException.critical(0).put("Variable size column has invalid data address value [path=").put(this.path).put(", indexOffset=").put(offset).put(", dataAddress=").put(dataAddress).put(", dataFileSize=").put(dataLength).put(']');
                            }
                            if (dataAddress > prevDataAddress) {
                                throw CairoException.critical(0).put("Variable size column has invalid data address value [path=").put(partitionPath).put(", indexOffset=").put(offset).put(", dataAddress=").put(dataAddress).put(", prevDataAddress=").put(prevDataAddress).put(", dataFileSize=").put(dataLength).put(']');
                            }
                            prevDataAddress = dataAddress;
                        }
                        break block12;
                    }
                    finally {
                        this.ff.munmap(mappedAddr, expectedFileSize, 0);
                    }
                }
                finally {
                    this.ff.close(indexFd);
                }
            }
            LOG.info().$("attaching partition with missing column [path=").$(partitionPath).I$();
            this.columnVersionWriter.upsertColumnTop(partitionTimestamp, columnIndex, partitionSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachPartitionCheckSymbolColumn(long partitionSize, long columnTop, String columnName, long columnNameTxn, Path partitionPath, long partitionTimestamp, int columnIndex) {
        long columnSize = partitionSize - columnTop;
        if (columnSize == 0L) {
            return;
        }
        int pathLen = partitionPath.length();
        TableUtils.dFile(partitionPath, columnName, columnNameTxn);
        if (!this.ff.exists(partitionPath.$())) {
            this.columnVersionWriter.upsertColumnTop(partitionTimestamp, columnIndex, partitionSize);
            return;
        }
        long fd = TableUtils.openRO(this.ff, partitionPath.$(), LOG);
        try {
            long fileSize = this.ff.length(fd);
            int typeSize = 4;
            long expectedSize = columnSize * (long)typeSize;
            if (fileSize < expectedSize) {
                throw CairoException.critical(0).put("Column file is too small. ").put("Partition files inconsistent [file=").put(partitionPath).put(", expectedSize=").put(expectedSize).put(", actual=").put(fileSize).put(']');
            }
            long address = TableUtils.mapRO(this.ff, fd, fileSize, 0);
            try {
                int maxKey = Vect.maxInt(address, columnSize);
                int symbolValues = this.symbolMapWriters.getQuick(columnIndex).getSymbolCount();
                if (maxKey >= symbolValues) {
                    throw CairoException.critical(0).put("Symbol file does not match symbol column [file=").put(this.path).put(", key=").put(maxKey).put(", columnKeys=").put(symbolValues).put(']');
                }
                int minKey = Vect.minInt(address, columnSize);
                if (minKey != Integer.MIN_VALUE && minKey < 0) {
                    throw CairoException.critical(0).put("Symbol file does not match symbol column, invalid key [file=").put(this.path).put(", key=").put(minKey).put(']');
                }
            }
            finally {
                this.ff.munmap(address, fileSize, 0);
            }
            if (this.metadata.isColumnIndexed(columnIndex)) {
                BitmapIndexUtils.valueFileName(partitionPath.trimTo(pathLen), columnName, columnNameTxn);
                if (!this.ff.exists(partitionPath.$())) {
                    throw CairoException.critical(0).put("Symbol index value file does not exist [file=").put(partitionPath).put(']');
                }
                BitmapIndexUtils.keyFileName(partitionPath.trimTo(pathLen), columnName, columnNameTxn);
                if (!this.ff.exists(partitionPath.$())) {
                    throw CairoException.critical(0).put("Symbol index key file does not exist [file=").put(partitionPath).put(']');
                }
            }
        }
        finally {
            this.ff.close(fd);
        }
    }

    private void bumpMasterRef() {
        if ((this.masterRef & 1L) == 0L) {
            ++this.masterRef;
        } else {
            this.cancelRowAndBump();
        }
    }

    private void bumpStructureVersion() {
        this.columnVersionWriter.commit();
        this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
        this.txWriter.bumpStructureVersion(this.denseSymbolMapWriters);
        assert (this.txWriter.getStructureVersion() == this.metadata.getStructureVersion());
    }

    private long calculateCommitInterval() {
        long commitIntervalMicros = (long)((double)this.metadata.getCommitLag() * this.commitIntervalFraction);
        return commitIntervalMicros > 0L ? commitIntervalMicros / 1000L : this.commitIntervalDefault;
    }

    private void cancelRowAndBump() {
        this.rowCancel();
        ++this.masterRef;
    }

    private void checkColumnName(CharSequence name) {
        if (!TableUtils.isValidColumnName(name, this.configuration.getMaxFileNameLength())) {
            throw CairoException.nonCritical().put("invalid column name [table=").put(this.tableName).put(", column=").putAsPrintable(name).put(']');
        }
    }

    private void checkDistressed() {
        if (!this.distressed) {
            return;
        }
        throw new CairoError("Table '" + this.tableName + "' is distressed");
    }

    private void clearO3() {
        this.o3MasterRef = -1L;
        this.rowAction = 4;
        this.activeColumns = this.columns;
        this.activeNullSetters = this.nullSetters;
    }

    private void clearTodoLog() {
        try {
            this.todoMem.putLong(0L, ++this.todoTxn);
            Unsafe.getUnsafe().storeFence();
            this.todoMem.putLong(8L, 0L);
            this.todoMem.putLong(16L, 0L);
            Unsafe.getUnsafe().storeFence();
            this.todoMem.putLong(32L, 0L);
            Unsafe.getUnsafe().storeFence();
            this.todoMem.putLong(24L, this.todoTxn);
            this.todoMem.jumpTo(40L);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    void closeActivePartition(boolean truncate) {
        LOG.info().$("closing last partition [table=").$(this.tableName).I$();
        this.closeAppendMemoryTruncate(truncate);
        this.freeIndexers();
    }

    void closeActivePartition(long size) {
        for (int i = 0; i < this.columnCount; ++i) {
            this.setColumnSize(i, size, false);
            Misc.free(this.getPrimaryColumn(i));
            Misc.free(this.getSecondaryColumn(i));
        }
        Misc.freeObjList(this.denseIndexers);
        this.denseIndexers.clear();
    }

    private void closeAppendMemoryTruncate(boolean truncate) {
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            MemoryMA m = this.columns.getQuick(i);
            if (m == null) continue;
            m.close(truncate);
        }
    }

    private void commit(int commitMode, long commitLag) {
        this.checkDistressed();
        if (this.o3InError) {
            this.rollback();
            return;
        }
        if ((this.masterRef & 1L) != 0L) {
            this.rowCancel();
        }
        if (this.inTransaction()) {
            boolean o3 = this.hasO3();
            if (o3 && this.o3Commit(commitLag)) {
                this.committedMasterRef = this.masterRef;
                return;
            }
            if (commitMode != 2) {
                this.syncColumns(commitMode);
            }
            long committedRowCount = this.txWriter.unsafeCommittedFixedRowCount() + this.txWriter.unsafeCommittedTransientRowCount();
            long rowsAdded = this.txWriter.getRowCount() - committedRowCount;
            this.updateIndexes();
            this.columnVersionWriter.commit();
            this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
            this.txWriter.commit(commitMode, this.denseSymbolMapWriters);
            this.committedMasterRef = this.masterRef;
            this.o3ProcessPartitionRemoveCandidates();
            this.metrics.tableWriter().incrementCommits();
            this.metrics.tableWriter().addCommittedRows(rowsAdded);
            if (!o3) {
                this.addPhysicallyWrittenRows(rowsAdded);
            }
        }
    }

    private void configureAppendPosition() {
        boolean partitioned = PartitionBy.isPartitioned(this.partitionBy);
        if (this.txWriter.getMaxTimestamp() > Long.MIN_VALUE || !partitioned) {
            this.openFirstPartition(this.txWriter.getMaxTimestamp());
            if (partitioned) {
                this.rowAction = 0;
                this.timestampSetter = this.appendTimestampSetter;
            } else if (this.metadata.getTimestampIndex() < 0) {
                this.rowAction = 2;
            } else {
                this.rowAction = 1;
                this.timestampSetter = this.appendTimestampSetter;
            }
        } else {
            this.rowAction = 0;
            this.timestampSetter = this.appendTimestampSetter;
        }
        this.activeColumns = this.columns;
        this.activeNullSetters = this.nullSetters;
    }

    private void configureColumn(int type, boolean indexFlag, int index) {
        MemoryCARW oooSecondary2;
        MemoryCARW oooSecondary;
        MemoryMA secondary;
        MemoryCARW oooPrimary2;
        MemoryCARW oooPrimary;
        MemoryMA primary;
        if (type > 0) {
            primary = Vm.getMAInstance();
            oooPrimary = Vm.getCARWInstance(this.o3ColumnMemorySize, Integer.MAX_VALUE, 3);
            oooPrimary2 = Vm.getCARWInstance(this.o3ColumnMemorySize, Integer.MAX_VALUE, 3);
            switch (ColumnType.tagOf(type)) {
                case 11: 
                case 18: {
                    secondary = Vm.getMAInstance();
                    oooSecondary = Vm.getCARWInstance(this.o3ColumnMemorySize, Integer.MAX_VALUE, 3);
                    oooSecondary2 = Vm.getCARWInstance(this.o3ColumnMemorySize, Integer.MAX_VALUE, 3);
                    break;
                }
                default: {
                    secondary = null;
                    oooSecondary = null;
                    oooSecondary2 = null;
                    break;
                }
            }
        } else {
            secondary = NullMemory.INSTANCE;
            primary = secondary;
            oooPrimary2 = oooSecondary2 = NullMemory.INSTANCE;
            oooSecondary = oooSecondary2;
            oooPrimary = oooSecondary2;
        }
        int baseIndex = TableWriter.getPrimaryColumnIndex(index);
        this.columns.extendAndSet(baseIndex, primary);
        this.columns.extendAndSet(baseIndex + 1, secondary);
        this.o3MemColumns.extendAndSet(baseIndex, oooPrimary);
        this.o3MemColumns.extendAndSet(baseIndex + 1, oooSecondary);
        this.o3MemColumns2.extendAndSet(baseIndex, oooPrimary2);
        this.o3MemColumns2.extendAndSet(baseIndex + 1, oooSecondary2);
        TableWriter.configureNullSetters(this.nullSetters, type, primary, secondary);
        TableWriter.configureNullSetters(this.o3NullSetters, type, oooPrimary, oooSecondary);
        TableWriter.configureNullSetters(this.o3NullSetters2, type, oooPrimary2, oooSecondary2);
        if (indexFlag) {
            this.indexers.extendAndSet(index, new SymbolColumnIndexer());
        }
        this.rowValueIsNotNull.add(0L);
    }

    private void configureColumnMemory() {
        this.symbolMapWriters.setPos(this.columnCount);
        for (int i = 0; i < this.columnCount; ++i) {
            int type = this.metadata.getColumnType(i);
            this.configureColumn(type, this.metadata.isColumnIndexed(i), i);
            if (!ColumnType.isSymbol(type)) continue;
            int symbolIndex = this.denseSymbolMapWriters.size();
            long columnNameTxn = this.columnVersionWriter.getDefaultColumnNameTxn(i);
            SymbolMapWriter symbolMapWriter = new SymbolMapWriter(this.configuration, this.path.trimTo(this.rootLen), this.metadata.getColumnName(i), columnNameTxn, this.txWriter.unsafeReadSymbolTransientCount(symbolIndex), symbolIndex, this.txWriter);
            this.symbolMapWriters.extendAndSet(i, symbolMapWriter);
            this.denseSymbolMapWriters.add(symbolMapWriter);
        }
        int timestampIndex = this.metadata.getTimestampIndex();
        if (timestampIndex != -1) {
            this.o3TimestampMem = this.o3MemColumns.getQuick(TableWriter.getPrimaryColumnIndex(timestampIndex));
            this.o3TimestampMemCpy = this.o3MemColumns2.getQuick(TableWriter.getPrimaryColumnIndex(timestampIndex));
        }
    }

    private void configureTimestampSetter() {
        int index = this.metadata.getTimestampIndex();
        if (index == -1) {
            this.timestampSetter = value -> {};
        } else {
            this.nullSetters.setQuick(index, NOOP);
            this.o3NullSetters.setQuick(index, NOOP);
            this.o3NullSetters2.setQuick(index, NOOP);
            this.timestampSetter = this.getPrimaryColumn(index)::putLong;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyMetadataAndSetIndexAttrs(int columnIndex, int indexedFlag, int indexValueBlockSize) {
        try {
            int index = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.configuration.getMaxSwapFileCount());
            int columnCount = this.metaMem.getInt(0L);
            this.ddlMem.putInt(columnCount);
            this.ddlMem.putInt(this.metaMem.getInt(4L));
            this.ddlMem.putInt(this.metaMem.getInt(8L));
            this.copyVersionAndLagValues();
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < columnCount; ++i) {
                if (i != columnIndex) {
                    this.writeColumnEntry(i, false);
                    continue;
                }
                this.ddlMem.putInt(TableUtils.getColumnType(this.metaMem, i));
                long flags = indexedFlag;
                if (TableUtils.isSequential(this.metaMem, i)) {
                    flags |= 2L;
                }
                this.ddlMem.putLong(flags);
                this.ddlMem.putInt(indexValueBlockSize);
                this.ddlMem.putLong(TableUtils.getColumnHash(this.metaMem, i));
                this.ddlMem.skip(8L);
            }
            long nameOffset = TableUtils.getColumnNameOffset(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                this.ddlMem.putStr(columnName);
                nameOffset += (long)Vm.getStorageLength(columnName);
            }
            int n = index;
            return n;
        }
        finally {
            this.ddlMem.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyMetadataAndUpdateVersion() {
        try {
            int index = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.configuration.getMaxSwapFileCount());
            int columnCount = this.metaMem.getInt(0L);
            this.ddlMem.putInt(columnCount);
            this.ddlMem.putInt(this.metaMem.getInt(4L));
            this.ddlMem.putInt(this.metaMem.getInt(8L));
            this.copyVersionAndLagValues();
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < columnCount; ++i) {
                this.writeColumnEntry(i, false);
            }
            long nameOffset = TableUtils.getColumnNameOffset(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                this.ddlMem.putStr(columnName);
                nameOffset += (long)Vm.getStorageLength(columnName);
            }
            this.metaSwapIndex = index;
            long l = nameOffset;
            return l;
        }
        finally {
            this.ddlMem.close();
        }
    }

    private int copyOverwrite(Path to) {
        int res = this.ff.copy(this.other, to);
        if (Os.type == 3 && res == -1 && this.ff.errno() == 80) {
            if (!this.ff.remove(to)) {
                return -1;
            }
            return this.ff.copy(this.other, to);
        }
        return res;
    }

    private void copyVersionAndLagValues() {
        this.ddlMem.putInt(426);
        this.ddlMem.putInt(this.metaMem.getInt(16L));
        this.ddlMem.putInt(this.metaMem.getInt(20L));
        this.ddlMem.putLong(this.metaMem.getLong(24L));
        this.ddlMem.putLong(this.txWriter.getStructureVersion() + 1L);
        this.ddlMem.putInt(this.metaMem.getInt(40L));
        this.metadata.setStructureVersion(this.txWriter.getStructureVersion() + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexFiles(CharSequence columnName, long columnNameTxn, int indexValueBlockCapacity, int plen, boolean force) {
        try {
            BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName, columnNameTxn);
            if (!force && this.ff.exists(this.path)) {
                return;
            }
            try {
                this.ddlMem.smallFile(this.ff, this.path, 5);
                BitmapIndexWriter.initKeyMemory(this.ddlMem, indexValueBlockCapacity);
            }
            catch (CairoException e) {
                LOG.error().$("could not create index [name=").utf8(this.path).$(", errno=").$(e.getErrno()).I$();
                if (!this.ff.remove(this.path)) {
                    LOG.critical().$("could not remove '").utf8(this.path).$("'. Please remove MANUALLY.").$("[errno=").$(this.ff.errno()).I$();
                }
                throw e;
            }
            finally {
                this.ddlMem.close();
            }
            if (!this.ff.touch(BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName, columnNameTxn))) {
                LOG.error().$("could not create index [name=").$(this.path).$(", errno=").$(this.ff.errno()).I$();
                throw CairoException.critical(this.ff.errno()).put("could not create index [name=").put(this.path).put(']');
            }
        }
        finally {
            this.path.trimTo(plen);
        }
    }

    private void createSymbolMapWriter(CharSequence name, long columnNameTxn, int symbolCapacity, boolean symbolCacheFlag) {
        MapWriter.createSymbolMapFiles(this.ff, this.ddlMem, this.path, name, columnNameTxn, symbolCapacity, symbolCacheFlag);
        SymbolMapWriter w = new SymbolMapWriter(this.configuration, this.path, name, columnNameTxn, 0, this.denseSymbolMapWriters.size(), this.txWriter);
        this.denseSymbolMapWriters.add(w);
        this.symbolMapWriters.extendAndSet(this.columnCount, w);
    }

    private boolean createWalSymbolMapping(SymbolMapDiff symbolMapDiff, int denseSymbolIndex, IntList symbolMap) {
        SymbolMapDiffEntry entry;
        int cleanSymbolCount = symbolMapDiff.getCleanSymbolCount();
        symbolMap.setPos(symbolMapDiff.getSize());
        symbolMap.setAll(symbolMapDiff.getSize(), -1);
        MapWriter mapWriter = this.denseSymbolMapWriters.get(denseSymbolIndex);
        boolean identical = true;
        while ((entry = symbolMapDiff.nextEntry()) != null) {
            CharSequence symbolValue = entry.getSymbol();
            int newKey = mapWriter.put(symbolValue);
            identical &= newKey == entry.getKey();
            symbolMap.setQuick(entry.getKey() - cleanSymbolCount, newKey);
        }
        return identical;
    }

    private void doClose(boolean truncate) {
        boolean tx = this.inTransaction();
        this.freeSymbolMapWriters();
        this.freeIndexers();
        Misc.free(this.txWriter);
        Misc.free(this.metaMem);
        Misc.free(this.ddlMem);
        Misc.free(this.indexMem);
        Misc.free(this.other);
        Misc.free(this.todoMem);
        Misc.free(this.attachMetaMem);
        Misc.free(this.attachMetadata);
        Misc.free(this.attachColumnVersionReader);
        Misc.free(this.attachIndexBuilder);
        Misc.free(this.columnVersionWriter);
        Misc.free(this.o3ColumnTopSink);
        Misc.free(this.slaveTxReader);
        Misc.free(this.commandQueue);
        this.updateOperator = Misc.free(this.updateOperator);
        this.dropIndexOperator = Misc.free(this.dropIndexOperator);
        this.freeColumns(truncate & !this.distressed);
        try {
            this.releaseLock(!truncate | tx | this.performRecovery | this.distressed);
        }
        finally {
            Misc.free(this.txnScoreboard);
            Misc.free(this.path);
            Misc.free(this.o3TimestampMem);
            Misc.free(this.o3TimestampMemCpy);
            Misc.free(this.o3PartitionUpdateQueue);
            Misc.free(this.ownMessageBus);
            this.freeTempMem();
            LOG.info().$("closed '").utf8(this.tableName).$('\'').$();
        }
    }

    private void finishMetaSwapUpdate() {
        this.metaPrevIndex = this.rename(this.fileOperationRetryCount);
        this.writeRestoreMetaTodo();
        try {
            this.restoreMetaFrom("_meta.swp", this.metaSwapIndex);
        }
        catch (CairoException ex) {
            try {
                this.recoverFromTodoWriteFailure(null);
            }
            catch (CairoException ex2) {
                this.throwDistressException(ex2);
            }
            throw ex;
        }
        try {
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        this.bumpStructureVersion();
        this.metadata.setTableVersion();
    }

    private void finishO3Append(long o3LagRowCount) {
        if (this.denseIndexers.size() == 0) {
            this.populateDenseIndexerList();
        }
        this.path.trimTo(this.rootLen);
        boolean bl = this.avoidIndexOnCommit = this.o3ErrorCount.get() == 0;
        if (o3LagRowCount == 0L) {
            this.clearO3();
            LOG.debug().$("lag segment is empty").$();
        } else {
            this.o3MasterRef = this.masterRef - o3LagRowCount * 2L + 1L;
            LOG.debug().$("adjusted [o3RowCount=").$(this.getO3RowCount0()).I$();
        }
    }

    private boolean finishO3Commit(long partitionTimestampHiLimit) {
        if (!this.o3InError) {
            this.updateO3ColumnTops();
        }
        if (!this.isLastPartitionColumnsOpen() || this.partitionTimestampHi > partitionTimestampHiLimit) {
            this.openPartition(this.txWriter.getMaxTimestamp());
        }
        try {
            this.setAppendPosition(this.txWriter.getTransientRowCount(), true);
        }
        catch (Throwable e) {
            LOG.critical().$("data is committed but writer failed to update its state `").$(e).$('`').$();
            this.distressed = true;
            throw e;
        }
        this.metrics.tableWriter().incrementO3Commits();
        return false;
    }

    private void freeAndRemoveColumnPair(ObjList<MemoryMA> columns, int pi, int si) {
        Misc.free(columns.getAndSetQuick(pi, NullMemory.INSTANCE));
        Misc.free(columns.getAndSetQuick(si, NullMemory.INSTANCE));
    }

    private void freeAndRemoveO3ColumnPair(ObjList<MemoryCARW> columns, int pi, int si) {
        Misc.free(columns.getAndSetQuick(pi, NullMemory.INSTANCE));
        Misc.free(columns.getAndSetQuick(si, NullMemory.INSTANCE));
    }

    private void freeColumns(boolean truncate) {
        if (this.columns != null) {
            this.closeAppendMemoryTruncate(truncate);
        }
        Misc.freeObjListAndKeepObjects(this.o3MemColumns);
        Misc.freeObjListAndKeepObjects(this.o3MemColumns2);
    }

    private void freeIndexers() {
        if (this.indexers != null) {
            int n = this.indexers.size();
            for (int i = 0; i < n; ++i) {
                Misc.free(this.indexers.getQuick(i));
            }
            this.denseIndexers.clear();
        }
    }

    private void freeNullSetter(ObjList<Runnable> nullSetters, int columnIndex) {
        nullSetters.setQuick(columnIndex, NOOP);
    }

    private void freeSymbolMapWriters() {
        if (this.denseSymbolMapWriters != null) {
            int n = this.denseSymbolMapWriters.size();
            for (int i = 0; i < n; ++i) {
                Misc.free(this.denseSymbolMapWriters.getQuick(i));
            }
            this.denseSymbolMapWriters.clear();
        }
        if (this.symbolMapWriters != null) {
            this.symbolMapWriters.clear();
        }
    }

    private void freeTempMem() {
        if (this.tempMem16b != 0L) {
            Unsafe.free(this.tempMem16b, 16L, 26);
            this.tempMem16b = 0L;
        }
    }

    BitmapIndexWriter getBitmapIndexWriter(int columnIndex) {
        return this.indexers.getQuick(columnIndex).getWriter();
    }

    long getColumnTop(int columnIndex) {
        return this.columnTops.getQuick(columnIndex);
    }

    ColumnVersionReader getColumnVersionReader() {
        return this.columnVersionWriter;
    }

    CairoConfiguration getConfiguration() {
        return this.configuration;
    }

    Sequence getO3CopyPubSeq() {
        return this.messageBus.getO3CopyPubSeq();
    }

    RingQueue<O3CopyTask> getO3CopyQueue() {
        return this.messageBus.getO3CopyQueue();
    }

    Sequence getO3OpenColumnPubSeq() {
        return this.messageBus.getO3OpenColumnPubSeq();
    }

    RingQueue<O3OpenColumnTask> getO3OpenColumnQueue() {
        return this.messageBus.getO3OpenColumnQueue();
    }

    Sequence getO3PartitionUpdatePubSeq() {
        return this.o3PartitionUpdatePubSeq;
    }

    RingQueue<O3PartitionUpdateTask> getO3PartitionUpdateQueue() {
        return this.o3PartitionUpdateQueue;
    }

    private long getO3RowCount0() {
        return (this.masterRef - this.o3MasterRef + 1L) / 2L;
    }

    private long getPartitionLo(long timestamp) {
        return this.partitionFloorMethod.floor(timestamp);
    }

    long getPartitionNameTxnByIndex(int index) {
        return this.txWriter.getPartitionNameTxnByIndex(index);
    }

    long getPartitionSizeByIndex(int index) {
        return this.txWriter.getPartitionSizeByIndex(index);
    }

    private MemoryMA getPrimaryColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(TableWriter.getPrimaryColumnIndex(column));
    }

    private MemoryMA getSecondaryColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(TableWriter.getSecondaryColumnIndex(column));
    }

    TxReader getTxReader() {
        return this.txWriter;
    }

    private boolean hasO3() {
        return this.o3MasterRef > -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexHistoricPartitions(SymbolColumnIndexer indexer, CharSequence columnName, int indexValueBlockSize) {
        long ts = this.txWriter.getMaxTimestamp();
        if (ts > Long.MIN_VALUE) {
            int columnIndex = this.metadata.getColumnIndex(columnName);
            try (MemoryMR roMem = this.indexMem;){
                int n = this.txWriter.getPartitionCount() - 1;
                for (int i = 0; i < n; ++i) {
                    long timestamp = this.txWriter.getPartitionTimestamp(i);
                    this.path.trimTo(this.rootLen);
                    this.setStateForTimestamp(this.path, timestamp, false);
                    if (!this.ff.exists(this.path.$())) continue;
                    int plen = this.path.length();
                    long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(timestamp, columnIndex);
                    TableUtils.dFile(this.path.trimTo(plen), columnName, columnNameTxn);
                    if (!this.ff.exists(this.path)) continue;
                    this.path.trimTo(plen);
                    LOG.info().$("indexing [path=").$(this.path).I$();
                    this.createIndexFiles(columnName, columnNameTxn, indexValueBlockSize, plen, true);
                    long partitionSize = this.txWriter.getPartitionSizeByPartitionTimestamp(timestamp);
                    long columnTop = this.columnVersionWriter.getColumnTop(timestamp, columnIndex);
                    if (columnTop <= -1L || partitionSize <= columnTop) continue;
                    TableUtils.dFile(this.path.trimTo(plen), columnName, columnNameTxn);
                    long columnSize = partitionSize - columnTop << ColumnType.pow2SizeOf(5);
                    roMem.of(this.ff, this.path, columnSize, columnSize, 5);
                    indexer.configureWriter(this.configuration, this.path.trimTo(plen), columnName, columnNameTxn, columnTop);
                    indexer.index(roMem, columnTop, partitionSize);
                }
            }
            finally {
                Misc.free(indexer);
            }
        }
    }

    private void indexLastPartition(SymbolColumnIndexer indexer, CharSequence columnName, long columnNameTxn, int columnIndex, int indexValueBlockSize) {
        int plen = this.path.length();
        this.createIndexFiles(columnName, columnNameTxn, indexValueBlockSize, plen, true);
        long lastPartitionTs = this.txWriter.getLastPartitionTimestamp();
        long columnTop = this.columnVersionWriter.getColumnTopQuick(lastPartitionTs, columnIndex);
        indexer.configureFollowerAndWriter(this.configuration, this.path.trimTo(plen), columnName, columnNameTxn, this.getPrimaryColumn(columnIndex), columnTop);
        indexer.refreshSourceAndIndex(0L, this.txWriter.getTransientRowCount());
    }

    private boolean isLastPartitionColumnsOpen() {
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.metadata.getColumnType(i) <= 0) continue;
            return this.columns.getQuick(TableWriter.getPrimaryColumnIndex(i)).isOpen();
        }
        return true;
    }

    boolean isSymbolMapWriterCached(int columnIndex) {
        return this.symbolMapWriters.getQuick(columnIndex).isCached();
    }

    private void lock() {
        try {
            this.path.trimTo(this.rootLen);
            TableUtils.lockName(this.path);
            this.performRecovery = this.ff.exists(this.path);
            this.lockFd = TableUtils.lock(this.ff, this.path);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
        if (this.lockFd == -1L) {
            throw CairoException.critical(this.ff.errno()).put("Cannot lock table: ").put(this.path.$());
        }
    }

    private void mmapWalColumn(Path walPath, int timestampIndex, long rowLo, long rowHi) {
        this.walMappedColumns.clear();
        int walPathLen = walPath.length();
        int columnCount = this.metadata.getColumnCount();
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            int type = this.metadata.getColumnType(columnIndex);
            this.o3RowCount = rowHi - rowLo;
            if (type > 0) {
                int sizeBitsPow2 = ColumnType.pow2SizeOf(type);
                if (columnIndex == timestampIndex) {
                    ++sizeBitsPow2;
                }
                if (!ColumnType.isVariableLength(type)) {
                    MemoryCMOR primary = (MemoryCMOR)this.walColumnMemoryPool.pop();
                    TableUtils.dFile(walPath, this.metadata.getColumnName(columnIndex), -1L);
                    primary.ofOffset(this.configuration.getFilesFacade(), walPath, rowLo << sizeBitsPow2, rowHi << sizeBitsPow2, 5, 0L);
                    walPath.trimTo(walPathLen);
                    this.walMappedColumns.add(primary);
                    this.walMappedColumns.add(null);
                    continue;
                }
                sizeBitsPow2 = 3;
                MemoryCMOR fixed = (MemoryCMOR)this.walColumnMemoryPool.pop();
                MemoryCMOR var = (MemoryCMOR)this.walColumnMemoryPool.pop();
                TableUtils.iFile(walPath, this.metadata.getColumnName(columnIndex), -1L);
                fixed.ofOffset(this.configuration.getFilesFacade(), walPath, rowLo << sizeBitsPow2, rowHi + 1L << sizeBitsPow2, 5, 0L);
                walPath.trimTo(walPathLen);
                long varOffset = fixed.getLong(rowLo << sizeBitsPow2);
                long varLen = fixed.getLong(rowHi << sizeBitsPow2) - varOffset;
                TableUtils.dFile(walPath, this.metadata.getColumnName(columnIndex), -1L);
                var.ofOffset(this.configuration.getFilesFacade(), walPath, varOffset, varOffset + varLen, 5, 0L);
                walPath.trimTo(walPathLen);
                this.walMappedColumns.add(var);
                this.walMappedColumns.add(fixed);
                continue;
            }
            this.walMappedColumns.add(null);
        }
    }

    private Row newRowO3(long timestamp) {
        LOG.info().$("switched to o3 [table=").utf8(this.tableName).I$();
        this.txWriter.beginPartitionSizeUpdate();
        this.o3OpenColumns();
        this.o3InError = false;
        this.o3MasterRef = this.masterRef;
        this.rowAction = 3;
        this.o3TimestampSetter(timestamp);
        return this.row;
    }

    void o3ClockDownPartitionUpdateCount() {
        this.o3PartitionUpdRemaining.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean o3Commit(long lag) {
        this.o3RowCount = this.getO3RowCount0();
        long o3LagRowCount = 0L;
        long maxUncommittedRows = this.metadata.getMaxUncommittedRows();
        int timestampIndex = this.metadata.getTimestampIndex();
        this.lastPartitionTimestamp = this.partitionFloorMethod.floor(this.partitionTimestampHi);
        long partitionTimestampHiLimit = this.partitionCeilMethod.ceil(this.partitionTimestampHi) - 1L;
        try {
            long srcOooMax;
            this.o3RowCount += this.o3MoveUncommitted(timestampIndex);
            LOG.info().$("sorting o3 [table=").$(this.tableName).I$();
            long sortedTimestampsAddr = this.o3TimestampMem.getAddress();
            assert (this.o3TimestampMem.getAppendOffset() == this.o3RowCount * 16L);
            if (this.o3RowCount > 600L || !this.o3QuickSortEnabled) {
                this.o3TimestampMemCpy.jumpTo(this.o3TimestampMem.getAppendOffset());
                Vect.radixSortLongIndexAscInPlace(sortedTimestampsAddr, this.o3RowCount, this.o3TimestampMemCpy.addressOf(0L));
            } else {
                Vect.quickSortLongIndexAscInPlace(sortedTimestampsAddr, this.o3RowCount);
            }
            long o3TimestampMin = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, 0L);
            if (o3TimestampMin < 0L) {
                this.o3InError = true;
                throw CairoException.nonCritical().put("timestamps before 1970-01-01 are not allowed for O3");
            }
            long o3TimestampMax = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, this.o3RowCount - 1L);
            if (o3TimestampMax < 0L) {
                this.o3InError = true;
                throw CairoException.nonCritical().put("timestamps before 1970-01-01 are not allowed for O3");
            }
            assert (o3TimestampMin <= o3TimestampMax);
            if (lag > 0L) {
                long lagThresholdTimestamp = o3TimestampMax - lag;
                if (lagThresholdTimestamp >= o3TimestampMin) {
                    long lagThresholdRow = Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, lagThresholdTimestamp, 0L, this.o3RowCount - 1L, 1);
                    o3LagRowCount = this.o3RowCount - lagThresholdRow - 1L;
                    if (o3LagRowCount > maxUncommittedRows) {
                        o3LagRowCount = maxUncommittedRows;
                        srcOooMax = this.o3RowCount - maxUncommittedRows;
                    } else {
                        srcOooMax = lagThresholdRow + 1L;
                    }
                } else {
                    o3LagRowCount = this.o3RowCount;
                    if (o3LagRowCount > maxUncommittedRows) {
                        o3LagRowCount = maxUncommittedRows / 2L;
                        srcOooMax = this.o3RowCount - o3LagRowCount;
                    } else {
                        srcOooMax = 0L;
                    }
                }
                LOG.debug().$("o3 commit lag [table=").$(this.tableName).$(", lag=").$(lag).$(", maxUncommittedRows=").$(maxUncommittedRows).$(", o3max=").$ts(o3TimestampMax).$(", lagThresholdTimestamp=").$ts(lagThresholdTimestamp).$(", o3LagRowCount=").$(o3LagRowCount).$(", srcOooMax=").$(srcOooMax).$(", o3RowCount=").$(this.o3RowCount).I$();
            } else {
                LOG.debug().$("o3 commit no lag [table=").$(this.tableName).$(", o3RowCount=").$(this.o3RowCount).I$();
                srcOooMax = this.o3RowCount;
            }
            if (srcOooMax == 0L) {
                boolean bl = true;
                return bl;
            }
            o3TimestampMax = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, srcOooMax - 1L);
            this.o3Sort(sortedTimestampsAddr, timestampIndex, this.o3RowCount);
            LOG.info().$("sorted [table=").utf8(this.tableName).I$();
            this.processO3Block(o3LagRowCount, timestampIndex, sortedTimestampsAddr, srcOooMax, o3TimestampMin, o3TimestampMax, true, 0L);
        }
        finally {
            this.finishO3Append(o3LagRowCount);
        }
        return this.finishO3Commit(partitionTimestampHiLimit);
    }

    private void o3CommitPartitionAsync(AtomicInteger columnCounter, long maxTimestamp, long sortedTimestampsAddr, long srcOooMax, long oooTimestampMin, long oooTimestampMax, long srcOooLo, long srcOooHi, long partitionTimestamp, boolean last, long srcDataMax, long srcNameTxn, O3Basket o3Basket, long colTopSinkAddr) {
        long cursor = this.messageBus.getO3PartitionPubSeq().next();
        if (cursor > -1L) {
            O3PartitionTask task = this.messageBus.getO3PartitionQueue().get(cursor);
            task.of(this.path, this.partitionBy, this.columns, this.o3Columns, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, partitionTimestamp, maxTimestamp, srcDataMax, srcNameTxn, last, this.getTxn(), sortedTimestampsAddr, this, columnCounter, o3Basket, colTopSinkAddr);
            this.messageBus.getO3PartitionPubSeq().done(cursor);
        } else {
            O3PartitionJob.processPartition(this.path, this.partitionBy, this.columns, this.o3Columns, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, partitionTimestamp, maxTimestamp, srcDataMax, srcNameTxn, last, this.getTxn(), sortedTimestampsAddr, this, columnCounter, o3Basket, colTopSinkAddr);
        }
    }

    private void o3ConsumePartitionUpdates(long srcOooMax, long timestampMin, long timestampMax) {
        MCSequence partitionSubSeq = this.messageBus.getO3PartitionSubSeq();
        RingQueue<O3PartitionTask> partitionQueue = this.messageBus.getO3PartitionQueue();
        MCSequence openColumnSubSeq = this.messageBus.getO3OpenColumnSubSeq();
        RingQueue<O3OpenColumnTask> openColumnQueue = this.messageBus.getO3OpenColumnQueue();
        MCSequence copySubSeq = this.messageBus.getO3CopySubSeq();
        RingQueue<O3CopyTask> copyQueue = this.messageBus.getO3CopyQueue();
        do {
            long cursor;
            if ((cursor = this.o3PartitionUpdateSubSeq.next()) > -1L) {
                O3PartitionUpdateTask task = this.o3PartitionUpdateQueue.get(cursor);
                long partitionTimestamp = task.getPartitionTimestamp();
                long srcOooPartitionLo = task.getSrcOooPartitionLo();
                long srcOooPartitionHi = task.getSrcOooPartitionHi();
                long srcDataMax = task.getSrcDataMax();
                boolean partitionMutates = task.isPartitionMutates();
                this.o3ClockDownPartitionUpdateCount();
                this.o3PartitionUpdateSubSeq.done(cursor);
                if (this.o3ErrorCount.get() != 0) continue;
                this.o3PartitionUpdate(timestampMin, timestampMax, partitionTimestamp, srcOooPartitionLo, srcOooPartitionHi, srcOooMax, srcDataMax, partitionMutates);
                continue;
            }
            cursor = partitionSubSeq.next();
            if (cursor > -1L) {
                O3PartitionTask partitionTask = partitionQueue.get(cursor);
                if (partitionTask.getTableWriter() == this && this.o3ErrorCount.get() > 0) {
                    partitionSubSeq.done(cursor);
                    this.o3ClockDownPartitionUpdateCount();
                    this.o3CountDownDoneLatch();
                    continue;
                }
                this.o3ProcessPartitionSafe(partitionSubSeq, cursor, partitionTask);
                continue;
            }
            cursor = openColumnSubSeq.next();
            if (cursor > -1L) {
                O3OpenColumnTask openColumnTask = openColumnQueue.get(cursor);
                if (openColumnTask.getTableWriter() == this && this.o3ErrorCount.get() > 0) {
                    O3CopyJob.closeColumnIdle(openColumnTask.getColumnCounter(), openColumnTask.getTimestampMergeIndexAddr(), openColumnTask.getTimestampMergeIndexSize(), openColumnTask.getSrcTimestampFd(), openColumnTask.getSrcTimestampAddr(), openColumnTask.getSrcTimestampSize(), this);
                    openColumnSubSeq.done(cursor);
                    continue;
                }
                this.o3OpenColumnSafe(openColumnSubSeq, cursor, openColumnTask);
                continue;
            }
            cursor = copySubSeq.next();
            if (cursor <= -1L) continue;
            O3CopyTask copyTask = copyQueue.get(cursor);
            if (copyTask.getTableWriter() == this && this.o3ErrorCount.get() > 0) {
                O3CopyJob.copyIdle(copyTask.getColumnCounter(), copyTask.getPartCounter(), copyTask.getTimestampMergeIndexAddr(), copyTask.getTimestampMergeIndexSize(), copyTask.getSrcDataFixFd(), copyTask.getSrcDataFixAddr(), copyTask.getSrcDataFixSize(), copyTask.getSrcDataVarFd(), copyTask.getSrcDataVarAddr(), copyTask.getSrcDataVarSize(), copyTask.getDstFixFd(), copyTask.getDstFixAddr(), copyTask.getDstFixSize(), copyTask.getDstVarFd(), copyTask.getDstVarAddr(), copyTask.getDstVarSize(), copyTask.getSrcTimestampFd(), copyTask.getSrcTimestampAddr(), copyTask.getSrcTimestampSize(), copyTask.getDstKFd(), copyTask.getDstVFd(), this);
                copySubSeq.done(cursor);
                continue;
            }
            this.o3CopySafe(cursor);
        } while (this.o3PartitionUpdRemaining.get() > 0L);
    }

    private void o3CopySafe(long cursor) {
        O3CopyTask task = this.messageBus.getO3CopyQueue().get(cursor);
        try {
            O3CopyJob.copy(task, cursor, this.messageBus.getO3CopySubSeq());
        }
        catch (CairoError | CairoException e) {
            LOG.error().$((Sinkable)((Object)e)).$();
        }
        catch (Throwable e) {
            LOG.error().$(e).$();
        }
    }

    void o3CountDownDoneLatch() {
        this.o3DoneLatch.countDown();
    }

    private void o3MoveLag0(int columnIndex, int columnType, long o3LagRowCount, long o3RowCount) {
        if (columnIndex > -1) {
            long size;
            long sourceOffset;
            MemoryARW o3DataMem = this.o3MemColumns.get(TableWriter.getPrimaryColumnIndex(columnIndex));
            MemoryARW o3IndexMem = this.o3MemColumns.get(TableWriter.getSecondaryColumnIndex(columnIndex));
            int shl = ColumnType.pow2SizeOf(columnType);
            if (null == o3IndexMem) {
                sourceOffset = o3RowCount << shl;
                size = o3LagRowCount << shl;
            } else {
                sourceOffset = o3IndexMem.getLong(o3RowCount * 8L);
                size = o3DataMem.getAppendOffset() - sourceOffset;
                O3Utils.shiftCopyFixedSizeColumnData(sourceOffset, o3IndexMem.addressOf(o3RowCount * 8L), 0L, o3LagRowCount, o3IndexMem.addressOf(0L));
                o3IndexMem.jumpTo(o3LagRowCount * 8L + 8L);
            }
            Vect.memmove(o3DataMem.addressOf(0L), o3DataMem.addressOf(sourceOffset), size);
            o3DataMem.jumpTo(size);
        } else {
            long sourceOffset = o3RowCount * 16L;
            long mergeMemAddr = this.o3TimestampMem.getAddress();
            Vect.shiftTimestampIndex(mergeMemAddr + sourceOffset, o3LagRowCount, mergeMemAddr);
            this.o3TimestampMem.jumpTo(o3LagRowCount * 16L);
        }
    }

    private long o3MoveUncommitted(int timestampIndex) {
        long committedRowCount = this.txWriter.unsafeCommittedFixedRowCount() + this.txWriter.unsafeCommittedTransientRowCount();
        long rowsAdded = this.txWriter.getRowCount() - committedRowCount;
        long transientRowsAdded = Math.min(this.txWriter.getTransientRowCount(), rowsAdded);
        if (transientRowsAdded > 0L) {
            LOG.debug().$("o3 move uncommitted [table=").$(this.tableName).$(", transientRowsAdded=").$(transientRowsAdded).I$();
            long committedTransientRowCount = this.txWriter.getTransientRowCount() - transientRowsAdded;
            return this.o3ScheduleMoveUncommitted0(timestampIndex, transientRowsAdded, committedTransientRowCount);
        }
        return 0L;
    }

    private void o3MoveUncommitted0(int colIndex, int columnType, long committedTransientRowCount, long transientRowsAdded) {
        if (colIndex > -1) {
            long srcFixOffset;
            long extendedSize;
            MemoryMA srcDataMem = this.getPrimaryColumn(colIndex);
            int shl = ColumnType.pow2SizeOf(columnType);
            MemoryARW o3DataMem = this.o3MemColumns.get(TableWriter.getPrimaryColumnIndex(colIndex));
            MemoryARW o3IndexMem = this.o3MemColumns.get(TableWriter.getSecondaryColumnIndex(colIndex));
            long dstVarOffset = o3DataMem.getAppendOffset();
            long columnTop = this.columnTops.getQuick(colIndex);
            if (columnTop > 0L) {
                LOG.debug().$("move uncommitted [columnTop=").$(columnTop).$(", columnIndex=").$(colIndex).$(", committedTransientRowCount=").$(committedTransientRowCount).$(", transientRowsAdded=").$(transientRowsAdded).I$();
            }
            if (null == o3IndexMem) {
                extendedSize = transientRowsAdded << shl;
                srcFixOffset = committedTransientRowCount - columnTop << shl;
            } else {
                long alignedExtraLen;
                boolean locallyMapped;
                int indexShl = 3;
                MemoryMA srcFixMem = this.getSecondaryColumn(colIndex);
                long sourceOffset = committedTransientRowCount - columnTop << 3;
                long sourceLen = transientRowsAdded + 1L << 3;
                long dstAppendOffset = o3IndexMem.getAppendOffset();
                o3IndexMem.jumpTo(dstAppendOffset + (transientRowsAdded << 3));
                long srcAddress = srcFixMem.map(sourceOffset, sourceLen);
                boolean bl = locallyMapped = srcAddress == 0L;
                if (!locallyMapped) {
                    alignedExtraLen = 0L;
                } else {
                    long alignedOffset = Files.floorPageSize(sourceOffset);
                    alignedExtraLen = sourceOffset - alignedOffset;
                    srcAddress = TableUtils.mapRO(this.ff, srcFixMem.getFd(), sourceLen + alignedExtraLen, alignedOffset, 5);
                }
                long srcVarOffset = Unsafe.getUnsafe().getLong(srcAddress + alignedExtraLen);
                O3Utils.shiftCopyFixedSizeColumnData(srcVarOffset - dstVarOffset, srcAddress + alignedExtraLen + 8L, 0L, transientRowsAdded - 1L, o3IndexMem.addressOf(dstAppendOffset));
                if (locallyMapped) {
                    this.ff.munmap(srcAddress, sourceLen + alignedExtraLen, 5);
                }
                extendedSize = srcDataMem.getAppendOffset() - srcVarOffset;
                srcFixOffset = srcVarOffset;
                srcFixMem.jumpTo(sourceOffset + 8L);
            }
            o3DataMem.jumpTo(dstVarOffset + extendedSize);
            long appendAddress = o3DataMem.addressOf(dstVarOffset);
            long sourceAddress = srcDataMem.map(srcFixOffset, extendedSize);
            if (sourceAddress != 0L) {
                Vect.memcpy(appendAddress, sourceAddress, extendedSize);
            } else {
                long alignedOffset = Files.floorPageSize(srcFixOffset);
                long alignedExtraLen = srcFixOffset - alignedOffset;
                sourceAddress = TableUtils.mapRO(this.ff, srcDataMem.getFd(), extendedSize + alignedExtraLen, alignedOffset, 5);
                Vect.memcpy(appendAddress, sourceAddress + alignedExtraLen, extendedSize);
                this.ff.munmap(sourceAddress, extendedSize + alignedExtraLen, 5);
            }
            srcDataMem.jumpTo(srcFixOffset);
        } else {
            long alignedExtraLen;
            boolean locallyMapped;
            long srcFixLen;
            long srcFixOffset;
            colIndex = -colIndex - 1;
            int shl = ColumnType.pow2SizeOf(8);
            MemoryMA srcDataMem = this.getPrimaryColumn(colIndex);
            long address = srcDataMem.map(srcFixOffset = committedTransientRowCount << shl, srcFixLen = transientRowsAdded << shl);
            boolean bl = locallyMapped = address == 0L;
            if (!locallyMapped) {
                alignedExtraLen = 0L;
            } else {
                long alignedOffset = Files.floorPageSize(srcFixOffset);
                alignedExtraLen = srcFixOffset - alignedOffset;
                address = TableUtils.mapRO(this.ff, srcDataMem.getFd(), srcFixLen + alignedExtraLen, alignedOffset, 5);
            }
            for (long n = 0L; n < transientRowsAdded; ++n) {
                long ts = Unsafe.getUnsafe().getLong(address + alignedExtraLen + (n << shl));
                this.o3TimestampMem.putLongLong(ts, this.o3RowCount + n);
            }
            if (locallyMapped) {
                this.ff.munmap(address, srcFixLen + alignedExtraLen, 5);
            }
            srcDataMem.jumpTo(srcFixOffset);
        }
    }

    private void o3OpenColumnSafe(Sequence openColumnSubSeq, long cursor, O3OpenColumnTask openColumnTask) {
        try {
            O3OpenColumnJob.openColumn(openColumnTask, cursor, openColumnSubSeq);
        }
        catch (CairoError | CairoException e) {
            LOG.error().$((Sinkable)((Object)e)).$();
        }
        catch (Throwable e) {
            LOG.error().$(e).$();
        }
    }

    private void o3OpenColumns() {
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.metadata.getColumnType(i) <= 0) continue;
            MemoryARW mem1 = this.o3MemColumns.getQuick(TableWriter.getPrimaryColumnIndex(i));
            mem1.jumpTo(0L);
            MemoryARW mem2 = this.o3MemColumns.getQuick(TableWriter.getSecondaryColumnIndex(i));
            if (mem2 == null) continue;
            mem2.jumpTo(0L);
            mem2.putLong(0L);
        }
        this.activeColumns = this.o3MemColumns;
        this.activeNullSetters = this.o3NullSetters;
        LOG.debug().$("switched partition to memory").$();
    }

    private void o3PartitionUpdate(long timestampMin, long timestampMax, long partitionTimestamp, long srcOooPartitionLo, long srcOooPartitionHi, long srcOooMax, long srcDataMax, boolean partitionMutates) {
        this.txWriter.minTimestamp = Math.min(timestampMin, this.txWriter.minTimestamp);
        long partitionSize = srcDataMax + srcOooPartitionHi - srcOooPartitionLo + 1L;
        long rowDelta = srcOooPartitionHi - srcOooMax;
        int partitionIndex = this.txWriter.findAttachedPartitionIndexByLoTimestamp(partitionTimestamp);
        if (partitionTimestamp == this.lastPartitionTimestamp) {
            if (partitionMutates) {
                this.closeActivePartition(true);
            } else if (rowDelta < -1L) {
                this.closeActivePartition(partitionSize);
            } else {
                this.setAppendPosition(partitionSize, false);
            }
        }
        LOG.debug().$("o3 partition update [timestampMin=").$ts(timestampMin).$(", timestampMax=").$ts(timestampMax).$(", last=").$(partitionTimestamp == this.lastPartitionTimestamp).$(", partitionTimestamp=").$ts(partitionTimestamp).$(", srcOooPartitionLo=").$(srcOooPartitionLo).$(", srcOooPartitionHi=").$(srcOooPartitionHi).$(", srcOooMax=").$(srcOooMax).$(", srcDataMax=").$(srcDataMax).$(", partitionMutates=").$(partitionMutates).$(", lastPartitionTimestamp=").$(this.lastPartitionTimestamp).$(", partitionSize=").$(partitionSize).I$();
        if (partitionMutates) {
            long srcDataTxn = this.txWriter.getPartitionNameTxnByIndex(partitionIndex);
            LOG.info().$("merged partition [table=`").utf8(this.tableName).$("`, ts=").$ts(partitionTimestamp).$(", txn=").$(this.txWriter.txn).I$();
            this.txWriter.updatePartitionSizeAndTxnByIndex(partitionIndex, partitionSize);
            this.o3PartitionRemoveCandidates.add(partitionTimestamp, srcDataTxn);
            this.txWriter.bumpPartitionTableVersion();
        } else {
            if (partitionTimestamp != this.lastPartitionTimestamp) {
                this.txWriter.bumpPartitionTableVersion();
            }
            this.txWriter.updatePartitionSizeByIndex(partitionIndex, partitionTimestamp, partitionSize);
        }
    }

    synchronized void o3PartitionUpdateSynchronized(long timestampMin, long timestampMax, long partitionTimestamp, long srcOooPartitionLo, long srcOooPartitionHi, boolean partitionMutates, long srcOooMax, long srcDataMax) {
        this.o3ClockDownPartitionUpdateCount();
        this.o3PartitionUpdate(timestampMin, timestampMax, partitionTimestamp, srcOooPartitionLo, srcOooPartitionHi, srcOooMax, srcDataMax, partitionMutates);
    }

    private void o3ProcessPartitionRemoveCandidates() {
        try {
            int n = this.o3PartitionRemoveCandidates.size();
            if (n > 0) {
                this.o3ProcessPartitionRemoveCandidates0(n);
            }
        }
        finally {
            this.o3PartitionRemoveCandidates.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void o3ProcessPartitionRemoveCandidates0(int n) {
        boolean anyReadersBeforeCommittedTxn;
        boolean scheduleAsyncPurge = anyReadersBeforeCommittedTxn = this.checkScoreboardHasReadersBeforeLastCommittedTxn();
        if (!anyReadersBeforeCommittedTxn) {
            for (int i = 0; i < n; i += 2) {
                try {
                    long timestamp = this.o3PartitionRemoveCandidates.getQuick(i);
                    long txn = this.o3PartitionRemoveCandidates.getQuick(i + 1);
                    TableUtils.setPathForPartition(this.other, this.partitionBy, timestamp, false);
                    TableUtils.txnPartitionConditionally(this.other, txn);
                    long errno = this.ff.rmdir(this.other.$());
                    if (errno == 0L || errno == -1L) {
                        LOG.info().$("purged [path=").$(this.other).I$();
                        continue;
                    }
                    LOG.info().$("could not purge partition version, async purge will be scheduled [path=").$(this.other).$(", errno=").$(errno).I$();
                    scheduleAsyncPurge = true;
                    continue;
                }
                finally {
                    this.other.trimTo(this.rootLen);
                }
            }
        }
        if (scheduleAsyncPurge) {
            if (TableUtils.schedulePurgeO3Partitions(this.messageBus, this.tableName, this.partitionBy)) {
                LOG.info().$("scheduled to purge partitions").$(", table=").$(this.tableName).I$();
            } else {
                LOG.error().$("could not queue for purge, queue is full [table=").$(this.tableName).I$();
            }
        }
    }

    private void o3ProcessPartitionSafe(Sequence partitionSubSeq, long cursor, O3PartitionTask partitionTask) {
        try {
            O3PartitionJob.processPartition(partitionTask, cursor, partitionSubSeq);
        }
        catch (CairoError | CairoException e) {
            LOG.error().$((Sinkable)((Object)e)).$();
        }
        catch (Throwable e) {
            LOG.error().$(e).$();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long o3ScheduleMoveUncommitted0(int timestampIndex, long transientRowsAdded, long committedTransientRowCount) {
        if (transientRowsAdded > 0L) {
            MPSequence pubSeq = this.messageBus.getO3CallbackPubSeq();
            RingQueue<O3CallbackTask> queue = this.messageBus.getO3CallbackQueue();
            this.o3PendingCallbackTasks.clear();
            this.o3DoneLatch.reset();
            int queuedCount = 0;
            for (int colIndex = 0; colIndex < this.columnCount; ++colIndex) {
                int columnType = this.metadata.getColumnType(colIndex);
                if (columnType <= 0) continue;
                int columnIndex = colIndex != timestampIndex ? colIndex : -colIndex - 1;
                long cursor = pubSeq.next();
                if (cursor > -1L) {
                    try {
                        O3CallbackTask task = queue.get(cursor);
                        task.of(this.o3DoneLatch, columnIndex, columnType, committedTransientRowCount, transientRowsAdded, this.o3MoveUncommittedRef);
                        this.o3PendingCallbackTasks.add(task);
                        continue;
                    }
                    finally {
                        ++queuedCount;
                        pubSeq.done(cursor);
                    }
                }
                this.o3MoveUncommitted0(columnIndex, columnType, committedTransientRowCount, transientRowsAdded);
            }
            for (int n = this.o3PendingCallbackTasks.size() - 1; n > -1; --n) {
                O3CallbackTask task = this.o3PendingCallbackTasks.getQuick(n);
                if (!task.tryLock()) continue;
                O3CallbackJob.runCallbackWithCol(task, -1L, null);
            }
            this.o3DoneLatch.await(queuedCount);
        }
        this.txWriter.resetToLastPartition(committedTransientRowCount);
        return transientRowsAdded;
    }

    private void o3SetAppendOffset(int columnIndex, int columnType, long o3RowCount) {
        if (columnIndex != this.metadata.getTimestampIndex()) {
            long size;
            MemoryARW o3DataMem = this.o3MemColumns.get(TableWriter.getPrimaryColumnIndex(columnIndex));
            MemoryARW o3IndexMem = this.o3MemColumns.get(TableWriter.getSecondaryColumnIndex(columnIndex));
            if (null == o3IndexMem) {
                size = o3RowCount << ColumnType.pow2SizeOf(columnType);
            } else if (o3RowCount > 0L) {
                size = o3IndexMem.getLong(o3RowCount * 8L);
                o3IndexMem.jumpTo((o3RowCount + 1L) * 8L);
            } else {
                size = 0L;
                o3IndexMem.jumpTo(0L);
            }
            o3DataMem.jumpTo(size);
        } else {
            this.o3TimestampMem.jumpTo(o3RowCount * 16L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void o3ShiftLagRowsUp(int timestampIndex, long o3LagRowCount, long o3RowCount) {
        this.o3PendingCallbackTasks.clear();
        MPSequence pubSeq = this.messageBus.getO3CallbackPubSeq();
        RingQueue<O3CallbackTask> queue = this.messageBus.getO3CallbackQueue();
        this.o3DoneLatch.reset();
        int queuedCount = 0;
        for (int colIndex = 0; colIndex < this.columnCount; ++colIndex) {
            int columnType = this.metadata.getColumnType(colIndex);
            int columnIndex = colIndex != timestampIndex ? colIndex : -colIndex - 1;
            long cursor = pubSeq.next();
            if (cursor > -1L && columnType > 0) {
                try {
                    O3CallbackTask task = queue.get(cursor);
                    task.of(this.o3DoneLatch, columnIndex, columnType, o3LagRowCount, o3RowCount, this.o3MoveLagRef);
                    this.o3PendingCallbackTasks.add(task);
                    continue;
                }
                finally {
                    ++queuedCount;
                    pubSeq.done(cursor);
                }
            }
            if (columnType <= 0) continue;
            this.o3MoveLag0(columnIndex, columnType, o3LagRowCount, o3RowCount);
        }
        for (int n = this.o3PendingCallbackTasks.size() - 1; n > -1; --n) {
            O3CallbackTask task = this.o3PendingCallbackTasks.getQuick(n);
            if (!task.tryLock()) continue;
            O3CallbackJob.runCallbackWithCol(task, -1L, null);
        }
        this.o3DoneLatch.await(queuedCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void o3Sort(long mergedTimestamps, int timestampIndex, long rowCount) {
        this.o3PendingCallbackTasks.clear();
        MPSequence pubSeq = this.messageBus.getO3CallbackPubSeq();
        RingQueue<O3CallbackTask> queue = this.messageBus.getO3CallbackQueue();
        this.o3DoneLatch.reset();
        int queuedCount = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            int type = this.metadata.getColumnType(i);
            if (timestampIndex == i || type <= 0) continue;
            long cursor = pubSeq.next();
            if (cursor > -1L) {
                try {
                    O3CallbackTask task = queue.get(cursor);
                    task.of(this.o3DoneLatch, i, type, mergedTimestamps, rowCount, ColumnType.isVariableLength(type) ? this.oooSortVarColumnRef : this.oooSortFixColumnRef);
                    this.o3PendingCallbackTasks.add(task);
                    continue;
                }
                finally {
                    ++queuedCount;
                    pubSeq.done(cursor);
                }
            }
            this.o3SortColumn(mergedTimestamps, i, type, rowCount);
        }
        for (int n = this.o3PendingCallbackTasks.size() - 1; n > -1; --n) {
            O3CallbackTask task = this.o3PendingCallbackTasks.getQuick(n);
            if (!task.tryLock()) continue;
            O3CallbackJob.runCallbackWithCol(task, -1L, null);
        }
        this.o3DoneLatch.await(queuedCount);
        this.swapO3ColumnsExcept(timestampIndex);
    }

    private void o3SortColumn(long mergedTimestamps, int i, int type, long rowCount) {
        if (ColumnType.isVariableLength(type)) {
            this.o3SortVarColumn(i, type, mergedTimestamps, rowCount);
        } else {
            this.o3SortFixColumn(i, type, mergedTimestamps, rowCount);
        }
    }

    private void o3SortFixColumn(int columnIndex, int columnType, long mergedTimestampsAddr, long valueCount) {
        int columnOffset = TableWriter.getPrimaryColumnIndex(columnIndex);
        MemoryCR mem = this.o3Columns.getQuick(columnOffset);
        MemoryCARW mem2 = this.o3MemColumns2.getQuick(columnOffset);
        int shl = ColumnType.pow2SizeOf(columnType);
        long src = mem.addressOf(0L);
        mem2.jumpTo(valueCount << shl);
        long tgtDataAddr = mem2.addressOf(0L);
        switch (shl) {
            case 0: {
                Vect.indexReshuffle8Bit(src, tgtDataAddr, mergedTimestampsAddr, valueCount);
                break;
            }
            case 1: {
                Vect.indexReshuffle16Bit(src, tgtDataAddr, mergedTimestampsAddr, valueCount);
                break;
            }
            case 2: {
                Vect.indexReshuffle32Bit(src, tgtDataAddr, mergedTimestampsAddr, valueCount);
                break;
            }
            case 3: {
                Vect.indexReshuffle64Bit(src, tgtDataAddr, mergedTimestampsAddr, valueCount);
                break;
            }
            case 5: {
                Vect.indexReshuffle256Bit(src, tgtDataAddr, mergedTimestampsAddr, valueCount);
                break;
            }
            default: {
                assert (false) : "col type is unsupported";
                break;
            }
        }
    }

    private void o3SortVarColumn(int columnIndex, int columnType, long mergedTimestampsAddr, long valueCount) {
        int primaryIndex = TableWriter.getPrimaryColumnIndex(columnIndex);
        int secondaryIndex = primaryIndex + 1;
        MemoryCR dataMem = this.o3Columns.getQuick(primaryIndex);
        MemoryCR indexMem = this.o3Columns.getQuick(secondaryIndex);
        MemoryCARW dataMem2 = this.o3MemColumns2.getQuick(primaryIndex);
        MemoryCARW indexMem2 = this.o3MemColumns2.getQuick(secondaryIndex);
        long srcDataAddr = dataMem.addressOf(0L);
        long srcIndxAddr = indexMem.addressOf(0L);
        long tgtDataAddr = dataMem2.resize(dataMem.size());
        long tgtIndxAddr = indexMem2.resize(valueCount * 8L);
        assert (srcDataAddr != 0L);
        assert (srcIndxAddr != 0L);
        assert (tgtDataAddr != 0L);
        assert (tgtIndxAddr != 0L);
        long offset = Vect.sortVarColumn(mergedTimestampsAddr, valueCount, srcDataAddr, srcIndxAddr, tgtDataAddr, tgtIndxAddr);
        dataMem2.jumpTo(offset);
        indexMem2.jumpTo(valueCount * 8L);
        indexMem2.putLong(offset);
    }

    private void o3TimestampSetter(long timestamp) {
        this.o3TimestampMem.putLongLong(timestamp, this.getO3RowCount0());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openColumnFiles(CharSequence name, long columnNameTxn, int columnIndex, int pathTrimToLen) {
        MemoryMA mem1 = this.getPrimaryColumn(columnIndex);
        MemoryMA mem2 = this.getSecondaryColumn(columnIndex);
        try {
            mem1.of(this.ff, TableUtils.dFile(this.path.trimTo(pathTrimToLen), name, columnNameTxn), this.configuration.getDataAppendPageSize(), -1L, 5, this.configuration.getWriterFileOpenOpts());
            if (mem2 != null) {
                mem2.of(this.ff, TableUtils.iFile(this.path.trimTo(pathTrimToLen), name, columnNameTxn), this.configuration.getDataAppendPageSize(), -1L, 5, this.configuration.getWriterFileOpenOpts());
            }
        }
        finally {
            this.path.trimTo(pathTrimToLen);
        }
    }

    private void openFirstPartition(long timestamp) {
        long ts = this.repairDataGaps(timestamp);
        this.openPartition(ts);
        this.populateDenseIndexerList();
        this.setAppendPosition(this.txWriter.getTransientRowCount(), false);
        if (this.performRecovery) {
            this.performRecovery();
        }
        this.txWriter.openFirstPartition(ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openNewColumnFiles(CharSequence name, boolean indexFlag, int indexValueBlockCapacity) {
        try {
            MemoryMA mem2;
            long partitionTimestamp = this.txWriter.getLastPartitionTimestamp();
            this.setStateForTimestamp(this.path, partitionTimestamp, false);
            int plen = this.path.length();
            int columnIndex = this.columnCount - 1;
            long columnNameTxn = this.getTxn();
            if (indexFlag) {
                this.createIndexFiles(name, columnNameTxn, indexValueBlockCapacity, plen, true);
            }
            this.openColumnFiles(name, columnNameTxn, columnIndex, plen);
            if (this.txWriter.getTransientRowCount() > 0L) {
                this.columnVersionWriter.upsert(this.txWriter.getLastPartitionTimestamp(), columnIndex, columnNameTxn, this.txWriter.getTransientRowCount());
            }
            if (indexFlag) {
                ColumnIndexer indexer = this.indexers.getQuick(columnIndex);
                assert (indexer != null);
                this.indexers.getQuick(columnIndex).configureFollowerAndWriter(this.configuration, this.path.trimTo(plen), name, columnNameTxn, this.getPrimaryColumn(columnIndex), this.txWriter.getTransientRowCount());
            }
            if ((mem2 = this.getSecondaryColumn(this.columnCount - 1)) != null) {
                mem2.putLong(0L);
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void openPartition(long timestamp) {
        try {
            this.setStateForTimestamp(this.path, timestamp, true);
            int plen = this.path.length();
            if (this.ff.mkdirs(this.path.slash$(), this.mkDirMode) != 0) {
                throw CairoException.critical(this.ff.errno()).put("Cannot create directory: ").put(this.path);
            }
            assert (this.columnCount > 0);
            long partitionTimestamp = this.txWriter.getPartitionTimestampLo(timestamp);
            for (int i = 0; i < this.columnCount; ++i) {
                ColumnIndexer indexer;
                if (this.metadata.getColumnType(i) <= 0) continue;
                String name = this.metadata.getColumnName(i);
                long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(partitionTimestamp, i);
                ColumnIndexer columnIndexer = indexer = this.metadata.isColumnIndexed(i) ? this.indexers.getQuick(i) : null;
                if (indexer != null) {
                    this.createIndexFiles(name, columnNameTxn, this.metadata.getIndexValueBlockCapacity(i), plen, this.txWriter.getTransientRowCount() < 1L);
                    indexer.closeSlider();
                }
                this.openColumnFiles(name, columnNameTxn, i, plen);
                long columnTop = this.columnVersionWriter.getColumnTopQuick(partitionTimestamp, i);
                this.columnTops.extendAndSet(i, columnTop);
                if (indexer == null) continue;
                indexer.configureFollowerAndWriter(this.configuration, this.path, name, columnNameTxn, this.getPrimaryColumn(i), columnTop);
            }
            this.populateDenseIndexerList();
            LOG.info().$("switched partition [path='").$(this.path).$('\'').I$();
        }
        catch (Throwable e) {
            this.distressed = true;
            throw e;
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long openTodoMem() {
        this.path.concat("_todo_").$();
        try {
            if (this.ff.exists(this.path)) {
                long fileLen = this.ff.length(this.path);
                if (fileLen < 32L) {
                    throw CairoException.critical(0).put("corrupt ").put(this.path);
                }
                this.todoMem.smallFile(this.ff, this.path, 5);
                this.todoTxn = this.todoMem.getLong(0L);
                if (this.todoMem.getLong(24L) != this.todoTxn) {
                    this.todoMem.putLong(8L, this.configuration.getDatabaseIdLo());
                    this.todoMem.putLong(16L, this.configuration.getDatabaseIdHi());
                    Unsafe.getUnsafe().storeFence();
                    this.todoMem.putLong(24L, this.todoTxn);
                    long l = 0L;
                    return l;
                }
                long l = this.todoMem.getLong(32L);
                return l;
            }
            TableUtils.resetTodoLog(this.ff, this.path, this.rootLen, this.todoMem);
            this.todoTxn = 0L;
            long l = 0L;
            return l;
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void performRecovery() {
        this.rollbackIndexes();
        this.rollbackSymbolTables();
        this.performRecovery = false;
    }

    private void populateDenseIndexerList() {
        this.denseIndexers.clear();
        int n = this.indexers.size();
        for (int i = 0; i < n; ++i) {
            ColumnIndexer indexer = this.indexers.getQuick(i);
            if (indexer == null) continue;
            this.denseIndexers.add(indexer);
        }
        this.indexCount = this.denseIndexers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attachPrepare(long partitionTimestamp, long partitionSize, Path detachedPath, int detachedPartitionRoot) {
        try {
            detachedPath.trimTo(detachedPartitionRoot).concat("_meta");
            if (!this.ff.exists(detachedPath.$())) {
                LOG.info().$("detached ").$("_meta").$(" file not found, skipping check [path=").$(detachedPath).I$();
                boolean bl = false;
                return bl;
            }
            if (this.attachMetadata == null) {
                this.attachMetaMem = Vm.getCMRInstance();
                this.attachMetaMem.smallFile(this.ff, detachedPath, 5);
                this.attachMetadata = new TableWriterMetadata(this.attachMetaMem);
            } else {
                this.attachMetaMem.smallFile(this.ff, detachedPath, 5);
                this.attachMetadata.reload(this.attachMetaMem);
            }
            if (this.metadata.getId() != this.attachMetadata.getId()) {
                throw CairoException.detachedMetadataMismatch("table_id");
            }
            if (this.metadata.getTimestampIndex() != this.attachMetadata.getTimestampIndex()) {
                throw CairoException.detachedMetadataMismatch("timestamp_index");
            }
            detachedPath.trimTo(detachedPartitionRoot).concat("_cv").$();
            if (!this.ff.exists(detachedPath)) {
                LOG.error().$("detached _dcv file not found, skipping check [path=").$(detachedPath).I$();
                boolean bl = false;
                return bl;
            }
            if (this.attachColumnVersionReader == null) {
                this.attachColumnVersionReader = new ColumnVersionReader();
            }
            this.attachColumnVersionReader.ofRO(this.ff, detachedPath);
            this.attachColumnVersionReader.readUnsafe();
            this.columnVersionWriter.copyPartition(partitionTimestamp, this.attachColumnVersionReader);
            for (int colIdx = 0; colIdx < this.columnCount; ++colIdx) {
                int attachColType;
                String columnName = this.metadata.getColumnName(colIdx);
                int detColIdx = this.attachMetadata.getColumnIndexQuiet(columnName);
                if (detColIdx == -1) {
                    this.columnVersionWriter.upsertColumnTop(partitionTimestamp, colIdx, partitionSize);
                    continue;
                }
                if (detColIdx != colIdx) {
                    throw CairoException.detachedColumnMetadataMismatch(colIdx, columnName, "name");
                }
                int tableColType = this.metadata.getColumnType(colIdx);
                if (tableColType != (attachColType = this.attachMetadata.getColumnType(detColIdx)) && tableColType != -attachColType) {
                    throw CairoException.detachedColumnMetadataMismatch(colIdx, columnName, "type");
                }
                if (tableColType != attachColType) {
                    LOG.info().$("detached partition has column deleted while the table has the same column alive [tableName=").$(this.tableName).$(", columnName=").$(columnName).$(", columnType=").$(ColumnType.nameOf(tableColType)).I$();
                    this.columnVersionWriter.upsertColumnTop(partitionTimestamp, colIdx, partitionSize);
                }
                if (!ColumnType.isSymbol(tableColType)) continue;
                boolean isIndexedNow = this.metadata.isColumnIndexed(colIdx);
                boolean wasIndexedAtDetached = this.attachMetadata.isColumnIndexed(detColIdx);
                int indexValueBlockCapacityNow = this.metadata.getIndexValueBlockCapacity(colIdx);
                int indexValueBlockCapacityDetached = this.attachMetadata.getIndexValueBlockCapacity(detColIdx);
                if (!isIndexedNow && wasIndexedAtDetached) {
                    long columnNameTxn = this.attachColumnVersionReader.getColumnNameTxn(partitionTimestamp, colIdx);
                    BitmapIndexUtils.keyFileName(detachedPath.trimTo(detachedPartitionRoot), columnName, columnNameTxn);
                    TableWriter.removeFileAndOrLog(this.ff, detachedPath);
                    BitmapIndexUtils.valueFileName(detachedPath.trimTo(detachedPartitionRoot), columnName, columnNameTxn);
                    TableWriter.removeFileAndOrLog(this.ff, detachedPath);
                    continue;
                }
                if (!isIndexedNow || wasIndexedAtDetached && indexValueBlockCapacityNow == indexValueBlockCapacityDetached) continue;
                detachedPath.trimTo(detachedPartitionRoot);
                this.rebuildAttachedPartitionColumnIndex(partitionTimestamp, partitionSize, detachedPath, columnName);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Misc.free(this.attachColumnVersionReader);
            Misc.free(this.attachMetaMem);
            Misc.free(this.attachIndexBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAsyncWriterCommand(AsyncWriterCommand asyncWriterCommand, TableWriterTask cmd, long cursor, Sequence sequence, boolean contextAllowsAnyStructureChanges) {
        int cmdType = cmd.getType();
        long correlationId = cmd.getInstance();
        long tableId = cmd.getTableId();
        int errorCode = 0;
        CharSequence errorMsg = null;
        long affectedRowsCount = 0L;
        try {
            this.publishTableWriterEvent(cmdType, tableId, correlationId, 0, null, 0L, 64);
            LOG.info().$("received async cmd [type=").$(cmdType).$(", tableName=").$(this.tableName).$(", tableId=").$(tableId).$(", correlationId=").$(correlationId).$(", cursor=").$(cursor).I$();
            asyncWriterCommand = asyncWriterCommand.deserialize(cmd);
            affectedRowsCount = asyncWriterCommand.apply(this, contextAllowsAnyStructureChanges);
        }
        catch (ReaderOutOfDateException ex) {
            LOG.info().$("cannot complete async cmd, reader is out of date [type=").$(cmdType).$(", tableName=").$(this.tableName).$(", tableId=").$(tableId).$(", correlationId=").$(correlationId).I$();
            errorCode = -1;
            errorMsg = ex.getMessage();
        }
        catch (AlterTableContextException ex) {
            LOG.info().$("cannot complete async cmd, table structure change is not allowed [type=").$(cmdType).$(", tableName=").$(this.tableName).$(", tableId=").$(tableId).$(", correlationId=").$(correlationId).I$();
            errorCode = -2;
            errorMsg = "async cmd cannot change table structure while writer is busy";
        }
        catch (CairoException | SqlException ex) {
            errorCode = -3;
            errorMsg = ((FlyweightMessageContainer)((Object)ex)).getFlyweightMessage();
        }
        catch (Throwable ex) {
            LOG.error().$("error on processing async cmd [type=").$(cmdType).$(", tableName=").$(this.tableName).$(", ex=").$(ex).I$();
            errorCode = -4;
            errorMsg = ex.getMessage();
        }
        finally {
            sequence.done(cursor);
        }
        this.publishTableWriterEvent(cmdType, tableId, correlationId, errorCode, errorMsg, affectedRowsCount, 65);
    }

    private void processCommandQueue(boolean contextAllowsAnyStructureChanges) {
        long cursor;
        while ((cursor = this.commandSubSeq.next()) > -1L) {
            TableWriterTask cmd = this.commandQueue.get(cursor);
            this.processCommandQueue(cmd, this.commandSubSeq, cursor, contextAllowsAnyStructureChanges);
        }
    }

    private void processO3Block(long o3LagRowCount, int timestampIndex, long sortedTimestampsAddr, long srcOooMax, long o3TimestampMin, long o3TimestampMax, boolean flattenTimestamp1, long rowLo) {
        this.o3ErrorCount.set(0);
        this.o3PartitionRemoveCandidates.clear();
        this.o3ColumnCounters.clear();
        this.o3BasketPool.clear();
        long maxTimestamp = this.txWriter.getMaxTimestamp();
        long transientRowCount = this.txWriter.transientRowCount;
        this.o3DoneLatch.reset();
        this.o3PartitionUpdRemaining.set(0L);
        boolean success = true;
        int latchCount = 0;
        long srcOoo = rowLo;
        boolean flattenTimestamp = flattenTimestamp1;
        int pCount = 0;
        try {
            long prevTransientRowCount = transientRowCount;
            this.resizeColumnTopSink(o3TimestampMin, o3TimestampMax);
            while (srcOoo < srcOooMax) {
                try {
                    long srcNameTxn;
                    long srcDataMax;
                    long srcOooLo = srcOoo;
                    long o3Timestamp = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, srcOoo);
                    long srcOooTimestampCeil = this.partitionCeilMethod.ceil(o3Timestamp) - 1L;
                    long srcOooHi = srcOooTimestampCeil < o3TimestampMax ? Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, srcOooTimestampCeil, srcOoo, srcOooMax - 1L, 1) : srcOooMax - 1L;
                    long partitionTimestamp = this.partitionFloorMethod.floor(o3Timestamp);
                    boolean last = partitionTimestamp == this.lastPartitionTimestamp;
                    srcOoo = srcOooHi + 1L;
                    int partitionIndex = this.txWriter.findAttachedPartitionIndexByLoTimestamp(partitionTimestamp);
                    if (partitionIndex > -1) {
                        srcDataMax = last ? transientRowCount : this.getPartitionSizeByIndex(partitionIndex);
                        srcNameTxn = this.getPartitionNameTxnByIndex(partitionIndex);
                    } else {
                        srcDataMax = 0L;
                        srcNameTxn = this.txWriter.getTxn() - 1L;
                    }
                    boolean append = last && (srcDataMax == 0L || o3Timestamp >= maxTimestamp);
                    long srcOooBatchRowSize = srcOooHi - srcOooLo + 1L;
                    long partitionSize = srcDataMax + srcOooBatchRowSize;
                    LOG.debug().$("o3 partition task [table=").$(this.tableName).$(", srcOooLo=").$(srcOooLo).$(", srcOooHi=").$(srcOooHi).$(", srcOooMax=").$(srcOooMax).$(", o3TimestampMin=").$ts(o3TimestampMin).$(", o3Timestamp=").$ts(o3Timestamp).$(", o3TimestampMax=").$ts(o3TimestampMax).$(", partitionTimestamp=").$ts(partitionTimestamp).$(", partitionIndex=").$(partitionIndex).$(", srcDataMax=").$(srcDataMax).$(", maxTimestamp=").$ts(maxTimestamp).$(", last=").$(last).$(", partitionSize=").$(partitionSize).$(", append=").$(append).$(", memUsed=").$(Unsafe.getMemUsed()).I$();
                    if (partitionTimestamp < this.lastPartitionTimestamp) {
                        this.txWriter.fixedRowCount += partitionSize - srcDataMax;
                    } else if (partitionTimestamp == this.lastPartitionTimestamp) {
                        prevTransientRowCount = partitionSize;
                    } else {
                        this.txWriter.fixedRowCount += prevTransientRowCount;
                        prevTransientRowCount = partitionSize;
                    }
                    ++pCount;
                    this.o3PartitionUpdRemaining.incrementAndGet();
                    O3Basket o3Basket = this.o3BasketPool.next();
                    o3Basket.ensureCapacity(this.columnCount, this.indexCount);
                    AtomicInteger columnCounter = this.o3ColumnCounters.next();
                    ++latchCount;
                    if (append) {
                        try {
                            this.setAppendPosition(srcDataMax, false);
                        }
                        catch (Throwable e) {
                            this.o3BumpErrorCount();
                            this.o3ClockDownPartitionUpdateCount();
                            this.o3CountDownDoneLatch();
                            throw e;
                        }
                        columnCounter.set(this.metadata.getDenseColumnCount());
                        Path pathToPartition = Path.getThreadLocal(this.path);
                        TableUtils.setPathForPartition(pathToPartition, this.partitionBy, o3TimestampMin, false);
                        TableUtils.txnPartitionConditionally(pathToPartition, srcNameTxn);
                        int plen = pathToPartition.length();
                        int columnsPublished = 0;
                        for (int i = 0; i < this.columnCount; ++i) {
                            MemoryMA dstVarMem;
                            MemoryMA dstFixMem;
                            long srcOooVarAddr;
                            long srcOooFixAddr;
                            int columnType = this.metadata.getColumnType(i);
                            if (columnType < 0) continue;
                            int colOffset = TableWriter.getPrimaryColumnIndex(i);
                            boolean notTheTimestamp = i != timestampIndex;
                            String columnName = this.metadata.getColumnName(i);
                            int indexBlockCapacity = this.metadata.isColumnIndexed(i) ? this.metadata.getIndexValueBlockCapacity(i) : -1;
                            BitmapIndexWriter indexWriter = indexBlockCapacity > -1 ? this.getBitmapIndexWriter(i) : null;
                            MemoryR oooMem1 = this.o3Columns.getQuick(colOffset);
                            MemoryR oooMem2 = this.o3Columns.getQuick(colOffset + 1);
                            MemoryMA mem1 = this.columns.getQuick(colOffset);
                            MemoryMA mem2 = this.columns.getQuick(colOffset + 1);
                            long srcDataTop = this.getColumnTop(i);
                            if (!ColumnType.isVariableLength(columnType)) {
                                srcOooFixAddr = oooMem1.addressOf(0L);
                                srcOooVarAddr = 0L;
                                dstFixMem = mem1;
                                dstVarMem = null;
                            } else {
                                srcOooFixAddr = oooMem2.addressOf(0L);
                                srcOooVarAddr = oooMem1.addressOf(0L);
                                dstFixMem = mem2;
                                dstVarMem = mem1;
                            }
                            ++columnsPublished;
                            try {
                                O3OpenColumnJob.appendLastPartition(pathToPartition, plen, columnName, columnCounter, notTheTimestamp ? columnType : ColumnType.setDesignatedTimestampBit(columnType, true), srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, o3TimestampMin, o3TimestampMax, partitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, dstFixMem, dstVarMem, this, indexWriter, this.getColumnNameTxn(partitionTimestamp, i));
                                continue;
                            }
                            catch (Throwable e) {
                                if (columnCounter.addAndGet(columnsPublished - this.columnCount) == 0) {
                                    this.o3ClockDownPartitionUpdateCount();
                                    this.o3CountDownDoneLatch();
                                }
                                throw e;
                            }
                        }
                        this.addPhysicallyWrittenRows(srcOooBatchRowSize);
                        continue;
                    }
                    if (flattenTimestamp && this.o3RowCount > 0L) {
                        Vect.flattenIndex(sortedTimestampsAddr, this.o3RowCount);
                        flattenTimestamp = false;
                    }
                    long colTopSinkIndex = (long)(pCount - 1) * (long)(this.metadata.getColumnCount() + 1);
                    long columnTopSinkAddress = colTopSinkIndex * 8L;
                    long columnTopPartitionSinkAddr = this.o3ColumnTopSink.getAddress() + columnTopSinkAddress;
                    assert (columnTopPartitionSinkAddr + ((long)this.columnCount + 1L) * 8L <= this.o3ColumnTopSink.getAddress() + this.o3ColumnTopSink.size() * 8L);
                    this.o3ColumnTopSink.set(colTopSinkIndex, partitionTimestamp);
                    this.o3CommitPartitionAsync(columnCounter, maxTimestamp, sortedTimestampsAddr, srcOooMax, o3TimestampMin, o3TimestampMax, srcOooLo, srcOooHi, partitionTimestamp, last, srcDataMax, srcNameTxn, o3Basket, columnTopPartitionSinkAddr + 8L);
                }
                catch (CairoError | CairoException e) {
                    LOG.error().$((Sinkable)((Object)e)).$();
                    success = false;
                    throw e;
                }
            }
            this.txWriter.transientRowCount = prevTransientRowCount;
            this.partitionTimestampHi = Math.max(this.partitionTimestampHi, o3TimestampMax);
            this.txWriter.updateMaxTimestamp(Math.max(this.txWriter.getMaxTimestamp(), o3TimestampMax));
            LOG.debug().$("o3 expecting updates [table=").$(this.tableName).$(", partitionsPublished=").$(pCount).I$();
            this.o3ConsumePartitionUpdates(srcOooMax, o3TimestampMin, o3TimestampMax);
            this.o3DoneLatch.await(latchCount);
            boolean bl = this.o3InError = !success || this.o3ErrorCount.get() > 0;
        }
        catch (Throwable th) {
            try {
                LOG.error().$(th).$();
                throw th;
            }
            catch (Throwable throwable) {
                LOG.debug().$("o3 expecting updates [table=").$(this.tableName).$(", partitionsPublished=").$(pCount).I$();
                this.o3ConsumePartitionUpdates(srcOooMax, o3TimestampMin, o3TimestampMax);
                this.o3DoneLatch.await(latchCount);
                boolean bl = this.o3InError = !success || this.o3ErrorCount.get() > 0;
                if (success && this.o3ErrorCount.get() > 0) {
                    throw CairoException.critical(0).put("bulk update failed and will be rolled back");
                }
                throw throwable;
            }
        }
        if (success && this.o3ErrorCount.get() > 0) {
            throw CairoException.critical(0).put("bulk update failed and will be rolled back");
        }
        if (o3LagRowCount > 0L) {
            this.o3ShiftLagRowsUp(timestampIndex, o3LagRowCount, srcOooMax);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReplSyncCommand(TableWriterTask cmd, long cursor, Sequence sequence) {
        TableSyncModel syncModel;
        long dst = cmd.getInstance();
        long dstIP = cmd.getIp();
        long tableId = cmd.getTableId();
        try {
            LOG.info().$("received replication SYNC cmd [tableName=").$(this.tableName).$(", tableId=").$(tableId).$(", src=").$(dst).$(", srcIP=").$ip(dstIP).I$();
            syncModel = this.replHandleSyncCmd(cmd);
        }
        finally {
            sequence.done(cursor);
        }
        if (syncModel != null) {
            this.publishTableWriterEvent(syncModel, tableId, dst, dstIP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishTableWriterEvent(int cmdType, long tableId, long correlationId, int errorCode, CharSequence errorMsg, long affectedRowsCount, int eventType) {
        long pubCursor;
        do {
            if ((pubCursor = this.messageBus.getTableWriterEventPubSeq().next()) != -2L) continue;
            Os.pause();
        } while (pubCursor < -1L);
        if (pubCursor > -1L) {
            try {
                TableWriterTask event = this.messageBus.getTableWriterEventQueue().get(pubCursor);
                event.of(eventType, tableId, this.tableName);
                event.putInt(errorCode);
                if (errorCode != 0) {
                    event.putStr(errorMsg);
                } else {
                    event.putLong(affectedRowsCount);
                }
                event.setInstance(correlationId);
            }
            finally {
                this.messageBus.getTableWriterEventPubSeq().done(pubCursor);
            }
            if (eventType == 65) {
                LogRecord lg = LOG.info().$("published async command complete event [type=").$(cmdType).$(",tableName=").$(this.tableName).$(",tableId=").$(tableId).$(",correlationId=").$(correlationId);
                if (errorCode != 0) {
                    lg.$(",errorCode=").$(errorCode).$(",errorMsg=").$(errorMsg);
                }
                lg.I$();
            }
        } else {
            LOG.error().$("could not publish sync command complete event [type=").$(cmdType).$(",tableName=").$(this.tableName).$(",tableId=").$(tableId).$(",correlationId=").$(correlationId).I$();
        }
    }

    void publishTableWriterEvent(TableSyncModel model, long tableId, long dst, long dstIP) {
        long pubCursor;
        do {
            if ((pubCursor = this.messageBus.getTableWriterEventPubSeq().next()) != -2L) continue;
            Os.pause();
        } while (pubCursor < -1L);
        if (pubCursor > -1L) {
            TableWriterTask event = this.messageBus.getTableWriterEventQueue().get(pubCursor);
            model.toBinary(event);
            event.setInstance(dst);
            event.setIp(dstIP);
            event.setTableId(tableId);
            this.messageBus.getTableWriterEventPubSeq().done(pubCursor);
            LOG.info().$("published replication SYNC event [table=").$(this.tableName).$(", tableId=").$(tableId).$(", dst=").$(dst).$(", dstIP=").$ip(dstIP).I$();
        } else {
            LOG.error().$("could not publish slave sync event [table=").$(this.tableName).$(", tableId=").$(tableId).$(", dst=").$(dst).$(", dstIP=").$ip(dstIP).I$();
        }
    }

    void purgeUnusedPartitions() {
        if (PartitionBy.isPartitioned(this.partitionBy)) {
            this.removeNonAttachedPartitions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readMinTimestamp(long partitionTimestamp) {
        this.setStateForTimestamp(this.other, partitionTimestamp, false);
        try {
            TableUtils.dFile(this.other, this.metadata.getColumnName(this.metadata.getTimestampIndex()), -1L);
            if (this.ff.exists(this.other)) {
                long fd = TableUtils.openRO(this.ff, this.other, LOG);
                try {
                    long l = TableUtils.readLongOrFail(this.ff, fd, 0L, this.tempMem16b, this.other);
                    return l;
                }
                finally {
                    this.ff.close(fd);
                }
            }
            throw CairoException.critical(0).put("Partition does not exist [path=").put(this.other).put(']');
        }
        finally {
            this.other.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPartitionMinMax(FilesFacade ff, long partitionTimestamp, Path path, CharSequence columnName, long partitionSize) {
        TableUtils.dFile(path, columnName, -1L);
        long fd = TableUtils.openRO(ff, path, LOG);
        try {
            this.attachMinTimestamp = ff.readULong(fd, 0L);
            this.attachMaxTimestamp = ff.readULong(fd, (partitionSize - 1L) * (long)ColumnType.sizeOf(8));
            if (this.attachMinTimestamp < 0L || this.attachMaxTimestamp < 0L) {
                throw CairoException.critical(ff.errno()).put("cannot read min, max timestamp from the column [path=").put(path).put(", partitionSizeRows=").put(partitionSize).put(", errno=").put(ff.errno()).put(']');
            }
            if (this.partitionFloorMethod.floor(this.attachMinTimestamp) != partitionTimestamp || this.partitionFloorMethod.floor(this.attachMaxTimestamp) != partitionTimestamp) {
                throw CairoException.critical(0).put("invalid timestamp column data in detached partition, data does not match partition directory name [path=").put(path).put(", minTimestamp=").ts(this.attachMinTimestamp).put(", maxTimestamp=").ts(this.attachMaxTimestamp).put(']');
            }
        }
        finally {
            ff.close(fd);
        }
    }

    /*
     * Exception decompiling
     */
    private long readPartitionSizeMinMax(FilesFacade ff, long partitionTimestamp, Path path, CharSequence columnName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void rebuildAttachedPartitionColumnIndex(long partitionTimestamp, long partitionSize, Path path, CharSequence columnName) {
        if (this.attachIndexBuilder == null) {
            this.attachIndexBuilder = new IndexBuilder();
            this.attachIndexBuilder.of("", this.configuration);
        }
        this.attachIndexBuilder.reindexColumn(this.attachColumnVersionReader, this.metadata, this.metadata.getColumnIndex(columnName), path, -1L, partitionTimestamp, partitionSize);
    }

    private void recoverFromMetaRenameFailure(CharSequence columnName) {
        TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
    }

    private void recoverFromSwapRenameFailure(CharSequence columnName) {
        this.recoverFromTodoWriteFailure(columnName);
        this.clearTodoLog();
    }

    private void recoverFromSymbolMapWriterFailure(CharSequence columnName) {
        this.removeSymbolMapFilesQuiet(columnName, this.getTxn());
        this.removeMetaFile();
        this.recoverFromSwapRenameFailure(columnName);
    }

    private void recoverFromTodoWriteFailure(CharSequence columnName) {
        this.restoreMetaFrom("_meta.prev", this.metaPrevIndex);
        TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
    }

    private void recoverOpenColumnFailure(CharSequence columnName) {
        int index = this.columnCount - 1;
        this.removeMetaFile();
        this.removeLastColumn();
        --this.columnCount;
        this.recoverFromSwapRenameFailure(columnName);
        this.removeSymbolMapWriter(index);
    }

    private void releaseLock(boolean distressed) {
        if (this.lockFd != -1L) {
            this.ff.close(this.lockFd);
            if (distressed) {
                return;
            }
            try {
                TableUtils.lockName(this.path);
                TableUtils.removeOrException(this.ff, this.path);
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
    }

    private ReadOnlyObjList<? extends MemoryCR> remapWalSymbols(SymbolMapDiffCursor symbolMapDiffCursor, long rowLo, long rowHi, Path walPath) {
        int sym = 0;
        ObjList<MemoryCR> o3ColumnOverrides = null;
        if (symbolMapDiffCursor != null) {
            SymbolMapDiff symbolMapDiff;
            while ((symbolMapDiff = symbolMapDiffCursor.nextSymbolMapDiff()) != null) {
                MemoryCARW symbolColumnDest;
                boolean identical;
                int columnIndex = symbolMapDiff.getColumnIndex();
                if (!ColumnType.isSymbol(this.metadata.getColumnType(columnIndex))) {
                    throw CairoException.critical(0).put("WAL column and table writer column types don't match [columnIndex=").put(columnIndex).put(", walPath=").put(walPath).put(']');
                }
                if (identical = this.createWalSymbolMapping(symbolMapDiff, sym++, this.symbolRewriteMap)) continue;
                MemoryCR o3SymbolColumn = this.o3Columns.getQuick(TableWriter.getPrimaryColumnIndex(columnIndex));
                if (o3SymbolColumn instanceof MemoryCARW) {
                    symbolColumnDest = (MemoryCARW)o3SymbolColumn;
                } else {
                    if (o3ColumnOverrides == null) {
                        o3ColumnOverrides = new ObjList<MemoryCR>(this.o3Columns.size());
                        for (int c = 0; c < this.o3Columns.size(); ++c) {
                            o3ColumnOverrides.add(this.o3Columns.getQuick(c));
                        }
                    }
                    symbolColumnDest = this.o3MemColumns.get(TableWriter.getPrimaryColumnIndex(columnIndex));
                    symbolColumnDest.jumpTo(rowHi << 2);
                    o3ColumnOverrides.setQuick(TableWriter.getPrimaryColumnIndex(columnIndex), symbolColumnDest);
                }
                int cleanSymbolCount = symbolMapDiff.getCleanSymbolCount();
                for (long rowId = rowLo; rowId < rowHi; ++rowId) {
                    long offset = rowId << 2;
                    int symKey = o3SymbolColumn.getInt(offset);
                    if (symKey >= cleanSymbolCount) {
                        int newKey = this.symbolRewriteMap.getQuick(symKey - cleanSymbolCount);
                        if (newKey < 0) {
                            throw CairoException.critical(0).put("WAL symbol key not mapped [columnIndex=").put(columnIndex).put(", columnKey=").put(symKey).put(", walPath=").put(walPath).put(", walRowId=").put(rowId).put(']');
                        }
                        symKey = newKey;
                    }
                    symbolColumnDest.putInt(offset, symKey);
                }
            }
        }
        if (o3ColumnOverrides == null) {
            return this.o3Columns;
        }
        return o3ColumnOverrides;
    }

    private void removeColumn(int columnIndex) {
        int pi = TableWriter.getPrimaryColumnIndex(columnIndex);
        int si = TableWriter.getSecondaryColumnIndex(columnIndex);
        this.freeNullSetter(this.nullSetters, columnIndex);
        this.freeNullSetter(this.o3NullSetters, columnIndex);
        this.freeNullSetter(this.o3NullSetters2, columnIndex);
        this.freeAndRemoveColumnPair(this.columns, pi, si);
        this.freeAndRemoveO3ColumnPair(this.o3MemColumns, pi, si);
        this.freeAndRemoveO3ColumnPair(this.o3MemColumns2, pi, si);
        if (columnIndex < this.indexers.size()) {
            Misc.free(this.indexers.getAndSetQuick(columnIndex, null));
            this.populateDenseIndexerList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeColumnFiles(CharSequence columnName, int columnIndex, int columnType) {
        try {
            int i = this.txWriter.getPartitionCount() - 1;
            while ((long)i > -1L) {
                long partitionTimestamp = this.txWriter.getPartitionTimestamp(i);
                long partitionNameTxn = this.txWriter.getPartitionNameTxn(i);
                this.removeColumnFilesInPartition(columnName, columnIndex, partitionTimestamp, partitionNameTxn);
                --i;
            }
            if (!PartitionBy.isPartitioned(this.partitionBy)) {
                this.removeColumnFilesInPartition(columnName, columnIndex, this.txWriter.getLastPartitionTimestamp(), -1L);
            }
            long columnNameTxn = this.columnVersionWriter.getDefaultColumnNameTxn(columnIndex);
            if (ColumnType.isSymbol(columnType)) {
                TableWriter.removeFileAndOrLog(this.ff, TableUtils.offsetFileName(this.path.trimTo(this.rootLen), columnName, columnNameTxn));
                TableWriter.removeFileAndOrLog(this.ff, TableUtils.charFileName(this.path.trimTo(this.rootLen), columnName, columnNameTxn));
                TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(this.rootLen), columnName, columnNameTxn));
                TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(this.rootLen), columnName, columnNameTxn));
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removeColumnFilesInPartition(CharSequence columnName, int columnIndex, long partitionTimestamp, long partitionNameTxn) {
        TableUtils.setPathForPartition(this.path, this.partitionBy, partitionTimestamp, false);
        TableUtils.txnPartitionConditionally(this.path, partitionNameTxn);
        int plen = this.path.length();
        long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
        TableWriter.removeFileAndOrLog(this.ff, TableUtils.dFile(this.path, columnName, columnNameTxn));
        TableWriter.removeFileAndOrLog(this.ff, TableUtils.iFile(this.path.trimTo(plen), columnName, columnNameTxn));
        TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName, columnNameTxn));
        TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName, columnNameTxn));
        this.path.trimTo(this.rootLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeColumnFromMeta(int index) {
        try {
            int metaSwapIndex = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.fileOperationRetryCount);
            int timestampIndex = this.metaMem.getInt(8L);
            this.ddlMem.putInt(this.columnCount);
            this.ddlMem.putInt(this.partitionBy);
            if (timestampIndex == index) {
                this.ddlMem.putInt(-1);
            } else {
                this.ddlMem.putInt(timestampIndex);
            }
            this.copyVersionAndLagValues();
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < this.columnCount; ++i) {
                this.writeColumnEntry(i, i == index);
            }
            long nameOffset = TableUtils.getColumnNameOffset(this.columnCount);
            for (int i = 0; i < this.columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                this.ddlMem.putStr(columnName);
                nameOffset += (long)Vm.getStorageLength(columnName);
            }
            int n = metaSwapIndex;
            return n;
        }
        finally {
            this.ddlMem.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIndexFiles(CharSequence columnName, int columnIndex) {
        try {
            int i = this.txWriter.getPartitionCount() - 1;
            while ((long)i > -1L) {
                long partitionTimestamp = this.txWriter.getPartitionTimestamp(i);
                long partitionNameTxn = this.txWriter.getPartitionNameTxn(i);
                this.removeIndexFilesInPartition(columnName, columnIndex, partitionTimestamp, partitionNameTxn);
                --i;
            }
            if (!PartitionBy.isPartitioned(this.partitionBy)) {
                this.removeColumnFilesInPartition(columnName, columnIndex, this.txWriter.getLastPartitionTimestamp(), -1L);
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removeIndexFilesInPartition(CharSequence columnName, int columnIndex, long partitionTimestamp, long partitionNameTxn) {
        TableUtils.setPathForPartition(this.path, this.partitionBy, partitionTimestamp, false);
        TableUtils.txnPartitionConditionally(this.path, partitionNameTxn);
        int plen = this.path.length();
        long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
        TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName, columnNameTxn));
        TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName, columnNameTxn));
        this.path.trimTo(this.rootLen);
    }

    private void removeLastColumn() {
        this.removeColumn(this.columnCount - 1);
    }

    private void removeMetaFile() {
        try {
            this.path.concat("_meta").$();
            if (this.ff.exists(this.path) && !this.ff.remove(this.path)) {
                throw CairoException.critical(this.ff.errno()).put("Recovery failed. Cannot remove: ").put(this.path);
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removeNonAttachedPartitions() {
        LOG.info().$("purging non attached partitions [path=").$(this.path.$()).I$();
        try {
            this.ff.iterateDir(this.path.$(), this.removePartitionDirsNotAttached);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removePartitionDirectories() {
        try {
            this.ff.iterateDir(this.path.$(), this.removePartitionDirectories);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removePartitionDirectories0(long pUtf8NameZ, int type) {
        if (Files.isDir(pUtf8NameZ, type)) {
            this.path.trimTo(this.rootLen);
            this.path.concat(pUtf8NameZ).$();
            if (!Chars.endsWith((CharSequence)this.path, ".detached") && this.ff.rmdir(this.path) != 0) {
                LOG.info().$("could not remove [path=").$(this.path).$(", errno=").$(this.ff.errno()).I$();
            }
        }
    }

    private void removePartitionDirsNotAttached(long pUtf8NameZ, int type) {
        if (Files.isDir(pUtf8NameZ, type, this.fileNameSink)) {
            if (Chars.endsWith((CharSequence)this.fileNameSink, ".detached") || Chars.endsWith((CharSequence)this.fileNameSink, this.configuration.getAttachPartitionSuffix()) || Chars.startsWith((CharSequence)this.fileNameSink, "wal") || Chars.startsWith((CharSequence)this.fileNameSink, "seq")) {
                return;
            }
            try {
                long txn = 0L;
                int txnSep = Chars.indexOf(this.fileNameSink, '.');
                if (txnSep < 0) {
                    txnSep = this.fileNameSink.length();
                } else {
                    txn = Numbers.parseLong(this.fileNameSink, txnSep + 1, this.fileNameSink.length());
                }
                long dirTimestamp = this.partitionDirFmt.parse(this.fileNameSink, 0, txnSep, null);
                if (txn <= this.txWriter.txn && (this.txWriter.attachedPartitionsContains(dirTimestamp) || this.txWriter.isActivePartition(dirTimestamp))) {
                    return;
                }
            }
            catch (NumericException ignore) {
                this.path.trimTo(this.rootLen);
                this.path.concat(pUtf8NameZ).$();
                LOG.error().$("invalid partition directory inside table folder: ").utf8(this.path).$();
                return;
            }
            this.path.trimTo(this.rootLen);
            this.path.concat(pUtf8NameZ).$();
            int errno = this.ff.rmdir(this.path);
            if (errno == 0) {
                LOG.info().$("removed partition dir: ").$(this.path).$();
            } else {
                LOG.error().$("cannot remove: ").$(this.path).$(" [errno=").$(errno).I$();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSymbolMapFilesQuiet(CharSequence name, long columnNamTxn) {
        try {
            TableWriter.removeFileAndOrLog(this.ff, TableUtils.offsetFileName(this.path.trimTo(this.rootLen), name, columnNamTxn));
            TableWriter.removeFileAndOrLog(this.ff, TableUtils.charFileName(this.path.trimTo(this.rootLen), name, columnNamTxn));
            TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(this.rootLen), name, columnNamTxn));
            TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(this.rootLen), name, columnNamTxn));
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removeSymbolMapWriter(int index) {
        MapWriter writer = this.symbolMapWriters.getAndSetQuick(index, NullMapWriter.INSTANCE);
        if (writer != null && writer != NullMapWriter.INSTANCE) {
            for (int symColIndex = this.denseSymbolMapWriters.remove(writer); symColIndex < this.denseSymbolMapWriters.size(); ++symColIndex) {
                MapWriter w = this.denseSymbolMapWriters.getQuick(symColIndex);
                w.setSymbolIndexInTxWriter(symColIndex);
            }
            Misc.free(writer);
        }
    }

    private int rename(int retries) {
        try {
            int index = 0;
            this.other.concat("_meta.prev").$();
            this.path.concat("_meta").$();
            int l = this.other.length();
            do {
                if (index > 0) {
                    this.other.trimTo(l);
                    this.other.put('.').put(index);
                    this.other.$();
                }
                if (this.ff.exists(this.other) && !this.ff.remove(this.other)) {
                    LOG.info().$("cannot remove target of rename '").$(this.path).$("' to '").$(this.other).$(" [errno=").$(this.ff.errno()).I$();
                    ++index;
                    continue;
                }
                if (this.ff.rename(this.path, this.other) != 0) {
                    LOG.info().$("cannot rename '").$(this.path).$("' to '").$(this.other).$(" [errno=").$(this.ff.errno()).I$();
                    ++index;
                    continue;
                }
                int n = index;
                return n;
            } while (index < retries);
            throw CairoException.critical(0).put("Cannot rename ").put(this.path).put(". Max number of attempts reached [").put(index).put("]. Last target was: ").put(this.other);
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameColumnFiles(CharSequence columnName, int columnIndex, CharSequence newName, int columnType) {
        try {
            int i = this.txWriter.getPartitionCount() - 1;
            while ((long)i > -1L) {
                long partitionTimestamp = this.txWriter.getPartitionTimestamp(i);
                long partitionNameTxn = this.txWriter.getPartitionNameTxn(i);
                this.renameColumnFiles(columnName, columnIndex, newName, partitionTimestamp, partitionNameTxn);
                --i;
            }
            if (!PartitionBy.isPartitioned(this.partitionBy)) {
                this.renameColumnFiles(columnName, columnIndex, newName, this.txWriter.getLastPartitionTimestamp(), -1L);
            }
            long columnNameTxn = this.columnVersionWriter.getDefaultColumnNameTxn(columnIndex);
            if (ColumnType.isSymbol(columnType)) {
                TableWriter.renameFileOrLog(this.ff, TableUtils.offsetFileName(this.path.trimTo(this.rootLen), columnName, columnNameTxn), TableUtils.offsetFileName(this.other.trimTo(this.rootLen), newName, columnNameTxn));
                TableWriter.renameFileOrLog(this.ff, TableUtils.charFileName(this.path.trimTo(this.rootLen), columnName, columnNameTxn), TableUtils.charFileName(this.other.trimTo(this.rootLen), newName, columnNameTxn));
                TableWriter.renameFileOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(this.rootLen), columnName, columnNameTxn), BitmapIndexUtils.keyFileName(this.other.trimTo(this.rootLen), newName, columnNameTxn));
                TableWriter.renameFileOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(this.rootLen), columnName, columnNameTxn), BitmapIndexUtils.valueFileName(this.other.trimTo(this.rootLen), newName, columnNameTxn));
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
    }

    private void renameColumnFiles(CharSequence columnName, int columnIndex, CharSequence newName, long partitionTimestamp, long partitionNameTxn) {
        TableUtils.setPathForPartition(this.path, this.partitionBy, partitionTimestamp, false);
        TableUtils.setPathForPartition(this.other, this.partitionBy, partitionTimestamp, false);
        TableUtils.txnPartitionConditionally(this.path, partitionNameTxn);
        TableUtils.txnPartitionConditionally(this.other, partitionNameTxn);
        int plen = this.path.length();
        long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
        TableWriter.renameFileOrLog(this.ff, TableUtils.dFile(this.path.trimTo(plen), columnName, columnNameTxn), TableUtils.dFile(this.other.trimTo(plen), newName, columnNameTxn));
        TableWriter.renameFileOrLog(this.ff, TableUtils.iFile(this.path.trimTo(plen), columnName, columnNameTxn), TableUtils.iFile(this.other.trimTo(plen), newName, columnNameTxn));
        TableWriter.renameFileOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName, columnNameTxn), BitmapIndexUtils.keyFileName(this.other.trimTo(plen), newName, columnNameTxn));
        TableWriter.renameFileOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName, columnNameTxn), BitmapIndexUtils.valueFileName(this.other.trimTo(plen), newName, columnNameTxn));
        this.path.trimTo(this.rootLen);
        this.other.trimTo(this.rootLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int renameColumnFromMeta(int index, CharSequence newName) {
        try {
            int metaSwapIndex = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.fileOperationRetryCount);
            int timestampIndex = this.metaMem.getInt(8L);
            this.ddlMem.putInt(this.columnCount);
            this.ddlMem.putInt(this.partitionBy);
            this.ddlMem.putInt(timestampIndex);
            this.copyVersionAndLagValues();
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < this.columnCount; ++i) {
                this.writeColumnEntry(i, false);
            }
            long nameOffset = TableUtils.getColumnNameOffset(this.columnCount);
            for (int i = 0; i < this.columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                nameOffset += (long)Vm.getStorageLength(columnName);
                if (i == index && TableUtils.getColumnType(this.metaMem, i) > 0) {
                    columnName = newName;
                }
                this.ddlMem.putStr(columnName);
            }
            int n = metaSwapIndex;
            return n;
        }
        finally {
            this.ddlMem.close();
        }
    }

    private void renameMetaToMetaPrev(CharSequence columnName) {
        try {
            this.metaPrevIndex = this.rename(this.fileOperationRetryCount);
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_META_RENAME_FAILURE, columnName, e);
        }
    }

    private void renameSwapMetaToMeta(CharSequence columnName) {
        try {
            this.restoreMetaFrom("_meta.swp", this.metaSwapIndex);
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_SWAP_RENAME_FAILURE, columnName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long repairDataGaps(long timestamp) {
        if (this.txWriter.getMaxTimestamp() != Long.MIN_VALUE && PartitionBy.isPartitioned(this.partitionBy)) {
            long expectedSize;
            long fixedRowCount = 0L;
            long lastTimestamp = -1L;
            long transientRowCount = this.txWriter.getTransientRowCount();
            long maxTimestamp = this.txWriter.getMaxTimestamp();
            try {
                long tsLimit = this.partitionFloorMethod.floor(this.txWriter.getMaxTimestamp());
                long ts = this.getPartitionLo(this.txWriter.getMinTimestamp());
                while (ts < tsLimit) {
                    this.path.trimTo(this.rootLen);
                    this.setStateForTimestamp(this.path, ts, false);
                    int p = this.path.length();
                    long partitionSize = this.txWriter.getPartitionSizeByPartitionTimestamp(ts);
                    if (partitionSize >= 0L && this.ff.exists(this.path.$())) {
                        fixedRowCount += partitionSize;
                        lastTimestamp = ts;
                    } else {
                        Path other = Path.getThreadLocal2(this.path.trimTo(p).$());
                        TableUtils.oldPartitionName(other, this.getTxn());
                        if (this.ff.exists(other.$())) {
                            if (this.ff.rename(other, this.path) != 0) {
                                LOG.error().$("could not rename [from=").$(other).$(", to=").$(this.path).I$();
                                throw new CairoError("could not restore directory, see log for details");
                            }
                            LOG.info().$("restored [path=").$(this.path).I$();
                        } else {
                            LOG.debug().$("missing partition [name=").$(this.path.trimTo(p).$()).I$();
                        }
                    }
                    ts = this.partitionCeilMethod.ceil(ts);
                }
                if (lastTimestamp > -1L) {
                    this.path.trimTo(this.rootLen);
                    this.setStateForTimestamp(this.path, tsLimit, false);
                    if (!this.ff.exists(this.path.$())) {
                        Path other = Path.getThreadLocal2(this.path);
                        TableUtils.oldPartitionName(other, this.getTxn());
                        if (this.ff.exists(other.$())) {
                            if (this.ff.rename(other, this.path) != 0) {
                                LOG.error().$("could not rename [from=").$(other).$(", to=").$(this.path).I$();
                                throw new CairoError("could not restore directory, see log for details");
                            }
                            LOG.info().$("restored [path=").$(this.path).I$();
                        } else {
                            LOG.error().$("last partition does not exist [name=").$(this.path).I$();
                            this.path.trimTo(this.rootLen);
                            this.setStateForTimestamp(this.path, lastTimestamp, false);
                            int p = this.path.length();
                            transientRowCount = this.txWriter.getPartitionSizeByPartitionTimestamp(lastTimestamp);
                            TableUtils.dFile(this.path.trimTo(p), this.metadata.getColumnName(this.metadata.getTimestampIndex()), -1L);
                            maxTimestamp = TableUtils.readLongAtOffset(this.ff, this.path, this.tempMem16b, (transientRowCount - 1L) * 8L);
                            fixedRowCount -= transientRowCount;
                            this.txWriter.removeAttachedPartitions(this.txWriter.getMaxTimestamp());
                            LOG.info().$("updated active partition [name=").$(this.path.trimTo(p).$()).$(", maxTimestamp=").$ts(maxTimestamp).$(", transientRowCount=").$(transientRowCount).$(", fixedRowCount=").$(this.txWriter.getFixedRowCount()).I$();
                        }
                    }
                }
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
            if ((expectedSize = this.txWriter.unsafeReadFixedRowCount()) != fixedRowCount || maxTimestamp != this.txWriter.getMaxTimestamp()) {
                LOG.info().$("actual table size has been adjusted [name=`").utf8(this.tableName).$('`').$(", expectedFixedSize=").$(expectedSize).$(", actualFixedSize=").$(fixedRowCount).I$();
                this.txWriter.reset(fixedRowCount, transientRowCount, maxTimestamp, this.defaultCommitMode, this.denseSymbolMapWriters);
                return maxTimestamp;
            }
        }
        return timestamp;
    }

    private void repairMetaRename(int index) {
        try {
            this.path.concat("_meta.prev");
            if (index > 0) {
                this.path.put('.').put(index);
            }
            this.path.$();
            if (this.ff.exists(this.path)) {
                LOG.info().$("Repairing metadata from: ").$(this.path).$();
                if (this.ff.exists(this.other.concat("_meta").$()) && !this.ff.remove(this.other)) {
                    throw CairoException.critical(this.ff.errno()).put("Repair failed. Cannot replace ").put(this.other);
                }
                if (this.ff.rename(this.path, this.other) != 0) {
                    throw CairoException.critical(this.ff.errno()).put("Repair failed. Cannot rename ").put(this.path).put(" -> ").put(this.other);
                }
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
        this.clearTodoLog();
    }

    private void repairTruncate() {
        LOG.info().$("repairing abnormally terminated truncate on ").$(this.path).$();
        if (PartitionBy.isPartitioned(this.partitionBy)) {
            this.removePartitionDirectories();
        }
        this.txWriter.truncate(this.columnVersionWriter.getVersion());
        this.clearTodoLog();
    }

    @Nullable
    TableSyncModel replHandleSyncCmd(TableWriterTask cmd) {
        long instance = cmd.getInstance();
        long sequence = cmd.getSequence();
        int index = this.cmdSequences.keyIndex(instance);
        if (index < 0 && sequence <= this.cmdSequences.valueAt(index)) {
            return null;
        }
        this.cmdSequences.putAt(index, instance, sequence);
        long txMemSize = Unsafe.getUnsafe().getLong(cmd.getData());
        return this.replCreateTableSyncModel(cmd.getData() + 8L, txMemSize, cmd.getData() + txMemSize + 16L, Unsafe.getUnsafe().getLong(cmd.getData() + txMemSize + 8L));
    }

    private void resizeColumnTopSink(long srcOoo, long srcOooMax) {
        long maxPartitionsAffected = (srcOooMax - srcOoo) / PartitionBy.getPartitionTimeIntervalFloor(this.partitionBy) + 2L;
        long size = maxPartitionsAffected * (long)(this.metadata.getColumnCount() + 1);
        if (this.o3ColumnTopSink == null) {
            this.o3ColumnTopSink = new DirectLongList(size, 3);
        }
        this.o3ColumnTopSink.setCapacity(size);
        this.o3ColumnTopSink.setPos(size);
        this.o3ColumnTopSink.zero(-1L);
    }

    private void restoreMetaFrom(CharSequence fromBase, int fromIndex) {
        try {
            this.path.concat(fromBase);
            if (fromIndex > 0) {
                this.path.put('.').put(fromIndex);
            }
            this.path.$();
            TableUtils.renameOrFail(this.ff, this.path, this.other.concat("_meta").$());
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
    }

    private void rollbackIndexes() {
        long maxRow = this.txWriter.getTransientRowCount() - 1L;
        int n = this.denseIndexers.size();
        for (int i = 0; i < n; ++i) {
            ColumnIndexer indexer = this.denseIndexers.getQuick(i);
            long fd = indexer.getFd();
            if (fd <= -1L) continue;
            LOG.info().$("recovering index [fd=").$(fd).I$();
            indexer.rollback(maxRow);
        }
    }

    private void rollbackSymbolTables() {
        int expectedMapWriters = this.txWriter.unsafeReadSymbolColumnCount();
        for (int i = 0; i < expectedMapWriters; ++i) {
            this.denseSymbolMapWriters.getQuick(i).rollback(this.txWriter.unsafeReadSymbolWriterIndexOffset(i));
        }
    }

    private void rowAppend(ObjList<Runnable> activeNullSetters) {
        if ((this.masterRef & 1L) != 0L) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.rowValueIsNotNull.getQuick(i) >= this.masterRef) continue;
                activeNullSetters.getQuick(i).run();
            }
            ++this.masterRef;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rowCancel() {
        if ((this.masterRef & 1L) == 0L) {
            return;
        }
        if (this.hasO3()) {
            long o3RowCount = this.getO3RowCount0();
            if (o3RowCount > 0L) {
                --this.masterRef;
                this.setO3AppendPosition(o3RowCount);
            } else {
                this.setO3AppendPosition(0L);
                --this.masterRef;
                this.clearO3();
            }
            this.rowValueIsNotNull.fill(0, this.columnCount, this.masterRef);
            return;
        }
        long dirtyMaxTimestamp = this.txWriter.getMaxTimestamp();
        long dirtyTransientRowCount = this.txWriter.getTransientRowCount();
        long rollbackToMaxTimestamp = this.txWriter.cancelToMaxTimestamp();
        long rollbackToTransientRowCount = this.txWriter.cancelToTransientRowCount();
        if (dirtyTransientRowCount == 1L) {
            if (PartitionBy.isPartitioned(this.partitionBy)) {
                this.closeActivePartition(false);
                if (this.removeDirOnCancelRow) {
                    try {
                        this.setStateForTimestamp(this.path, dirtyMaxTimestamp, false);
                        int errno = this.ff.rmdir(this.path.$());
                        if (errno != 0) {
                            throw CairoException.critical(errno).put("Cannot remove directory: ").put(this.path);
                        }
                        this.removeDirOnCancelRow = false;
                    }
                    finally {
                        this.path.trimTo(this.rootLen);
                    }
                }
                if (rollbackToMaxTimestamp > Long.MIN_VALUE) {
                    try {
                        this.openPartition(rollbackToMaxTimestamp);
                        this.setAppendPosition(rollbackToTransientRowCount, false);
                    }
                    catch (Throwable e) {
                        this.freeColumns(false);
                        throw e;
                    }
                } else {
                    this.rowAction = 0;
                }
                this.removeDirOnCancelRow = true;
                this.txWriter.cancelRow();
            } else {
                this.txWriter.cancelRow();
                for (int i = 0; i < this.columnCount; ++i) {
                    this.getPrimaryColumn(i).jumpTo(0L);
                    MemoryMA mem = this.getSecondaryColumn(i);
                    if (mem == null) continue;
                    mem.jumpTo(0L);
                    mem.putLong(0L);
                }
            }
        } else {
            boolean rowChanged;
            this.txWriter.cancelRow();
            boolean bl = rowChanged = this.metadata.getTimestampIndex() >= 0;
            if (!rowChanged) {
                for (int i = 0; i < this.columnCount; ++i) {
                    if (this.rowValueIsNotNull.getQuick(i) != this.masterRef) continue;
                    rowChanged = true;
                    break;
                }
            }
            if (rowChanged) {
                this.setAppendPosition(dirtyTransientRowCount - 1L, false);
            }
        }
        this.rowValueIsNotNull.fill(0, this.columnCount, --this.masterRef);
        --this.txWriter.transientRowCount;
    }

    private void runFragile(FragileCode fragile, CharSequence columnName, CairoException e) {
        try {
            fragile.run(columnName);
        }
        catch (CairoException err) {
            LOG.error().$("DOUBLE ERROR: 1st: {").$(e).$('}').$();
            this.throwDistressException(err);
        }
        throw e;
    }

    private void safeDeletePartitionDir(long timestamp, long partitionNameTxn) {
        this.o3PartitionRemoveCandidates.clear();
        this.o3PartitionRemoveCandidates.add(timestamp, partitionNameTxn);
        this.o3ProcessPartitionRemoveCandidates();
    }

    private void setAppendPosition(long position, boolean doubleAllocate) {
        for (int i = 0; i < this.columnCount; ++i) {
            this.setColumnSize(i, position, doubleAllocate);
        }
    }

    private void setColumnSize(int columnIndex, long size, boolean doubleAllocate) {
        MemoryMA mem1 = this.getPrimaryColumn(columnIndex);
        MemoryMA mem2 = this.getSecondaryColumn(columnIndex);
        int type = this.metadata.getColumnType(columnIndex);
        if (type > 0) {
            long pos = size - this.columnTops.getQuick(columnIndex);
            if (pos > 0L) {
                long m1pos;
                switch (ColumnType.tagOf(type)) {
                    case 11: 
                    case 18: {
                        assert (mem2 != null);
                        if (doubleAllocate) {
                            mem2.allocate(pos * 8L + 8L);
                        }
                        mem2.jumpTo(pos * 8L);
                        m1pos = Unsafe.getUnsafe().getLong(mem2.getAppendAddress());
                        mem2.jumpTo((pos + 1L) * 8L);
                        break;
                    }
                    default: {
                        m1pos = pos << ColumnType.pow2SizeOf(type);
                    }
                }
                if (doubleAllocate) {
                    mem1.allocate(m1pos);
                }
                mem1.jumpTo(m1pos);
            } else {
                mem1.jumpTo(0L);
                if (mem2 != null) {
                    mem2.jumpTo(0L);
                    mem2.putLong(0L);
                }
            }
        }
    }

    private void setO3AppendPosition(long position) {
        for (int i = 0; i < this.columnCount; ++i) {
            int columnType = this.metadata.getColumnType(i);
            if (columnType <= 0) continue;
            this.o3SetAppendOffset(i, columnType, position);
        }
    }

    private void setRowValueNotNull(int columnIndex) {
        assert (this.rowValueIsNotNull.getQuick(columnIndex) != this.masterRef);
        this.rowValueIsNotNull.setQuick(columnIndex, this.masterRef);
    }

    private void setStateForTimestamp(Path path, long timestamp, boolean updatePartitionInterval) {
        long partitionTimestampHi = TableUtils.setPathForPartition(path, this.partitionBy, timestamp, true);
        long partitionTxnName = PartitionBy.isPartitioned(this.partitionBy) ? this.txWriter.getTxn() - 1L : -1L;
        TableUtils.txnPartitionConditionally(path, this.txWriter.getPartitionNameTxnByPartitionTimestamp(partitionTimestampHi, partitionTxnName));
        if (updatePartitionInterval) {
            this.partitionTimestampHi = partitionTimestampHi;
        }
    }

    private void swapMetaFile(CharSequence columnName) {
        this.metaMem.close();
        this.validateSwapMeta(columnName);
        this.renameMetaToMetaPrev(columnName);
        this.writeRestoreMetaTodo(columnName);
        this.renameSwapMetaToMeta(columnName);
        try {
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
            this.clearTodoLog();
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        this.bumpStructureVersion();
    }

    private void swapO3ColumnsExcept(int timestampIndex) {
        ObjList<MemoryCARW> temp = this.o3MemColumns;
        this.o3MemColumns = this.o3MemColumns2;
        this.o3MemColumns2 = temp;
        int timestampMemoryIndex = TableWriter.getPrimaryColumnIndex(timestampIndex);
        this.o3MemColumns2.setQuick(timestampMemoryIndex, this.o3MemColumns.getAndSetQuick(timestampMemoryIndex, this.o3MemColumns2.getQuick(timestampMemoryIndex)));
        this.o3Columns = this.o3MemColumns;
        this.activeColumns = this.o3MemColumns;
        ObjList<Runnable> tempNullSetters = this.o3NullSetters;
        this.o3NullSetters = this.o3NullSetters2;
        this.o3NullSetters2 = tempNullSetters;
        this.activeNullSetters = this.o3NullSetters;
    }

    private void switchPartition(long timestamp) {
        this.updateIndexes();
        this.txWriter.switchPartitions(timestamp);
        this.openPartition(timestamp);
        this.setAppendPosition(0L, false);
    }

    private void syncColumns(int commitMode) {
        boolean async = commitMode == 0;
        for (int i = 0; i < this.columnCount; ++i) {
            this.columns.getQuick(i * 2).sync(async);
            MemoryMA m2 = this.columns.getQuick(i * 2 + 1);
            if (m2 == null) continue;
            m2.sync(false);
        }
    }

    private void throwDistressException(CairoException cause) {
        LOG.critical().$("writer error [table=").$(this.tableName).$(", e=").$(cause).I$();
        this.distressed = true;
        throw new CairoError(cause);
    }

    private void updateIndexes() {
        if (this.indexCount == 0 || this.avoidIndexOnCommit) {
            this.avoidIndexOnCommit = false;
            return;
        }
        this.updateIndexesSlow();
    }

    private void updateIndexesParallel(long lo, long hi) {
        int i;
        this.indexSequences.clear();
        this.indexLatch.setCount(this.indexCount);
        int nParallelIndexes = this.indexCount - 1;
        Sequence indexPubSequence = this.messageBus.getIndexerPubSequence();
        RingQueue<ColumnIndexerTask> indexerQueue = this.messageBus.getIndexerQueue();
        LOG.info().$("parallel indexing [table=").$(this.tableName).$(", indexCount=").$(this.indexCount).$(", rowCount=").$(hi - lo).I$();
        int serialIndexCount = 0;
        block0: for (i = 0; i < nParallelIndexes; ++i) {
            long cursor = indexPubSequence.next();
            if (cursor == -1L) {
                TableWriter.indexAndCountDown(this.denseIndexers.getQuick(i), lo, hi, this.indexLatch);
                ++serialIndexCount;
                continue;
            }
            if (cursor == -2L) {
                do {
                    Os.pause();
                    cursor = indexPubSequence.next();
                    if (cursor != -1L) continue;
                    TableWriter.indexAndCountDown(this.denseIndexers.getQuick(i), lo, hi, this.indexLatch);
                    ++serialIndexCount;
                    continue block0;
                } while (cursor < 0L);
            }
            ColumnIndexerTask queueItem = indexerQueue.get(cursor);
            ColumnIndexer indexer = this.denseIndexers.getQuick(i);
            long sequence = indexer.getSequence();
            queueItem.indexer = indexer;
            queueItem.lo = lo;
            queueItem.hi = hi;
            queueItem.countDownLatch = this.indexLatch;
            queueItem.sequence = sequence;
            this.indexSequences.add(sequence);
            indexPubSequence.done(cursor);
        }
        TableWriter.indexAndCountDown(this.denseIndexers.getQuick(this.indexCount - 1), lo, hi, this.indexLatch);
        ++serialIndexCount;
        if (!this.indexLatch.await(this.configuration.getWorkStealTimeoutNanos())) {
            for (i = 0; i < nParallelIndexes; ++i) {
                ColumnIndexer indexer = this.denseIndexers.getQuick(i);
                if (!indexer.tryLock(this.indexSequences.getQuick(i))) continue;
                TableWriter.indexAndCountDown(indexer, lo, hi, this.indexLatch);
                ++serialIndexCount;
            }
            this.indexLatch.await();
        }
        boolean distressed = false;
        for (int i2 = 0; i2 < this.indexCount; ++i2) {
            ColumnIndexer indexer = this.denseIndexers.getQuick(i2);
            distressed |= indexer.isDistressed();
        }
        if (distressed) {
            this.throwDistressException(null);
        }
        LOG.info().$("parallel indexing done [serialCount=").$(serialIndexCount).I$();
    }

    private void updateIndexesSerially(long lo, long hi) {
        LOG.info().$("serial indexing [table=").$(this.tableName).$(", indexCount=").$(this.indexCount).$(", rowCount=").$(hi - lo).I$();
        int n = this.denseIndexers.size();
        for (int i = 0; i < n; ++i) {
            try {
                this.denseIndexers.getQuick(i).refreshSourceAndIndex(lo, hi);
                continue;
            }
            catch (CairoException e) {
                this.throwDistressException(e);
            }
        }
        LOG.info().$("serial indexing done [table=").$(this.tableName).I$();
    }

    private void updateIndexesSlow() {
        long lo;
        long hi = this.txWriter.getTransientRowCount();
        long l = lo = this.txWriter.getAppendedPartitionCount() == 1 ? hi - this.txWriter.getLastTxSize() : 0L;
        if (this.indexCount > 1 && this.parallelIndexerEnabled && hi - lo > (long)this.configuration.getParallelIndexThreshold()) {
            this.updateIndexesParallel(lo, hi);
        } else {
            this.updateIndexesSerially(lo, hi);
        }
    }

    private void updateMaxTimestamp(long timestamp) {
        this.txWriter.updateMaxTimestamp(timestamp);
        this.timestampSetter.accept(timestamp);
    }

    private void updateMetaStructureVersion() {
        try {
            this.copyMetadataAndUpdateVersion();
            this.finishMetaSwapUpdate();
            this.clearTodoLog();
        }
        finally {
            this.ddlMem.close();
        }
    }

    private void updateO3ColumnTops() {
        int columnCount = this.metadata.getColumnCount();
        int increment = columnCount + 1;
        int n = (int)this.o3ColumnTopSink.size();
        for (int partitionOffset = 0; partitionOffset < n; partitionOffset += increment) {
            long partitionTimestamp = this.o3ColumnTopSink.get(partitionOffset);
            if (partitionTimestamp <= -1L) continue;
            for (int column = 0; column < columnCount; ++column) {
                long colTop = this.o3ColumnTopSink.get(partitionOffset + column + 1);
                if (colTop <= -1L) continue;
                this.columnVersionWriter.upsertColumnTop(partitionTimestamp, column, colTop);
            }
        }
    }

    private void validateSwapMeta(CharSequence columnName) {
        try {
            try {
                this.path.concat("_meta.swp");
                if (this.metaSwapIndex > 0) {
                    this.path.put('.').put(this.metaSwapIndex);
                }
                this.metaMem.smallFile(this.ff, this.path.$(), 5);
                this.validationMap.clear();
                TableUtils.validateMeta(this.metaMem, this.validationMap, 426);
            }
            finally {
                this.metaMem.close();
                this.path.trimTo(this.rootLen);
            }
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_META_RENAME_FAILURE, columnName, e);
        }
    }

    private void writeColumnEntry(int i, boolean markDeleted) {
        int columnType = TableUtils.getColumnType(this.metaMem, i);
        if (markDeleted) {
            columnType = -Math.abs(columnType);
        }
        this.ddlMem.putInt(columnType);
        long flags = 0L;
        if (TableUtils.isColumnIndexed(this.metaMem, i)) {
            flags |= 1L;
        }
        if (TableUtils.isSequential(this.metaMem, i)) {
            flags |= 2L;
        }
        this.ddlMem.putLong(flags);
        this.ddlMem.putInt(TableUtils.getIndexBlockCapacity(this.metaMem, i));
        this.ddlMem.putLong(TableUtils.getColumnHash(this.metaMem, i));
        this.ddlMem.skip(8L);
    }

    private void writeRestoreMetaTodo(CharSequence columnName) {
        try {
            this.writeRestoreMetaTodo();
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_TODO_WRITE_FAILURE, columnName, e);
        }
    }

    private void writeRestoreMetaTodo() {
        this.todoMem.putLong(0L, ++this.todoTxn);
        Unsafe.getUnsafe().storeFence();
        this.todoMem.putLong(8L, this.configuration.getDatabaseIdLo());
        this.todoMem.putLong(16L, this.configuration.getDatabaseIdHi());
        Unsafe.getUnsafe().storeFence();
        this.todoMem.putLong(32L, 1L);
        this.todoMem.putLong(40L, 2L);
        this.todoMem.putLong(48L, this.metaPrevIndex);
        Unsafe.getUnsafe().storeFence();
        this.todoMem.putLong(24L, this.todoTxn);
        this.todoMem.jumpTo(56L);
    }

    private class RowImpl
    implements Row {
        private RowImpl() {
        }

        @Override
        public void append() {
            TableWriter.this.rowAppend(TableWriter.this.activeNullSetters);
        }

        @Override
        public void cancel() {
            TableWriter.this.rowCancel();
        }

        @Override
        public void putBin(int columnIndex, long address, long len) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putBin(address, len));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putBin(int columnIndex, BinarySequence sequence) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putBin(sequence));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putBool(int columnIndex, boolean value) {
            this.getPrimaryColumn(columnIndex).putBool(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putByte(int columnIndex, byte value) {
            this.getPrimaryColumn(columnIndex).putByte(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putChar(int columnIndex, char value) {
            this.getPrimaryColumn(columnIndex).putChar(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putDouble(int columnIndex, double value) {
            this.getPrimaryColumn(columnIndex).putDouble(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putFloat(int columnIndex, float value) {
            this.getPrimaryColumn(columnIndex).putFloat(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putGeoHash(int index, long value) {
            int type = TableWriter.this.metadata.getColumnType(index);
            WriterRowUtils.putGeoHash(index, value, type, this);
        }

        @Override
        public void putGeoHashDeg(int index, double lat, double lon) {
            int type = TableWriter.this.metadata.getColumnType(index);
            WriterRowUtils.putGeoHash(index, GeoHashes.fromCoordinatesDegUnsafe(lat, lon, ColumnType.getGeoHashBits(type)), type, this);
        }

        @Override
        public void putGeoStr(int index, CharSequence hash) {
            int type = TableWriter.this.metadata.getColumnType(index);
            WriterRowUtils.putGeoStr(index, hash, type, this);
        }

        @Override
        public void putInt(int columnIndex, int value) {
            this.getPrimaryColumn(columnIndex).putInt(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong(int columnIndex, long value) {
            this.getPrimaryColumn(columnIndex).putLong(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong128LittleEndian(int columnIndex, long hi, long lo) {
            MemoryA primaryColumn = this.getPrimaryColumn(columnIndex);
            primaryColumn.putLong(lo);
            primaryColumn.putLong(hi);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, long l0, long l1, long l2, long l3) {
            this.getPrimaryColumn(columnIndex).putLong256(l0, l1, l2, l3);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, Long256 value) {
            this.getPrimaryColumn(columnIndex).putLong256(value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3());
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, CharSequence hexString) {
            this.getPrimaryColumn(columnIndex).putLong256(hexString);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, @NotNull CharSequence hexString, int start, int end) {
            this.getPrimaryColumn(columnIndex).putLong256(hexString, start, end);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putShort(int columnIndex, short value) {
            this.getPrimaryColumn(columnIndex).putShort(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, CharSequence value) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, char value) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, CharSequence value, int pos, int len) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value, pos, len));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putSym(int columnIndex, CharSequence value) {
            this.getPrimaryColumn(columnIndex).putInt(((MapWriter)TableWriter.this.symbolMapWriters.getQuick(columnIndex)).put(value));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putSym(int columnIndex, char value) {
            this.getPrimaryColumn(columnIndex).putInt(((MapWriter)TableWriter.this.symbolMapWriters.getQuick(columnIndex)).put(value));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        private MemoryA getPrimaryColumn(int columnIndex) {
            return (MemoryA)TableWriter.this.activeColumns.getQuick(TableWriter.getPrimaryColumnIndex(columnIndex));
        }

        private MemoryA getSecondaryColumn(int columnIndex) {
            return (MemoryA)TableWriter.this.activeColumns.getQuick(TableWriter.getSecondaryColumnIndex(columnIndex));
        }
    }

    @FunctionalInterface
    public static interface ExtensionListener {
        public void onTableExtended(long var1);
    }

    public static interface Row {
        public void append();

        public void cancel();

        public void putBin(int var1, long var2, long var4);

        public void putBin(int var1, BinarySequence var2);

        public void putBool(int var1, boolean var2);

        public void putByte(int var1, byte var2);

        public void putChar(int var1, char var2);

        default public void putDate(int columnIndex, long value) {
            this.putLong(columnIndex, value);
        }

        public void putDouble(int var1, double var2);

        public void putFloat(int var1, float var2);

        public void putGeoHash(int var1, long var2);

        public void putGeoHashDeg(int var1, double var2, double var4);

        public void putGeoStr(int var1, CharSequence var2);

        public void putInt(int var1, int var2);

        public void putLong(int var1, long var2);

        public void putLong128LittleEndian(int var1, long var2, long var4);

        public void putLong256(int var1, long var2, long var4, long var6, long var8);

        public void putLong256(int var1, Long256 var2);

        public void putLong256(int var1, CharSequence var2);

        public void putLong256(int var1, @NotNull CharSequence var2, int var3, int var4);

        public void putShort(int var1, short var2);

        public void putStr(int var1, CharSequence var2);

        public void putStr(int var1, char var2);

        public void putStr(int var1, CharSequence var2, int var3, int var4);

        public void putSym(int var1, CharSequence var2);

        public void putSym(int var1, char var2);

        default public void putSymIndex(int columnIndex, int key) {
            this.putInt(columnIndex, key);
        }

        default public void putTimestamp(int columnIndex, long value) {
            this.putLong(columnIndex, value);
        }
    }

    @FunctionalInterface
    public static interface O3ColumnUpdateMethod {
        public void run(int var1, int var2, long var3, long var5);
    }

    @FunctionalInterface
    private static interface FragileCode {
        public void run(CharSequence var1);
    }
}

