/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.Sequencer;
import io.questdb.cairo.SequencerImpl;
import io.questdb.cairo.TableStructure;
import io.questdb.std.Chars;
import io.questdb.std.ConcurrentHashMap;
import java.io.Closeable;
import java.util.Map;
import java.util.Set;

public class TableRegistry
implements Closeable {
    private final ConcurrentHashMap<Sequencer> tableRegistry = new ConcurrentHashMap();
    private final CairoEngine engine;

    TableRegistry(CairoEngine engine) {
        this.engine = engine;
    }

    void registerTable(TableStructure struct) {
        String tableName = Chars.toString(struct.getTableName());
        Sequencer other = this.tableRegistry.remove(tableName);
        if (other != null) {
            other.close();
        }
        SequencerImpl sequencer = new SequencerImpl(this.engine, tableName);
        sequencer.of(struct);
        sequencer.close();
    }

    Sequencer getSequencer(CharSequence tableName) {
        Sequencer sequencer = this.tableRegistry.get(tableName);
        if (sequencer == null) {
            sequencer = new SequencerImpl(this.engine, Chars.toString(tableName));
            sequencer.open();
            Sequencer other = this.tableRegistry.putIfAbsent(Chars.toString(tableName), sequencer);
            if (other != null) {
                sequencer.close();
                return other;
            }
        }
        return sequencer;
    }

    void clear() {
        Set<Map.Entry<CharSequence, Sequencer>> entries = this.tableRegistry.entrySet();
        for (Map.Entry<CharSequence, Sequencer> entry : entries) {
            entry.getValue().close();
        }
        this.tableRegistry.clear();
    }

    @Override
    public void close() {
        this.clear();
    }
}

