/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexBwdNullReader;
import io.questdb.cairo.BitmapIndexBwdReader;
import io.questdb.cairo.BitmapIndexFwdNullReader;
import io.questdb.cairo.BitmapIndexFwdReader;
import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.EmptySymbolMapReader;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.SymbolMapReaderImpl;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableReaderRecordCursor;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.vm.NullMemoryMR;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Path;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableReader
implements Closeable,
SymbolTableSource {
    private static final Log LOG = LogFactory.getLog(TableReader.class);
    private static final int PARTITIONS_SLOT_SIZE = 4;
    private static final int PARTITIONS_SLOT_OFFSET_SIZE = 1;
    private static final int PARTITIONS_SLOT_OFFSET_NAME_TXN = 2;
    private static final int PARTITIONS_SLOT_OFFSET_COLUMN_VERSION = 3;
    private static final int PARTITIONS_SLOT_SIZE_MSB = Numbers.msb(4);
    private final FilesFacade ff;
    private final Path path;
    private final int partitionBy;
    private final int rootLen;
    private final TableReaderMetadata metadata;
    private final DateFormat partitionDirFormatMethod;
    private final LongList openPartitionInfo;
    private final TableReaderRecordCursor recordCursor = new TableReaderRecordCursor();
    private final PartitionBy.PartitionFloorMethod partitionFloorMethod;
    private final String tableName;
    private final MessageBus messageBus;
    private final ObjList<SymbolMapReader> symbolMapReaders = new ObjList();
    private final CairoConfiguration configuration;
    private final TxReader txFile;
    private final MemoryMR todoMem = Vm.getMRInstance();
    private final TxnScoreboard txnScoreboard;
    private final ColumnVersionReader columnVersionReader;
    private int partitionCount;
    private LongList columnTops;
    private ObjList<MemoryMR> columns;
    private ObjList<BitmapIndexReader> bitmapIndexes;
    private int columnCount;
    private int columnCountShl;
    private long rowCount;
    private long txn = 0L;
    private long tempMem8b = Unsafe.malloc(8L, 25);
    private boolean txnAcquired = false;
    private final MillisecondClock clock;

    public TableReader(CairoConfiguration configuration, CharSequence tableName) {
        this(configuration, tableName, null);
    }

    public TableReader(CairoConfiguration configuration, CharSequence tableName, @Nullable MessageBus messageBus) {
        this.configuration = configuration;
        this.clock = configuration.getMillisecondClock();
        this.ff = configuration.getFilesFacade();
        this.tableName = Chars.toString(tableName);
        this.messageBus = messageBus;
        this.path = new Path();
        this.path.of(configuration.getRoot()).concat(this.tableName);
        this.rootLen = this.path.length();
        this.path.trimTo(this.rootLen);
        try {
            this.metadata = this.openMetaFile();
            this.columnCount = this.metadata.getColumnCount();
            this.columnCountShl = TableReader.getColumnBits(this.columnCount);
            this.partitionBy = this.metadata.getPartitionBy();
            this.columnVersionReader = new ColumnVersionReader().ofRO(this.ff, this.path.trimTo(this.rootLen).concat("_cv").$());
            this.txnScoreboard = new TxnScoreboard(this.ff, configuration.getTxnScoreboardEntryCount()).ofRW(this.path.trimTo(this.rootLen));
            LOG.debug().$("open [id=").$(this.metadata.getId()).$(", table=").$(this.tableName).I$();
            this.txFile = new TxReader(this.ff).ofRO(this.path.trimTo(this.rootLen).concat("_txn").$(), this.partitionBy);
            this.path.trimTo(this.rootLen);
            this.reloadSlow(false);
            this.openSymbolMaps();
            this.partitionCount = this.txFile.getPartitionCount();
            this.partitionDirFormatMethod = PartitionBy.getPartitionDirFormatMethod(this.partitionBy);
            this.partitionFloorMethod = PartitionBy.getPartitionFloorMethod(this.partitionBy);
            int capacity = this.getColumnBase(this.partitionCount);
            this.columns = new ObjList(capacity);
            this.columns.setPos(capacity + 2);
            this.columns.setQuick(0, NullMemoryMR.INSTANCE);
            this.columns.setQuick(1, NullMemoryMR.INSTANCE);
            this.bitmapIndexes = new ObjList(capacity);
            this.bitmapIndexes.setPos(capacity + 2);
            this.openPartitionInfo = new LongList(this.partitionCount * 4);
            this.openPartitionInfo.setPos(this.partitionCount * 4);
            for (int i = 0; i < this.partitionCount; ++i) {
                this.openPartitionInfo.setQuick(i * 4, this.txFile.getPartitionTimestamp(i));
                this.openPartitionInfo.setQuick(i * 4 + 1, -1L);
                this.openPartitionInfo.setQuick(i * 4 + 2, this.txFile.getPartitionNameTxn(i));
                this.openPartitionInfo.setQuick(i * 4 + 3, this.txFile.getPartitionColumnVersion(i));
            }
            this.columnTops = new LongList(capacity / 2);
            this.columnTops.setPos(capacity / 2);
            this.recordCursor.of(this);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    public static int getPrimaryColumnIndex(int base, int index) {
        return 2 + base + index * 2;
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            this.goPassive();
            this.freeSymbolMapReaders();
            this.freeBitmapIndexCache();
            Misc.free(this.metadata);
            Misc.free(this.txFile);
            Misc.free(this.todoMem);
            this.freeColumns();
            this.freeTempMem();
            Misc.free(this.txnScoreboard);
            Misc.free(this.path);
            Misc.free(this.columnVersionReader);
            LOG.debug().$("closed '").utf8(this.tableName).$('\'').$();
        }
    }

    public void closeColumnForRemove(int columnIndex) {
        assert (columnIndex > -1 && columnIndex < this.columnCount);
        for (int partitionIndex = 0; partitionIndex < this.partitionCount; ++partitionIndex) {
            this.closePartitionColumnFile(this.getColumnBase(partitionIndex), columnIndex);
        }
        if (ColumnType.isSymbol(this.metadata.getColumnType(columnIndex))) {
            Misc.free(this.symbolMapReaders.getAndSetQuick(columnIndex, EmptySymbolMapReader.INSTANCE));
        }
    }

    public void closeColumnForRemove(CharSequence columnName) {
        this.closeColumnForRemove(this.metadata.getColumnIndex(columnName));
    }

    public long floorToPartitionTimestamp(long timestamp) {
        return this.partitionFloorMethod.floor(timestamp);
    }

    public BitmapIndexReader getBitmapIndexReader(int partitionIndex, int columnIndex, int direction) {
        int columnBase = this.getColumnBase(partitionIndex);
        return this.getBitmapIndexReader(partitionIndex, columnBase, columnIndex, direction);
    }

    public BitmapIndexReader getBitmapIndexReader(int partitionIndex, int columnBase, int columnIndex, int direction) {
        int index = TableReader.getPrimaryColumnIndex(columnBase, columnIndex);
        BitmapIndexReader reader = this.bitmapIndexes.getQuick(direction == 2 ? index : index + 1);
        if (reader != null) {
            return reader;
        }
        long partitionTimestamp = this.txFile.getPartitionTimestamp(partitionIndex);
        long columnNameTxn = this.columnVersionReader.getColumnNameTxn(partitionTimestamp, this.metadata.getWriterIndex(columnIndex));
        return this.createBitmapIndexReaderAt(index, columnBase, columnIndex, columnNameTxn, direction, this.txFile.getPartitionNameTxn(partitionIndex));
    }

    public MemoryR getColumn(int absoluteIndex) {
        return this.columns.getQuick(absoluteIndex);
    }

    public int getColumnBase(int partitionIndex) {
        return partitionIndex << this.columnCountShl;
    }

    public long getColumnTop(int base, int columnIndex) {
        return this.columnTops.getQuick(base / 2 + columnIndex);
    }

    public ColumnVersionReader getColumnVersionReader() {
        return this.columnVersionReader;
    }

    public long getCommitLag() {
        return this.metadata.getCommitLag();
    }

    public TableReaderRecordCursor getCursor() {
        this.recordCursor.toTop();
        return this.recordCursor;
    }

    public long getDataVersion() {
        return this.txFile.getDataVersion();
    }

    public long getMaxTimestamp() {
        return this.txFile.getMaxTimestamp();
    }

    public int getMaxUncommittedRows() {
        return this.metadata.getMaxUncommittedRows();
    }

    public TableReaderMetadata getMetadata() {
        return this.metadata;
    }

    public long getMinTimestamp() {
        return this.txFile.getMinTimestamp();
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public int getPartitionIndexByTimestamp(long timestamp) {
        int end = this.openPartitionInfo.binarySearchBlock(PARTITIONS_SLOT_SIZE_MSB, timestamp, -1);
        if (end < 0) {
            return (-end - 2) / 4;
        }
        return end / 4;
    }

    public long getPartitionTimestampByIndex(int partitionIndex) {
        return this.txFile.getPartitionTimestamp(partitionIndex);
    }

    public int getPartitionedBy() {
        return this.metadata.getPartitionBy();
    }

    public SymbolMapReader getSymbolMapReader(int columnIndex) {
        return this.symbolMapReaders.getQuick(columnIndex);
    }

    @Override
    public StaticSymbolTable getSymbolTable(int columnIndex) {
        return this.getSymbolMapReader(columnIndex);
    }

    @Override
    public StaticSymbolTable newSymbolTable(int columnIndex) {
        return this.getSymbolMapReader(columnIndex).newSymbolTableView();
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getTransientRowCount() {
        return this.txFile.getTransientRowCount();
    }

    public TxReader getTxFile() {
        return this.txFile;
    }

    public long getTxnStructureVersion() {
        return this.txFile.getStructureVersion();
    }

    public long getVersion() {
        return this.txFile.getStructureVersion();
    }

    public void goActive() {
        this.reload();
    }

    public void goPassive() {
        if (this.releaseTxn() && PartitionBy.isPartitioned(this.partitionBy)) {
            this.checkSchedulePurgeO3Partitions();
        }
    }

    public boolean isOpen() {
        return this.tempMem8b != 0L;
    }

    public long openPartition(int partitionIndex) {
        long size = this.getPartitionRowCount(partitionIndex);
        if (size != -1L) {
            return size;
        }
        return this.openPartition0(partitionIndex);
    }

    public void reconcileOpenPartitionsFrom(int partitionIndex, boolean forceTruncate) {
        int txPartitionCount = this.txFile.getPartitionCount();
        int txPartitionIndex = partitionIndex;
        boolean changed = false;
        while (partitionIndex < this.partitionCount && txPartitionIndex < txPartitionCount) {
            int offset = partitionIndex * 4;
            long txPartTs = this.txFile.getPartitionTimestamp(txPartitionIndex);
            long openPartitionTimestamp = this.openPartitionInfo.getQuick(offset);
            if (openPartitionTimestamp < txPartTs) {
                this.deletePartition(partitionIndex);
                continue;
            }
            if (openPartitionTimestamp > txPartTs) {
                this.insertPartition(partitionIndex, txPartTs);
                changed = true;
                ++txPartitionIndex;
                ++partitionIndex;
                continue;
            }
            long newPartitionSize = this.txFile.getPartitionSize(txPartitionIndex);
            long txPartitionNameTxn = this.txFile.getPartitionNameTxn(partitionIndex);
            long txPartitionColumnVersion = this.txFile.getPartitionColumnVersion(partitionIndex);
            long openPartitionSize = this.openPartitionInfo.getQuick(offset + 1);
            long openPartitionNameTxn = this.openPartitionInfo.getQuick(offset + 2);
            long openPartitionColumnVersion = this.openPartitionInfo.getQuick(offset + 3);
            if (!forceTruncate) {
                if (openPartitionNameTxn == txPartitionNameTxn && openPartitionColumnVersion == txPartitionColumnVersion) {
                    if (openPartitionSize != newPartitionSize) {
                        if (openPartitionSize > -1L) {
                            this.reloadPartition(partitionIndex, newPartitionSize, txPartitionNameTxn);
                            this.openPartitionInfo.setQuick(offset + 1, newPartitionSize);
                            LOG.debug().$("updated partition size [partition=").$(openPartitionTimestamp).I$();
                        }
                        changed = true;
                    }
                } else {
                    this.reOpenPartition(offset, partitionIndex, txPartitionNameTxn);
                    changed = true;
                }
            } else if (openPartitionSize > -1L && newPartitionSize > -1L) {
                this.reOpenPartition(offset, partitionIndex, txPartitionNameTxn);
            }
            ++txPartitionIndex;
            ++partitionIndex;
        }
        while (partitionIndex < this.partitionCount) {
            this.deletePartition(partitionIndex);
            changed = true;
        }
        while (partitionIndex < txPartitionCount) {
            this.insertPartition(partitionIndex, this.txFile.getPartitionTimestamp(partitionIndex));
            changed = true;
            ++partitionIndex;
        }
        if (forceTruncate) {
            this.reloadAllSymbols();
        } else if (changed) {
            this.reloadSymbolMapCounts();
        }
    }

    public boolean reload() {
        if (this.acquireTxn()) {
            return false;
        }
        long prevPartitionVersion = this.txFile.getPartitionTableVersion();
        long prevColumnVersion = this.txFile.getColumnVersion();
        long prevTruncateVersion = this.txFile.getTruncateVersion();
        try {
            this.reloadSlow(true);
            this.reconcileOpenPartitions(prevPartitionVersion, prevColumnVersion, prevTruncateVersion);
            return true;
        }
        catch (Throwable e) {
            this.releaseTxn();
            throw e;
        }
    }

    public long size() {
        return this.rowCount;
    }

    private static int getColumnBits(int columnCount) {
        return Numbers.msb(Numbers.ceilPow2(columnCount) * 2);
    }

    private static void growColumn(MemoryR mem1, MemoryR mem2, int type, long rowCount) {
        if (rowCount > 0L) {
            if (ColumnType.isVariableLength(type)) {
                assert (mem2 != null);
                mem2.extend((rowCount + 1L) * 8L);
                mem1.extend(mem2.getLong(rowCount * 8L));
            } else {
                mem1.extend(rowCount << ColumnType.pow2SizeOf(type));
            }
        }
    }

    private boolean acquireTxn() {
        if (!this.txnAcquired) {
            if (this.txnScoreboard.acquireTxn(this.txn)) {
                this.txnAcquired = true;
            } else {
                return false;
            }
        }
        if (this.txn == this.txFile.getTxn()) {
            Unsafe.getUnsafe().loadFence();
            return this.txFile.getVersion() == this.txFile.unsafeReadVersion();
        }
        return false;
    }

    private void checkSchedulePurgeO3Partitions() {
        long txnLocks = this.txnScoreboard.getActiveReaderCount(this.txn);
        long partitionTableVersion = this.txFile.getPartitionTableVersion();
        if (txnLocks == 0L && this.txFile.unsafeLoadAll() && this.txFile.getPartitionTableVersion() > partitionTableVersion) {
            if (TableUtils.schedulePurgeO3Partitions(this.messageBus, this.tableName, this.partitionBy)) {
                return;
            }
            LOG.error().$("could not queue purge partition task, queue is full [").$("table=").$(this.tableName).$(", txn=").$(this.txn).$(']').$();
        }
    }

    private void closePartitionColumnFile(int base, int columnIndex) {
        int index = TableReader.getPrimaryColumnIndex(base, columnIndex);
        Misc.free(this.columns.getAndSetQuick(index, NullMemoryMR.INSTANCE));
        Misc.free(this.columns.getAndSetQuick(index + 1, NullMemoryMR.INSTANCE));
        Misc.free(this.bitmapIndexes.getAndSetQuick(index, null));
        Misc.free(this.bitmapIndexes.getAndSetQuick(index + 1, null));
    }

    private long closeRewrittenPartitionFiles(int partitionIndex, int oldBase, Path path) {
        int offset = partitionIndex * 4;
        long partitionTs = this.openPartitionInfo.getQuick(offset);
        long exisingPartitionNameTxn = this.openPartitionInfo.getQuick(offset + 2);
        long newNameTxn = this.txFile.getPartitionNameTxnByPartitionTimestamp(partitionTs);
        long newSize = this.txFile.getPartitionSizeByPartitionTimestamp(partitionTs);
        if (exisingPartitionNameTxn != newNameTxn || newSize < 0L) {
            LOG.debugW().$("close outdated partition files [table=").$(this.tableName).$(", ts=").$ts(partitionTs).$(", nameTxn=").$(newNameTxn).$();
            for (int i = 0; i < this.columnCount; ++i) {
                this.closePartitionColumnFile(oldBase, i);
            }
            this.openPartitionInfo.setQuick(offset + 1, -1L);
            return -1L;
        }
        this.pathGenPartitioned(partitionIndex);
        TableUtils.txnPartitionConditionally(path, exisingPartitionNameTxn);
        return newSize;
    }

    private void copyColumns(int fromBase, int fromColumnIndex, ObjList<MemoryMR> toColumns, LongList toColumnTops, ObjList<BitmapIndexReader> toIndexReaders, int toBase, int toColumnIndex) {
        int fromIndex = TableReader.getPrimaryColumnIndex(fromBase, fromColumnIndex);
        int toIndex = TableReader.getPrimaryColumnIndex(toBase, toColumnIndex);
        toColumns.setQuick(toIndex, this.columns.getAndSetQuick(fromIndex, null));
        toColumns.setQuick(toIndex + 1, this.columns.getAndSetQuick(fromIndex + 1, null));
        toColumnTops.setQuick(toBase / 2 + toColumnIndex, this.columnTops.getQuick(fromBase / 2 + fromColumnIndex));
        toIndexReaders.setQuick(toIndex, this.bitmapIndexes.getAndSetQuick(fromIndex, null));
        toIndexReaders.setQuick(toIndex + 1, this.bitmapIndexes.getAndSetQuick(fromIndex + 1, null));
    }

    private void copyOrRenewSymbolMapReader(SymbolMapReader reader, int columnIndex) {
        if (reader != null && reader.isDeleted()) {
            reader = this.reloadSymbolMapReader(columnIndex, reader);
        }
        this.symbolMapReaders.setQuick(columnIndex, reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BitmapIndexReader createBitmapIndexReaderAt(int globalIndex, int columnBase, int columnIndex, long columnNameTxn, int direction, long txn) {
        BitmapIndexReader reader;
        if (!this.metadata.isColumnIndexed(columnIndex)) {
            throw CairoException.critical(0).put("Not indexed: ").put(this.metadata.getColumnName(columnIndex));
        }
        MemoryR col = this.columns.getQuick(globalIndex);
        if (col instanceof NullMemoryMR) {
            if (direction == 2) {
                reader = new BitmapIndexBwdNullReader();
                this.bitmapIndexes.setQuick(globalIndex, reader);
            } else {
                reader = new BitmapIndexFwdNullReader();
                this.bitmapIndexes.setQuick(globalIndex + 1, reader);
            }
        } else {
            Path path = this.pathGenPartitioned(this.getPartitionIndex(columnBase));
            try {
                if (direction == 2) {
                    reader = new BitmapIndexBwdReader(this.configuration, path, this.metadata.getColumnName(columnIndex), columnNameTxn, this.getColumnTop(columnBase, columnIndex), txn);
                    this.bitmapIndexes.setQuick(globalIndex, reader);
                } else {
                    reader = new BitmapIndexFwdReader(this.configuration, path, this.metadata.getColumnName(columnIndex), columnNameTxn, this.getColumnTop(columnBase, columnIndex), txn);
                    this.bitmapIndexes.setQuick(globalIndex + 1, reader);
                }
            }
            finally {
                path.trimTo(this.rootLen);
            }
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewColumnList(int columnCount, long pTransitionIndex, int columnCountShl) {
        LOG.debug().$("resizing columns file list [table=").$(this.tableName).I$();
        int capacity = this.partitionCount << columnCountShl;
        ObjList<MemoryMR> columns = new ObjList<MemoryMR>(capacity + 2);
        LongList columnTops = new LongList(capacity / 2);
        ObjList<BitmapIndexReader> indexReaders = new ObjList<BitmapIndexReader>(capacity);
        columns.setPos(capacity + 2);
        columns.setQuick(0, NullMemoryMR.INSTANCE);
        columns.setQuick(1, NullMemoryMR.INSTANCE);
        columnTops.setPos(capacity / 2);
        indexReaders.setPos(capacity + 2);
        long pIndexBase = pTransitionIndex + 8L;
        int iterateCount = Math.max(columnCount, this.columnCount);
        for (int partitionIndex = 0; partitionIndex < this.partitionCount; ++partitionIndex) {
            int base = partitionIndex << columnCountShl;
            int oldBase = partitionIndex << this.columnCountShl;
            try {
                long partitionRowCount = this.openPartitionInfo.getQuick(partitionIndex * 4 + 1);
                if (partitionRowCount <= -1L || (partitionRowCount = this.closeRewrittenPartitionFiles(partitionIndex, oldBase, this.path)) <= -1L) continue;
                for (int i = 0; i < iterateCount; ++i) {
                    int action = Unsafe.getUnsafe().getInt(pIndexBase + (long)i * 8L);
                    int copyFrom = Unsafe.getUnsafe().getInt(pIndexBase + (long)i * 8L + 4L);
                    if (action == -1) {
                        this.closePartitionColumnFile(oldBase, i);
                    }
                    if (copyFrom > -1) {
                        this.copyColumns(oldBase, copyFrom, columns, columnTops, indexReaders, base, i);
                        continue;
                    }
                    if (copyFrom == Integer.MIN_VALUE) continue;
                    this.reloadColumnAt(partitionIndex, this.path, columns, columnTops, indexReaders, base, i, partitionRowCount);
                }
                continue;
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
        this.columns = columns;
        this.columnTops = columnTops;
        this.columnCountShl = columnCountShl;
        this.bitmapIndexes = indexReaders;
    }

    private void deletePartition(int partitionIndex) {
        int offset = partitionIndex * 4;
        long partitionTimestamp = this.openPartitionInfo.getQuick(offset);
        long partitionSize = this.openPartitionInfo.getQuick(offset + 1);
        int columnBase = this.getColumnBase(partitionIndex);
        if (partitionSize > -1L) {
            for (int k = 0; k < this.columnCount; ++k) {
                this.closePartitionColumnFile(columnBase, k);
            }
        }
        int baseIndex = TableReader.getPrimaryColumnIndex(columnBase, 0);
        int newBaseIndex = TableReader.getPrimaryColumnIndex(this.getColumnBase(partitionIndex + 1), 0);
        this.columns.remove(baseIndex, newBaseIndex - 1);
        this.openPartitionInfo.removeIndexBlock(offset, 4);
        LOG.info().$("deleted partition [path=").$(this.path).$(",timestamp=").$ts(partitionTimestamp).I$();
        --this.partitionCount;
    }

    private void formatPartitionDirName(int partitionIndex, CharSink sink) {
        this.partitionDirFormatMethod.format(this.openPartitionInfo.getQuick(partitionIndex * 4), null, null, sink);
    }

    private void freeBitmapIndexCache() {
        Misc.freeObjList(this.bitmapIndexes);
    }

    private void freeColumns() {
        Misc.freeObjList(this.columns);
    }

    private void freeSymbolMapReaders() {
        int n = this.symbolMapReaders.size();
        for (int i = 0; i < n; ++i) {
            Misc.free(this.symbolMapReaders.getQuick(i));
        }
        this.symbolMapReaders.clear();
    }

    private void freeTempMem() {
        if (this.tempMem8b != 0L) {
            Unsafe.free(this.tempMem8b, 8L, 25);
            this.tempMem8b = 0L;
        }
    }

    int getColumnCount() {
        return this.columnCount;
    }

    int getPartitionIndex(int columnBase) {
        return columnBase >>> this.columnCountShl;
    }

    long getPartitionRowCount(int partitionIndex) {
        return this.openPartitionInfo.getQuick(partitionIndex * 4 + 1);
    }

    public long getTxn() {
        return this.txn;
    }

    TxnScoreboard getTxnScoreboard() {
        return this.txnScoreboard;
    }

    private void insertPartition(int partitionIndex, long timestamp) {
        int columnBase = this.getColumnBase(partitionIndex);
        int columnSlotSize = this.getColumnBase(1);
        int topBase = columnBase / 2;
        int topSlotSize = columnSlotSize / 2;
        int idx = TableReader.getPrimaryColumnIndex(columnBase, 0);
        this.columns.insert(idx, columnSlotSize, NullMemoryMR.INSTANCE);
        this.bitmapIndexes.insert(idx, columnSlotSize, null);
        this.columnTops.insert(topBase, topSlotSize);
        this.columnTops.seed(topBase, topSlotSize, 0L);
        int offset = partitionIndex * 4;
        this.openPartitionInfo.insert(offset, 4);
        this.openPartitionInfo.setQuick(offset, timestamp);
        this.openPartitionInfo.setQuick(offset + 1, -1L);
        this.openPartitionInfo.setQuick(offset + 2, -1L);
        this.openPartitionInfo.setQuick(offset + 3, -1L);
        ++this.partitionCount;
        LOG.debug().$("inserted partition [index=").$(partitionIndex).$(", path=").$(this.path).$(", timestamp=").$ts(timestamp).I$();
    }

    boolean isColumnCached(int columnIndex) {
        return this.symbolMapReaders.getQuick(columnIndex).isCached();
    }

    @NotNull
    private SymbolMapReaderImpl newSymbolMapReader(int symbolColumnIndex, int columnIndex) {
        return new SymbolMapReaderImpl(this.configuration, this.path, this.metadata.getColumnName(columnIndex), this.columnVersionReader.getDefaultColumnNameTxn(this.metadata.getWriterIndex(columnIndex)), this.txFile.getSymbolValueCount(symbolColumnIndex));
    }

    private TableReaderMetadata openMetaFile() {
        long deadline = this.clock.getTicks() + this.configuration.getSpinLockTimeout();
        TableReaderMetadata metadata = new TableReaderMetadata(this.ff);
        this.path.concat("_meta").$();
        try {
            boolean existenceChecked = false;
            while (true) {
                try {
                    TableReaderMetadata tableReaderMetadata = metadata.deferredInit(this.path, 426);
                    return tableReaderMetadata;
                }
                catch (CairoException ex) {
                    if (!existenceChecked) {
                        this.path.trimTo(this.rootLen).put(Files.SEPARATOR).$();
                        if (!this.ff.exists(this.path)) {
                            throw CairoException.nonCritical().put("table does not exist [table=").put(this.tableName).put(']');
                        }
                        this.path.trimTo(this.rootLen).concat("_meta").$();
                    }
                    existenceChecked = true;
                    TableUtils.handleMetadataLoadException(this.configuration, this.tableName, deadline, ex);
                    continue;
                }
                break;
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    @NotNull
    private MemoryMR openOrCreateMemory(Path path, ObjList<MemoryMR> columns, int primaryIndex, MemoryMR mem, long columnSize) {
        if (mem != null && mem != NullMemoryMR.INSTANCE) {
            mem.of(this.ff, path, columnSize, columnSize, 7);
        } else {
            mem = Vm.getMRInstance(this.ff, path, columnSize, 7);
            columns.setQuick(primaryIndex, mem);
        }
        return mem;
    }

    private long openPartition0(int partitionIndex) {
        if (this.txFile.getPartitionCount() < 2 && this.txFile.getTransientRowCount() == 0L) {
            return -1L;
        }
        try {
            long partitionNameTxn = this.txFile.getPartitionNameTxn(partitionIndex);
            Path path = this.pathGenPartitioned(partitionIndex);
            TableUtils.txnPartitionConditionally(path, partitionNameTxn);
            if (this.ff.exists(path.$())) {
                path.chop$();
                long partitionSize = this.txFile.getPartitionSize(partitionIndex);
                if (partitionSize > -1L) {
                    LOG.info().$("open partition ").utf8(path.$()).$(" [rowCount=").$(partitionSize).$(", partitionNameTxn=").$(partitionNameTxn).$(", transientRowCount=").$(this.txFile.getTransientRowCount()).$(", partitionIndex=").$(partitionIndex).$(", partitionCount=").$(this.partitionCount).$(']').$();
                    this.openPartitionColumns(partitionIndex, path, this.getColumnBase(partitionIndex), partitionSize);
                    int offset = partitionIndex * 4;
                    this.openPartitionInfo.setQuick(offset + 1, partitionSize);
                    long txPartitionNameTxn = this.txFile.getPartitionNameTxn(partitionIndex);
                    this.openPartitionInfo.setQuick(offset + 2, txPartitionNameTxn);
                    long txPartitionColumnVersion = this.txFile.getPartitionColumnVersion(partitionIndex);
                    this.openPartitionInfo.setQuick(offset + 3, txPartitionColumnVersion);
                }
                long l = partitionSize;
                return l;
            }
            LOG.error().$("open partition failed, partition does not exist on the disk. [path=").utf8(path.$()).I$();
            if (PartitionBy.isPartitioned(this.getPartitionedBy())) {
                CairoException exception = CairoException.critical(0).put("Partition '");
                this.formatPartitionDirName(partitionIndex, exception.message);
                TableUtils.txnPartitionConditionally(exception.message, partitionNameTxn);
                exception.put("' does not exist in table '").put(this.tableName).put("' directory. Run [ALTER TABLE ").put(this.tableName).put(" DROP PARTITION LIST '");
                this.formatPartitionDirName(partitionIndex, exception.message);
                TableUtils.txnPartitionConditionally(exception.message, partitionNameTxn);
                exception.put("'] to repair the table or restore the partition directory.");
                throw exception;
            }
            throw CairoException.critical(0).put("Table '").put(this.tableName).put("' data directory does not exist on the disk at ").put(path).put(". Restore data on disk or drop the table.");
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void openPartitionColumns(int partitionIndex, Path path, int columnBase, long partitionRowCount) {
        for (int i = 0; i < this.columnCount; ++i) {
            this.reloadColumnAt(partitionIndex, path, this.columns, this.columnTops, this.bitmapIndexes, columnBase, i, partitionRowCount);
        }
    }

    private void openSymbolMaps() {
        int symbolColumnIndex = 0;
        int columnCount = this.metadata.getColumnCount();
        this.symbolMapReaders.setPos(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            if (!ColumnType.isSymbol(this.metadata.getColumnType(i))) continue;
            this.symbolMapReaders.extendAndSet(i, this.newSymbolMapReader(symbolColumnIndex++, i));
        }
    }

    private Path pathGenPartitioned(int partitionIndex) {
        this.formatPartitionDirName(partitionIndex, this.path.slash());
        return this.path;
    }

    private void reOpenPartition(int offset, int partitionIndex, long txPartitionNameTxn) {
        this.openPartitionInfo.setQuick(offset + 1, -1L);
        this.openPartition0(partitionIndex);
        this.openPartitionInfo.setQuick(offset + 2, txPartitionNameTxn);
    }

    private void readTxnSlow(long deadline) {
        long txn;
        int count = 0;
        while (true) {
            if (this.txFile.unsafeLoadAll()) {
                txn = this.txFile.getTxn();
                this.releaseTxn();
                this.txn = txn;
                if (this.acquireTxn()) break;
            }
            ++count;
            if (this.clock.getTicks() > deadline) {
                LOG.error().$("tx read timeout [timeout=").$(this.configuration.getSpinLockTimeout()).utf8("ms]").$();
                throw CairoException.critical(0).put("Transaction read timeout");
            }
            Os.pause();
        }
        this.rowCount = this.txFile.getFixedRowCount() + this.txFile.getTransientRowCount();
        LOG.debug().$("new transaction [txn=").$(txn).$(", transientRowCount=").$(this.txFile.getTransientRowCount()).$(", fixedRowCount=").$(this.txFile.getFixedRowCount()).$(", maxTimestamp=").$ts(this.txFile.getMaxTimestamp()).$(", attempts=").$(count).$(", thread=").$(Thread.currentThread().getName()).$(']').$();
    }

    private void reconcileOpenPartitions(long prevPartitionVersion, long prevColumnVersion, long prevTruncateVersion) {
        boolean truncateHappened;
        boolean bl = truncateHappened = this.txFile.getTruncateVersion() != prevTruncateVersion;
        if (this.txFile.getPartitionTableVersion() == prevPartitionVersion && this.txFile.getColumnVersion() == prevColumnVersion && !truncateHappened) {
            int txPartitionCount;
            int partitionIndex = Math.max(0, this.partitionCount - 1);
            if (partitionIndex < (txPartitionCount = this.txFile.getPartitionCount())) {
                if (partitionIndex < this.partitionCount) {
                    int offset = partitionIndex * 4;
                    long openPartitionSize = this.openPartitionInfo.getQuick(offset + 1);
                    if (openPartitionSize > -1L) {
                        long openPartitionNameTxn = this.openPartitionInfo.getQuick(offset + 2);
                        long txPartitionSize = this.txFile.getPartitionSize(partitionIndex);
                        long txPartitionNameTxn = this.txFile.getPartitionNameTxn(partitionIndex);
                        if (openPartitionNameTxn == txPartitionNameTxn) {
                            if (openPartitionSize != txPartitionSize) {
                                this.reloadPartition(partitionIndex, txPartitionSize, txPartitionNameTxn);
                                this.openPartitionInfo.setQuick(offset + 1, txPartitionSize);
                                LOG.debug().$("updated partition size [partition=").$(this.openPartitionInfo.getQuick(offset)).I$();
                            }
                        } else {
                            this.openPartition0(partitionIndex);
                        }
                    }
                    ++partitionIndex;
                }
                while (partitionIndex < txPartitionCount) {
                    this.insertPartition(partitionIndex, this.txFile.getPartitionTimestamp(partitionIndex));
                    ++partitionIndex;
                }
                this.reloadSymbolMapCounts();
            }
            return;
        }
        this.reconcileOpenPartitionsFrom(0, truncateHappened);
    }

    private boolean releaseTxn() {
        if (this.txnAcquired) {
            long readerCount = this.txnScoreboard.releaseTxn(this.txn);
            this.txnAcquired = false;
            return readerCount == 0L;
        }
        return false;
    }

    private void reloadAllSymbols() {
        int symbolMapIndex = 0;
        for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
            SymbolMapReader symbolMapReader;
            if (!ColumnType.isSymbol(this.metadata.getColumnType(columnIndex)) || !((symbolMapReader = this.symbolMapReaders.getQuick(columnIndex)) instanceof SymbolMapReaderImpl)) continue;
            int writerColumnIndex = this.metadata.getWriterIndex(columnIndex);
            long columnNameTxn = this.columnVersionReader.getDefaultColumnNameTxn(writerColumnIndex);
            int symbolCount = this.txFile.getSymbolValueCount(symbolMapIndex++);
            ((SymbolMapReaderImpl)symbolMapReader).of(this.configuration, this.path, this.metadata.getColumnName(columnIndex), columnNameTxn, symbolCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadColumnAt(int partitionIndex, Path path, ObjList<MemoryMR> columns, LongList columnTops, ObjList<BitmapIndexReader> indexReaders, int columnBase, int columnIndex, long partitionRowCount) {
        int plen = path.length();
        try {
            long columnTxn;
            String name = this.metadata.getColumnName(columnIndex);
            int primaryIndex = TableReader.getPrimaryColumnIndex(columnBase, columnIndex);
            int secondaryIndex = primaryIndex + 1;
            MemoryMR mem1 = columns.getQuick(primaryIndex);
            MemoryMR mem2 = columns.getQuick(secondaryIndex);
            long partitionTimestamp = this.openPartitionInfo.getQuick(partitionIndex * 4);
            int writerIndex = this.metadata.getWriterIndex(columnIndex);
            int versionRecordIndex = this.columnVersionReader.getRecordIndex(partitionTimestamp, writerIndex);
            long columnTop = (long)versionRecordIndex > -1L ? this.columnVersionReader.getColumnTopByIndex(versionRecordIndex) : 0L;
            long l = columnTxn = (long)versionRecordIndex > -1L ? this.columnVersionReader.getColumnNameTxnByIndex(versionRecordIndex) : -1L;
            if (columnTxn == -1L) {
                columnTxn = this.columnVersionReader.getDefaultColumnNameTxn(writerIndex);
            }
            long columnRowCount = partitionRowCount - columnTop;
            assert (partitionRowCount < 0L || columnRowCount >= 0L);
            if (columnRowCount > 0L && ((long)versionRecordIndex > -1L || this.columnVersionReader.getColumnTopPartitionTimestamp(writerIndex) <= partitionTimestamp)) {
                long columnSize;
                int columnType = this.metadata.getColumnType(columnIndex);
                if (ColumnType.isVariableLength(columnType)) {
                    columnSize = columnRowCount * 8L + 8L;
                    TableUtils.iFile(path.trimTo(plen), name, columnTxn);
                    mem2 = this.openOrCreateMemory(path, columns, secondaryIndex, mem2, columnSize);
                    columnSize = mem2.getLong(columnRowCount * 8L);
                    TableUtils.dFile(path.trimTo(plen), name, columnTxn);
                    this.openOrCreateMemory(path, columns, primaryIndex, mem1, columnSize);
                } else {
                    columnSize = columnRowCount << ColumnType.pow2SizeOf(columnType);
                    TableUtils.dFile(path.trimTo(plen), name, columnTxn);
                    this.openOrCreateMemory(path, columns, primaryIndex, mem1, columnSize);
                    Misc.free(columns.getAndSetQuick(secondaryIndex, null));
                }
                columnTops.setQuick(columnBase / 2 + columnIndex, columnTop);
                if (this.metadata.isColumnIndexed(columnIndex)) {
                    BitmapIndexReader indexReader = indexReaders.getQuick(primaryIndex);
                    if (indexReader instanceof BitmapIndexBwdReader) {
                        ((BitmapIndexBwdReader)indexReader).of(this.configuration, path.trimTo(plen), name, columnTxn, columnTop, -1L);
                    }
                    if ((indexReader = indexReaders.getQuick(secondaryIndex)) instanceof BitmapIndexFwdReader) {
                        ((BitmapIndexFwdReader)indexReader).of(this.configuration, path.trimTo(plen), name, columnTxn, columnTop, -1L);
                    }
                } else {
                    Misc.free(indexReaders.getAndSetQuick(primaryIndex, null));
                    Misc.free(indexReaders.getAndSetQuick(secondaryIndex, null));
                }
            } else {
                Misc.free(columns.getAndSetQuick(primaryIndex, NullMemoryMR.INSTANCE));
                Misc.free(columns.getAndSetQuick(secondaryIndex, NullMemoryMR.INSTANCE));
                Misc.free(indexReaders.getAndSetQuick(primaryIndex, null));
                Misc.free(indexReaders.getAndSetQuick(secondaryIndex, null));
                columnTops.setQuick(columnBase / 2 + columnIndex, partitionRowCount);
            }
        }
        finally {
            path.trimTo(plen);
        }
    }

    private boolean reloadColumnVersion(long columnVersion, long deadline) {
        if (this.columnVersionReader.getVersion() != columnVersion) {
            this.columnVersionReader.readSafe(this.clock, deadline);
        }
        return this.columnVersionReader.getVersion() == columnVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reloadMetadata(long txnStructureVersion, long deadline, boolean reshuffleColumns) {
        long pTransitionIndex;
        if (txnStructureVersion == this.metadata.getStructureVersion()) {
            return true;
        }
        while (true) {
            try {
                pTransitionIndex = this.metadata.createTransitionIndex(txnStructureVersion);
                if (pTransitionIndex < 0L) {
                    if (this.clock.getTicks() < deadline) {
                        return false;
                    }
                    LOG.error().$("metadata read timeout [timeout=").$(this.configuration.getSpinLockTimeout()).utf8("ms]").$();
                    throw CairoException.critical(0).put("Metadata read timeout");
                }
            }
            catch (CairoException ex) {
                TableUtils.handleMetadataLoadException(this.configuration, this.tableName, deadline, ex);
                continue;
            }
            break;
        }
        try {
            this.metadata.applyTransitionIndex();
            if (reshuffleColumns) {
                int columnCount = this.metadata.getColumnCount();
                int columnCountShl = TableReader.getColumnBits(columnCount);
                if (columnCountShl > this.columnCountShl) {
                    this.createNewColumnList(columnCount, pTransitionIndex, columnCountShl);
                } else {
                    this.reshuffleColumns(columnCount, pTransitionIndex);
                }
                this.reshuffleSymbolMapReaders(pTransitionIndex, columnCount);
                this.columnCount = columnCount;
                this.reloadSymbolMapCounts();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            TableUtils.freeTransitionIndex(pTransitionIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadPartition(int partitionIndex, long rowCount, long openPartitionNameTxn) {
        Path path = this.pathGenPartitioned(partitionIndex);
        TableUtils.txnPartitionConditionally(path, openPartitionNameTxn);
        try {
            int symbolMapIndex = 0;
            int columnBase = this.getColumnBase(partitionIndex);
            for (int i = 0; i < this.columnCount; ++i) {
                int index = TableReader.getPrimaryColumnIndex(columnBase, i);
                MemoryMR mem1 = this.columns.getQuick(index);
                if (mem1 instanceof NullMemoryMR) {
                    this.reloadColumnAt(partitionIndex, path, this.columns, this.columnTops, this.bitmapIndexes, columnBase, i, rowCount);
                } else {
                    TableReader.growColumn(mem1, this.columns.getQuick(index + 1), this.metadata.getColumnType(i), rowCount - this.getColumnTop(columnBase, i));
                }
                SymbolMapReader reader = this.symbolMapReaders.getQuick(i);
                if (reader == null) continue;
                reader.updateSymbolCount(this.txFile.getSymbolValueCount(symbolMapIndex++));
            }
        }
        finally {
            path.trimTo(this.rootLen);
        }
    }

    private void reloadSlow(boolean reshuffle) {
        long deadline = this.clock.getTicks() + this.configuration.getSpinLockTimeout();
        do {
            this.readTxnSlow(deadline);
        } while (!this.reloadColumnVersion(this.txFile.getColumnVersion(), deadline) || !this.reloadMetadata(this.txFile.getStructureVersion(), deadline, reshuffle));
    }

    private void reloadSymbolMapCounts() {
        int symbolMapIndex = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            if (!ColumnType.isSymbol(this.metadata.getColumnType(i))) continue;
            this.symbolMapReaders.getQuick(i).updateSymbolCount(this.txFile.getSymbolValueCount(symbolMapIndex++));
        }
    }

    private SymbolMapReader reloadSymbolMapReader(int columnIndex, SymbolMapReader reader) {
        if (ColumnType.isSymbol(this.metadata.getColumnType(columnIndex))) {
            int writerColumnIndex = this.metadata.getWriterIndex(columnIndex);
            long columnNameTxn = this.columnVersionReader.getDefaultColumnNameTxn(writerColumnIndex);
            if (reader instanceof SymbolMapReaderImpl) {
                ((SymbolMapReaderImpl)reader).of(this.configuration, this.path, this.metadata.getColumnName(columnIndex), columnNameTxn, 0);
                return reader;
            }
            return new SymbolMapReaderImpl(this.configuration, this.path, this.metadata.getColumnName(columnIndex), columnNameTxn, 0);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reshuffleColumns(int columnCount, long pTransitionIndex) {
        LOG.debug().$("reshuffling columns file list [table=").$(this.tableName).I$();
        long pIndexBase = pTransitionIndex + 8L;
        int iterateCount = Math.max(columnCount, this.columnCount);
        for (int partitionIndex = 0; partitionIndex < this.partitionCount; ++partitionIndex) {
            int base = this.getColumnBase(partitionIndex);
            try {
                long partitionRowCount = this.openPartitionInfo.getQuick(partitionIndex * 4 + 1);
                if (partitionRowCount <= -1L || (partitionRowCount = this.closeRewrittenPartitionFiles(partitionIndex, base, this.path)) <= -1L) continue;
                for (int i = 0; i < iterateCount; ++i) {
                    int action = Unsafe.getUnsafe().getInt(pIndexBase + (long)i * 8L);
                    int copyFrom = Unsafe.getUnsafe().getInt(pIndexBase + (long)i * 8L + 4L);
                    if (action == -1) {
                        this.closePartitionColumnFile(base, i);
                    }
                    if (copyFrom == i) {
                        MemoryMR col = this.columns.getQuick(TableReader.getPrimaryColumnIndex(base, i));
                        if (!(col instanceof NullMemoryMR)) continue;
                        this.reloadColumnAt(partitionIndex, this.path, this.columns, this.columnTops, this.bitmapIndexes, base, i, partitionRowCount);
                        continue;
                    }
                    if (copyFrom > -1) {
                        this.copyColumns(base, copyFrom, this.columns, this.columnTops, this.bitmapIndexes, base, i);
                        continue;
                    }
                    if (copyFrom == Integer.MIN_VALUE) continue;
                    this.reloadColumnAt(partitionIndex, this.path, this.columns, this.columnTops, this.bitmapIndexes, base, i, partitionRowCount);
                }
                continue;
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
    }

    private void reshuffleSymbolMapReaders(long pTransitionIndex, int columnCount) {
        long pIndexBase = pTransitionIndex + 8L;
        if (columnCount > this.columnCount) {
            this.symbolMapReaders.setPos(columnCount);
        }
        int n = Math.max(columnCount, this.columnCount);
        for (int i = 0; i < n; ++i) {
            int action = Unsafe.getUnsafe().getInt(pIndexBase + (long)i * 8L);
            int copyFrom = Unsafe.getUnsafe().getInt(pIndexBase + (long)i * 8L + 4L);
            if (action == -1) {
                Misc.free(this.symbolMapReaders.getAndSetQuick(i, null));
            }
            if (copyFrom == i) {
                SymbolMapReader reader = this.symbolMapReaders.getQuick(copyFrom);
                if (reader == null || !reader.isDeleted()) continue;
                this.symbolMapReaders.setQuick(copyFrom, this.reloadSymbolMapReader(copyFrom, reader));
                continue;
            }
            if (copyFrom > -1) {
                SymbolMapReader tmp = this.symbolMapReaders.getQuick(copyFrom);
                this.copyOrRenewSymbolMapReader(tmp, i);
                continue;
            }
            if (copyFrom == Integer.MIN_VALUE) continue;
            this.symbolMapReaders.getAndSetQuick(i, this.reloadSymbolMapReader(i, null));
        }
    }
}

