/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnIndexer;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.MemorySRImpl;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;

public class SymbolColumnIndexer
implements ColumnIndexer,
Mutable {
    private static final long SEQUENCE_OFFSET = Unsafe.getFieldOffset(SymbolColumnIndexer.class, "sequence");
    private final BitmapIndexWriter writer = new BitmapIndexWriter();
    private final MemorySRImpl mem = new MemorySRImpl();
    private long columnTop;
    private volatile long sequence = 0L;
    private volatile boolean distressed = false;

    @Override
    public void clear() {
        this.writer.clear();
    }

    @Override
    public void close() {
        Misc.free(this.writer);
        Misc.free(this.mem);
    }

    @Override
    public void distress() {
        this.distressed = true;
    }

    @Override
    public long getFd() {
        return this.mem.getFd();
    }

    @Override
    public long getSequence() {
        return this.sequence;
    }

    @Override
    public void refreshSourceAndIndex(long loRow, long hiRow) {
        this.mem.updateSize();
        this.index(this.mem, loRow, hiRow);
    }

    @Override
    public void index(MemoryR mem, long loRow, long hiRow) {
        this.writer.rollbackConditionally(loRow);
        for (long lo = Math.max(loRow, this.columnTop); lo < hiRow; ++lo) {
            this.writer.add(TableUtils.toIndexKey(mem.getInt((lo - this.columnTop) * 4L)), lo);
        }
        this.writer.setMaxValue(hiRow - 1L);
    }

    @Override
    public BitmapIndexWriter getWriter() {
        return this.writer;
    }

    @Override
    public boolean isDistressed() {
        return this.distressed;
    }

    @Override
    public void configureFollowerAndWriter(CairoConfiguration configuration, Path path, CharSequence name, long columnNameTxn, MemoryMA columnMem, long columnTop) {
        this.columnTop = columnTop;
        try {
            this.writer.of(configuration, path, name, columnNameTxn, configuration.getDataIndexKeyAppendPageSize(), configuration.getDataIndexValueAppendPageSize());
            this.mem.of(columnMem, 15);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void configureWriter(CairoConfiguration configuration, Path path, CharSequence name, long columnNameTxn, long columnTop) {
        this.columnTop = columnTop;
        try {
            this.writer.of(configuration, path, name, columnNameTxn, configuration.getDataIndexKeyAppendPageSize(), configuration.getDataIndexValueAppendPageSize());
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void closeSlider() {
        this.mem.close();
    }

    @Override
    public void rollback(long maxRow) {
        this.writer.rollbackValues(maxRow);
    }

    @Override
    public boolean tryLock(long expectedSequence) {
        return Unsafe.cas((Object)this, SEQUENCE_OFFSET, expectedSequence, expectedSequence + 1L);
    }
}

