/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.IDGenerator;
import io.questdb.cairo.Sequencer;
import io.questdb.cairo.SequencerMetadata;
import io.questdb.cairo.TableDescriptor;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TxnCatalog;
import io.questdb.cairo.WalWriter;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.SimpleReadWriteLock;
import io.questdb.std.str.Path;
import java.util.concurrent.locks.ReadWriteLock;

public class SequencerImpl
implements Sequencer {
    private final ReadWriteLock schemaLock = new SimpleReadWriteLock();
    private final CairoEngine engine;
    private final String tableName;
    private final Path path;
    private final int rootLen;
    private final SequencerMetadata metadata;
    private final TxnCatalog catalog;
    private final IDGenerator txnGenerator;
    private final IDGenerator walIdGenerator;

    SequencerImpl(CairoEngine engine, String tableName) {
        this.engine = engine;
        this.tableName = tableName;
        CairoConfiguration configuration = engine.getConfiguration();
        FilesFacade ff = configuration.getFilesFacade();
        try {
            this.path = new Path().of(configuration.getRoot()).concat(tableName).concat("seq");
            this.rootLen = this.path.length();
            this.createSequencerDir(ff, configuration.getMkDirMode());
            this.metadata = new SequencerMetadata(ff);
            this.walIdGenerator = new IDGenerator(configuration, "_wal_index.d");
            this.walIdGenerator.open(this.path);
            this.txnGenerator = new IDGenerator(configuration, "_txn");
            this.txnGenerator.open(this.path);
            this.catalog = new TxnCatalog(ff);
            this.catalog.open(this.path, this.rootLen, this.txnGenerator.getCurrentId());
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    private void createSequencerDir(FilesFacade ff, int mkDirMode) {
        if (ff.mkdirs(this.path.slash$(), mkDirMode) != 0) {
            throw CairoException.critical(ff.errno()).put("Cannot create sequencer directory: ").put(this.path);
        }
        this.path.trimTo(this.rootLen);
    }

    @Override
    public void open() {
        this.metadata.open(this.path, this.rootLen);
    }

    void of(TableStructure model) {
        this.schemaLock.writeLock().lock();
        try {
            this.metadata.init(model, this.path, this.rootLen);
        }
        finally {
            this.schemaLock.writeLock().unlock();
        }
    }

    @Override
    public long nextTxn(int walId, long segmentId) {
        long txn = this.txnGenerator.getNextId();
        this.catalog.setEntry(txn, walId, segmentId);
        return txn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextTxn(int expectedSchemaVersion, int walId, long segmentId) {
        this.schemaLock.readLock().lock();
        try {
            long l = this.metadata.getSchemaVersion() == expectedSchemaVersion ? this.nextTxn(walId, segmentId) : Long.MIN_VALUE;
            return l;
        }
        finally {
            this.schemaLock.readLock().unlock();
        }
    }

    @Override
    public void populateDescriptor(TableDescriptor descriptor) {
        this.schemaLock.readLock().lock();
        try {
            descriptor.of(this.metadata);
        }
        finally {
            this.schemaLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addColumn(int columnIndex, CharSequence columnName, int columnType, int walId, long segmentId) {
        this.schemaLock.writeLock().lock();
        try {
            this.metadata.addColumn(columnIndex, columnName, columnType, this.path, this.rootLen);
            long l = this.nextTxn(walId, segmentId);
            return l;
        }
        finally {
            this.schemaLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long removeColumn(int columnIndex, int walId, long segmentId) {
        this.schemaLock.writeLock().lock();
        try {
            this.metadata.removeColumn(columnIndex, this.path, this.rootLen);
            long l = this.nextTxn(walId, segmentId);
            return l;
        }
        finally {
            this.schemaLock.writeLock().unlock();
        }
    }

    @Override
    public WalWriter createWal() {
        return new WalWriter(this.engine, this.tableName, (int)this.walIdGenerator.getNextId(), this);
    }

    @Override
    public void close() {
        this.schemaLock.writeLock().lock();
        try {
            Misc.free(this.metadata);
            Misc.free(this.catalog);
            Misc.free(this.walIdGenerator);
            Misc.free(this.txnGenerator);
            Misc.free(this.path);
        }
        finally {
            this.schemaLock.writeLock().unlock();
        }
    }
}

