/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.microtime.TimestampFormatCompiler;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.CharSink;

public final class PartitionBy {
    public static final int DAY = 0;
    public static final int MONTH = 1;
    public static final int YEAR = 2;
    public static final int HOUR = 4;
    public static final int NONE = 3;
    private static final PartitionCeilMethod CEIL_DD = Timestamps::ceilDD;
    private static final PartitionCeilMethod CEIL_YYYY = Timestamps::ceilYYYY;
    private static final PartitionCeilMethod CEIL_HH = Timestamps::ceilHH;
    private static final PartitionFloorMethod FLOOR_MM = Timestamps::floorMM;
    private static final PartitionCeilMethod CEIL_MM = Timestamps::ceilMM;
    private static final PartitionAddMethod ADD_MM = Timestamps::addMonths;
    private static final PartitionAddMethod ADD_YYYY = Timestamps::addYear;
    private static final PartitionAddMethod ADD_HH = Timestamps::addHours;
    private static final PartitionFloorMethod FLOOR_DD = Timestamps::floorDD;
    private static final PartitionAddMethod ADD_DD = Timestamps::addDays;
    private static final PartitionFloorMethod FLOOR_YYYY = Timestamps::floorYYYY;
    private static final PartitionFloorMethod FLOOR_HH = Timestamps::floorHH;
    private static final LowerCaseCharSequenceIntHashMap nameToIndexMap = new LowerCaseCharSequenceIntHashMap();
    private static final DateFormat fmtDay;
    private static final DateFormat fmtMonth;
    private static final DateFormat fmtYear;
    private static final DateFormat fmtDefault;
    private static final DateFormat fmtHour;

    private PartitionBy() {
    }

    public static int fromString(CharSequence name) {
        return nameToIndexMap.get(name);
    }

    public static PartitionAddMethod getPartitionAddMethod(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return ADD_DD;
            }
            case 1: {
                return ADD_MM;
            }
            case 2: {
                return ADD_YYYY;
            }
            case 4: {
                return ADD_HH;
            }
        }
        return null;
    }

    public static DateFormat getPartitionDirFormatMethod(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return fmtDay;
            }
            case 1: {
                return fmtMonth;
            }
            case 2: {
                return fmtYear;
            }
            case 4: {
                return fmtHour;
            }
            case 3: {
                return fmtDefault;
            }
        }
        throw new UnsupportedOperationException("partition by " + partitionBy + " does not have date format");
    }

    public static PartitionFloorMethod getPartitionFloorMethod(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return FLOOR_DD;
            }
            case 1: {
                return FLOOR_MM;
            }
            case 2: {
                return FLOOR_YYYY;
            }
            case 4: {
                return FLOOR_HH;
            }
        }
        return null;
    }

    public static long getPartitionTimeIntervalFloor(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return 86400000000L;
            }
            case 1: {
                return 2419200000000L;
            }
            case 2: {
                return 31536000000000L;
            }
            case 4: {
                return 3600000000L;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean isPartitioned(int partitionBy) {
        return partitionBy != 3;
    }

    public static long parsePartitionDirName(CharSequence partitionName, int partitionBy) {
        try {
            return PartitionBy.getPartitionDirFormatMethod(partitionBy).parse(partitionName, null);
        }
        catch (NumericException e) {
            CairoException ee = CairoException.critical(0);
            switch (partitionBy) {
                case 0: {
                    ee.put("'YYYY-MM-DD'");
                    break;
                }
                case 1: {
                    ee.put("'YYYY-MM'");
                    break;
                }
                case 2: {
                    ee.put("'YYYY'");
                    break;
                }
                case 4: {
                    ee.put("'YYYY-MM-DDTHH'");
                }
            }
            ee.put(" expected");
            throw ee;
        }
    }

    public static long setSinkForPartition(CharSink path, int partitionBy, long timestamp, boolean calculatePartitionMax) {
        switch (partitionBy) {
            case 0: {
                int y = Timestamps.getYear(timestamp);
                boolean leap = Timestamps.isLeapYear(y);
                int m = Timestamps.getMonthOfYear(timestamp, y, leap);
                int d = Timestamps.getDayOfMonth(timestamp, y, m, leap);
                TimestampFormatUtils.append000(path, y);
                path.put('-');
                TimestampFormatUtils.append0(path, m);
                path.put('-');
                TimestampFormatUtils.append0(path, d);
                if (calculatePartitionMax) {
                    return Timestamps.yearMicros(y, leap) + Timestamps.monthOfYearMicros(m, leap) + (long)(d - 1) * 86400000000L + 86400000000L - 1L;
                }
                return 0L;
            }
            case 1: {
                int y = Timestamps.getYear(timestamp);
                boolean leap = Timestamps.isLeapYear(y);
                int m = Timestamps.getMonthOfYear(timestamp, y, leap);
                TimestampFormatUtils.append000(path, y);
                path.put('-');
                TimestampFormatUtils.append0(path, m);
                if (calculatePartitionMax) {
                    return Timestamps.yearMicros(y, leap) + Timestamps.monthOfYearMicros(m, leap) + (long)Timestamps.getDaysPerMonth(m, leap) * 24L * 3600000000L - 1L;
                }
                return 0L;
            }
            case 2: {
                int y = Timestamps.getYear(timestamp);
                boolean leap = Timestamps.isLeapYear(y);
                TimestampFormatUtils.append000(path, y);
                if (calculatePartitionMax) {
                    return Timestamps.addYear(Timestamps.yearMicros(y, leap), 1) - 1L;
                }
                return 0L;
            }
            case 4: {
                int y = Timestamps.getYear(timestamp);
                boolean leap = Timestamps.isLeapYear(y);
                int m = Timestamps.getMonthOfYear(timestamp, y, leap);
                int d = Timestamps.getDayOfMonth(timestamp, y, m, leap);
                int h = Timestamps.getHourOfDay(timestamp);
                TimestampFormatUtils.append000(path, y);
                path.put('-');
                TimestampFormatUtils.append0(path, m);
                path.put('-');
                TimestampFormatUtils.append0(path, d);
                path.put('T');
                TimestampFormatUtils.append0(path, h);
                if (calculatePartitionMax) {
                    return Timestamps.yearMicros(y, leap) + Timestamps.monthOfYearMicros(m, leap) + (long)(d - 1) * 86400000000L + (long)(h + 1) * 3600000000L - 1L;
                }
                return 0L;
            }
        }
        path.put("default");
        return Long.MAX_VALUE;
    }

    public static String toString(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return "DAY";
            }
            case 1: {
                return "MONTH";
            }
            case 2: {
                return "YEAR";
            }
            case 4: {
                return "HOUR";
            }
            case 3: {
                return "NONE";
            }
        }
        return "UNKNOWN";
    }

    static PartitionCeilMethod getPartitionCeilMethod(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return CEIL_DD;
            }
            case 1: {
                return CEIL_MM;
            }
            case 2: {
                return CEIL_YYYY;
            }
            case 4: {
                return CEIL_HH;
            }
        }
        return null;
    }

    static {
        nameToIndexMap.put("day", 0);
        nameToIndexMap.put("month", 1);
        nameToIndexMap.put("year", 2);
        nameToIndexMap.put("hour", 4);
        nameToIndexMap.put("none", 3);
        TimestampFormatCompiler compiler = new TimestampFormatCompiler();
        fmtDay = compiler.compile("yyyy-MM-dd");
        fmtMonth = compiler.compile("yyyy-MM");
        fmtYear = compiler.compile("yyyy");
        fmtHour = compiler.compile("yyyy-MM-ddTHH");
        fmtDefault = new DateFormat(){

            @Override
            public void format(long datetime, DateLocale locale, CharSequence timeZoneName, CharSink sink) {
                sink.put("default");
            }

            @Override
            public long parse(CharSequence in, DateLocale locale) {
                return this.parse(in, 0, in.length(), locale);
            }

            @Override
            public long parse(CharSequence in, int lo, int hi, DateLocale locale) {
                return 0L;
            }
        };
    }

    @FunctionalInterface
    public static interface PartitionAddMethod {
        public long calculate(long var1, int var3);
    }

    @FunctionalInterface
    public static interface PartitionCeilMethod {
        public long ceil(long var1);
    }

    @FunctionalInterface
    public static interface PartitionFloorMethod {
        public long floor(long var1);
    }
}

