/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.std.Chars;
import io.questdb.std.DirectLongList;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Vect;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.str.MutableCharSink;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.tasks.O3PartitionPurgeTask;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class O3PartitionPurgeJob
extends AbstractQueueConsumerJob<O3PartitionPurgeTask>
implements Closeable {
    private static final Log LOG = LogFactory.getLog(O3PartitionPurgeJob.class);
    private final CairoConfiguration configuration;
    private final MutableCharSink[] sink;
    private final StringSink[] fileNameSinks;
    private final ObjList<DirectLongList> partitionList;
    private final ObjList<TxnScoreboard> txnScoreboards;
    private final ObjList<TxReader> txnReaders;
    private final AtomicBoolean halted = new AtomicBoolean(false);

    public O3PartitionPurgeJob(MessageBus messageBus, int workerCount) {
        super(messageBus.getO3PurgeDiscoveryQueue(), messageBus.getO3PurgeDiscoverySubSeq());
        this.configuration = messageBus.getConfiguration();
        this.sink = new MutableCharSink[workerCount];
        this.fileNameSinks = new StringSink[workerCount];
        this.partitionList = new ObjList(workerCount);
        this.txnScoreboards = new ObjList(workerCount);
        this.txnReaders = new ObjList(workerCount);
        for (int i = 0; i < workerCount; ++i) {
            this.sink[i] = new StringSink();
            this.fileNameSinks[i] = new StringSink();
            this.partitionList.add(new DirectLongList((long)this.configuration.getPartitionPurgeListCapacity() * 2L, 3));
            this.txnScoreboards.add(new TxnScoreboard(this.configuration.getFilesFacade(), this.configuration.getTxnScoreboardEntryCount()));
            this.txnReaders.add(new TxReader(this.configuration.getFilesFacade()));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.halted.compareAndSet(false, true)) {
            Misc.freeObjList(this.partitionList);
            Misc.freeObjList(this.txnReaders);
            Misc.freeObjList(this.txnScoreboards);
        }
    }

    private static void processPartition(FilesFacade ff, Path path, int tableRootLen, TxReader txReader, TxnScoreboard txnScoreboard, long partitionTimestamp, int partitionBy, DirectLongList partitionList, int lo, int hi) {
        boolean partitionInTxnFile;
        boolean bl = partitionInTxnFile = txReader.getPartitionSizeByPartitionTimestamp(partitionTimestamp) > 0L;
        if (partitionInTxnFile) {
            O3PartitionPurgeJob.processPartition0(ff, path, tableRootLen, txReader, txnScoreboard, partitionTimestamp, partitionBy, partitionList, lo, hi);
        } else {
            O3PartitionPurgeJob.processDetachedPartition(ff, path, tableRootLen, txReader, txnScoreboard, partitionTimestamp, partitionBy, partitionList, lo, hi);
        }
    }

    private static void processDetachedPartition(FilesFacade ff, Path path, int tableRootLen, TxReader txReader, TxnScoreboard txnScoreboard, long partitionTimestamp, int partitionBy, DirectLongList partitionList, int lo, int hi) {
        long lastTxn = txReader.getTxn();
        int n = lo - 1;
        for (int i = hi - 2; i > n; i -= 2) {
            boolean rangeUnlocked;
            long nameTxn = partitionList.get(i);
            boolean bl = rangeUnlocked = nameTxn < lastTxn && txnScoreboard.isRangeAvailable(nameTxn, lastTxn);
            if (!rangeUnlocked) break;
            LOG.info().$("purging removed partition directory [ts=").$ts(partitionTimestamp).$(", nameTxn=").$(nameTxn - 1L).I$();
            O3PartitionPurgeJob.deletePartitionDirectory(ff, path, tableRootLen, partitionTimestamp, partitionBy, nameTxn - 1L);
            lastTxn = nameTxn;
        }
    }

    private static void processPartition0(FilesFacade ff, Path path, int tableRootLen, TxReader txReader, TxnScoreboard txnScoreboard, long partitionTimestamp, int partitionBy, DirectLongList partitionList, int lo, int hi) {
        long lastCommittedPartitionName = txReader.getPartitionNameTxnByPartitionTimestamp(partitionTimestamp);
        if (lastCommittedPartitionName > -1L) {
            assert ((long)hi <= partitionList.size());
            for (int i = lo + 2; i < hi; i += 2) {
                boolean rangeUnlocked;
                long nextNameVersion = Math.min(lastCommittedPartitionName + 1L, partitionList.get(i));
                long previousNameVersion = partitionList.get(i - 2);
                boolean bl = rangeUnlocked = previousNameVersion < nextNameVersion && txnScoreboard.isRangeAvailable(previousNameVersion, nextNameVersion);
                if (!rangeUnlocked) continue;
                LOG.info().$("purging [ts=").$ts(partitionTimestamp).$(", nameTxn=").$(previousNameVersion - 1L).$(", nameTxnNext=").$(nextNameVersion - 1L).$(", lastCommittedPartitionName=").$(lastCommittedPartitionName).I$();
                O3PartitionPurgeJob.deletePartitionDirectory(ff, path, tableRootLen, partitionTimestamp, partitionBy, previousNameVersion - 1L);
            }
        }
    }

    private static void deletePartitionDirectory(FilesFacade ff, Path path, int tableRootLen, long partitionTimestamp, int partitionBy, long previousNameVersion) {
        path.trimTo(tableRootLen);
        TableUtils.setPathForPartition(path, partitionBy, partitionTimestamp, false);
        TableUtils.txnPartitionConditionally(path, previousNameVersion);
        path.slash$();
        long errno = ff.rmdir(path);
        if (errno == 0L) {
            LOG.info().$("purged [path=").$(path).I$();
        } else {
            LOG.info().$("partition purge failed [path=").$(path).$(", errno=").$(errno).I$();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverPartitions(FilesFacade ff, MutableCharSink sink, StringSink fileNameSink, DirectLongList partitionList, CharSequence root, CharSequence tableName, TxnScoreboard txnScoreboard, TxReader txReader, int partitionBy) {
        LOG.info().$("processing [table=").$(tableName).I$();
        Path path = Path.getThreadLocal(root);
        path.concat(tableName).slash$();
        sink.clear();
        path.slash$();
        partitionList.clear();
        DateFormat partitionByFormat = PartitionBy.getPartitionDirFormatMethod(partitionBy);
        long p = ff.findFirst(path);
        if (p > 0L) {
            try {
                do {
                    long fileName;
                    if (!Files.isDir(fileName = ff.findName(p), ff.findType(p), fileNameSink)) continue;
                    this.parsePartitionDateVersion(fileNameSink, partitionList, tableName, partitionByFormat);
                } while (ff.findNext(p) > 0);
            }
            finally {
                ff.findClose(p);
            }
        }
        assert (partitionList.size() % 2L == 0L);
        Vect.sort128BitAscInPlace(partitionList.getAddress(), partitionList.size() / 2L);
        long partitionTimestamp = Long.MIN_VALUE;
        int lo = 0;
        int n = (int)partitionList.size();
        path.of(root).concat(tableName);
        int tableRootLen = path.length();
        try {
            txnScoreboard.ofRO(path);
            txReader.ofRO(path.trimTo(tableRootLen).concat("_txn").$(), partitionBy);
            TableUtils.safeReadTxn(txReader, this.configuration.getMillisecondClock(), this.configuration.getSpinLockTimeout());
            for (int i = 0; i < n; i += 2) {
                long currentPartitionTs = partitionList.get(i + 1);
                if (currentPartitionTs == partitionTimestamp) continue;
                if (i > lo + 2 || i > 0 && txReader.getPartitionSizeByPartitionTimestamp(partitionTimestamp) < 0L) {
                    O3PartitionPurgeJob.processPartition(ff, path, tableRootLen, txReader, txnScoreboard, partitionTimestamp, partitionBy, partitionList, lo, i);
                }
                lo = i;
                partitionTimestamp = currentPartitionTs;
            }
            if (n > lo + 2) {
                O3PartitionPurgeJob.processPartition(ff, path, tableRootLen, txReader, txnScoreboard, partitionTimestamp, partitionBy, partitionList, lo, n);
            }
        }
        catch (CairoException ex) {
            LOG.error().$("could not purge partition open [table=`").utf8(tableName).$("`, ex=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
            LOG.error().$(ex.getFlyweightMessage()).$();
        }
        finally {
            txReader.clear();
            txnScoreboard.clear();
        }
    }

    @Override
    protected boolean doRun(int workerId, long cursor) {
        O3PartitionPurgeTask task = (O3PartitionPurgeTask)this.queue.get(cursor);
        this.discoverPartitions(this.configuration.getFilesFacade(), this.sink[workerId], this.fileNameSinks[workerId], this.partitionList.get(workerId), this.configuration.getRoot(), task.getTableName(), this.txnScoreboards.get(workerId), this.txnReaders.get(workerId), task.getPartitionBy());
        this.subSeq.done(cursor);
        return true;
    }

    private void parsePartitionDateVersion(StringSink fileNameSink, DirectLongList partitionList, CharSequence tableName, DateFormat partitionByFormat) {
        int index = Chars.lastIndexOf(fileNameSink, '.');
        int len = fileNameSink.length();
        if (index < 0) {
            index = len;
        }
        try {
            if (index < len) {
                long partitionVersion = Numbers.parseLong(fileNameSink, index + 1, len);
                partitionList.add(partitionVersion + 1L);
            } else {
                partitionList.add(0L);
            }
            try {
                long partitionTs = partitionByFormat.parse(fileNameSink, 0, index, null);
                partitionList.add(partitionTs);
            }
            catch (NumericException e) {
                LOG.error().$("unknown directory [table=").utf8(tableName).$(", dir=").utf8(fileNameSink).$(']').$();
                partitionList.setPos(partitionList.size() - 1L);
            }
        }
        catch (NumericException e) {
            LOG.error().$("unknown directory [table=").utf8(tableName).$(", dir=").utf8(fileNameSink).$(']').$();
        }
    }
}

