/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.O3CopyJob;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.Sequence;
import io.questdb.std.FilesFacade;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;
import io.questdb.tasks.O3CopyTask;
import io.questdb.tasks.O3OpenColumnTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class O3OpenColumnJob
extends AbstractQueueConsumerJob<O3OpenColumnTask> {
    public static final int OPEN_MID_PARTITION_FOR_APPEND = 1;
    public static final int OPEN_LAST_PARTITION_FOR_APPEND = 2;
    public static final int OPEN_MID_PARTITION_FOR_MERGE = 3;
    public static final int OPEN_LAST_PARTITION_FOR_MERGE = 4;
    public static final int OPEN_NEW_PARTITION_FOR_APPEND = 5;
    private static final Log LOG = LogFactory.getLog(O3OpenColumnJob.class);

    public O3OpenColumnJob(MessageBus messageBus) {
        super(messageBus.getO3OpenColumnQueue(), messageBus.getO3OpenColumnSubSeq());
    }

    public static void appendLastPartition(Path pathToPartition, int plen, CharSequence columnName, AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long timestampMax, long partitionTimestamp, long srcDataTop, long srcDataMax, int indexBlockCapacity, MemoryMA dstFixMem, MemoryMA dstVarMem, TableWriter tableWriter, BitmapIndexWriter indexWriter, long columnNameTxn) {
        long dstLen = srcOooHi - srcOooLo + 1L + srcDataMax - srcDataTop;
        switch (ColumnType.tagOf(columnType)) {
            case 11: 
            case 18: {
                O3OpenColumnJob.appendVarColumn(columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, 0L, 0L, 0L, -dstFixMem.getFd(), -dstVarMem.getFd(), dstFixMem, dstVarMem, dstLen, tableWriter);
                break;
            }
            case 8: {
                boolean designated = ColumnType.isDesignatedTimestamp(columnType);
                if (designated) {
                    O3OpenColumnJob.appendTimestampColumn(columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataMax, indexBlockCapacity, -dstFixMem.getFd(), 0L, 0L, dstFixMem, dstLen, tableWriter);
                    break;
                }
            }
            default: {
                O3OpenColumnJob.appendFixColumn(pathToPartition, plen, columnName, columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, 0L, 0L, 0L, -dstFixMem.getFd(), dstFixMem, dstLen, tableWriter, indexWriter, columnNameTxn);
            }
        }
    }

    public static boolean isOpenColumnModeForAppend(int openColumnMode) {
        switch (openColumnMode) {
            case 1: 
            case 2: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static void openColumn(O3OpenColumnTask task, long cursor, Sequence subSeq) {
        int openColumnMode = task.getOpenColumnMode();
        Path pathToTable = task.getPathToTable();
        int columnType = task.getColumnType();
        CharSequence columnName = task.getColumnName();
        long srcOooLo = task.getSrcOooLo();
        long srcOooHi = task.getSrcOooHi();
        long srcOooMax = task.getSrcOooMax();
        long timestampMin = task.getTimestampMin();
        long timestampMax = task.getTimestampMax();
        long oooTimestampLo = task.getOooTimestampLo();
        long partitionTimestamp = task.getPartitionTimestamp();
        long srcDataMax = task.getSrcDataMax();
        long srcDataTxn = task.getSrcDataTxn();
        long srcTimestampFd = task.getSrcTimestampFd();
        long srcTimestampAddr = task.getSrcTimestampAddr();
        long srcTimestampSize = task.getSrcTimestampSize();
        AtomicInteger columnCounter = task.getColumnCounter();
        AtomicInteger partCounter = task.getPartCounter();
        int indexBlockCapacity = task.getIndexBlockCapacity();
        long srcOooFixAddr = task.getSrcOooFixAddr();
        long srcOooVarAddr = task.getSrcOooVarAddr();
        long mergeOOOLo = task.getMergeOOOLo();
        long mergeOOOHi = task.getMergeOOOHi();
        long mergeDataLo = task.getMergeDataLo();
        long mergeDataHi = task.getMergeDataHi();
        long txn = task.getTxn();
        int prefixType = task.getPrefixType();
        long prefixLo = task.getPrefixLo();
        long prefixHi = task.getPrefixHi();
        int suffixType = task.getSuffixType();
        long suffixLo = task.getSuffixLo();
        long suffixHi = task.getSuffixHi();
        int mergeType = task.getMergeType();
        long timestampMergeIndexAddr = task.getTimestampMergeIndexAddr();
        long timestampMergeIndexSize = task.getTimestampMergeIndexSize();
        long activeFixFd = task.getActiveFixFd();
        long activeVarFd = task.getActiveVarFd();
        long srcDataTop = task.getSrcDataTop();
        TableWriter tableWriter = task.getTableWriter();
        BitmapIndexWriter indexWriter = task.getIndexWriter();
        long colTopSinkAddr = task.getColTopSinkAddr();
        int columnIndex = task.getColumnIndex();
        long columnNameTxn = task.getColumnNameTxn();
        subSeq.done(cursor);
        O3OpenColumnJob.openColumn(openColumnMode, pathToTable, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, oooTimestampLo, partitionTimestamp, srcDataTop, srcDataMax, srcDataTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, suffixType, suffixLo, suffixHi, srcTimestampFd, srcTimestampAddr, srcTimestampSize, indexBlockCapacity, activeFixFd, activeVarFd, tableWriter, indexWriter, colTopSinkAddr, columnIndex, columnNameTxn);
    }

    public static void openColumn(int openColumnMode, Path pathToTable, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long timestampMax, long oooTimestampLo, long partitionTimestamp, long srcDataTop, long srcDataMax, long srcDataTxn, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, int suffixType, long suffixLo, long suffixHi, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, int indexBlockCapacity, long activeFixFd, long activeVarFd, TableWriter tableWriter, BitmapIndexWriter indexWriter, long colTopSinkAddr, int columnIndex, long columnNameTxn) {
        long mergeLen = mergeOOOHi - mergeOOOLo + 1L + mergeDataHi - mergeDataLo + 1L;
        Path pathToPartition = Path.getThreadLocal(pathToTable);
        TableUtils.setPathForPartition(pathToPartition, tableWriter.getPartitionBy(), oooTimestampLo, false);
        int pplen = pathToPartition.length();
        TableUtils.txnPartitionConditionally(pathToPartition, srcDataTxn);
        int plen = pathToPartition.length();
        switch (openColumnMode) {
            case 1: {
                O3OpenColumnJob.appendMidPartition(pathToPartition, plen, columnName, columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, indexWriter, colTopSinkAddr, columnIndex, columnNameTxn);
                break;
            }
            case 3: {
                O3OpenColumnJob.mergeMidPartition(pathToPartition, plen, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataTop, srcDataMax, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, indexWriter, colTopSinkAddr, partitionTimestamp, columnIndex, columnNameTxn);
                break;
            }
            case 4: {
                O3OpenColumnJob.mergeLastPartition(pathToPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataTop, srcDataMax, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, indexBlockCapacity, activeFixFd, activeVarFd, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, indexWriter, colTopSinkAddr, columnNameTxn);
                break;
            }
            case 5: {
                Unsafe.getUnsafe().putLong(colTopSinkAddr, 0L);
                O3OpenColumnJob.appendNewPartition(pathToPartition, plen, columnName, columnCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataMax, indexBlockCapacity, tableWriter, indexWriter, columnNameTxn);
                break;
            }
        }
    }

    private static void appendMidPartition(Path pathToPartition, int plen, CharSequence columnName, AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long timestampMax, long partitionTimestamp, long srcDataTop, long srcDataMax, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long colTopSinkAddr, int columnIndex, long columnNameTxn) {
        long dstFixFd = 0L;
        long dstVarFd = 0L;
        FilesFacade ff = tableWriter.getFilesFacade();
        if (srcDataTop == -1L) {
            try {
                srcDataTop = tableWriter.getColumnTop(partitionTimestamp, columnIndex, srcDataMax);
                if (srcDataTop == srcDataMax) {
                    Unsafe.getUnsafe().putLong(colTopSinkAddr, srcDataMax);
                }
            }
            catch (Throwable e) {
                LOG.error().$("append mid partition error 1 [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
                O3OpenColumnJob.freeTs(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
                throw e;
            }
        }
        long dstLen = srcOooHi - srcOooLo + 1L + srcDataMax - srcDataTop;
        switch (ColumnType.tagOf(columnType)) {
            case 11: 
            case 18: {
                try {
                    TableUtils.iFile(pathToPartition.trimTo(plen), columnName, columnNameTxn);
                    dstFixFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                    TableUtils.dFile(pathToPartition.trimTo(plen), columnName, columnNameTxn);
                    dstVarFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                }
                catch (Throwable e) {
                    LOG.error().$("append mid partition error 2 [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
                    O3Utils.close(ff, dstFixFd);
                    O3Utils.close(ff, dstVarFd);
                    O3OpenColumnJob.freeTs(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
                    throw e;
                }
                O3OpenColumnJob.appendVarColumn(columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, dstVarFd, null, null, dstLen, tableWriter);
                break;
            }
            case 8: {
                boolean designated = ColumnType.isDesignatedTimestamp(columnType);
                if (designated) {
                    O3OpenColumnJob.appendTimestampColumn(columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataMax, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, null, dstLen, tableWriter);
                    break;
                }
            }
            default: {
                try {
                    TableUtils.dFile(pathToPartition.trimTo(plen), columnName, columnNameTxn);
                    dstFixFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                }
                catch (Throwable e) {
                    LOG.error().$("append mid partition error 3 [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
                    O3Utils.close(ff, dstFixFd);
                    O3Utils.close(ff, dstVarFd);
                    O3OpenColumnJob.freeTs(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
                    throw e;
                }
                O3OpenColumnJob.appendFixColumn(pathToPartition, plen, columnName, columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, null, dstLen, tableWriter, indexWriter, columnNameTxn);
            }
        }
    }

    private static void appendFixColumn(Path pathToPartition, int plen, CharSequence columnName, AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long timestampMax, long partitionTimestamp, long srcDataTop, long srcDataMax, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long dstFixFd, MemoryMA dstFixMem, long dstLen, TableWriter tableWriter, BitmapIndexWriter indexWriter, long columnNameTxn) {
        long dstFixFileOffset;
        long dstIndexAdjust;
        long dstIndexOffset;
        long dstFixAddr;
        long dstFixOffset;
        long dstFixSize;
        long dstKFd = 0L;
        long dstVFd = 0L;
        int shl = ColumnType.pow2SizeOf(columnType);
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            dstFixSize = dstLen << shl;
            dstFixOffset = srcDataMax - srcDataTop << shl;
            if (dstFixMem == null || dstFixMem.getAppendAddressSize() < dstFixSize) {
                dstFixAddr = TableUtils.mapRW(ff, Math.abs(dstFixFd), dstFixSize, 2);
            } else {
                dstFixAddr = dstFixMem.getAppendAddress() - dstFixOffset;
                dstFixSize = -dstFixSize;
            }
            dstIndexOffset = dstFixOffset;
            dstIndexAdjust = srcDataTop;
            dstFixFileOffset = dstFixOffset;
            if (indexBlockCapacity > -1 && !indexWriter.isOpen()) {
                BitmapIndexUtils.keyFileName(pathToPartition.trimTo(plen), columnName, columnNameTxn);
                dstKFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                BitmapIndexUtils.valueFileName(pathToPartition.trimTo(plen), columnName, columnNameTxn);
                dstVFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            }
        }
        catch (Throwable e) {
            LOG.error().$("append fix error [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
            O3Utils.unmapAndClose(ff, dstFixFd, 0L, 0L);
            O3Utils.close(ff, dstKFd);
            O3Utils.close(ff, dstVFd);
            O3OpenColumnJob.freeTs(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
            throw e;
        }
        O3OpenColumnJob.publishCopyTask(columnCounter, null, columnType, 1, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcOooLo, srcOooHi, srcDataTop << shl, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, 0L, 0L, 0L, 0L, 0L, 0L, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, false, tableWriter, indexWriter);
    }

    private static void appendTimestampColumn(AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long timestampMax, long partitionTimestamp, long srcDataMax, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, MemoryMA dstFixMem, long dstLen, TableWriter tableWriter) {
        long dstFixAddr;
        long dstFixFileOffset;
        long dstFixOffset;
        long dstFixSize;
        long dstFixFd = 0L;
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            dstFixSize = dstLen * 8L;
            if (dstFixMem == null || dstFixMem.getAppendAddressSize() < dstFixSize) {
                dstFixFileOffset = dstFixOffset = srcDataMax * 8L;
                dstFixFd = -Math.abs(srcTimestampFd);
                dstFixAddr = TableUtils.mapRW(ff, -dstFixFd, dstFixSize, 2);
            } else {
                dstFixAddr = dstFixMem.getAppendAddress();
                dstFixOffset = 0L;
                dstFixFileOffset = dstFixMem.getAppendOffset();
                dstFixSize = -dstFixSize;
            }
        }
        catch (Throwable e) {
            LOG.error().$("append ts error [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
            O3Utils.close(ff, dstFixFd);
            O3OpenColumnJob.freeTs(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
            throw e;
        }
        O3OpenColumnJob.publishCopyTask(columnCounter, null, columnType, 1, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcOooLo, srcOooHi, 0L, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, false, tableWriter, null);
    }

    private static void appendVarColumn(AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long timestampMax, long partitionTimestamp, long srcDataTop, long srcDataMax, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long activeFixFd, long activeVarFd, MemoryMA dstFixMem, MemoryMA dstVarMem, long dstLen, TableWriter tableWriter) {
        long dstVarAdjust;
        long dstVarOffset;
        long dstFixFileOffset;
        long dstFixOffset;
        long dstFixAddr = 0L;
        long dstVarAddr = 0L;
        long dstVarSize = 0L;
        long dstFixSize = 0L;
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            long l = O3Utils.getVarColumnLength(srcOooLo, srcOooHi, srcOooFixAddr);
            dstFixSize = (dstLen + 1L) * 8L;
            if (dstFixMem == null || dstFixMem.getAppendAddressSize() < dstFixSize || dstVarMem.getAppendAddressSize() < l) {
                assert (dstFixMem == null || dstFixMem.getAppendOffset() - 8L == (srcDataMax - srcDataTop) * 8L);
                dstFixFileOffset = dstFixOffset = (srcDataMax - srcDataTop) * 8L;
                dstFixAddr = TableUtils.mapRW(ff, Math.abs(activeFixFd), dstFixSize, 2);
                dstVarOffset = dstFixOffset > 0L ? Unsafe.getUnsafe().getLong(dstFixAddr + dstFixOffset) : 0L;
                dstVarSize = l + dstVarOffset;
                dstVarAddr = TableUtils.mapRW(ff, Math.abs(activeVarFd), dstVarSize, 2);
                dstVarAdjust = 0L;
            } else {
                assert (dstFixMem.getAppendOffset() >= 8L);
                assert (dstFixMem.getAppendOffset() - 8L == (srcDataMax - srcDataTop) * 8L);
                dstFixAddr = dstFixMem.getAppendAddress() - 8L;
                dstVarAddr = dstVarMem.getAppendAddress();
                dstFixOffset = 0L;
                dstFixFileOffset = dstFixMem.getAppendOffset() - 8L;
                dstFixSize = -dstFixSize;
                dstVarOffset = 0L;
                dstVarSize = -l;
                dstVarAdjust = dstVarMem.getAppendOffset();
            }
        }
        catch (Throwable e) {
            LOG.error().$("append var error [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
            O3Utils.unmapAndClose(ff, activeFixFd, dstFixAddr, dstFixSize);
            O3Utils.unmapAndClose(ff, activeVarFd, dstVarAddr, dstVarSize);
            O3OpenColumnJob.freeTs(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
            throw e;
        }
        O3OpenColumnJob.publishCopyTask(columnCounter, null, columnType, 1, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcOooLo, srcOooHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, activeFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, activeVarFd, dstVarAddr, dstVarOffset, 0L, dstVarAdjust, dstVarSize, 0L, 0L, 0L, 0L, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, false, tableWriter, null);
    }

    private static void publishCopyTask(AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, int columnType, int blockType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataLo, long srcDataHi, long srcDataTop, long srcDataMax, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long timestampMax, long partitionTimestamp, long dstFixFd, long dstFixAddr, long dstFixOffset, long dstFixFileOffset, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarOffset, long dstVarOffsetEnd, long dstVarAdjust, long dstVarSize, long dstKFd, long dstVFd, long dstIndexOffset, long dstIndexAdjust, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, TableWriter tableWriter, BitmapIndexWriter indexWriter) {
        long cursor = tableWriter.getO3CopyPubSeq().next();
        if (cursor > -1L) {
            O3OpenColumnJob.publishCopyTaskHarmonized(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarOffsetEnd, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, cursor, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, tableWriter, indexWriter);
        } else {
            O3OpenColumnJob.publishCopyTaskContended(cursor, columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataTop, srcDataLo, srcDataHi, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarOffsetEnd, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, tableWriter, indexWriter);
        }
    }

    private static void publishCopyTaskContended(long cursor, AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, int columnType, int blockType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataTop, long srcDataLo, long srcDataHi, long srcDataMax, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long timestampMax, long partitionTimestamp, long dstFixFd, long dstFixAddr, long dstFixOffset, long dstFixFileOffset, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarOffset, long dstVarOffsetEnd, long dstVarAdjust, long dstVarSize, long dstKFd, long dstVFd, long dstIndexOffset, long dstIndexAdjust, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, TableWriter tableWriter, BitmapIndexWriter indexWriter) {
        while (cursor == -2L) {
            cursor = tableWriter.getO3CopyPubSeq().next();
        }
        if (cursor == -1L) {
            O3CopyJob.copy(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarOffsetEnd, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, tableWriter, indexWriter);
        } else {
            O3OpenColumnJob.publishCopyTaskHarmonized(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarOffsetEnd, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, cursor, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, tableWriter, indexWriter);
        }
    }

    private static void publishCopyTaskHarmonized(AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, int columnType, int blockType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataLo, long srcDataHi, long srcDataTop, long srcDataMax, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long timestampMax, long partitionTimestamp, long dstFixFd, long dstFixAddr, long dstFixOffset, long dstFixFileOffset, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarOffset, long dstVarOffsetEnd, long dstVarAdjust, long dstVarSize, long dstKFd, long dstVFd, long dstIndexOffset, long dstIndexAdjust, int indexBlockCapacity, long cursor, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, TableWriter tableWriter, BitmapIndexWriter indexWriter) {
        O3CopyTask task = tableWriter.getO3CopyQueue().get(cursor);
        task.of(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarOffsetEnd, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, tableWriter, indexWriter);
        tableWriter.getO3CopyPubSeq().done(cursor);
    }

    private static void mergeLastPartition(Path pathToPartition, int pplen, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long oooPartitionMin, long oooPartitionMax, long oooPartitionHi, long srcDataTop, long srcDataMax, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, long mergeLen, int suffixType, long suffixLo, long suffixHi, int indexBlockCapacity, long activeFixFd, long activeVarFd, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long colTopSinkAddr, long columnNameTxn) {
        switch (ColumnType.tagOf(columnType)) {
            case 11: 
            case 18: {
                O3OpenColumnJob.mergeVarColumn(pathToPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionMax, oooPartitionHi, srcDataTop, srcDataMax, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, -activeFixFd, -activeVarFd, tableWriter, colTopSinkAddr, columnNameTxn);
                break;
            }
            default: {
                O3OpenColumnJob.mergeFixColumn(pathToPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionMax, oooPartitionHi, srcDataMax, srcDataTop, -activeFixFd, srcTimestampFd, srcTimestampAddr, srcTimestampSize, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, indexBlockCapacity, tableWriter, indexWriter, colTopSinkAddr, columnNameTxn);
            }
        }
    }

    private static void mergeMidPartition(Path pathToPartition, int plen, int pplen, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long oooPartitionMin, long oooPartitionMax, long oooPartitionHi, long srcDataTop, long srcDataMax, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, long mergeLen, int suffixType, long suffixLo, long suffixHi, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long colTopSinkAddr, long partitionTimestamp, int columnIndex, long columnNameTxn) {
        FilesFacade ff = tableWriter.getFilesFacade();
        if (srcDataTop == -1L) {
            try {
                srcDataTop = tableWriter.getColumnTop(partitionTimestamp, columnIndex, srcDataMax);
            }
            catch (Throwable e) {
                LOG.error().$("merge mid partition error 1 [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
                O3OpenColumnJob.freeTs(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
                throw e;
            }
        }
        long srcDataFixFd = 0L;
        long srcDataVarFd = 0L;
        switch (ColumnType.tagOf(columnType)) {
            case 11: 
            case 18: {
                try {
                    TableUtils.iFile(pathToPartition.trimTo(plen), columnName, columnNameTxn);
                    srcDataFixFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                    TableUtils.dFile(pathToPartition.trimTo(plen), columnName, columnNameTxn);
                    srcDataVarFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                }
                catch (Throwable e) {
                    LOG.error().$("merge mid partition error 2 [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
                    O3Utils.close(ff, srcDataFixFd);
                    O3Utils.close(ff, srcDataVarFd);
                    O3OpenColumnJob.freeTs(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
                    throw e;
                }
                O3OpenColumnJob.mergeVarColumn(pathToPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionMax, oooPartitionHi, srcDataTop, srcDataMax, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, srcDataFixFd, srcDataVarFd, tableWriter, colTopSinkAddr, columnNameTxn);
                break;
            }
            default: {
                try {
                    if (columnType < 0 && srcTimestampFd > 0L) {
                        srcDataFixFd = -srcTimestampFd;
                    } else {
                        TableUtils.dFile(pathToPartition.trimTo(plen), columnName, columnNameTxn);
                        srcDataFixFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                    }
                }
                catch (Throwable e) {
                    LOG.error().$("merge mid partition error 3 [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
                    O3OpenColumnJob.freeTs(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
                    throw e;
                }
                O3OpenColumnJob.mergeFixColumn(pathToPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionMax, oooPartitionHi, srcDataMax, srcDataTop, srcDataFixFd, srcTimestampFd, srcTimestampAddr, srcTimestampSize, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, indexBlockCapacity, tableWriter, indexWriter, colTopSinkAddr, columnNameTxn);
            }
        }
    }

    private static void freeTs(AtomicInteger columnCounter, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter, FilesFacade ff) {
        tableWriter.o3BumpErrorCount();
        if (columnCounter.decrementAndGet() == 0) {
            O3Utils.unmap(ff, srcTimestampAddr, srcTimestampSize);
            O3Utils.close(ff, srcTimestampFd);
            tableWriter.o3ClockDownPartitionUpdateCount();
            tableWriter.o3CountDownDoneLatch();
            if (timestampMergeIndexAddr != 0L) {
                Vect.freeMergedIndex(timestampMergeIndexAddr, timestampMergeIndexSize);
            }
        }
    }

    private static void mergeFixColumn(Path pathToPartition, int pplen, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long oooPartitionMin, long oooPartitionMax, long oooPartitionHi, long srcDataMax, long srcDataTop, long srcDataFixFd, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, long mergeLen, int suffixType, long suffixLo, long suffixHi, int indexBlockCapacity, TableWriter tableWriter, BitmapIndexWriter indexWriter, long colTopSinkAddr, long columnNameTxn) {
        long dstFixAppendOffset2;
        long dstFixAppendOffset1;
        long srcDataTopOffset;
        long srcDataFixOffset;
        int partCount = 0;
        long srcDataFixSize = 0L;
        long srcDataFixAddr = 0L;
        long dstFixFd = 0L;
        long dstFixAddr = 0L;
        long dstFixSize = 0L;
        long dstKFd = 0L;
        long dstVFd = 0L;
        long srcFixFd = Math.abs(srcDataFixFd);
        int shl = ColumnType.pow2SizeOf(Math.abs(columnType));
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            TableUtils.txnPartition(pathToPartition.trimTo(pplen), txn);
            int pDirNameLen = pathToPartition.length();
            if (srcDataTop > 0L) {
                long srcDataActualBytes = srcDataMax - srcDataTop << shl;
                long srcDataMaxBytes = srcDataMax << shl;
                if (srcDataTop > prefixHi || prefixType == 1) {
                    srcDataFixSize = srcDataActualBytes + srcDataMaxBytes;
                    srcDataFixAddr = TableUtils.mapRW(ff, srcFixFd, srcDataFixSize, 2);
                    TableUtils.setNull(columnType, srcDataFixAddr + srcDataActualBytes, srcDataTop);
                    Vect.memcpy(srcDataFixAddr + srcDataMaxBytes, srcDataFixAddr, srcDataActualBytes);
                    srcDataTop = 0L;
                    srcDataFixOffset = srcDataActualBytes;
                } else {
                    Unsafe.getUnsafe().putLong(colTopSinkAddr, srcDataTop);
                    srcDataFixSize = srcDataActualBytes;
                    srcDataFixAddr = TableUtils.mapRW(ff, srcFixFd, srcDataFixSize, 2);
                    srcDataFixOffset = 0L;
                }
            } else {
                srcDataFixSize = srcDataMax << shl;
                srcDataFixAddr = TableUtils.mapRW(ff, srcFixFd, srcDataFixSize, 2);
                srcDataFixOffset = 0L;
            }
            srcDataTopOffset = srcDataTop << shl;
            TableUtils.dFile(pathToPartition.trimTo(pDirNameLen), columnName, columnNameTxn);
            dstFixFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            dstFixSize = srcOooHi - srcOooLo + 1L + srcDataMax - srcDataTop << shl;
            dstFixAddr = TableUtils.mapRW(ff, dstFixFd, dstFixSize, 2);
            if (prefixType == 2) {
                dstFixAppendOffset1 = prefixHi - prefixLo + 1L - srcDataTop << shl;
                prefixHi -= srcDataTop;
            } else {
                dstFixAppendOffset1 = prefixHi - prefixLo + 1L << shl;
            }
            dstFixAppendOffset2 = mergeDataLo > -1L && mergeOOOLo > -1L ? dstFixAppendOffset1 + (mergeLen << shl) : dstFixAppendOffset1;
            if (suffixType == 2 && srcDataTop > 0L) {
                suffixHi -= srcDataTop;
                suffixLo -= srcDataTop;
            }
            if (indexBlockCapacity > -1) {
                BitmapIndexUtils.keyFileName(pathToPartition.trimTo(pDirNameLen), columnName, columnNameTxn);
                dstKFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                BitmapIndexUtils.valueFileName(pathToPartition.trimTo(pDirNameLen), columnName, columnNameTxn);
                dstVFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            }
            if (prefixType != -1) {
                ++partCount;
            }
            if (mergeType != -1) {
                ++partCount;
            }
            if (suffixType != -1) {
                ++partCount;
            }
        }
        catch (Throwable e) {
            LOG.error().$("merge fix error [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
            O3Utils.unmapAndClose(ff, srcDataFixFd, srcDataFixAddr, srcDataFixSize);
            O3Utils.unmapAndClose(ff, dstFixFd, dstFixAddr, dstFixSize);
            O3Utils.close(ff, dstKFd);
            O3Utils.close(ff, dstVFd);
            tableWriter.o3BumpErrorCount();
            if (columnCounter.decrementAndGet() == 0) {
                O3Utils.unmap(ff, srcTimestampAddr, srcTimestampSize);
                O3Utils.close(ff, srcTimestampFd);
                Vect.freeMergedIndex(timestampMergeIndexAddr, timestampMergeIndexSize);
                tableWriter.o3ClockDownPartitionUpdateCount();
                tableWriter.o3CountDownDoneLatch();
            }
            throw e;
        }
        partCounter.set(partCount);
        O3OpenColumnJob.publishMultiCopyTasks(columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, 0L, 0L, 0L, 0L, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionMax, oooPartitionHi, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, dstFixFd, dstFixAddr, dstFixSize, 0L, 0L, 0L, dstFixAppendOffset1, dstFixAppendOffset2, 0L, 0L, dstKFd, dstVFd, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, indexWriter);
    }

    private static void mergeVarColumn(Path pathToPartition, int pplen, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long oooPartitionMin, long oooPartitionMax, long oooPartitionHi, long srcDataTop, long srcDataMax, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, long mergeLen, int suffixType, long suffixLo, long suffixHi, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long srcDataFixFd, long srcDataVarFd, TableWriter tableWriter, long colTopSinkAddr, long columnNameTxn) {
        long dstVarAppendOffset2;
        long dstFixAppendOffset2;
        long dstFixAppendOffset1;
        long srcDataTopOffset;
        long srcDataFixOffset;
        int partCount = 0;
        long dstVarFd = 0L;
        long dstVarAddr = 0L;
        long srcDataFixAddr = 0L;
        long dstVarSize = 0L;
        long dstFixSize = 0L;
        long srcDataFixSize = 0L;
        long srcDataVarSize = 0L;
        long dstFixFd = 0L;
        long dstFixAddr = 0L;
        long srcDataVarAddr = 0L;
        long srcDataVarOffset = 0L;
        long dstVarAppendOffset1 = 0L;
        long srcFixFd = Math.abs(srcDataFixFd);
        long srcVarFd = Math.abs(srcDataVarFd);
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            TableUtils.txnPartition(pathToPartition.trimTo(pplen), txn);
            int pDirNameLen = pathToPartition.length();
            if (srcDataTop > 0L) {
                long srcDataActualBytes = (srcDataMax - srcDataTop) * 8L;
                long srcDataMaxBytes = srcDataMax * 8L;
                if (srcDataTop > prefixHi || prefixType == 1) {
                    srcDataFixSize = srcDataActualBytes + srcDataMaxBytes + 8L;
                    srcDataFixAddr = TableUtils.mapRW(ff, srcFixFd, srcDataFixSize, 2);
                    if (srcDataActualBytes > 0L) {
                        srcDataVarSize = Unsafe.getUnsafe().getLong(srcDataFixAddr + srcDataActualBytes);
                    }
                    srcDataVarOffset = srcDataVarSize;
                    if (ColumnType.isString(columnType)) {
                        long reservedBytesForColTopNulls = srcDataTop * 4L;
                        srcDataVarSize += reservedBytesForColTopNulls + srcDataVarSize;
                        srcDataVarAddr = TableUtils.mapRW(ff, srcVarFd, srcDataVarSize, 2);
                        Vect.memset(srcDataVarAddr + srcDataVarOffset, (int)reservedBytesForColTopNulls, -1);
                        Vect.memcpy(srcDataVarAddr + srcDataVarOffset + reservedBytesForColTopNulls, srcDataVarAddr, srcDataVarOffset);
                        long hiInclusive = srcDataMax - srcDataTop;
                        assert (srcDataFixSize >= srcDataMaxBytes + (hiInclusive + 1L) * 8L);
                        O3Utils.shiftCopyFixedSizeColumnData(-reservedBytesForColTopNulls, srcDataFixAddr, 0L, hiInclusive, srcDataFixAddr + srcDataMaxBytes);
                        Vect.setVarColumnRefs32Bit(srcDataFixAddr + srcDataActualBytes, 0L, srcDataTop);
                    } else {
                        long reservedBytesForColTopNulls = srcDataTop * 8L;
                        srcDataVarSize += reservedBytesForColTopNulls + srcDataVarSize;
                        srcDataVarAddr = TableUtils.mapRW(ff, srcVarFd, srcDataVarSize, 2);
                        Vect.memset(srcDataVarAddr + srcDataVarOffset, (int)reservedBytesForColTopNulls, -1);
                        Vect.memcpy(srcDataVarAddr + srcDataVarOffset + reservedBytesForColTopNulls, srcDataVarAddr, srcDataVarOffset);
                        long hiInclusive = srcDataMax - srcDataTop;
                        assert (srcDataFixSize >= srcDataMaxBytes + (hiInclusive + 1L) * 8L);
                        O3Utils.shiftCopyFixedSizeColumnData(-reservedBytesForColTopNulls, srcDataFixAddr, 0L, hiInclusive, srcDataFixAddr + srcDataMaxBytes);
                        Vect.setVarColumnRefs64Bit(srcDataFixAddr + srcDataActualBytes, 0L, srcDataTop);
                    }
                    srcDataTop = 0L;
                    srcDataFixOffset = srcDataActualBytes;
                } else {
                    Unsafe.getUnsafe().putLong(colTopSinkAddr, srcDataTop);
                    srcDataFixSize = srcDataActualBytes + 8L;
                    srcDataFixAddr = TableUtils.mapRW(ff, srcFixFd, srcDataFixSize, 2);
                    srcDataFixOffset = 0L;
                    srcDataVarSize = Unsafe.getUnsafe().getLong(srcDataFixAddr + srcDataFixSize - 8L);
                    srcDataVarAddr = TableUtils.mapRO(ff, srcVarFd, srcDataVarSize, 2);
                }
            } else {
                srcDataFixSize = (srcDataMax + 1L) * 8L;
                srcDataFixAddr = TableUtils.mapRW(ff, srcFixFd, srcDataFixSize, 2);
                srcDataFixOffset = 0L;
                srcDataVarSize = Unsafe.getUnsafe().getLong(srcDataFixAddr + srcDataFixSize - 8L);
                srcDataVarAddr = TableUtils.mapRO(ff, srcVarFd, srcDataVarSize, 2);
            }
            srcDataTopOffset = srcDataTop * 8L;
            TableUtils.iFile(pathToPartition.trimTo(pDirNameLen), columnName, columnNameTxn);
            dstFixFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            dstFixSize = (srcOooHi - srcOooLo + 1L + srcDataMax - srcDataTop + 1L) * 8L;
            dstFixAddr = TableUtils.mapRW(ff, dstFixFd, dstFixSize, 2);
            TableUtils.dFile(pathToPartition.trimTo(pDirNameLen), columnName, columnNameTxn);
            dstVarFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            dstVarSize = srcDataVarSize - srcDataVarOffset + O3Utils.getVarColumnLength(srcOooLo, srcOooHi, srcOooFixAddr);
            dstVarAddr = TableUtils.mapRW(ff, dstVarFd, dstVarSize, 2);
            if (prefixType == 2) {
                dstFixAppendOffset1 = (prefixHi - prefixLo + 1L - srcDataTop) * 8L;
                prefixHi -= srcDataTop;
            } else {
                dstFixAppendOffset1 = (prefixHi - prefixLo + 1L) * 8L;
            }
            if (suffixType == 2 && srcDataTop > 0L) {
                suffixHi -= srcDataTop;
                suffixLo -= srcDataTop;
            }
            switch (prefixType) {
                case 1: {
                    dstVarAppendOffset1 = O3Utils.getVarColumnLength(prefixLo, prefixHi, srcOooFixAddr);
                    ++partCount;
                    break;
                }
                case 2: {
                    dstVarAppendOffset1 = O3Utils.getVarColumnLength(prefixLo, prefixHi, srcDataFixAddr + srcDataFixOffset);
                    ++partCount;
                    break;
                }
            }
            if (mergeDataLo > -1L && mergeOOOLo > -1L) {
                long oooLen = O3Utils.getVarColumnLength(mergeOOOLo, mergeOOOHi, srcOooFixAddr);
                long dataLen = O3Utils.getVarColumnLength(mergeDataLo, mergeDataHi, srcDataFixAddr + srcDataFixOffset - srcDataTop * 8L);
                dstFixAppendOffset2 = dstFixAppendOffset1 + mergeLen * 8L;
                dstVarAppendOffset2 = dstVarAppendOffset1 + oooLen + dataLen;
            } else {
                dstFixAppendOffset2 = dstFixAppendOffset1;
                dstVarAppendOffset2 = dstVarAppendOffset1;
            }
            if (mergeType != -1) {
                ++partCount;
            }
            if (suffixType != -1) {
                ++partCount;
            }
        }
        catch (Throwable e) {
            LOG.error().$("merge var error [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
            tableWriter.o3BumpErrorCount();
            O3CopyJob.copyIdleQuick(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, 0L, 0L, tableWriter);
            throw e;
        }
        partCounter.set(partCount);
        O3OpenColumnJob.publishMultiCopyTasks(columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionMax, oooPartitionHi, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, dstFixAppendOffset1, dstFixAppendOffset2, dstVarAppendOffset1, dstVarAppendOffset2, 0L, 0L, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, null);
    }

    private static void appendNewPartition(Path pathToPartition, int plen, CharSequence columnName, AtomicInteger columnCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long timestampMax, long partitionTimestamp, long srcDataMax, int indexBlockCapacity, TableWriter tableWriter, BitmapIndexWriter indexWriter, long columnNameTxn) {
        long dstFixFd = 0L;
        long dstFixAddr = 0L;
        long dstFixSize = 0L;
        long dstVarFd = 0L;
        long dstVarAddr = 0L;
        long dstVarSize = 0L;
        long dstKFd = 0L;
        long dstVFd = 0L;
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            if (ColumnType.isVariableLength(columnType)) {
                TableUtils.iFile(pathToPartition.trimTo(plen), columnName, columnNameTxn);
                dstFixFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                dstFixSize = (srcOooHi - srcOooLo + 1L + 1L) * 8L;
                dstFixAddr = TableUtils.mapRW(ff, dstFixFd, dstFixSize, 2);
                TableUtils.dFile(pathToPartition.trimTo(plen), columnName, columnNameTxn);
                dstVarFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                dstVarSize = O3Utils.getVarColumnLength(srcOooLo, srcOooHi, srcOooFixAddr);
                dstVarAddr = TableUtils.mapRW(ff, dstVarFd, dstVarSize, 2);
            } else {
                TableUtils.dFile(pathToPartition.trimTo(plen), columnName, columnNameTxn);
                dstFixFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                dstFixSize = srcOooHi - srcOooLo + 1L << ColumnType.pow2SizeOf(Math.abs(columnType));
                dstFixAddr = TableUtils.mapRW(ff, dstFixFd, dstFixSize, 2);
                if (indexBlockCapacity > -1) {
                    BitmapIndexUtils.keyFileName(pathToPartition.trimTo(plen), columnName, columnNameTxn);
                    dstKFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                    BitmapIndexUtils.valueFileName(pathToPartition.trimTo(plen), columnName, columnNameTxn);
                    dstVFd = TableUtils.openRW(ff, pathToPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                }
            }
        }
        catch (Throwable e) {
            LOG.error().$("append new partition error [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
            tableWriter.o3BumpErrorCount();
            FilesFacade ff1 = tableWriter.getFilesFacade();
            O3Utils.unmapAndClose(ff1, dstFixFd, dstFixAddr, dstFixSize);
            O3Utils.unmapAndClose(ff1, dstVarFd, dstVarAddr, dstVarSize);
            O3Utils.close(ff1, dstKFd);
            O3Utils.close(ff1, dstVFd);
            if (columnCounter.decrementAndGet() == 0) {
                tableWriter.o3ClockDownPartitionUpdateCount();
                tableWriter.o3CountDownDoneLatch();
            }
            throw e;
        }
        O3OpenColumnJob.publishCopyTask(columnCounter, null, columnType, 1, timestampMergeIndexAddr, timestampMergeIndexSize, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, 0L, 0L, dstFixSize, dstVarFd, dstVarAddr, 0L, 0L, 0L, dstVarSize, dstKFd, dstVFd, 0L, 0L, indexBlockCapacity, 0L, 0L, 0L, false, tableWriter, indexWriter);
    }

    private static void publishMultiCopyTasks(AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataTopOffset, long srcDataMax, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long timestampMax, long partitionTimestamp, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeDataLo, long mergeDataHi, long mergeOOOLo, long mergeOOOHi, int suffixType, long suffixLo, long suffixHi, long dstFixFd, long dstFixAddr, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarSize, long dstFixAppendOffset1, long dstFixAppendOffset2, long dstVarAppendOffset1, long dstVarAppendOffset2, long dstKFd, long dstVFd, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter, BitmapIndexWriter indexWriter) {
        boolean partitionMutates = true;
        switch (prefixType) {
            case 1: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, prefixType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, 0L, 0L, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooVarAddr, prefixLo, prefixHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, 0L, 0L, dstFixSize, dstVarFd, dstVarAddr, 0L, 0L, 0L, dstVarSize, dstKFd, dstVFd, 0L, srcDataTopOffset >> 2, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, tableWriter, indexWriter);
                break;
            }
            case 2: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, prefixType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, prefixLo, prefixHi, srcDataTopOffset, srcDataMax, 0L, 0L, 0L, 0L, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, 0L, 0L, dstFixSize, dstVarFd, dstVarAddr, 0L, 0L, 0L, dstVarSize, dstKFd, dstVFd, 0L, srcDataTopOffset >> 2, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, tableWriter, indexWriter);
                break;
            }
        }
        switch (mergeType) {
            case 1: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, mergeType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, 0L, 0L, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooVarAddr, mergeOOOLo, mergeOOOHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixAppendOffset1, dstFixAppendOffset1, dstFixSize, dstVarFd, dstVarAddr, dstVarAppendOffset1, dstVarAppendOffset2, 0L, dstVarSize, dstKFd, dstVFd, 0L, srcDataTopOffset >> 2, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, tableWriter, indexWriter);
                break;
            }
            case 2: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, mergeType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, mergeDataLo, mergeDataHi, srcDataTopOffset, srcDataMax, 0L, 0L, 0L, 0L, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixAppendOffset1, dstFixAppendOffset1, dstFixSize, dstVarFd, dstVarAddr, dstVarAppendOffset1, dstVarAppendOffset2, 0L, dstVarSize, dstKFd, dstVFd, 0L, srcDataTopOffset >> 2, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, tableWriter, indexWriter);
                break;
            }
            case 3: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, mergeType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, mergeDataLo, mergeDataHi, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooVarAddr, mergeOOOLo, mergeOOOHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixAppendOffset1, dstFixAppendOffset1, dstFixSize, dstVarFd, dstVarAddr, dstVarAppendOffset1, dstVarAppendOffset2, 0L, dstVarSize, dstKFd, dstVFd, 0L, srcDataTopOffset >> 2, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, tableWriter, indexWriter);
                break;
            }
        }
        switch (suffixType) {
            case 1: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, suffixType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, 0L, 0L, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooVarAddr, suffixLo, suffixHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixAppendOffset2, dstFixAppendOffset2, dstFixSize, dstVarFd, dstVarAddr, dstVarAppendOffset2, 0L, 0L, dstVarSize, dstKFd, dstVFd, 0L, srcDataTopOffset >> 2, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, tableWriter, indexWriter);
                break;
            }
            case 2: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, suffixType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, suffixLo, suffixHi, srcDataTopOffset, srcDataMax, 0L, 0L, 0L, 0L, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixAppendOffset2, dstFixAppendOffset2, dstFixSize, dstVarFd, dstVarAddr, dstVarAppendOffset2, 0L, 0L, dstVarSize, dstKFd, dstVFd, 0L, srcDataTopOffset >> 2, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, tableWriter, indexWriter);
                break;
            }
        }
    }

    @Override
    protected boolean doRun(int workerId, long cursor) {
        O3OpenColumnJob.openColumn((O3OpenColumnTask)this.queue.get(cursor), cursor, this.subSeq);
        return true;
    }
}

