/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractDataFrameCursorFactory;
import io.questdb.cairo.IntervalBwdDataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.model.RuntimeIntrinsicIntervalModel;
import io.questdb.std.Misc;

public class IntervalBwdDataFrameCursorFactory
extends AbstractDataFrameCursorFactory {
    private final IntervalBwdDataFrameCursor cursor;
    private final RuntimeIntrinsicIntervalModel intervals;

    public IntervalBwdDataFrameCursorFactory(String tableName, int tableId, long tableVersion, RuntimeIntrinsicIntervalModel intervals, int timestampIndex) {
        super(tableName, tableId, tableVersion);
        this.cursor = new IntervalBwdDataFrameCursor(intervals, timestampIndex);
        this.intervals = intervals;
    }

    @Override
    public DataFrameCursor getCursor(SqlExecutionContext executionContext, int order) throws SqlException {
        if (order == 1 || order == 2) {
            this.cursor.of(this.getReader(executionContext), executionContext);
            return this.cursor;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public void close() {
        super.close();
        Misc.free(this.intervals);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("IntervalBwdDataFrame");
        super.toPlan(sink);
        sink.attr("intervals").val(this.intervals);
    }
}

