/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BaseRecordMetadata;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.ObjList;

public class GenericRecordMetadata
extends BaseRecordMetadata {
    public static final GenericRecordMetadata EMPTY = new GenericRecordMetadata();

    public GenericRecordMetadata() {
        this.columnMetadata = new ObjList();
        this.columnNameIndexMap = new LowerCaseCharSequenceIntHashMap();
        this.timestampIndex = -1;
    }

    public static void copyColumns(RecordMetadata from, GenericRecordMetadata to) {
        if (from instanceof BaseRecordMetadata) {
            BaseRecordMetadata gm = (BaseRecordMetadata)from;
            int n = gm.getColumnCount();
            for (int i = 0; i < n; ++i) {
                to.add(gm.getColumnQuick(i));
            }
        } else {
            int n = from.getColumnCount();
            for (int i = 0; i < n; ++i) {
                to.add(new TableColumnMetadata(from.getColumnName(i), from.getColumnHash(i), from.getColumnType(i), from.isColumnIndexed(i), from.getIndexValueBlockCapacity(i), from.isSymbolTableStatic(i), GenericRecordMetadata.copyOf(from.getMetadata(i))));
            }
        }
    }

    public static GenericRecordMetadata copyOf(RecordMetadata that) {
        if (that != null) {
            if (that instanceof GenericRecordMetadata) {
                return (GenericRecordMetadata)that;
            }
            GenericRecordMetadata metadata = GenericRecordMetadata.copyOfSansTimestamp(that);
            metadata.setTimestampIndex(that.getTimestampIndex());
            return metadata;
        }
        return null;
    }

    public static GenericRecordMetadata copyOfSansTimestamp(RecordMetadata that) {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        GenericRecordMetadata.copyColumns(that, metadata);
        return metadata;
    }

    public static RecordMetadata removeTimestamp(RecordMetadata that) {
        if (that.getTimestampIndex() != -1) {
            if (that instanceof GenericRecordMetadata) {
                ((GenericRecordMetadata)that).setTimestampIndex(-1);
                return that;
            }
            return GenericRecordMetadata.copyOfSansTimestamp(that);
        }
        return that;
    }

    public GenericRecordMetadata add(TableColumnMetadata meta) {
        return this.add(this.columnCount, meta);
    }

    public GenericRecordMetadata add(int i, TableColumnMetadata meta) {
        int index = this.columnNameIndexMap.keyIndex(meta.getName());
        if (index > -1) {
            this.columnNameIndexMap.putAt(index, meta.getName(), i);
            this.columnMetadata.extendAndSet(i, meta);
            ++this.columnCount;
            return this;
        }
        throw CairoException.duplicateColumn(meta.getName());
    }

    public void clear() {
        this.columnMetadata.clear();
        this.columnNameIndexMap.clear();
        this.columnCount = 0;
        this.timestampIndex = -1;
    }

    @Override
    public int getColumnIndexQuiet(CharSequence columnName, int lo, int hi) {
        int index = this.columnNameIndexMap.keyIndex(columnName, lo, hi);
        if (index < 0) {
            return this.columnNameIndexMap.valueAt(index);
        }
        return -1;
    }

    public void setTimestampIndex(int index) {
        this.timestampIndex = index;
    }
}

