/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractFullDataFrameCursor;
import io.questdb.cairo.sql.DataFrame;
import org.jetbrains.annotations.Nullable;

public class FullBwdDataFrameCursor
extends AbstractFullDataFrameCursor {
    @Override
    public DataFrame next() {
        while (this.partitionIndex > -1) {
            long hi = this.reader.openPartition(this.partitionIndex);
            if (hi < 1L) {
                --this.partitionIndex;
                continue;
            }
            this.frame.partitionIndex = this.partitionIndex--;
            this.frame.rowHi = hi;
            return this.frame;
        }
        return null;
    }

    @Override
    public void toTop() {
        this.partitionIndex = this.partitionHi - 1;
    }

    @Override
    @Nullable
    public DataFrame skipTo(long rowCount) {
        int partitionIndex;
        int partitionCount = this.getTableReader().getPartitionCount();
        if (partitionCount < 1) {
            return null;
        }
        long position = rowCount;
        long partitionRows = 0L;
        for (partitionIndex = partitionCount - 1; partitionIndex > -1; --partitionIndex) {
            partitionRows = this.getTableReader().openPartition(partitionIndex);
            if (partitionRows < 0L) continue;
            if (partitionRows > position) break;
            if (partitionIndex == 0) {
                position = -1L;
                break;
            }
            position -= partitionRows;
        }
        this.frame.partitionIndex = partitionIndex;
        this.frame.rowHi = position > -1L ? partitionRows - position : position;
        this.frame.rowLo = 0L;
        this.partitionIndex = partitionIndex - 1;
        return this.frame;
    }

    @Override
    public boolean supportsRandomAccess() {
        return true;
    }
}

