/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.MessageBusImpl;
import io.questdb.Metrics;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.IDGenerator;
import io.questdb.cairo.Sequencer;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableRegistry;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.WalReader;
import io.questdb.cairo.WalWriter;
import io.questdb.cairo.mig.EngineMigration;
import io.questdb.cairo.pool.PoolListener;
import io.questdb.cairo.pool.ReaderPool;
import io.questdb.cairo.pool.WalWriterSource;
import io.questdb.cairo.pool.WriterPool;
import io.questdb.cairo.pool.WriterSource;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.cairo.sql.ReaderOutOfDateException;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cutlass.text.TextImportExecutionContext;
import io.questdb.griffin.DatabaseSnapshotAgent;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.Job;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.Sequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import io.questdb.tasks.TelemetryTask;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CairoEngine
implements Closeable,
WriterSource,
WalWriterSource {
    public static final String BUSY_READER = "busyReader";
    private static final Log LOG = LogFactory.getLog(CairoEngine.class);
    private final WriterPool writerPool;
    private final ReaderPool readerPool;
    private final CairoConfiguration configuration;
    private final Metrics metrics;
    private final EngineMaintenanceJob engineMaintenanceJob;
    private final MessageBus messageBus;
    private final RingQueue<TelemetryTask> telemetryQueue;
    private final MPSequence telemetryPubSeq;
    private final SCSequence telemetrySubSeq;
    private final AtomicLong asyncCommandCorrelationId = new AtomicLong();
    private final IDGenerator tableIdGenerator;
    private final TableRegistry tableRegistry;
    private final TextImportExecutionContext textImportExecutionContext;

    public CairoEngine(CairoConfiguration configuration) {
        this(configuration, Metrics.disabled());
    }

    public CairoEngine(CairoConfiguration configuration, Metrics metrics) {
        this.configuration = configuration;
        this.textImportExecutionContext = new TextImportExecutionContext(configuration);
        this.metrics = metrics;
        this.tableRegistry = new TableRegistry(this);
        this.messageBus = new MessageBusImpl(configuration);
        this.writerPool = new WriterPool(configuration, this.messageBus, metrics);
        this.readerPool = new ReaderPool(configuration, this.messageBus);
        this.engineMaintenanceJob = new EngineMaintenanceJob(configuration);
        if (configuration.getTelemetryConfiguration().getEnabled()) {
            this.telemetryQueue = new RingQueue<TelemetryTask>(TelemetryTask::new, configuration.getTelemetryConfiguration().getQueueCapacity());
            this.telemetryPubSeq = new MPSequence(this.telemetryQueue.getCycle());
            this.telemetrySubSeq = new SCSequence();
            this.telemetryPubSeq.then(this.telemetrySubSeq).then(this.telemetryPubSeq);
        } else {
            this.telemetryQueue = null;
            this.telemetryPubSeq = null;
            this.telemetrySubSeq = null;
        }
        this.tableIdGenerator = new IDGenerator(configuration, "_tab_index.d");
        try {
            this.tableIdGenerator.open();
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        try {
            DatabaseSnapshotAgent.recoverSnapshot(this);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        try {
            EngineMigration.migrateEngineTo(this, 426, false);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    public boolean clear() {
        this.tableRegistry.clear();
        boolean b1 = this.readerPool.releaseAll();
        boolean b2 = this.writerPool.releaseAll();
        return b1 & b2;
    }

    @Override
    public void close() {
        Misc.free(this.writerPool);
        Misc.free(this.readerPool);
        Misc.free(this.tableIdGenerator);
        Misc.free(this.messageBus);
        this.tableRegistry.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(CairoSecurityContext securityContext, MemoryMARW mem, Path path, TableStructure struct) {
        this.checkTableName(struct.getTableName());
        CharSequence lockedReason = this.lock(securityContext, struct.getTableName(), "createTable");
        if (null == lockedReason) {
            boolean newTable = false;
            try {
                if (this.getStatus(securityContext, path, struct.getTableName()) != 1) {
                    throw EntryUnavailableException.instance("table exists");
                }
                this.createTableUnsafe(securityContext, mem, path, struct);
                newTable = true;
            }
            finally {
                this.unlock(securityContext, struct.getTableName(), null, newTable);
            }
        } else {
            throw EntryUnavailableException.instance(lockedReason);
        }
    }

    public void createTableUnsafe(CairoSecurityContext securityContext, MemoryMARW mem, Path path, TableStructure struct) {
        securityContext.checkWritePermission();
        this.tableRegistry.registerTable(struct);
        TableUtils.createTable(this.configuration, mem, path, struct, (int)this.tableIdGenerator.getNextId());
    }

    public TableWriter getBackupWriter(CairoSecurityContext securityContext, CharSequence tableName, CharSequence backupDirName) {
        securityContext.checkWritePermission();
        return new TableWriter(this.configuration, tableName, this.messageBus, null, true, DefaultLifecycleManager.INSTANCE, backupDirName, Metrics.disabled());
    }

    public int getBusyReaderCount() {
        return this.readerPool.getBusyCount();
    }

    public Map<CharSequence, ReaderPool.Entry> getReaderPoolEntries() {
        return this.readerPool.entries();
    }

    public int getBusyWriterCount() {
        return this.writerPool.getBusyCount();
    }

    public long getCommandCorrelationId() {
        return this.asyncCommandCorrelationId.incrementAndGet();
    }

    public CairoConfiguration getConfiguration() {
        return this.configuration;
    }

    public Job getEngineMaintenanceJob() {
        return this.engineMaintenanceJob;
    }

    public MessageBus getMessageBus() {
        return this.messageBus;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public PoolListener getPoolListener() {
        return this.writerPool.getPoolListener();
    }

    public IDGenerator getTableIdGenerator() {
        return this.tableIdGenerator;
    }

    public void setPoolListener(PoolListener poolListener) {
        this.writerPool.setPoolListener(poolListener);
        this.readerPool.setPoolListener(poolListener);
    }

    public TableReader getReader(CairoSecurityContext securityContext, CharSequence tableName) {
        return this.getReader(securityContext, tableName, -1, -1L);
    }

    public TableReader getReader(CairoSecurityContext securityContext, CharSequence tableName, int tableId, long version) {
        this.checkTableName(tableName);
        TableReader reader = this.readerPool.get(tableName);
        if (version > -1L && reader.getVersion() != version || tableId > -1 && reader.getMetadata().getId() != tableId) {
            ReaderOutOfDateException ex = ReaderOutOfDateException.of(tableName, tableId, reader.getMetadata().getId(), version, reader.getVersion());
            reader.close();
            throw ex;
        }
        return reader;
    }

    public WalReader getWalReader(CairoSecurityContext securityContext, CharSequence tableName, CharSequence walName, int segmentId, long walRowCount) {
        return new WalReader(this.configuration, tableName, walName, segmentId, walRowCount);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TableReader getReaderForStatement(SqlExecutionContext executionContext, CharSequence tableName, CharSequence statement) {
        this.checkTableName(tableName);
        try {
            return this.getReader(executionContext.getCairoSecurityContext(), tableName);
        }
        catch (CairoException ex) {
            LOG.critical().$("error opening reader for ").$(statement).$(" statement [table=").$(tableName).$(",errno=").$(ex.getErrno()).$(",error=").$(ex.getMessage()).I$();
            try (TableWriter ignored = this.getWriter(executionContext.getCairoSecurityContext(), tableName, statement + " statement");){
                TableReader tableReader = this.getReader(executionContext.getCairoSecurityContext(), tableName);
                return tableReader;
            }
            catch (EntryUnavailableException wrOpEx) {
                throw ex;
            }
            catch (Throwable th) {
                LOG.error().$("error preliminary opening writer for ").$(statement).$(" statement [table=").$(tableName).$(",error=").$(ex.getMessage()).I$();
                throw ex;
            }
        }
    }

    public int getStatus(CairoSecurityContext securityContext, Path path, CharSequence tableName, int lo, int hi) {
        return TableUtils.exists(this.configuration.getFilesFacade(), path, this.configuration.getRoot(), tableName, lo, hi);
    }

    public int getStatus(CairoSecurityContext securityContext, Path path, CharSequence tableName) {
        return this.getStatus(securityContext, path, tableName, 0, tableName.length());
    }

    public Sequence getTelemetryPubSequence() {
        return this.telemetryPubSeq;
    }

    public RingQueue<TelemetryTask> getTelemetryQueue() {
        return this.telemetryQueue;
    }

    public SCSequence getTelemetrySubSequence() {
        return this.telemetrySubSeq;
    }

    @Override
    public TableWriter getWriter(CairoSecurityContext securityContext, CharSequence tableName, CharSequence lockReason) {
        securityContext.checkWritePermission();
        this.checkTableName(tableName);
        return this.writerPool.get(tableName, lockReason);
    }

    public TableWriter getWriterOrPublishCommand(CairoSecurityContext securityContext, CharSequence tableName, @NotNull AsyncWriterCommand asyncWriterCommand) {
        securityContext.checkWritePermission();
        this.checkTableName(tableName);
        return this.writerPool.getWriterOrPublishCommand(tableName, asyncWriterCommand.getCommandName(), asyncWriterCommand);
    }

    @Override
    public WalWriter getWalWriter(CairoSecurityContext securityContext, CharSequence tableName) {
        securityContext.checkWritePermission();
        Sequencer sequencer = this.tableRegistry.getSequencer(tableName);
        return sequencer.createWal();
    }

    public CharSequence lock(CairoSecurityContext securityContext, CharSequence tableName, CharSequence lockReason) {
        assert (null != lockReason);
        securityContext.checkWritePermission();
        this.checkTableName(tableName);
        CharSequence lockedReason = this.writerPool.lock(tableName, lockReason);
        if (lockedReason == WriterPool.OWNERSHIP_REASON_NONE) {
            boolean locked = this.readerPool.lock(tableName);
            if (locked) {
                LOG.info().$("locked [table=`").utf8(tableName).$("`, thread=").$(Thread.currentThread().getId()).$(']').$();
                return null;
            }
            this.writerPool.unlock(tableName);
            return BUSY_READER;
        }
        return lockedReason;
    }

    public boolean lockReaders(CharSequence tableName) {
        this.checkTableName(tableName);
        return this.readerPool.lock(tableName);
    }

    public CharSequence lockWriter(CairoSecurityContext securityContext, CharSequence tableName, CharSequence lockReason) {
        securityContext.checkWritePermission();
        this.checkTableName(tableName);
        return this.writerPool.lock(tableName, lockReason);
    }

    public boolean releaseAllReaders() {
        return this.readerPool.releaseAll();
    }

    public void releaseAllWriters() {
        this.writerPool.releaseAll();
    }

    public boolean releaseInactive() {
        boolean useful = this.writerPool.releaseInactive();
        return useful |= this.readerPool.releaseInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CairoSecurityContext securityContext, Path path, CharSequence tableName) {
        securityContext.checkWritePermission();
        this.checkTableName(tableName);
        CharSequence lockedReason = this.lock(securityContext, tableName, "removeTable");
        if (null == lockedReason) {
            try {
                path.of(this.configuration.getRoot()).concat(tableName).$();
                int errno = this.configuration.getFilesFacade().rmdir(path);
                if (errno != 0) {
                    LOG.error().$("remove failed [tableName='").utf8(tableName).$("', error=").$(errno).$(']').$();
                    throw CairoException.critical(errno).put("Table remove failed");
                }
                return;
            }
            finally {
                this.unlock(securityContext, tableName, null, false);
            }
        }
        throw CairoException.nonCritical().put("Could not lock '").put(tableName).put("' [reason='").put(lockedReason).put("']");
    }

    public int removeDirectory(Path path, CharSequence dir) {
        path.of(this.configuration.getRoot()).concat(dir);
        FilesFacade ff = this.configuration.getFilesFacade();
        return ff.rmdir(path.slash$());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(CairoSecurityContext securityContext, Path path, CharSequence tableName, Path otherPath, CharSequence newName) {
        securityContext.checkWritePermission();
        this.checkTableName(tableName);
        this.checkTableName(newName);
        CharSequence lockedReason = this.lock(securityContext, tableName, "renameTable");
        if (null == lockedReason) {
            try {
                this.rename0(path, tableName, otherPath, newName);
            }
            finally {
                this.unlock(securityContext, tableName, null, false);
            }
        } else {
            LOG.error().$("cannot lock and rename [from='").$(tableName).$("', to='").$(newName).$("', reason='").$(lockedReason).$("']").$();
            throw EntryUnavailableException.instance(lockedReason);
        }
    }

    public void unlock(CairoSecurityContext securityContext, CharSequence tableName, @Nullable TableWriter writer, boolean newTable) {
        this.checkTableName(tableName);
        this.readerPool.unlock(tableName);
        this.writerPool.unlock(tableName, writer, newTable);
        LOG.info().$("unlocked [table=`").utf8(tableName).$("`]").$();
    }

    public void unlockReaders(CharSequence tableName) {
        this.checkTableName(tableName);
        this.readerPool.unlock(tableName);
    }

    public void unlockWriter(CairoSecurityContext securityContext, CharSequence tableName) {
        securityContext.checkWritePermission();
        this.checkTableName(tableName);
        this.writerPool.unlock(tableName);
    }

    public TextImportExecutionContext getTextImportExecutionContext() {
        return this.textImportExecutionContext;
    }

    private void checkTableName(CharSequence tableName) {
        if (!TableUtils.isValidTableName(tableName, this.configuration.getMaxFileNameLength())) {
            throw CairoException.nonCritical().put("invalid table name [table=").putAsPrintable(tableName).put(']');
        }
    }

    private void rename0(Path path, CharSequence tableName, Path otherPath, CharSequence to) {
        CharSequence root;
        FilesFacade ff = this.configuration.getFilesFacade();
        if (TableUtils.exists(ff, path, root = this.configuration.getRoot(), tableName) != 0) {
            LOG.error().$('\'').utf8(tableName).$("' does not exist. Rename failed.").$();
            throw CairoException.nonCritical().put("Rename failed. Table '").put(tableName).put("' does not exist");
        }
        path.of(root).concat(tableName).$();
        otherPath.of(root).concat(to).$();
        if (ff.exists(otherPath)) {
            LOG.error().$("rename target exists [from='").$(tableName).$("', to='").$(otherPath).$("']").$();
            throw CairoException.nonCritical().put("Rename target exists");
        }
        if (ff.rename(path, otherPath) != 0) {
            int error = ff.errno();
            LOG.error().$("rename failed [from='").$(path).$("', to='").$(otherPath).$("', error=").$(error).$(']').$();
            throw CairoException.critical(error).put("Rename failed");
        }
    }

    private class EngineMaintenanceJob
    extends SynchronizedJob {
        private final MicrosecondClock clock;
        private final long checkInterval;
        private long last = 0L;

        public EngineMaintenanceJob(CairoConfiguration configuration) {
            this.clock = configuration.getMicrosecondClock();
            this.checkInterval = configuration.getIdleCheckInterval() * 1000L;
        }

        @Override
        protected boolean runSerially() {
            long t = this.clock.getTicks();
            if (this.last + this.checkInterval < t) {
                this.last = t;
                return CairoEngine.this.releaseInactive();
            }
            return false;
        }
    }
}

