/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Chars;
import io.questdb.std.str.CharSink;

public abstract class AbstractDataFrameCursorFactory
implements DataFrameCursorFactory {
    private final String tableName;
    private final int tableId;
    private final long tableVersion;

    public AbstractDataFrameCursorFactory(String tableName, int tableId, long tableVersion) {
        this.tableName = tableName;
        this.tableId = tableId;
        this.tableVersion = tableVersion;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("{\"name\":\"").put(this.getClass().getSimpleName()).put("\", \"table\":\"").put(this.tableName).put("\"}");
    }

    protected TableReader getReader(SqlExecutionContext executionContext) throws SqlException {
        return executionContext.getCairoEngine().getReader(executionContext.getCairoSecurityContext(), this.tableName, this.tableId, this.tableVersion);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean supportTableRowId(CharSequence tableName) {
        return Chars.equalsIgnoreCaseNc(tableName, this.tableName);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.attr("tableName").val(this.tableName);
    }
}

