/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.BuildInformation;
import io.questdb.BuildInformationHolder;
import io.questdb.Metrics;
import io.questdb.PropServerConfiguration;
import io.questdb.ServerConfigurationException;
import io.questdb.ShutdownFlag;
import io.questdb.TelemetryJob;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ColumnIndexerJob;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.TableUtils;
import io.questdb.cutlass.http.HttpServer;
import io.questdb.cutlass.json.JsonException;
import io.questdb.cutlass.line.tcp.LineTcpReceiver;
import io.questdb.cutlass.line.udp.LineUdpReceiver;
import io.questdb.cutlass.line.udp.LinuxMMLineUdpReceiver;
import io.questdb.cutlass.pgwire.PGWireServer;
import io.questdb.cutlass.text.TextImportJob;
import io.questdb.cutlass.text.TextImportRequestJob;
import io.questdb.griffin.DatabaseSnapshotAgent;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.engine.groupby.vect.GroupByJob;
import io.questdb.griffin.engine.table.AsyncFilterAtom;
import io.questdb.griffin.engine.table.LatestByAllIndexedJob;
import io.questdb.jit.JitUtil;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.mp.WorkerPool;
import io.questdb.network.NetworkError;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.datetime.millitime.Dates;
import io.questdb.std.str.NativeLPSZ;
import io.questdb.std.str.Path;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sun.misc.Signal;

public class ServerMain {
    private static final String VERSION_TXT = "version.txt";
    private static final String PUBLIC_ZIP = "/io/questdb/site/public.zip";
    protected PropServerConfiguration configuration;

    public ServerMain(String[] args) throws Exception {
        BuildInformationHolder buildInformation = BuildInformationHolder.INSTANCE;
        System.err.printf("QuestDB server %s%nCopyright (C) 2014-%d, all rights reserved.%n%n", buildInformation.getQuestDbVersion(), Dates.getYear(System.currentTimeMillis()));
        if (args.length < 1) {
            System.err.println("Root directory name expected");
            return;
        }
        if (Os.type == -2) {
            System.err.println("QuestDB requires 64-bit JVM");
            return;
        }
        CharSequenceObjHashMap<String> optHash = ServerMain.hashArgs(args);
        String rootDirectory = optHash.get("-d");
        LogFactory.configureFromSystemProperties(LogFactory.INSTANCE, null, rootDirectory);
        Log log = LogFactory.getLog("server-main");
        log.advisoryW().$("QuestDB server ").$(buildInformation.getQuestDbVersion()).$(". Copyright (C) 2014-").$(Dates.getYear(System.currentTimeMillis())).$(", all rights reserved.").$();
        ServerMain.extractSite(buildInformation, rootDirectory, log);
        Properties properties = new Properties();
        String configurationFileName = "/server.conf";
        File configurationFile = new File(new File(rootDirectory, "conf"), "/server.conf");
        try (FileInputStream is = new FileInputStream(configurationFile);){
            properties.load(is);
        }
        log.advisoryW().$("Server config: ").$(configurationFile.getAbsoluteFile()).$();
        try {
            this.readServerConfiguration(rootDirectory, properties, log, buildInformation);
        }
        catch (ServerConfigurationException sce) {
            log.errorW().$(sce.getMessage()).$();
            throw sce;
        }
        CairoConfiguration cairoConfiguration = this.configuration.getCairoConfiguration();
        boolean httpEnabled = this.configuration.getHttpServerConfiguration().isEnabled();
        boolean httpReadOnly = this.configuration.getHttpServerConfiguration().getHttpContextConfiguration().readOnlySecurityContext();
        String httpReadOnlyHint = httpEnabled && httpReadOnly ? " [read-only]" : "";
        boolean pgEnabled = this.configuration.getPGWireConfiguration().isEnabled();
        boolean pgReadOnly = this.configuration.getPGWireConfiguration().readOnlySecurityContext();
        String pgReadOnlyHint = pgEnabled && pgReadOnly ? " [read-only]" : "";
        log.advisoryW().$("Config changes applied:").$();
        log.advisoryW().$("  http.enabled : ").$(httpEnabled).$(httpReadOnlyHint).$();
        log.advisoryW().$("  tcp.enabled  : ").$(this.configuration.getLineTcpReceiverConfiguration().isEnabled()).$();
        log.advisoryW().$("  pg.enabled   : ").$(pgEnabled).$(pgReadOnlyHint).$();
        log.advisoryW().$("open database [id=").$(cairoConfiguration.getDatabaseIdLo()).$('.').$(cairoConfiguration.getDatabaseIdHi()).$(']').$();
        log.advisoryW().$("platform [bit=").$(System.getProperty("sun.arch.data.model")).$(']').$();
        switch (Os.type) {
            case 3: {
                log.advisoryW().$("OS/Arch: windows/amd64").$(Vect.getSupportedInstructionSetName()).$();
                break;
            }
            case 2: {
                log.advisoryW().$("OS/Arch: linux/amd64").$(Vect.getSupportedInstructionSetName()).$();
                break;
            }
            case 1: {
                log.advisoryW().$("OS/Arch: apple/amd64").$(Vect.getSupportedInstructionSetName()).$();
                break;
            }
            case 6: {
                log.advisoryW().$("OS/Arch: apple/apple-silicon").$();
                break;
            }
            case 4: {
                log.advisoryW().$("OS/Arch: linux/arm64").$(Vect.getSupportedInstructionSetName()).$();
                break;
            }
            case 5: {
                log.advisoryW().$("OS: freebsd/amd64").$(Vect.getSupportedInstructionSetName()).$();
                break;
            }
            default: {
                log.criticalW().$("Unsupported OS").$(Vect.getSupportedInstructionSetName()).$();
            }
        }
        log.advisoryW().$("available CPUs: ").$(Runtime.getRuntime().availableProcessors()).$();
        log.advisoryW().$("db root: ").$(cairoConfiguration.getRoot()).$();
        log.advisoryW().$("backup root: ").$(cairoConfiguration.getBackupRoot()).$();
        try (Path path = new Path();){
            ServerMain.verifyFileSystem("db", cairoConfiguration.getRoot(), path, log);
            ServerMain.verifyFileSystem("backup", cairoConfiguration.getBackupRoot(), path, log);
            ServerMain.verifyFileOpts(cairoConfiguration, path);
        }
        if (JitUtil.isJitSupported()) {
            int jitMode = this.configuration.getCairoConfiguration().getSqlJitMode();
            switch (jitMode) {
                case 0: {
                    log.advisoryW().$("SQL JIT compiler mode: on").$();
                    break;
                }
                case 1: {
                    log.advisoryW().$("SQL JIT compiler mode: scalar").$();
                    break;
                }
                case 2: {
                    log.advisoryW().$("SQL JIT compiler mode: off").$();
                    break;
                }
                default: {
                    log.errorW().$("Unknown SQL JIT compiler mode: ").$(jitMode).$();
                }
            }
        }
        Metrics metrics = this.configuration.getMetricsConfiguration().isEnabled() ? Metrics.enabled() : Metrics.disabled();
        ServerMain.reportCrashFiles(this.configuration.getCairoConfiguration(), log);
        WorkerPool workerPool = new WorkerPool(this.configuration.getWorkerPoolConfiguration(), metrics);
        FunctionFactoryCache functionFactoryCache = new FunctionFactoryCache(this.configuration.getCairoConfiguration(), ServiceLoader.load(FunctionFactory.class, FunctionFactory.class.getClassLoader()));
        ObjList<Closeable> instancesToClean = new ObjList<Closeable>();
        CairoEngine cairoEngine = new CairoEngine(this.configuration.getCairoConfiguration(), metrics);
        workerPool.assign(cairoEngine.getEngineMaintenanceJob());
        instancesToClean.add(cairoEngine);
        DatabaseSnapshotAgent snapshotAgent = new DatabaseSnapshotAgent(cairoEngine);
        instancesToClean.add(snapshotAgent);
        if (!this.configuration.getCairoConfiguration().getTelemetryConfiguration().getDisableCompletely()) {
            TelemetryJob telemetryJob = new TelemetryJob(cairoEngine, functionFactoryCache);
            instancesToClean.add(telemetryJob);
            if (this.configuration.getCairoConfiguration().getTelemetryConfiguration().getEnabled()) {
                workerPool.assign(telemetryJob);
            }
        }
        workerPool.assignCleaner(Path.CLEANER);
        O3Utils.setupWorkerPool(workerPool, cairoEngine, this.configuration.getCairoConfiguration().getCircuitBreakerConfiguration(), functionFactoryCache);
        try {
            this.initQuestDb(workerPool, cairoEngine, log);
            workerPool.assign(new ColumnIndexerJob(cairoEngine.getMessageBus()));
            workerPool.assign(new GroupByJob(cairoEngine.getMessageBus()));
            workerPool.assign(new LatestByAllIndexedJob(cairoEngine.getMessageBus()));
            TextImportJob.assignToPool(cairoEngine.getMessageBus(), workerPool);
            if (this.configuration.getCairoConfiguration().getSqlCopyInputRoot() != null) {
                TextImportRequestJob textImportRequestJob = new TextImportRequestJob(cairoEngine, Math.max(1, workerPool.getWorkerCount() - 2), functionFactoryCache);
                workerPool.assign(textImportRequestJob);
                workerPool.freeOnHalt(textImportRequestJob);
            }
            instancesToClean.add(this.createHttpServer(workerPool, log, cairoEngine, functionFactoryCache, snapshotAgent, metrics));
            instancesToClean.add(this.createMinHttpServer(workerPool, log, cairoEngine, functionFactoryCache, snapshotAgent, metrics));
            if (this.configuration.getPGWireConfiguration().isEnabled()) {
                instancesToClean.add(PGWireServer.create(this.configuration.getPGWireConfiguration(), workerPool, log, cairoEngine, functionFactoryCache, snapshotAgent, metrics));
            }
            if (this.configuration.getLineUdpReceiverConfiguration().isEnabled()) {
                if (Os.type == 2 || Os.type == 4) {
                    instancesToClean.add(new LinuxMMLineUdpReceiver(this.configuration.getLineUdpReceiverConfiguration(), cairoEngine, workerPool));
                } else {
                    instancesToClean.add(new LineUdpReceiver(this.configuration.getLineUdpReceiverConfiguration(), cairoEngine, workerPool));
                }
            }
            instancesToClean.add(LineTcpReceiver.create(this.configuration.getLineTcpReceiverConfiguration(), workerPool, log, cairoEngine, metrics));
            this.startQuestDb(workerPool, cairoEngine, log);
            if (this.configuration.getHttpServerConfiguration().isEnabled()) {
                ServerMain.logWebConsoleUrls(log, this.configuration);
            }
            System.gc();
            log.advisoryW().$("enjoy").$();
            if (Os.type != 3 && optHash.get("-n") == null) {
                Signal.handle(new Signal("HUP"), signal -> {});
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                System.err.println(new Date() + " QuestDB is shutting down");
                System.err.println("Pre-touch magic number: " + AsyncFilterAtom.PRE_TOUCH_BLACKHOLE.sum());
                ServerMain.shutdownQuestDb(workerPool, instancesToClean);
                System.err.println(new Date() + " QuestDB is down");
                LogFactory.INSTANCE.flushJobsAndClose();
            }));
        }
        catch (NetworkError e) {
            log.error().$(e).$();
            LogFactory.INSTANCE.flushJobsAndClose();
            System.exit(55);
        }
    }

    public static void deleteOrException(File file) {
        if (!file.exists()) {
            return;
        }
        ServerMain.deleteDirContentsOrException(file);
        boolean deleted = false;
        for (int retryCount = 3; retryCount > 0 && !(deleted = file.delete()); --retryCount) {
            Thread.yield();
        }
        if (!deleted) {
            throw new RuntimeException("Cannot delete file " + file);
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            new ServerMain(args);
        }
        catch (ServerConfigurationException sce) {
            System.err.println(sce.getMessage());
            LogFactory.INSTANCE.flushJobsAndClose();
            System.exit(1);
        }
    }

    static void reportCrashFiles(CairoConfiguration configuration, Log log) {
        CharSequence dbRoot = configuration.getRoot();
        FilesFacade ff = configuration.getFilesFacade();
        int maxFiles = configuration.getMaxCrashFiles();
        NativeLPSZ name = new NativeLPSZ();
        try (Path path = new Path().of(dbRoot).slash$();
             Path other = new Path().of(dbRoot).slash$();){
            int plen = path.length();
            AtomicInteger counter = new AtomicInteger(0);
            FilesFacadeImpl.INSTANCE.iterateDir(path, (pUtf8NameZ, type) -> {
                if (Files.notDots(pUtf8NameZ)) {
                    name.of(pUtf8NameZ);
                    if (Chars.startsWith((CharSequence)name, configuration.getOGCrashFilePrefix()) && type == 8) {
                        path.trimTo(plen).concat(pUtf8NameZ).$();
                        boolean shouldRename = false;
                        do {
                            other.trimTo(plen).concat(configuration.getArchivedCrashFilePrefix()).put(counter.getAndIncrement()).put(".log").$();
                            if (ff.exists(other)) continue;
                            shouldRename = counter.get() <= maxFiles;
                            break;
                        } while (counter.get() < maxFiles);
                        if (shouldRename && ff.rename(path, other) == 0) {
                            log.criticalW().$("found crash file [path=").$(other).I$();
                        } else {
                            log.criticalW().$("could not rename crash file [path=").$(path).$(", errno=").$(ff.errno()).$(", index=").$(counter.get()).$(", max=").$(maxFiles).I$();
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void verifyFileOpts(CairoConfiguration cairoConfiguration, Path path) {
        FilesFacade ff;
        block6: {
            ff = cairoConfiguration.getFilesFacade();
            path.of(cairoConfiguration.getRoot()).concat("_verify_").put(cairoConfiguration.getRandom().nextPositiveInt()).put(".d");
            long fd = ff.openRW(path.$(), cairoConfiguration.getWriterFileOpenOpts());
            try {
                if (fd <= -1L) break block6;
                long mem = Unsafe.malloc(8L, 1);
                try {
                    TableUtils.writeLongOrFail(ff, fd, 0L, 123456789L, mem, path);
                }
                finally {
                    Unsafe.free(mem, 8L, 1);
                }
            }
            finally {
                ff.close(fd);
            }
        }
        ff.remove(path);
    }

    private static void logWebConsoleUrls(Log log, PropServerConfiguration configuration) throws SocketException {
        LogRecord record = log.infoW().$("web console URL(s):").$('\n').$('\n');
        int httpBindIP = configuration.getHttpServerConfiguration().getDispatcherConfiguration().getBindIPv4Address();
        int httpBindPort = configuration.getHttpServerConfiguration().getDispatcherConfiguration().getBindPort();
        if (httpBindIP == 0) {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface networkInterface : Collections.list(nets)) {
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    record.$('\t').$("http:/").$(inetAddress).$(':').$(httpBindPort).$('\n');
                }
            }
            record.$('\n').$();
        } else {
            record.$('\t').$("http://").$ip(httpBindIP).$(':').$(httpBindPort).$('\n').$();
        }
    }

    private static CharSequenceObjHashMap<String> hashArgs(String[] args) {
        CharSequenceObjHashMap<String> optHash = new CharSequenceObjHashMap<String>();
        String flag = null;
        for (String s : args) {
            if (s.startsWith("-")) {
                if (flag != null) {
                    optHash.put(flag, "");
                }
                flag = s;
                continue;
            }
            if (flag != null) {
                optHash.put(flag, s);
                flag = null;
                continue;
            }
            System.err.println("Unknown arg: " + s);
            System.exit(55);
        }
        if (flag != null) {
            optHash.put(flag, "");
        }
        return optHash;
    }

    private static String getPublicVersion(String publicDir) throws IOException {
        File f = new File(publicDir, VERSION_TXT);
        if (f.exists()) {
            try (FileInputStream fis = new FileInputStream(f);){
                byte[] buf = new byte[128];
                int len = fis.read(buf);
                String string = new String(buf, 0, len);
                return string;
            }
        }
        return null;
    }

    private static void setPublicVersion(String publicDir, String version) throws IOException {
        File f = new File(publicDir, VERSION_TXT);
        File publicFolder = f.getParentFile();
        if (!publicFolder.exists()) {
            publicFolder.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(f);){
            byte[] buf = version.getBytes();
            fos.write(buf, 0, buf.length);
        }
    }

    static void extractSite(BuildInformation buildInformation, String dir, Log log) throws IOException {
        String publicZip = PUBLIC_ZIP;
        String publicDir = dir + "/public";
        byte[] buffer = new byte[0x100000];
        URL resource = ServerMain.class.getResource(PUBLIC_ZIP);
        long thisVersion = Long.MIN_VALUE;
        if (resource == null) {
            log.errorW().$("did not find Web Console build at '").$(PUBLIC_ZIP).$("'. Proceeding without Web Console checks").$();
        } else {
            thisVersion = resource.openConnection().getLastModified();
        }
        boolean extracted = false;
        String oldVersionStr = ServerMain.getPublicVersion(publicDir);
        CharSequence dbVersion = buildInformation.getQuestDbVersion();
        if (oldVersionStr == null) {
            if (thisVersion != 0L) {
                ServerMain.extractSite0(dir, log, publicDir, buffer, Long.toString(thisVersion));
            } else {
                ServerMain.extractSite0(dir, log, publicDir, buffer, Chars.toString(dbVersion));
            }
            extracted = true;
        } else if (thisVersion == 0L) {
            if (!Chars.equals((CharSequence)oldVersionStr, dbVersion)) {
                ServerMain.extractSite0(dir, log, publicDir, buffer, Chars.toString(dbVersion));
                extracted = true;
            }
        } else {
            try {
                long oldVersion = Numbers.parseLong(oldVersionStr);
                if (thisVersion > oldVersion) {
                    ServerMain.extractSite0(dir, log, publicDir, buffer, Long.toString(thisVersion));
                    extracted = true;
                }
            }
            catch (NumericException e) {
                ServerMain.extractSite0(dir, log, publicDir, buffer, Long.toString(thisVersion));
                extracted = true;
            }
        }
        if (!extracted) {
            log.infoW().$("web console is up to date").$();
        }
    }

    private static void extractSite0(String dir, Log log, String publicDir, byte[] buffer, String thisVersion) throws IOException {
        block30: {
            block29: {
                try (InputStream is = ServerMain.class.getResourceAsStream(PUBLIC_ZIP);){
                    if (is != null) {
                        try (ZipInputStream zip = new ZipInputStream(is);){
                            ZipEntry ze;
                            while ((ze = zip.getNextEntry()) != null) {
                                File dest = new File(publicDir, ze.getName());
                                if (!ze.isDirectory()) {
                                    ServerMain.copyInputStream(true, buffer, dest, zip, log);
                                }
                                zip.closeEntry();
                            }
                            break block29;
                        }
                    }
                    log.errorW().$("could not find site [resource=").$(PUBLIC_ZIP).$(']').$();
                }
            }
            ServerMain.setPublicVersion(publicDir, thisVersion);
            ServerMain.copyConfResource(dir, false, buffer, "conf/date.formats", log);
            try {
                ServerMain.copyConfResource(dir, true, buffer, "conf/mime.types", log);
            }
            catch (IOException exception) {
                if (exception.getMessage() != null && (exception.getMessage().contains("Read-only file system") || exception.getMessage().contains("Permission denied"))) break block30;
                throw exception;
            }
        }
        ServerMain.copyConfResource(dir, false, buffer, "conf/server.conf", log);
        ServerMain.copyConfResource(dir, false, buffer, "conf/log.conf", log);
    }

    private static void copyConfResource(String dir, boolean force, byte[] buffer, String res, Log log) throws IOException {
        File out = new File(dir, res);
        try (InputStream is = ServerMain.class.getResourceAsStream("/io/questdb/site/" + res);){
            if (is != null) {
                ServerMain.copyInputStream(force, buffer, out, is, log);
            }
        }
    }

    private static void copyInputStream(boolean force, byte[] buffer, File out, InputStream is, Log log) throws IOException {
        boolean exists = out.exists();
        if (force || !exists) {
            File dir = out.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                log.errorW().$("could not create directory [path=").$(dir).$(']').$();
                return;
            }
            try (FileOutputStream fos = new FileOutputStream(out);){
                int n;
                while ((n = is.read(buffer, 0, buffer.length)) > 0) {
                    fos.write(buffer, 0, n);
                }
            }
            log.infoW().$("extracted [path=").$(out).$(']').$();
            return;
        }
        log.debugW().$("skipped [path=").$(out).$(']').$();
    }

    private static void deleteDirContentsOrException(File file) {
        if (!file.exists()) {
            return;
        }
        try {
            File[] files;
            if (ServerMain.notSymlink(file) && (files = file.listFiles()) != null) {
                for (File f : files) {
                    ServerMain.deleteOrException(f);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot delete dir contents: " + file, e);
        }
    }

    private static boolean notSymlink(File file) throws IOException {
        File fileInCanonicalDir;
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        if (Os.type == 3) {
            return true;
        }
        if (file.getParentFile() == null) {
            fileInCanonicalDir = file;
        } else {
            File canonicalDir = file.getParentFile().getCanonicalFile();
            fileInCanonicalDir = new File(canonicalDir, file.getName());
        }
        return fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }

    protected static void shutdownQuestDb(WorkerPool workerPool, ObjList<? extends Closeable> instancesToClean) {
        ShutdownFlag.INSTANCE.shutdown();
        workerPool.halt();
        Misc.freeObjList(instancesToClean);
    }

    private static void verifyFileSystem(String kind, CharSequence dir, Path path, Log log) {
        if (dir != null) {
            path.of(dir).$();
            long fsStatus = Files.getFileSystemStatus(path);
            path.seekZ();
            LogRecord rec = log.advisoryW().$(kind).$(" file system magic: 0x");
            if (fsStatus < 0L) {
                rec.$hex(-fsStatus).$(" [").$(path).$("] SUPPORTED").$();
            } else {
                rec.$hex(fsStatus).$(" [").$(path).$("] EXPERIMENTAL").$();
                log.advisoryW().$("\n\n\n\t\t\t*** SYSTEM IS USING UNSUPPORTED FILE SYSTEM AND COULD BE UNSTABLE ***\n\n").$();
            }
        }
    }

    protected HttpServer createHttpServer(WorkerPool workerPool, Log log, CairoEngine cairoEngine, FunctionFactoryCache functionFactoryCache, DatabaseSnapshotAgent snapshotAgent, Metrics metrics) {
        return HttpServer.create(this.configuration.getHttpServerConfiguration(), workerPool, log, cairoEngine, functionFactoryCache, snapshotAgent, metrics);
    }

    protected HttpServer createMinHttpServer(WorkerPool workerPool, Log log, CairoEngine cairoEngine, FunctionFactoryCache functionFactoryCache, DatabaseSnapshotAgent snapshotAgent, Metrics metrics) {
        if (!metrics.isEnabled()) {
            log.advisoryW().$("Min health server is starting. Health check endpoint will not consider unhandled errors when metrics are disabled.").$();
        }
        return HttpServer.createMin(this.configuration.getHttpMinServerConfiguration(), workerPool, log, cairoEngine, functionFactoryCache, snapshotAgent, metrics);
    }

    protected void initQuestDb(WorkerPool workerPool, CairoEngine cairoEngine, Log log) {
    }

    protected void readServerConfiguration(String rootDirectory, Properties properties, Log log, BuildInformation buildInformation) throws ServerConfigurationException, JsonException {
        this.configuration = new PropServerConfiguration(rootDirectory, properties, System.getenv(), log, buildInformation);
    }

    protected void startQuestDb(WorkerPool workerPool, CairoEngine cairoEngine, Log log) {
        workerPool.start(log);
    }
}

