/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.nifi.web.security.saml2.web.authentication.logout;

import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.authority.AuthorityUtils;

import java.util.Objects;

/**
 * Logout Authentication Token for processing Logout Requests using Spring Security SAML 2 handlers
 */
public class LogoutAuthenticationToken extends AbstractAuthenticationToken {
    private final String name;

    public LogoutAuthenticationToken(final String name) {
        super(AuthorityUtils.NO_AUTHORITIES);
        this.name = Objects.requireNonNull(name, "Name required");
    }

    @Override
    public Object getCredentials() {
        return name;
    }

    @Override
    public Object getPrincipal() {
        return name;
    }
}
