/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Chars;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.CloneableMutable;
import io.questdb.std.str.MutableCharSink;
import org.jetbrains.annotations.NotNull;

public class StringSink
extends AbstractCharSink
implements MutableCharSink,
CloneableMutable {
    private final StringBuilder builder = new StringBuilder();

    public void clear(int pos) {
        this.builder.setLength(pos);
    }

    @Override
    public void clear() {
        this.builder.setLength(0);
    }

    @Override
    public <T> T copy() {
        return (T)this.toString();
    }

    public int hashCode() {
        return Chars.hashCode(this.builder);
    }

    public boolean equals(Object obj) {
        return obj instanceof CharSequence && Chars.equals((CharSequence)this.builder, (CharSequence)obj);
    }

    @Override
    @NotNull
    public String toString() {
        return this.builder.toString();
    }

    @Override
    public int length() {
        return this.builder.length();
    }

    @Override
    public char charAt(int index) {
        return this.builder.charAt(index);
    }

    @Override
    public CharSequence subSequence(int lo, int hi) {
        return this.builder.subSequence(lo, hi);
    }

    @Override
    public CharSink put(CharSequence cs) {
        if (cs != null) {
            this.builder.append(cs);
        }
        return this;
    }

    @Override
    public CharSink put(CharSequence cs, int lo, int hi) {
        this.builder.append(cs, lo, hi);
        return this;
    }

    @Override
    public CharSink put(char c) {
        this.builder.append(c);
        return this;
    }

    @Override
    public CharSink put(char[] chars, int start, int len) {
        this.builder.append(chars, start, len);
        return this;
    }

    public CharSink put(char c, int n) {
        for (int i = 0; i < n; ++i) {
            this.builder.append(c);
        }
        return this;
    }
}

