/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Chars;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.MutableCharSink;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class FloatingDirectCharSink
extends AbstractCharSink
implements MutableCharSink,
Closeable {
    private long ptr = 0L;
    private long lo = 0L;
    private long hi = 0L;

    public FloatingDirectCharSink of(long lo, long hi) {
        this.ptr = lo;
        this.lo = lo;
        this.hi = hi;
        return this;
    }

    public FloatingDirectCharSink asCharSequence(long lo, long hi) {
        this.ptr = lo;
        this.lo = hi;
        this.hi = hi;
        return this;
    }

    @Override
    public void clear() {
        this.lo = this.ptr;
    }

    @Override
    public void close() {
        this.ptr = 0L;
        this.hi = 0L;
        this.lo = 0L;
    }

    @Override
    public int length() {
        return (int)(this.lo - this.ptr) / 2;
    }

    @Override
    public char charAt(int index) {
        return Unsafe.getUnsafe().getChar(this.ptr + (long)index * 2L);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSink put(CharSequence cs) {
        int l = cs.length();
        assert (this.checkCapacity(l));
        int l2 = l * 2;
        for (int i = 0; i < l; ++i) {
            Unsafe.getUnsafe().putChar(this.lo + (long)i * 2L, cs.charAt(i));
        }
        this.lo += (long)l2;
        return this;
    }

    @Override
    public CharSink put(char[] chars, int start, int len) {
        assert (this.checkCapacity(len));
        int l2 = len * 2;
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putChar(this.lo + (long)i * 2L, chars[i + start]);
        }
        this.lo += (long)l2;
        return this;
    }

    @Override
    public CharSink put(char c) {
        assert (this.checkCapacity(1));
        Unsafe.getUnsafe().putChar(this.lo, c);
        this.lo += 2L;
        return this;
    }

    private boolean checkCapacity(int nChars) {
        return this.lo + 2L * (long)nChars <= this.hi;
    }

    public int hashCode() {
        return Chars.hashCode(this);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof CharSequence && Chars.equals((CharSequence)this, (CharSequence)obj);
    }

    @Override
    @NotNull
    public String toString() {
        return AbstractCharSequence.getString(this);
    }
}

