/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Chars;
import io.questdb.std.Mutable;
import io.questdb.std.ObjectFactory;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.ByteSequence;
import org.jetbrains.annotations.NotNull;

public class DirectByteCharSequence
extends AbstractCharSequence
implements Mutable,
ByteSequence {
    public static final Factory FACTORY = new Factory();
    private long lo;
    private long hi;

    @Override
    public byte byteAt(int index) {
        return Unsafe.getUnsafe().getByte(this.lo + (long)index);
    }

    @Override
    public void clear() {
        this.hi = 0L;
        this.lo = 0L;
    }

    public long getHi() {
        return this.hi;
    }

    public long getLo() {
        return this.lo;
    }

    @Override
    public int length() {
        return (int)(this.hi - this.lo);
    }

    @Override
    public char charAt(int index) {
        return (char)this.byteAt(index);
    }

    public void shl(long delta) {
        this.lo -= delta;
        this.hi -= delta;
    }

    public DirectByteCharSequence of(long lo, long hi) {
        this.lo = lo;
        this.hi = hi;
        return this;
    }

    public void decHi() {
        --this.hi;
    }

    public void squeeze() {
        ++this.lo;
        --this.hi;
    }

    @Override
    @NotNull
    public String toString() {
        return Chars.stringFromUtf8Bytes(this.lo, this.hi);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        DirectByteCharSequence seq = new DirectByteCharSequence();
        seq.lo = this.lo + (long)start;
        seq.hi = this.lo + (long)end;
        return seq;
    }

    public static final class Factory
    implements ObjectFactory<DirectByteCharSequence> {
        @Override
        public DirectByteCharSequence newInstance() {
            return new DirectByteCharSequence();
        }
    }
}

