/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Numbers;
import io.questdb.std.ObjHashSet;
import io.questdb.std.str.CharSink;
import java.util.Set;

public abstract class AbstractCharSink
implements CharSink {
    private static final ThreadLocal<ObjHashSet<Throwable>> tlSet = ThreadLocal.withInitial(ObjHashSet::new);
    private final char[] doubleDigits = new char[21];

    @Override
    public char[] getDoubleDigitsBuffer() {
        return this.doubleDigits;
    }

    @Override
    public CharSink put(Throwable e) {
        ObjHashSet<Throwable> dejaVu = tlSet.get();
        dejaVu.add(e);
        this.put0(e);
        this.put("\r\n");
        StackTraceElement[] trace = e.getStackTrace();
        int n = trace.length;
        for (int i = 0; i < n; ++i) {
            this.put(trace[i]);
        }
        Throwable[] suppressed = e.getSuppressed();
        int n2 = suppressed.length;
        for (int i = 0; i < n2; ++i) {
            this.put(suppressed[i], trace, "Suppressed: ", "\t", dejaVu);
        }
        Throwable ourCause = e.getCause();
        if (ourCause != null) {
            this.put(ourCause, trace, "Caused by: ", "", dejaVu);
        }
        return this;
    }

    public void putAsPrintable(CharSequence nonPrintable) {
        int n = nonPrintable.length();
        for (int i = 0; i < n; ++i) {
            char c = nonPrintable.charAt(i);
            if (c > '\u001f' && c != '\u007f') {
                this.put(c);
                continue;
            }
            this.put('\\');
            this.put('u');
            int s = c & 0xFF;
            this.put('0');
            this.put('0');
            this.put(Numbers.hexDigits[s / 16]);
            this.put(Numbers.hexDigits[s % 16]);
        }
    }

    private void put(StackTraceElement e) {
        this.put("\tat ");
        this.put(e.getClassName());
        this.put('.');
        this.put(e.getMethodName());
        if (e.isNativeMethod()) {
            this.put("(Native Method)");
        } else if (e.getFileName() != null && e.getLineNumber() > -1) {
            this.put('(').put(e.getFileName()).put(':').put(e.getLineNumber()).put(')');
        } else if (e.getFileName() != null) {
            this.put('(').put(e.getFileName()).put(')');
        } else {
            this.put("(Unknown Source)");
        }
        this.put("\r\n");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int encodeSurrogate(char c, CharSequence in, int pos, int hi) {
        int dword;
        if (Character.isHighSurrogate((char)c)) {
            char c2;
            if (hi - pos < 1) {
                this.put('?');
                return pos;
            }
            if (!Character.isLowSurrogate(c2 = in.charAt(pos++))) {
                this.put('?');
                return pos;
            }
            dword = Character.toCodePoint((char)c, c2);
        } else {
            if (Character.isLowSurrogate((char)c)) {
                this.put('?');
                return pos;
            }
            dword = c;
        }
        this.put((char)(0xF0 | dword >> 18)).put((char)(0x80 | dword >> 12 & 0x3F)).put((char)(0x80 | dword >> 6 & 0x3F)).put((char)(0x80 | dword & 0x3F));
        return pos;
    }

    private void put(Throwable throwable, StackTraceElement[] enclosingTrace, String caption, String prefix, Set<Throwable> dejaVu) {
        if (dejaVu.contains(throwable)) {
            this.put("\t[CIRCULAR REFERENCE:");
            this.put0(throwable);
            this.put(']');
        } else {
            dejaVu.add(throwable);
            StackTraceElement[] trace = throwable.getStackTrace();
            int m = trace.length - 1;
            for (int n = enclosingTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(enclosingTrace[n]); --m, --n) {
            }
            int framesInCommon = trace.length - 1 - m;
            this.put(prefix).put(caption);
            this.put0(throwable);
            this.put("\r\n");
            for (int i = 0; i <= m; ++i) {
                this.put(prefix);
                this.put(trace[i]);
            }
            if (framesInCommon != 0) {
                this.put(prefix).put("\t...").put(framesInCommon).put(" more");
            }
            Throwable[] suppressed = throwable.getSuppressed();
            int k = suppressed.length;
            for (int i = 0; i < k; ++i) {
                this.put(suppressed[i], trace, "Suppressed: ", prefix + '\t', dejaVu);
            }
            Throwable cause = throwable.getCause();
            if (cause != null) {
                this.put(cause, trace, "Caused by: ", prefix, dejaVu);
            }
        }
    }

    public CharSink repeat(CharSequence value, int n) {
        for (int i = 0; i < n; ++i) {
            this.put(value);
        }
        return this;
    }

    private void put0(Throwable e) {
        this.put(e.getClass().getName());
        if (e.getMessage() != null) {
            this.put(": ").put(e.getMessage());
        }
    }
}

