/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.fastdouble;

import io.questdb.std.NumericException;
import io.questdb.std.fastdouble.FastDoubleMath;
import io.questdb.std.fastdouble.FastDoubleSwar;
import io.questdb.std.fastdouble.FastDoubleUtils;

class FastDouble {
    FastDouble() {
    }

    static int skipWhitespace(CharSequence str, int index, int endIndex) {
        while (index < endIndex && str.charAt(index) <= ' ') {
            ++index;
        }
        return index;
    }

    static double parseInfinity(CharSequence str, int index, int endIndex, boolean negative) throws NumericException {
        if (index + 7 < endIndex && str.charAt(index) == 'I' && str.charAt(index + 1) == 'n' && str.charAt(index + 2) == 'f' && str.charAt(index + 3) == 'i' && str.charAt(index + 4) == 'n' && str.charAt(index + 5) == 'i' && str.charAt(index + 6) == 't' && str.charAt(index + 7) == 'y' && (index = FastDouble.skipWhitespace(str, index + 8, endIndex)) == endIndex) {
            return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        throw NumericException.INSTANCE;
    }

    static double parseFloatingPointLiteral(CharSequence str, int offset, int length, boolean rejectOverflow) throws NumericException {
        boolean hasLeadingZero;
        boolean isNegative;
        int endIndex = offset + length;
        if (offset < 0 || endIndex > str.length()) {
            throw NumericException.INSTANCE;
        }
        int index = FastDouble.skipWhitespace(str, offset, endIndex);
        if (index == endIndex) {
            throw NumericException.INSTANCE;
        }
        char ch = str.charAt(index);
        boolean bl = isNegative = ch == '-';
        if (isNegative || ch == '+') {
            char c = ch = ++index < endIndex ? str.charAt(index) : (char)'\u0000';
            if (ch == '\u0000') {
                throw NumericException.INSTANCE;
            }
        }
        if (ch >= 'I') {
            return ch == 'N' ? FastDouble.parseNaN(str, index, endIndex) : FastDouble.parseInfinity(str, index, endIndex, isNegative);
        }
        boolean bl2 = hasLeadingZero = ch == '0';
        if (hasLeadingZero) {
            char c = ch = ++index < endIndex ? str.charAt(index) : (char)'\u0000';
            if (ch == 'x' || ch == 'X') {
                return FastDouble.parseHexFloatLiteral(str, index + 1, offset, endIndex, isNegative, rejectOverflow);
            }
        }
        return FastDouble.parseDecFloatLiteral(str, index, offset, endIndex, isNegative, hasLeadingZero, rejectOverflow);
    }

    private static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private static double parseDecFloatLiteral(CharSequence str, int index, int startIndex, int endIndex, boolean isNegative, boolean hasLeadingZero, boolean rejectOverflow) throws NumericException {
        int exponentOfTruncatedSignificand;
        boolean isSignificandTruncated;
        int exponent;
        int digitCount;
        long significand = 0L;
        int significandStartIndex = index;
        int virtualIndexOfPoint = -1;
        boolean illegal = false;
        char ch = '\u0000';
        while (index < endIndex) {
            ch = str.charAt(index);
            if (FastDouble.isDigit(ch)) {
                significand = 10L * significand + (long)ch - 48L;
            } else {
                int eightDigits;
                if (ch != '.') break;
                illegal |= virtualIndexOfPoint >= 0;
                virtualIndexOfPoint = index;
                while (index < endIndex - 8 && (eightDigits = FastDouble.tryToParseEightDigits(str, index + 1)) >= 0) {
                    significand = 100000000L * significand + (long)eightDigits;
                    index += 8;
                }
            }
            ++index;
        }
        int significandEndIndex = index;
        if (virtualIndexOfPoint < 0) {
            digitCount = significandEndIndex - significandStartIndex;
            virtualIndexOfPoint = significandEndIndex;
            exponent = 0;
        } else {
            digitCount = significandEndIndex - significandStartIndex - 1;
            exponent = virtualIndexOfPoint - significandEndIndex + 1;
        }
        int expNumber = 0;
        if (ch == 'e' || ch == 'E') {
            boolean neg_exp;
            ch = ++index < endIndex ? str.charAt(index) : (char)'\u0000';
            boolean bl = neg_exp = ch == '-';
            if (neg_exp || ch == '+') {
                ch = ++index < endIndex ? str.charAt(index) : (char)'\u0000';
            }
            illegal |= !FastDouble.isDigit(ch);
            do {
                if (expNumber >= 1024) continue;
                expNumber = 10 * expNumber + ch - 48;
            } while (FastDouble.isDigit(ch = ++index < endIndex ? str.charAt(index) : (char)'\u0000'));
            if (neg_exp) {
                expNumber = -expNumber;
            }
            exponent += expNumber;
        }
        if (index < endIndex && (ch == 'd' || ch == 'D')) {
            ++index;
        }
        index = FastDouble.skipWhitespace(str, index, endIndex);
        if (illegal || index < endIndex || !hasLeadingZero && digitCount == 0) {
            throw NumericException.INSTANCE;
        }
        int skipCountInTruncatedDigits = 0;
        if (digitCount > 19) {
            significand = 0L;
            for (index = significandStartIndex; index < significandEndIndex; ++index) {
                ch = str.charAt(index);
                if (ch == '.') {
                    ++skipCountInTruncatedDigits;
                    continue;
                }
                if (Long.compareUnsigned(significand, 1000000000000000000L) >= 0) break;
                significand = 10L * significand + (long)ch - 48L;
            }
            isSignificandTruncated = index < significandEndIndex;
            exponentOfTruncatedSignificand = virtualIndexOfPoint - index + skipCountInTruncatedDigits + expNumber;
        } else {
            isSignificandTruncated = false;
            exponentOfTruncatedSignificand = 0;
        }
        return FastDouble.valueOfFloatLiteral(str, startIndex, endIndex, isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand, rejectOverflow);
    }

    private static double parseHexFloatLiteral(CharSequence str, int index, int startIndex, int endIndex, boolean isNegative, boolean rejectOverflow) throws NumericException {
        boolean isSignificandTruncated;
        boolean hasExponent;
        int digitCount;
        long significand = 0L;
        int exponent = 0;
        int significandStartIndex = index;
        int virtualIndexOfPoint = -1;
        boolean illegal = false;
        char ch = '\u0000';
        while (index < endIndex) {
            int hexValue;
            ch = str.charAt(index);
            int n = hexValue = ch > '\u007f' ? -1 : FastDoubleUtils.CHAR_TO_HEX_MAP[ch];
            if (hexValue >= 0) {
                significand = significand << 4 | (long)hexValue;
            } else {
                if (hexValue != -4) break;
                illegal |= virtualIndexOfPoint >= 0;
                virtualIndexOfPoint = index;
            }
            ++index;
        }
        int significandEndIndex = index;
        if (virtualIndexOfPoint < 0) {
            digitCount = significandEndIndex - significandStartIndex;
            virtualIndexOfPoint = significandEndIndex;
        } else {
            digitCount = significandEndIndex - significandStartIndex - 1;
            exponent = Math.min(virtualIndexOfPoint - index + 1, 1024) * 4;
        }
        int expNumber = 0;
        boolean bl = hasExponent = ch == 'p' || ch == 'P';
        if (hasExponent) {
            boolean neg_exp;
            ch = ++index < endIndex ? str.charAt(index) : (char)'\u0000';
            boolean bl2 = neg_exp = ch == '-';
            if (neg_exp || ch == '+') {
                ch = ++index < endIndex ? str.charAt(index) : (char)'\u0000';
            }
            illegal |= !FastDouble.isDigit(ch);
            do {
                if (expNumber >= 1024) continue;
                expNumber = 10 * expNumber + ch - 48;
            } while (FastDouble.isDigit(ch = ++index < endIndex ? str.charAt(index) : (char)'\u0000'));
            if (neg_exp) {
                expNumber = -expNumber;
            }
            exponent += expNumber;
        }
        if (index < endIndex && (ch == 'd' || ch == 'D' || ch == 'f' || ch == 'F')) {
            ++index;
        }
        index = FastDouble.skipWhitespace(str, index, endIndex);
        if (illegal || index < endIndex || digitCount == 0 || !hasExponent) {
            throw NumericException.INSTANCE;
        }
        int skipCountInTruncatedDigits = 0;
        if (digitCount > 16) {
            significand = 0L;
            for (index = significandStartIndex; index < significandEndIndex; ++index) {
                int hexValue;
                ch = str.charAt(index);
                int n = hexValue = ch > '\u007f' ? -1 : FastDoubleUtils.CHAR_TO_HEX_MAP[ch];
                if (hexValue >= 0) {
                    if (Long.compareUnsigned(significand, 1000000000000000000L) >= 0) break;
                    significand = significand << 4 | (long)hexValue;
                    continue;
                }
                ++skipCountInTruncatedDigits;
            }
            isSignificandTruncated = index < significandEndIndex;
        } else {
            isSignificandTruncated = false;
        }
        return FastDouble.valueOfHexLiteral(str, startIndex, endIndex, isNegative, significand, exponent, isSignificandTruncated, virtualIndexOfPoint - index + skipCountInTruncatedDigits + expNumber, rejectOverflow);
    }

    private static double parseNaN(CharSequence str, int index, int endIndex) throws NumericException {
        if (index + 2 < endIndex && str.charAt(index + 1) == 'a' && str.charAt(index + 2) == 'N' && (index = FastDouble.skipWhitespace(str, index + 3, endIndex)) == endIndex) {
            return Double.NaN;
        }
        throw NumericException.INSTANCE;
    }

    private static int tryToParseEightDigits(CharSequence str, int offset) {
        long first = (long)str.charAt(offset) | (long)str.charAt(offset + 1) << 16 | (long)str.charAt(offset + 2) << 32 | (long)str.charAt(offset + 3) << 48;
        long second = (long)str.charAt(offset + 4) | (long)str.charAt(offset + 5) << 16 | (long)str.charAt(offset + 6) << 32 | (long)str.charAt(offset + 7) << 48;
        return FastDoubleSwar.tryToParseEightDigitsUtf16(first, second);
    }

    static double valueOfFloatLiteral(CharSequence str, int startIndex, int endIndex, boolean isNegative, long significand, int exponent, boolean isSignificandTruncated, int exponentOfTruncatedSignificand, boolean rejectOverflow) throws NumericException {
        double d = FastDoubleMath.tryDecFloatToDoubleTruncated(isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand);
        if (Double.isNaN(d)) {
            d = FastDouble.fallbackToJavaParser(str, startIndex, endIndex, rejectOverflow);
        }
        return d;
    }

    private static double fallbackToJavaParser(CharSequence str, int startIndex, int endIndex, boolean rejectOverflow) throws NumericException {
        double d = Double.parseDouble(str.subSequence(startIndex, endIndex).toString());
        if (rejectOverflow && (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || d == 0.0)) {
            throw NumericException.INSTANCE;
        }
        return d;
    }

    static double valueOfHexLiteral(CharSequence str, int startIndex, int endIndex, boolean isNegative, long significand, int exponent, boolean isSignificandTruncated, int exponentOfTruncatedSignificand, boolean rejectOverflow) throws NumericException {
        double d = FastDoubleMath.tryHexFloatToDoubleTruncated(isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand);
        if (Double.isNaN(d)) {
            return FastDouble.fallbackToJavaParser(str, startIndex, endIndex, rejectOverflow);
        }
        return d;
    }
}

