/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.datetime.microtime;

import io.questdb.std.BytecodeAssembler;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.GenericLexer;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.AbstractDateFormat;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.microtime.GenericTimestampFormat;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.CharSink;

public class TimestampFormatCompiler {
    static final int OP_ERA = 1;
    static final int OP_YEAR_ONE_DIGIT = 2;
    static final int OP_YEAR_TWO_DIGITS = 3;
    static final int OP_YEAR_THREE_DIGITS = 148;
    static final int OP_YEAR_FOUR_DIGITS = 4;
    static final int OP_MONTH_ONE_DIGIT = 5;
    static final int OP_MONTH_TWO_DIGITS = 6;
    static final int OP_MONTH_SHORT_NAME = 7;
    static final int OP_MONTH_LONG_NAME = 8;
    static final int OP_DAY_ONE_DIGIT = 9;
    static final int OP_DAY_TWO_DIGITS = 10;
    static final int OP_DAY_NAME_SHORT = 11;
    static final int OP_DAY_NAME_LONG = 12;
    static final int OP_DAY_OF_WEEK = 13;
    static final int OP_DAY_OF_YEAR = 36;
    static final int OP_WEEK_OF_YEAR = 37;
    static final int OP_WEEK_OF_MONTH = 38;
    static final int OP_AM_PM = 14;
    static final int OP_HOUR_24_ONE_DIGIT = 15;
    static final int OP_HOUR_24_TWO_DIGITS = 32;
    static final int OP_HOUR_24_ONE_DIGIT_ONE_BASED = 16;
    static final int OP_HOUR_24_TWO_DIGITS_ONE_BASED = 33;
    static final int OP_HOUR_12_ONE_DIGIT = 17;
    static final int OP_HOUR_12_TWO_DIGITS = 34;
    static final int OP_HOUR_12_ONE_DIGIT_ONE_BASED = 18;
    static final int OP_HOUR_12_TWO_DIGITS_ONE_BASED = 35;
    static final int OP_MINUTE_ONE_DIGIT = 19;
    static final int OP_MINUTE_TWO_DIGITS = 29;
    static final int OP_SECOND_ONE_DIGIT = 20;
    static final int OP_SECOND_TWO_DIGITS = 30;
    static final int OP_MILLIS_ONE_DIGIT = 21;
    static final int OP_MILLIS_THREE_DIGITS = 31;
    static final int OP_TIME_ZONE_GMT_BASED = 22;
    static final int OP_TIME_ZONE_SHORT = 23;
    static final int OP_TIME_ZONE_LONG = 24;
    static final int OP_TIME_ZONE_RFC_822 = 25;
    static final int OP_TIME_ZONE_ISO_8601_1 = 26;
    static final int OP_TIME_ZONE_ISO_8601_2 = 27;
    static final int OP_TIME_ZONE_ISO_8601_3 = 28;
    static final int OP_MICROS_ONE_DIGIT = 39;
    static final int OP_MICROS_THREE_DIGITS = 49;
    static final int OP_NANOS_ONE_DIGIT = 40;
    static final int OP_NANOS_THREE_DIGITS = 50;
    static final int OP_MICROS_GREEDY = 149;
    static final int OP_YEAR_GREEDY = 132;
    static final int OP_MONTH_GREEDY = 135;
    static final int OP_DAY_GREEDY = 139;
    static final int OP_HOUR_24_GREEDY = 140;
    static final int OP_HOUR_24_GREEDY_ONE_BASED = 141;
    static final int OP_HOUR_12_GREEDY = 142;
    static final int OP_HOUR_12_GREEDY_ONE_BASED = 143;
    static final int OP_MINUTE_GREEDY = 144;
    static final int OP_SECOND_GREEDY = 145;
    static final int OP_MILLIS_GREEDY = 146;
    static final int OP_NANOS_GREEDY = 147;
    static final CharSequenceIntHashMap opMap = new CharSequenceIntHashMap();
    static final ObjList<String> opList = new ObjList();
    private static final int FA_LOCAL_DATETIME = 1;
    private static final int FA_LOCAL_SINK = 5;
    private static final int FA_LOCAL_LOCALE = 3;
    private static final int FA_LOCAL_TIMEZONE = 4;
    private static final int FA_SECOND_MILLIS = 1;
    private static final int FA_SECOND = 2;
    private static final int FA_MINUTE = 3;
    private static final int FA_HOUR = 4;
    private static final int FA_DAY = 5;
    private static final int FA_MONTH = 6;
    private static final int FA_YEAR = 7;
    private static final int FA_LEAP = 8;
    private static final int FA_DAY_OF_WEEK = 10;
    private static final int FA_DAY_OF_YEAR = 14;
    private static final int FA_WEEK_OF_YEAR = 12;
    private static final int FA_WEEK_OF_MONTH = 13;
    private static final int FA_MILLIS_MICROS = 11;
    private static final int P_INPUT_STR = 1;
    private static final int P_LO = 2;
    private static final int P_HI = 3;
    private static final int P_LOCALE = 4;
    private static final int LOCAL_DAY = 5;
    private static final int LOCAL_MONTH = 6;
    private static final int LOCAL_YEAR = 7;
    private static final int LOCAL_HOUR = 8;
    private static final int LOCAL_MINUTE = 9;
    private static final int LOCAL_SECOND = 10;
    private static final int LOCAL_MILLIS = 11;
    private static final int LOCAL_POS = 12;
    private static final int LOCAL_TEMP_LONG = 13;
    private static final int LOCAL_TIMEZONE = 15;
    private static final int LOCAL_OFFSET = 16;
    private static final int LOCAL_HOUR_TYPE = 18;
    private static final int LOCAL_ERA = 19;
    private static final int LOCAL_MICROS = 20;
    private static final int FORMAT_METHOD_STACK_START = 6;
    private final GenericLexer lexer = new GenericLexer(2048);
    private final BytecodeAssembler asm = new BytecodeAssembler();
    private final IntList ops = new IntList();
    private final ObjList<String> delimiters = new ObjList();
    private final IntList delimiterIndexes = new IntList();
    private final LongList frameOffsets = new LongList();
    private final int[] fmtAttributeIndex = new int[32];

    public TimestampFormatCompiler() {
        int n = opList.size();
        for (int i = 0; i < n; ++i) {
            this.lexer.defineSymbol(opList.getQuick(i));
        }
    }

    private static void addOp(String op, int opDayTwoDigits) {
        opMap.put(op, opDayTwoDigits);
        opList.add(op);
    }

    public DateFormat compile(CharSequence pattern) {
        return this.compile(pattern, false);
    }

    public DateFormat compile(CharSequence pattern, boolean generic) {
        return this.compile(pattern, 0, pattern.length(), generic);
    }

    public DateFormat compile(CharSequence pattern, int lo, int hi, boolean generic) {
        ObjList<String> delimiters;
        IntList ops;
        this.lexer.of(pattern, lo, hi);
        if (generic) {
            ops = new IntList();
            delimiters = new ObjList();
        } else {
            ops = this.ops;
            delimiters = this.delimiters;
            ops.clear();
            delimiters.clear();
        }
        block4: while (this.lexer.hasNext()) {
            CharSequence cs = this.lexer.next();
            int op = opMap.get(cs);
            switch (op) {
                case -1: {
                    this.makeLastOpGreedy(ops);
                    delimiters.add(Chars.toString(cs));
                    ops.add(-delimiters.size());
                    continue block4;
                }
                case 14: 
                case 23: {
                    this.makeLastOpGreedy(ops);
                }
            }
            ops.add(op);
        }
        this.makeLastOpGreedy(ops);
        return generic ? new GenericTimestampFormat(ops, delimiters) : this.compile(ops, delimiters);
    }

    private void addTempToPos(int decodeLenIndex) {
        this.asm.iload(12);
        this.decodeInt(decodeLenIndex);
        this.asm.iadd();
        this.asm.istore(12);
    }

    private void assembleFormatMethod(IntList ops, ObjList<String> delimiters, int getWeekdayIndex, int getShortWeekdayIndex, int getMonthIndex, int getShortMonthIndex, int appendEraIndex, int appendAmPmIndex, int appendHour12Index, int appendHour12PaddedIndex, int appendHour121Index, int appendHour121PaddedIndex, int getYearIndex, int isLeapYearIndex, int getMonthOfYearIndex, int getDayOfMonthIndex, int getHourOfDayIndex, int getMinuteOfHourIndex, int getSecondOfMinuteIndex, int getMillisOfSecondIndex, int getMicrosOfSecondIndex, int getDayOfWeekIndex, int append00Index, int append0Index, int appendYear000Index, int appendYear00Index, int appendYear0Index, int appendYearIndex, int sinkPutIntIndex, int sinkPutStrIndex, int sinkPutChrIndex, int formatNameIndex, int formatSigIndex, int getDayOfYearIndex, int getWeekOfMonthIndex, int getWeekOfYearIndex) {
        int formatAttributes = this.computeFormatAttributes(ops);
        this.asm.startMethod(formatNameIndex, formatSigIndex, 6, 6 + Integer.bitCount(formatAttributes));
        this.assembleFormatMethodStack(formatAttributes, getYearIndex, isLeapYearIndex, getMonthOfYearIndex, getDayOfMonthIndex, getHourOfDayIndex, getMinuteOfHourIndex, getSecondOfMinuteIndex, getMillisOfSecondIndex, getMicrosOfSecondIndex, getDayOfWeekIndex, getDayOfYearIndex, getWeekOfMonthIndex, getWeekOfYearIndex);
        int n = ops.size();
        block39: for (int i = 0; i < n; ++i) {
            int op = ops.getQuick(i);
            switch (op) {
                case 14: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[4]);
                    this.asm.aload(3);
                    this.asm.invokeStatic(appendAmPmIndex);
                    continue block39;
                }
                case 39: 
                case 149: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[11]);
                    this.asm.invokeInterface(sinkPutIntIndex, 1);
                    this.asm.pop();
                    continue block39;
                }
                case 49: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[11]);
                    this.asm.invokeStatic(append00Index);
                    continue block39;
                }
                case 40: 
                case 147: {
                    this.asm.aload(5);
                    this.asm.iconst(0);
                    this.asm.invokeInterface(sinkPutIntIndex, 1);
                    this.asm.pop();
                    continue block39;
                }
                case 50: {
                    this.asm.aload(5);
                    this.asm.iconst(0);
                    this.asm.invokeStatic(append00Index);
                    continue block39;
                }
                case 21: 
                case 146: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[1]);
                    this.asm.invokeInterface(sinkPutIntIndex, 1);
                    this.asm.pop();
                    continue block39;
                }
                case 31: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[1]);
                    this.asm.invokeStatic(append00Index);
                    continue block39;
                }
                case 20: 
                case 145: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[2]);
                    this.asm.invokeInterface(sinkPutIntIndex, 1);
                    this.asm.pop();
                    continue block39;
                }
                case 30: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[2]);
                    this.asm.invokeStatic(append0Index);
                    continue block39;
                }
                case 19: 
                case 144: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[3]);
                    this.asm.invokeInterface(sinkPutIntIndex, 1);
                    this.asm.pop();
                    continue block39;
                }
                case 29: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[3]);
                    this.asm.invokeStatic(append0Index);
                    continue block39;
                }
                case 17: 
                case 142: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[4]);
                    this.asm.invokeStatic(appendHour12Index);
                    continue block39;
                }
                case 34: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[4]);
                    this.asm.invokeStatic(appendHour12PaddedIndex);
                    continue block39;
                }
                case 18: 
                case 143: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[4]);
                    this.asm.invokeStatic(appendHour121Index);
                    continue block39;
                }
                case 35: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[4]);
                    this.asm.invokeStatic(appendHour121PaddedIndex);
                    continue block39;
                }
                case 15: 
                case 140: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[4]);
                    this.asm.invokeInterface(sinkPutIntIndex, 1);
                    this.asm.pop();
                    continue block39;
                }
                case 32: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[4]);
                    this.asm.invokeStatic(append0Index);
                    continue block39;
                }
                case 16: 
                case 141: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[4]);
                    this.asm.iconst(1);
                    this.asm.iadd();
                    this.asm.invokeInterface(sinkPutIntIndex, 1);
                    this.asm.pop();
                    continue block39;
                }
                case 33: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[4]);
                    this.asm.iconst(1);
                    this.asm.iadd();
                    this.asm.invokeStatic(append0Index);
                    continue block39;
                }
                case 9: 
                case 139: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[5]);
                    this.asm.invokeInterface(sinkPutIntIndex, 1);
                    this.asm.pop();
                    continue block39;
                }
                case 10: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[5]);
                    this.asm.invokeStatic(append0Index);
                    continue block39;
                }
                case 12: {
                    this.asm.aload(5);
                    this.asm.aload(3);
                    this.asm.iload(this.fmtAttributeIndex[10]);
                    this.asm.invokeVirtual(getWeekdayIndex);
                    this.asm.invokeInterface(sinkPutStrIndex, 1);
                    this.asm.pop();
                    continue block39;
                }
                case 11: {
                    this.asm.aload(5);
                    this.asm.aload(3);
                    this.asm.iload(this.fmtAttributeIndex[10]);
                    this.asm.invokeVirtual(getShortWeekdayIndex);
                    this.asm.invokeInterface(sinkPutStrIndex, 1);
                    this.asm.pop();
                    continue block39;
                }
                case 13: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[10]);
                    this.asm.invokeInterface(sinkPutIntIndex, 1);
                    this.asm.pop();
                    continue block39;
                }
                case 36: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[14]);
                    this.asm.invokeInterface(sinkPutIntIndex, 1);
                    this.asm.pop();
                    continue block39;
                }
                case 38: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[13]);
                    this.asm.invokeInterface(sinkPutIntIndex, 1);
                    this.asm.pop();
                    continue block39;
                }
                case 37: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[12]);
                    this.asm.invokeInterface(sinkPutIntIndex, 1);
                    this.asm.pop();
                    continue block39;
                }
                case 5: 
                case 135: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[6]);
                    this.asm.invokeInterface(sinkPutIntIndex, 1);
                    this.asm.pop();
                    continue block39;
                }
                case 6: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[6]);
                    this.asm.invokeStatic(append0Index);
                    continue block39;
                }
                case 7: {
                    this.asm.aload(5);
                    this.asm.aload(3);
                    this.asm.iload(this.fmtAttributeIndex[6]);
                    this.asm.iconst(1);
                    this.asm.isub();
                    this.asm.invokeVirtual(getShortMonthIndex);
                    this.asm.invokeInterface(sinkPutStrIndex, 1);
                    this.asm.pop();
                    continue block39;
                }
                case 8: {
                    this.asm.aload(5);
                    this.asm.aload(3);
                    this.asm.iload(this.fmtAttributeIndex[6]);
                    this.asm.iconst(1);
                    this.asm.isub();
                    this.asm.invokeVirtual(getMonthIndex);
                    this.asm.invokeInterface(sinkPutStrIndex, 1);
                    this.asm.pop();
                    continue block39;
                }
                case 2: 
                case 132: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[7]);
                    this.asm.invokeStatic(appendYearIndex);
                    continue block39;
                }
                case 3: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[7]);
                    this.asm.iconst(100);
                    this.asm.irem();
                    this.asm.invokeStatic(appendYear0Index);
                    continue block39;
                }
                case 148: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[7]);
                    this.asm.iconst(1000);
                    this.asm.irem();
                    this.asm.invokeStatic(appendYear00Index);
                    continue block39;
                }
                case 4: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[7]);
                    this.asm.invokeStatic(appendYear000Index);
                    continue block39;
                }
                case 1: {
                    this.asm.aload(5);
                    this.asm.iload(this.fmtAttributeIndex[7]);
                    this.asm.aload(3);
                    this.asm.invokeStatic(appendEraIndex);
                    continue block39;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    this.asm.aload(5);
                    this.asm.aload(4);
                    this.asm.invokeInterface(sinkPutStrIndex, 1);
                    continue block39;
                }
                default: {
                    if (op >= 0) continue block39;
                    String delimiter = delimiters.getQuick(-op - 1);
                    if (delimiter.length() > 1) {
                        this.asm.aload(5);
                        this.asm.ldc(this.delimiterIndexes.getQuick(-op - 1));
                        this.asm.invokeInterface(sinkPutStrIndex, 1);
                    } else {
                        this.asm.aload(5);
                        this.asm.iconst(delimiter.charAt(0));
                        this.asm.invokeInterface(sinkPutChrIndex, 1);
                    }
                    this.asm.pop();
                }
            }
        }
        this.asm.return_();
        this.asm.endMethodCode();
        this.asm.putShort(0);
        this.asm.putShort(0);
        this.asm.endMethod();
    }

    private void assembleFormatMethodStack(int formatAttributes, int getYearIndex, int isLeapYearIndex, int getMonthOfYearIndex, int getDayOfMonthIndex, int getHourOfDayIndex, int getMinuteOfHourIndex, int getSecondOfMinuteIndex, int getMillisOfSecondIndex, int getMicrosOfSecondIndex, int getDayOfWeekIndex, int getDayOfYearIndex, int getWeekOfMonthIndex, int getWeekOfYearIndex) {
        int index = 6;
        if (this.invokeConvertMillis(formatAttributes, 7, getYearIndex, index)) {
            this.fmtAttributeIndex[7] = index++;
        }
        if ((formatAttributes & 0x100) != 0) {
            this.asm.iload(this.fmtAttributeIndex[7]);
            this.asm.invokeStatic(isLeapYearIndex);
            this.asm.istore(index);
            this.fmtAttributeIndex[8] = index++;
        }
        if ((formatAttributes & 0x40) != 0) {
            this.asm.lload(1);
            this.asm.iload(this.fmtAttributeIndex[7]);
            this.asm.iload(this.fmtAttributeIndex[8]);
            this.asm.invokeStatic(getMonthOfYearIndex);
            this.asm.istore(index);
            this.fmtAttributeIndex[6] = index++;
        }
        if ((formatAttributes & 0x20) != 0) {
            this.asm.lload(1);
            this.asm.iload(this.fmtAttributeIndex[7]);
            this.asm.iload(this.fmtAttributeIndex[6]);
            this.asm.iload(this.fmtAttributeIndex[8]);
            this.asm.invokeStatic(getDayOfMonthIndex);
            this.asm.istore(index);
            this.fmtAttributeIndex[5] = index++;
        }
        if (this.invokeConvertMillis(formatAttributes, 4, getHourOfDayIndex, index)) {
            this.fmtAttributeIndex[4] = index++;
        }
        if (this.invokeConvertMillis(formatAttributes, 3, getMinuteOfHourIndex, index)) {
            this.fmtAttributeIndex[3] = index++;
        }
        if (this.invokeConvertMillis(formatAttributes, 2, getSecondOfMinuteIndex, index)) {
            this.fmtAttributeIndex[2] = index++;
        }
        if (this.invokeConvertMillis(formatAttributes, 1, getMillisOfSecondIndex, index)) {
            this.fmtAttributeIndex[1] = index++;
        }
        if (this.invokeConvertMillis(formatAttributes, 11, getMicrosOfSecondIndex, index)) {
            this.fmtAttributeIndex[11] = index++;
        }
        if (this.invokeConvertMillis(formatAttributes, 10, getDayOfWeekIndex, index)) {
            this.fmtAttributeIndex[10] = index;
        }
        if (this.invokeConvertMillis(formatAttributes, 14, getDayOfYearIndex, index)) {
            this.fmtAttributeIndex[14] = index;
        }
        if (this.invokeConvertMillis(formatAttributes, 13, getWeekOfMonthIndex, index)) {
            this.fmtAttributeIndex[13] = index;
        }
        if (this.invokeConvertMillis(formatAttributes, 12, getWeekOfYearIndex, index)) {
            this.fmtAttributeIndex[12] = index;
        }
    }

    private void assembleParseMethod(IntList ops, ObjList<String> delimiters, int thisClassIndex, int stackMapTableIndex, int dateLocaleClassIndex, int charSequenceClassIndex, int minLongIndex, int minMillisIndex, int matchWeekdayIndex, int matchMonthIndex, int matchZoneIndex, int matchAMPMIndex, int matchEraIndex, int parseIntSafelyIndex, int parseInt000GreedyIndex, int decodeLenIndex, int decodeIntIndex, int assertRemainingIndex, int assertNoTailIndex, int parseIntIndex, int assertStringIndex, int assertCharIndex, int computeMillisIndex, int adjustYearIndex, int parseYearGreedyIndex, int parseOffsetIndex, int parseNameIndex, int parseSigIndex, IntList delimIndices, int charAtIndex) {
        int stackState = this.computeParseMethodStack(ops);
        this.asm.startMethod(parseNameIndex, parseSigIndex, 14, 21);
        if ((stackState & 0x20) == 0) {
            this.asm.iconst(1);
            this.asm.istore(5);
        }
        if ((stackState & 0x40) == 0) {
            this.asm.iconst(1);
            this.asm.istore(6);
        }
        if ((stackState & 0x80) == 0) {
            this.asm.iconst(1970);
            this.asm.istore(7);
        }
        if ((stackState & 0x100) == 0) {
            this.asm.iconst(0);
            this.asm.istore(8);
        }
        if ((stackState & 0x200) == 0) {
            this.asm.iconst(0);
            this.asm.istore(9);
        }
        if ((stackState & 0x400) == 0) {
            this.asm.iconst(0);
            this.asm.istore(10);
        }
        if ((stackState & 0x800) == 0) {
            this.asm.iconst(0);
            this.asm.istore(11);
        }
        this.asm.iload(2);
        this.asm.istore(12);
        this.asm.iconst(-1);
        this.asm.istore(15);
        this.asm.ldc2_w(minLongIndex);
        this.asm.lstore(16);
        this.asm.iconst(2);
        this.asm.istore(18);
        if ((stackState & 0x80000) == 0) {
            this.asm.iconst(1);
            this.asm.istore(19);
        }
        if ((stackState & 0x2000) == 0) {
            this.asm.lconst_0();
            this.asm.lstore(13);
        }
        if ((stackState & 0x100000) == 0) {
            this.asm.iconst(0);
            this.asm.istore(20);
        }
        this.frameOffsets.clear();
        int n = ops.size();
        block47: for (int i = 0; i < n; ++i) {
            int op = ops.getQuick(i);
            switch (op) {
                case 14: {
                    stackState &= 0xFFFFDFFF;
                    this.invokeMatch(matchAMPMIndex);
                    this.decodeInt(decodeIntIndex);
                    this.asm.istore(18);
                    this.addTempToPos(decodeLenIndex);
                    continue block47;
                }
                case 39: {
                    stackState &= 0xFFEFFFFF;
                    this.parseDigits(assertRemainingIndex, parseIntIndex, 1, 20);
                    continue block47;
                }
                case 49: {
                    stackState &= 0xFFEFFFFF;
                    this.parseDigits(assertRemainingIndex, parseIntIndex, 3, 20);
                    continue block47;
                }
                case 149: {
                    stackState &= 0xFFEFFFFF;
                    stackState &= 0xFFFFDFFF;
                    this.invokeParseIntSafelyAndStore(parseInt000GreedyIndex, decodeLenIndex, decodeIntIndex, 20);
                    continue block47;
                }
                case 40: {
                    this.parseDigits(assertRemainingIndex, parseIntIndex, 1, -1);
                    continue block47;
                }
                case 50: {
                    this.parseDigits(assertRemainingIndex, parseIntIndex, 3, -1);
                    continue block47;
                }
                case 147: {
                    this.invokeParseIntSafelyAndStore(parseIntSafelyIndex, decodeLenIndex, decodeIntIndex, -1);
                    continue block47;
                }
                case 21: {
                    stackState &= 0xFFFFF7FF;
                    this.parseDigits(assertRemainingIndex, parseIntIndex, 1, 11);
                    continue block47;
                }
                case 31: {
                    stackState &= 0xFFFFF7FF;
                    this.parseDigits(assertRemainingIndex, parseIntIndex, 3, 11);
                    continue block47;
                }
                case 146: {
                    stackState &= 0xFFFFF7FF;
                    stackState &= 0xFFFFDFFF;
                    this.invokeParseIntSafelyAndStore(parseInt000GreedyIndex, decodeLenIndex, decodeIntIndex, 11);
                    continue block47;
                }
                case 20: {
                    stackState &= 0xFFFFFBFF;
                    this.parseDigits(assertRemainingIndex, parseIntIndex, 1, 10);
                    continue block47;
                }
                case 30: {
                    stackState &= 0xFFFFFBFF;
                    this.parseTwoDigits(assertRemainingIndex, parseIntIndex, 10);
                    continue block47;
                }
                case 145: {
                    stackState &= 0xFFFFFBFF;
                    stackState &= 0xFFFFDFFF;
                    this.invokeParseIntSafelyAndStore(parseIntSafelyIndex, decodeLenIndex, decodeIntIndex, 10);
                    continue block47;
                }
                case 19: {
                    stackState &= 0xFFFFFDFF;
                    this.parseDigits(assertRemainingIndex, parseIntIndex, 1, 9);
                    continue block47;
                }
                case 29: {
                    stackState &= 0xFFFFFDFF;
                    this.parseTwoDigits(assertRemainingIndex, parseIntIndex, 9);
                    continue block47;
                }
                case 144: {
                    stackState &= 0xFFFFFDFF;
                    stackState &= 0xFFFFDFFF;
                    this.invokeParseIntSafelyAndStore(parseIntSafelyIndex, decodeLenIndex, decodeIntIndex, 9);
                    continue block47;
                }
                case 17: {
                    this.parseDigits(assertRemainingIndex, parseIntIndex, 1, 8);
                    this.setHourType(stackState &= 0xFFFFFEFF);
                    continue block47;
                }
                case 34: {
                    this.parseTwoDigits(assertRemainingIndex, parseIntIndex, 8);
                    this.setHourType(stackState &= 0xFFFFFEFF);
                    continue block47;
                }
                case 142: {
                    stackState &= 0xFFFFFEFF;
                    this.invokeParseIntSafelyAndStore(parseIntSafelyIndex, decodeLenIndex, decodeIntIndex, 8);
                    this.setHourType(stackState &= 0xFFFFDFFF);
                    continue block47;
                }
                case 18: {
                    this.parseDigitsSub1(assertRemainingIndex, parseIntIndex, 1);
                    this.setHourType(stackState &= 0xFFFFFEFF);
                    continue block47;
                }
                case 35: {
                    this.parseDigitsSub1(assertRemainingIndex, parseIntIndex, 2);
                    this.setHourType(stackState &= 0xFFFFFEFF);
                    continue block47;
                }
                case 143: {
                    stackState &= 0xFFFFFEFF;
                    stackState &= 0xFFFFDFFF;
                    this.asm.aload(1);
                    this.asm.iload(12);
                    this.asm.iload(3);
                    this.asm.invokeStatic(parseIntSafelyIndex);
                    this.asm.lstore(13);
                    this.decodeInt(decodeIntIndex);
                    this.asm.iconst(1);
                    this.asm.isub();
                    this.asm.istore(8);
                    this.addTempToPos(decodeLenIndex);
                    this.setHourType(stackState);
                    continue block47;
                }
                case 15: {
                    stackState &= 0xFFFFFEFF;
                    this.parseDigits(assertRemainingIndex, parseIntIndex, 1, 8);
                    continue block47;
                }
                case 32: {
                    stackState &= 0xFFFFFEFF;
                    this.parseTwoDigits(assertRemainingIndex, parseIntIndex, 8);
                    continue block47;
                }
                case 140: {
                    stackState &= 0xFFFFFEFF;
                    stackState &= 0xFFFFDFFF;
                    this.invokeParseIntSafelyAndStore(parseIntSafelyIndex, decodeLenIndex, decodeIntIndex, 8);
                    continue block47;
                }
                case 16: {
                    stackState &= 0xFFFFFEFF;
                    this.parseDigitsSub1(assertRemainingIndex, parseIntIndex, 1);
                    continue block47;
                }
                case 33: {
                    stackState &= 0xFFFFFEFF;
                    this.parseDigitsSub1(assertRemainingIndex, parseIntIndex, 2);
                    continue block47;
                }
                case 141: {
                    stackState &= 0xFFFFFEFF;
                    stackState &= 0xFFFFDFFF;
                    this.asm.aload(1);
                    this.asm.iload(12);
                    this.asm.iload(3);
                    this.asm.invokeStatic(parseIntSafelyIndex);
                    this.asm.lstore(13);
                    this.decodeInt(decodeIntIndex);
                    this.asm.iconst(1);
                    this.asm.isub();
                    this.asm.istore(8);
                    this.addTempToPos(decodeLenIndex);
                    continue block47;
                }
                case 9: {
                    stackState &= 0xFFFFFFDF;
                    this.parseDigits(assertRemainingIndex, parseIntIndex, 1, 5);
                    continue block47;
                }
                case 10: {
                    stackState &= 0xFFFFFFDF;
                    this.parseTwoDigits(assertRemainingIndex, parseIntIndex, 5);
                    continue block47;
                }
                case 139: {
                    stackState &= 0xFFFFFFDF;
                    stackState &= 0xFFFFDFFF;
                    this.invokeParseIntSafelyAndStore(parseIntSafelyIndex, decodeLenIndex, decodeIntIndex, 5);
                    continue block47;
                }
                case 11: 
                case 12: {
                    stackState &= 0xFFFFDFFF;
                    this.invokeMatch(matchWeekdayIndex);
                    this.addTempToPos(decodeLenIndex);
                    continue block47;
                }
                case 36: 
                case 37: {
                    stackState &= 0xFFFFDFFF;
                    this.asm.aload(1);
                    this.asm.iload(12);
                    this.asm.iload(3);
                    this.asm.invokeStatic(parseIntSafelyIndex);
                    this.asm.lstore(13);
                    this.addTempToPos(decodeLenIndex);
                    continue block47;
                }
                case 13: 
                case 38: {
                    this.asm.iload(12);
                    this.asm.iload(3);
                    this.asm.invokeStatic(assertRemainingIndex);
                    this.asm.aload(1);
                    this.asm.iload(12);
                    this.asm.iinc(12, 1);
                    this.asm.iload(12);
                    this.asm.invokeStatic(parseIntIndex);
                    this.asm.pop();
                    continue block47;
                }
                case 5: {
                    stackState &= 0xFFFFFFBF;
                    this.parseDigits(assertRemainingIndex, parseIntIndex, 1, 6);
                    continue block47;
                }
                case 6: {
                    stackState &= 0xFFFFFFBF;
                    this.parseTwoDigits(assertRemainingIndex, parseIntIndex, 6);
                    continue block47;
                }
                case 135: {
                    stackState &= 0xFFFFFFBF;
                    stackState &= 0xFFFFDFFF;
                    this.invokeParseIntSafelyAndStore(parseIntSafelyIndex, decodeLenIndex, decodeIntIndex, 6);
                    continue block47;
                }
                case 7: 
                case 8: {
                    stackState &= 0xFFFFFFBF;
                    stackState &= 0xFFFFDFFF;
                    this.invokeMatch(matchMonthIndex);
                    this.decodeInt(decodeIntIndex);
                    this.asm.iconst(1);
                    this.asm.iadd();
                    this.asm.istore(6);
                    this.addTempToPos(decodeLenIndex);
                    continue block47;
                }
                case 2: {
                    stackState &= 0xFFFFFF7F;
                    this.parseDigits(assertRemainingIndex, parseIntIndex, 1, 7);
                    continue block47;
                }
                case 3: {
                    stackState &= 0xFFFFFF7F;
                    this.asm.iload(12);
                    this.asm.iconst(1);
                    this.asm.iadd();
                    this.asm.iload(3);
                    this.asm.invokeStatic(assertRemainingIndex);
                    this.asm.aload(1);
                    this.asm.iload(12);
                    this.asm.iinc(12, 2);
                    this.asm.iload(12);
                    this.asm.invokeStatic(parseIntIndex);
                    this.asm.invokeStatic(adjustYearIndex);
                    this.asm.istore(7);
                    continue block47;
                }
                case 148: {
                    stackState &= 0xFFFFFF7F;
                    this.asm.iload(12);
                    this.asm.iconst(2);
                    this.asm.iadd();
                    this.asm.iload(3);
                    this.asm.invokeStatic(assertRemainingIndex);
                    this.asm.aload(1);
                    this.asm.iload(12);
                    this.asm.iinc(12, 3);
                    this.asm.iload(12);
                    this.asm.invokeStatic(parseIntIndex);
                    this.asm.istore(7);
                    continue block47;
                }
                case 4: {
                    this.asm.iload(12);
                    this.asm.iload(3);
                    int b1 = this.asm.if_icmpge();
                    this.asm.aload(1);
                    this.asm.iload(12);
                    this.asm.invokeInterface(charAtIndex, 1);
                    this.asm.iconst(45);
                    int b2 = this.asm.if_icmpne();
                    this.asm.iload(12);
                    this.asm.iconst(4);
                    this.asm.iadd();
                    this.asm.iload(3);
                    this.asm.invokeStatic(assertRemainingIndex);
                    this.asm.aload(1);
                    this.asm.iload(12);
                    this.asm.iconst(1);
                    this.asm.iadd();
                    this.asm.iinc(12, 5);
                    this.asm.iload(12);
                    this.asm.invokeStatic(parseIntIndex);
                    this.asm.ineg();
                    this.asm.istore(7);
                    int b3 = this.asm.goto_();
                    int p = this.asm.position();
                    this.frameOffsets.add(Numbers.encodeLowHighInts(stackState, p));
                    this.asm.setJmp(b1, p);
                    this.asm.setJmp(b2, p);
                    this.asm.iload(12);
                    this.asm.iconst(3);
                    this.asm.iadd();
                    this.asm.iload(3);
                    this.asm.invokeStatic(assertRemainingIndex);
                    this.asm.aload(1);
                    this.asm.iload(12);
                    this.asm.iinc(12, 4);
                    this.asm.iload(12);
                    this.asm.invokeStatic(parseIntIndex);
                    this.asm.istore(7);
                    p = this.asm.position();
                    this.frameOffsets.add(Numbers.encodeLowHighInts(stackState &= 0xFFFFFF7F, p));
                    this.asm.setJmp(b3, p);
                    continue block47;
                }
                case 132: {
                    stackState &= 0xFFFFFF7F;
                    stackState &= 0xFFFFDFFF;
                    this.asm.aload(1);
                    this.asm.iload(12);
                    this.asm.iload(3);
                    this.asm.invokeStatic(parseYearGreedyIndex);
                    this.asm.lstore(13);
                    this.decodeInt(decodeIntIndex);
                    this.asm.istore(7);
                    this.addTempToPos(decodeLenIndex);
                    continue block47;
                }
                case 1: {
                    stackState &= 0xFFF7FFFF;
                    this.invokeMatch(matchEraIndex);
                    this.decodeInt(decodeIntIndex);
                    this.asm.istore(19);
                    this.addTempToPos(decodeLenIndex);
                    continue block47;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    stackState &= 0xFFFFDFFF;
                    this.asm.aload(1);
                    this.asm.iload(12);
                    this.asm.iload(3);
                    this.asm.invokeStatic(parseOffsetIndex);
                    this.asm.lstore(13);
                    this.asm.lload(13);
                    this.asm.ldc2_w(minLongIndex);
                    this.asm.lcmp();
                    int branch1 = this.asm.ifne();
                    this.invokeMatch(matchZoneIndex);
                    this.decodeInt(decodeIntIndex);
                    this.asm.istore(15);
                    int branch2 = this.asm.goto_();
                    int p = this.asm.position();
                    this.frameOffsets.add(Numbers.encodeLowHighInts(stackState, p));
                    this.asm.setJmp(branch1, p);
                    this.decodeInt(decodeIntIndex);
                    this.asm.i2l();
                    this.asm.ldc2_w(minMillisIndex);
                    this.asm.lmul();
                    this.asm.lstore(16);
                    p = this.asm.position();
                    this.frameOffsets.add(Numbers.encodeLowHighInts(stackState, p));
                    this.asm.setJmp(branch2, p);
                    this.addTempToPos(decodeLenIndex);
                    continue block47;
                }
                default: {
                    String delimiter = delimiters.getQuick(-op - 1);
                    int len = delimiter.length();
                    if (len == 1) {
                        this.asm.iconst(delimiter.charAt(0));
                        this.asm.aload(1);
                        this.asm.iload(12);
                        this.asm.iinc(12, 1);
                        this.asm.iload(3);
                        this.asm.invokeStatic(assertCharIndex);
                        continue block47;
                    }
                    this.asm.ldc(delimIndices.getQuick(-op - 1));
                    this.asm.iconst(len);
                    this.asm.aload(1);
                    this.asm.iload(12);
                    this.asm.iload(3);
                    this.asm.invokeStatic(assertStringIndex);
                    this.asm.istore(12);
                }
            }
        }
        this.asm.iload(12);
        this.asm.iload(3);
        this.asm.invokeStatic(assertNoTailIndex);
        this.asm.aload(4);
        this.asm.iload(19);
        this.asm.iload(7);
        this.asm.iload(6);
        this.asm.iload(5);
        this.asm.iload(8);
        this.asm.iload(9);
        this.asm.iload(10);
        this.asm.iload(11);
        this.asm.iload(20);
        this.asm.iload(15);
        this.asm.lload(16);
        this.asm.iload(18);
        this.asm.invokeStatic(computeMillisIndex);
        this.asm.lreturn();
        this.asm.endMethodCode();
        this.asm.putShort(0);
        int n2 = this.frameOffsets.size();
        this.asm.putShort(n2 > 0 ? 1 : 0);
        if (n2 > 0) {
            this.asm.startStackMapTables(stackMapTableIndex, n2);
            int prevStackState = 0;
            int start = this.asm.getCodeStart();
            for (int i = 0; i < n2; ++i) {
                long l = this.frameOffsets.getQuick(i);
                int offset = Numbers.decodeHighInt(l);
                int ss = Numbers.decodeLowInt(l);
                if (i == 0 || prevStackState != ss) {
                    this.asm.full_frame(offset - start);
                    int countPos = this.asm.position();
                    int count = 19;
                    this.asm.putShort(0);
                    this.asm.putITEM_Object(thisClassIndex);
                    this.asm.putITEM_Object(charSequenceClassIndex);
                    this.asm.putITEM_Integer();
                    this.asm.putITEM_Integer();
                    this.asm.putITEM_Object(dateLocaleClassIndex);
                    if ((ss & 0x20) == 0) {
                        this.asm.putITEM_Integer();
                    } else {
                        this.asm.putITEM_Top();
                    }
                    if ((ss & 0x40) == 0) {
                        this.asm.putITEM_Integer();
                    } else {
                        this.asm.putITEM_Top();
                    }
                    if ((ss & 0x80) == 0) {
                        this.asm.putITEM_Integer();
                    } else {
                        this.asm.putITEM_Top();
                    }
                    if ((ss & 0x100) == 0) {
                        this.asm.putITEM_Integer();
                    } else {
                        this.asm.putITEM_Top();
                    }
                    if ((ss & 0x200) == 0) {
                        this.asm.putITEM_Integer();
                    } else {
                        this.asm.putITEM_Top();
                    }
                    if ((ss & 0x400) == 0) {
                        this.asm.putITEM_Integer();
                    } else {
                        this.asm.putITEM_Top();
                    }
                    if ((ss & 0x800) == 0) {
                        this.asm.putITEM_Integer();
                    } else {
                        this.asm.putITEM_Top();
                    }
                    this.asm.putITEM_Integer();
                    if ((ss & 0x2000) == 0) {
                        this.asm.putITEM_Long();
                    } else {
                        this.asm.putITEM_Top();
                        this.asm.putITEM_Top();
                        ++count;
                    }
                    this.asm.putITEM_Integer();
                    this.asm.putITEM_Long();
                    this.asm.putITEM_Integer();
                    if ((ss & 0x80000) == 0) {
                        this.asm.putITEM_Integer();
                    } else {
                        this.asm.putITEM_Top();
                    }
                    if ((ss & 0x100000) == 0) {
                        this.asm.putITEM_Integer();
                    } else {
                        this.asm.putITEM_Top();
                    }
                    this.asm.putShort(countPos, count);
                    this.asm.putShort(0);
                    prevStackState = ss;
                } else {
                    this.asm.same_frame(offset - start);
                }
                start = offset + 1;
            }
            this.asm.endStackMapTables();
        }
        this.asm.endMethod();
    }

    private DateFormat compile(IntList ops, ObjList<String> delimiters) {
        this.asm.init(DateFormat.class);
        this.asm.setupPool();
        int thisClassIndex = this.asm.poolClass(this.asm.poolUtf8("io/questdb/std/datetime/TimestampFormatAsm"));
        int stackMapTableIndex = this.asm.poolUtf8("StackMapTable");
        int superclassIndex = this.asm.poolClass(AbstractDateFormat.class);
        int dateLocaleClassIndex = this.asm.poolClass(DateLocale.class);
        int charSequenceClassIndex = this.asm.poolClass(CharSequence.class);
        int minLongIndex = this.asm.poolLongConst(Long.MIN_VALUE);
        int minMillisIndex = this.asm.poolLongConst(60000000L);
        int superIndex = this.asm.poolMethod(superclassIndex, (CharSequence)"<init>", (CharSequence)"()V");
        int matchWeekdayIndex = this.asm.poolMethod(DateLocale.class, (CharSequence)"matchWeekday", (CharSequence)"(Ljava/lang/CharSequence;II)J");
        int matchMonthIndex = this.asm.poolMethod(DateLocale.class, (CharSequence)"matchMonth", (CharSequence)"(Ljava/lang/CharSequence;II)J");
        int matchZoneIndex = this.asm.poolMethod(DateLocale.class, (CharSequence)"matchZone", (CharSequence)"(Ljava/lang/CharSequence;II)J");
        int matchAMPMIndex = this.asm.poolMethod(DateLocale.class, (CharSequence)"matchAMPM", (CharSequence)"(Ljava/lang/CharSequence;II)J");
        int matchEraIndex = this.asm.poolMethod(DateLocale.class, (CharSequence)"matchEra", (CharSequence)"(Ljava/lang/CharSequence;II)J");
        int getWeekdayIndex = this.asm.poolMethod(DateLocale.class, (CharSequence)"getWeekday", (CharSequence)"(I)Ljava/lang/String;");
        int getShortWeekdayIndex = this.asm.poolMethod(DateLocale.class, (CharSequence)"getShortWeekday", (CharSequence)"(I)Ljava/lang/String;");
        int getMonthIndex = this.asm.poolMethod(DateLocale.class, (CharSequence)"getMonth", (CharSequence)"(I)Ljava/lang/String;");
        int getShortMonthIndex = this.asm.poolMethod(DateLocale.class, (CharSequence)"getShortMonth", (CharSequence)"(I)Ljava/lang/String;");
        int parseIntSafelyIndex = this.asm.poolMethod(Numbers.class, (CharSequence)"parseIntSafely", (CharSequence)"(Ljava/lang/CharSequence;II)J");
        int parseInt000GreedyIndex = this.asm.poolMethod(Numbers.class, (CharSequence)"parseInt000Greedy", (CharSequence)"(Ljava/lang/CharSequence;II)J");
        int decodeLenIndex = this.asm.poolMethod(Numbers.class, (CharSequence)"decodeHighInt", (CharSequence)"(J)I");
        int decodeIntIndex = this.asm.poolMethod(Numbers.class, (CharSequence)"decodeLowInt", (CharSequence)"(J)I");
        int parseIntIndex = this.asm.poolMethod(Numbers.class, (CharSequence)"parseInt", (CharSequence)"(Ljava/lang/CharSequence;II)I");
        int assertRemainingIndex = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"assertRemaining", (CharSequence)"(II)V");
        int assertNoTailIndex = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"assertNoTail", (CharSequence)"(II)V");
        int assertStringIndex = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"assertString", (CharSequence)"(Ljava/lang/CharSequence;ILjava/lang/CharSequence;II)I");
        int assertCharIndex = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"assertChar", (CharSequence)"(CLjava/lang/CharSequence;II)V");
        int computeMillisIndex = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"compute", (CharSequence)"(Lio/questdb/std/datetime/DateLocale;IIIIIIIIIIJI)J");
        int adjustYearIndex = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"adjustYear", (CharSequence)"(I)I");
        int parseYearGreedyIndex = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"parseYearGreedy", (CharSequence)"(Ljava/lang/CharSequence;II)J");
        int appendEraIndex = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"appendEra", (CharSequence)"(Lio/questdb/std/str/CharSink;ILio/questdb/std/datetime/DateLocale;)V");
        int appendAmPmIndex = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"appendAmPm", (CharSequence)"(Lio/questdb/std/str/CharSink;ILio/questdb/std/datetime/DateLocale;)V");
        int appendHour12Index = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"appendHour12", (CharSequence)"(Lio/questdb/std/str/CharSink;I)V");
        int appendHour12PaddedIndex = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"appendHour12Padded", (CharSequence)"(Lio/questdb/std/str/CharSink;I)V");
        int appendHour121Index = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"appendHour121", (CharSequence)"(Lio/questdb/std/str/CharSink;I)V");
        int appendHour121PaddedIndex = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"appendHour121Padded", (CharSequence)"(Lio/questdb/std/str/CharSink;I)V");
        int append00Index = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"append00", (CharSequence)"(Lio/questdb/std/str/CharSink;I)V");
        int append0Index = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"append0", (CharSequence)"(Lio/questdb/std/str/CharSink;I)V");
        int appendYear000Index = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"appendYear000", (CharSequence)"(Lio/questdb/std/str/CharSink;I)V");
        int appendYear00Index = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"appendYear00", (CharSequence)"(Lio/questdb/std/str/CharSink;I)V");
        int appendYear0Index = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"appendYear0", (CharSequence)"(Lio/questdb/std/str/CharSink;I)V");
        int appendYearIndex = this.asm.poolMethod(TimestampFormatUtils.class, (CharSequence)"appendYear", (CharSequence)"(Lio/questdb/std/str/CharSink;I)V");
        int parseOffsetIndex = this.asm.poolMethod(Timestamps.class, (CharSequence)"parseOffset", (CharSequence)"(Ljava/lang/CharSequence;II)J");
        int getYearIndex = this.asm.poolMethod(Timestamps.class, (CharSequence)"getYear", (CharSequence)"(J)I");
        int isLeapYearIndex = this.asm.poolMethod(Timestamps.class, (CharSequence)"isLeapYear", (CharSequence)"(I)Z");
        int getMonthOfYearIndex = this.asm.poolMethod(Timestamps.class, (CharSequence)"getMonthOfYear", (CharSequence)"(JIZ)I");
        int getDayOfMonthIndex = this.asm.poolMethod(Timestamps.class, (CharSequence)"getDayOfMonth", (CharSequence)"(JIIZ)I");
        int getHourOfDayIndex = this.asm.poolMethod(Timestamps.class, (CharSequence)"getHourOfDay", (CharSequence)"(J)I");
        int getMinuteOfHourIndex = this.asm.poolMethod(Timestamps.class, (CharSequence)"getMinuteOfHour", (CharSequence)"(J)I");
        int getSecondOfMinuteIndex = this.asm.poolMethod(Timestamps.class, (CharSequence)"getSecondOfMinute", (CharSequence)"(J)I");
        int getMillisOfSecondIndex = this.asm.poolMethod(Timestamps.class, (CharSequence)"getMillisOfSecond", (CharSequence)"(J)I");
        int getMicrosOfSecondIndex = this.asm.poolMethod(Timestamps.class, (CharSequence)"getMicrosOfSecond", (CharSequence)"(J)I");
        int getDayOfWeekIndex = this.asm.poolMethod(Timestamps.class, (CharSequence)"getDayOfWeekSundayFirst", (CharSequence)"(J)I");
        int getDayOfYearIndex = this.asm.poolMethod(Timestamps.class, (CharSequence)"getDayOfYear", (CharSequence)"(J)I");
        int getWeekOfYearIndex = this.asm.poolMethod(Timestamps.class, (CharSequence)"getWeekOfYear", (CharSequence)"(J)I");
        int getWeekOfMonthIndex = this.asm.poolMethod(Timestamps.class, (CharSequence)"getWeekOfMonth", (CharSequence)"(J)I");
        int sinkPutIntIndex = this.asm.poolInterfaceMethod(CharSink.class, "put", "(I)Lio/questdb/std/str/CharSink;");
        int sinkPutStrIndex = this.asm.poolInterfaceMethod(CharSink.class, "put", "(Ljava/lang/CharSequence;)Lio/questdb/std/str/CharSink;");
        int sinkPutChrIndex = this.asm.poolInterfaceMethod(CharSink.class, "put", "(C)Lio/questdb/std/str/CharSink;");
        int charAtIndex = this.asm.poolInterfaceMethod(charSequenceClassIndex, "charAt", "(I)C");
        int parseNameIndex = this.asm.poolUtf8("parse");
        int parseSigIndex = this.asm.poolUtf8("(Ljava/lang/CharSequence;IILio/questdb/std/datetime/DateLocale;)J");
        int formatNameIndex = this.asm.poolUtf8("format");
        int formatSigIndex = this.asm.poolUtf8("(JLio/questdb/std/datetime/DateLocale;Ljava/lang/CharSequence;Lio/questdb/std/str/CharSink;)V");
        this.delimiterIndexes.clear();
        int n = delimiters.size();
        for (int i = 0; i < n; ++i) {
            String delimiter = delimiters.getQuick(i);
            if (delimiter.length() > 1) {
                this.delimiterIndexes.add(this.asm.poolStringConst(this.asm.poolUtf8(delimiter)));
                continue;
            }
            this.delimiterIndexes.add(-1);
        }
        this.asm.finishPool();
        this.asm.defineClass(thisClassIndex, superclassIndex);
        this.asm.interfaceCount(0);
        this.asm.fieldCount(0);
        this.asm.methodCount(3);
        this.asm.defineDefaultConstructor(superIndex);
        this.assembleParseMethod(ops, delimiters, thisClassIndex, stackMapTableIndex, dateLocaleClassIndex, charSequenceClassIndex, minLongIndex, minMillisIndex, matchWeekdayIndex, matchMonthIndex, matchZoneIndex, matchAMPMIndex, matchEraIndex, parseIntSafelyIndex, parseInt000GreedyIndex, decodeLenIndex, decodeIntIndex, assertRemainingIndex, assertNoTailIndex, parseIntIndex, assertStringIndex, assertCharIndex, computeMillisIndex, adjustYearIndex, parseYearGreedyIndex, parseOffsetIndex, parseNameIndex, parseSigIndex, this.delimiterIndexes, charAtIndex);
        this.assembleFormatMethod(ops, delimiters, getWeekdayIndex, getShortWeekdayIndex, getMonthIndex, getShortMonthIndex, appendEraIndex, appendAmPmIndex, appendHour12Index, appendHour12PaddedIndex, appendHour121Index, appendHour121PaddedIndex, getYearIndex, isLeapYearIndex, getMonthOfYearIndex, getDayOfMonthIndex, getHourOfDayIndex, getMinuteOfHourIndex, getSecondOfMinuteIndex, getMillisOfSecondIndex, getMicrosOfSecondIndex, getDayOfWeekIndex, append00Index, append0Index, appendYear000Index, appendYear00Index, appendYear0Index, appendYearIndex, sinkPutIntIndex, sinkPutStrIndex, sinkPutChrIndex, formatNameIndex, formatSigIndex, getDayOfYearIndex, getWeekOfMonthIndex, getWeekOfYearIndex);
        this.asm.putShort(0);
        return (DateFormat)this.asm.newInstance();
    }

    private int computeFormatAttributes(IntList ops) {
        int attributes = 0;
        int n = ops.size();
        block16: for (int i = 0; i < n; ++i) {
            switch (ops.getQuick(i)) {
                case 14: {
                    attributes |= 0x10;
                    continue block16;
                }
                case 39: 
                case 49: 
                case 149: {
                    attributes |= 0x800;
                    continue block16;
                }
                case 21: 
                case 31: 
                case 146: {
                    attributes |= 2;
                    continue block16;
                }
                case 20: 
                case 30: 
                case 145: {
                    attributes |= 4;
                    continue block16;
                }
                case 19: 
                case 29: 
                case 144: {
                    attributes |= 8;
                    continue block16;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 140: 
                case 141: 
                case 142: 
                case 143: {
                    attributes |= 0x10;
                    continue block16;
                }
                case 9: 
                case 10: 
                case 139: {
                    attributes |= 0x20;
                    attributes |= 0x40;
                    attributes |= 0x80;
                    attributes |= 0x100;
                    continue block16;
                }
                case 11: 
                case 12: 
                case 13: {
                    attributes |= 0x400;
                    continue block16;
                }
                case 36: {
                    attributes |= 0x4000;
                    continue block16;
                }
                case 37: {
                    attributes |= 0x1000;
                    continue block16;
                }
                case 38: {
                    attributes |= 0x2000;
                    continue block16;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 135: {
                    attributes |= 0x40;
                    attributes |= 0x80;
                    attributes |= 0x100;
                    continue block16;
                }
                case 2: 
                case 3: 
                case 4: 
                case 132: 
                case 148: {
                    attributes |= 0x80;
                    continue block16;
                }
                case 1: {
                    attributes |= 0x80;
                    continue block16;
                }
            }
        }
        return attributes;
    }

    private int computeParseMethodStack(IntList ops) {
        int result = 0;
        int n = ops.size();
        block22: for (int i = 0; i < n; ++i) {
            switch (ops.getQuick(i)) {
                case 14: {
                    result |= 0x2000;
                    continue block22;
                }
                case 149: {
                    result |= 0x2000;
                }
                case 39: 
                case 49: {
                    result |= 0x100000;
                    continue block22;
                }
                case 146: {
                    result |= 0x2000;
                }
                case 21: 
                case 31: {
                    result |= 0x800;
                    continue block22;
                }
                case 145: {
                    result |= 0x2000;
                }
                case 20: 
                case 30: {
                    result |= 0x400;
                    continue block22;
                }
                case 144: {
                    result |= 0x2000;
                }
                case 19: 
                case 29: {
                    result |= 0x200;
                    continue block22;
                }
                case 140: 
                case 141: 
                case 142: 
                case 143: {
                    result |= 0x2000;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    result |= 0x100;
                    continue block22;
                }
                case 139: {
                    result |= 0x2000;
                }
                case 9: 
                case 10: {
                    result |= 0x20;
                    continue block22;
                }
                case 11: 
                case 12: {
                    result |= 0x2000;
                    continue block22;
                }
                case 7: 
                case 8: 
                case 135: {
                    result |= 0x2000;
                }
                case 5: 
                case 6: {
                    result |= 0x40;
                    continue block22;
                }
                case 132: {
                    result |= 0x2000;
                }
                case 2: 
                case 3: 
                case 4: 
                case 148: {
                    result |= 0x80;
                    continue block22;
                }
                case 1: {
                    result |= 0x80000;
                    continue block22;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    result |= 0x2000;
                    continue block22;
                }
            }
        }
        return result;
    }

    private void decodeInt(int decodeIntIndex) {
        this.asm.lload(13);
        this.asm.invokeStatic(decodeIntIndex);
    }

    private boolean invokeConvertMillis(int formatAttributes, int bit, int funcIndex, int stackIndex) {
        if ((formatAttributes & 1 << bit) != 0) {
            this.asm.lload(1);
            this.asm.invokeStatic(funcIndex);
            this.asm.istore(stackIndex);
            return true;
        }
        return false;
    }

    private void invokeMatch(int matchIndex) {
        this.asm.aload(4);
        this.asm.aload(1);
        this.asm.iload(12);
        this.asm.iload(3);
        this.asm.invokeVirtual(matchIndex);
        this.asm.lstore(13);
    }

    private void invokeParseIntSafelyAndStore(int parseIntSafelyIndex, int decodeLenIndex, int decodeIntIndex, int target) {
        this.asm.aload(1);
        this.asm.iload(12);
        this.asm.iload(3);
        this.asm.invokeStatic(parseIntSafelyIndex);
        this.asm.lstore(13);
        this.decodeInt(decodeIntIndex);
        if (target > -1) {
            this.asm.istore(target);
        } else {
            this.asm.pop();
        }
        this.addTempToPos(decodeLenIndex);
    }

    private int makeGreedy(int oldOp) {
        switch (oldOp) {
            case 2: {
                return 132;
            }
            case 5: {
                return 135;
            }
            case 9: {
                return 139;
            }
            case 15: {
                return 140;
            }
            case 16: {
                return 141;
            }
            case 17: {
                return 142;
            }
            case 18: {
                return 143;
            }
            case 19: {
                return 144;
            }
            case 20: {
                return 145;
            }
            case 21: {
                return 146;
            }
            case 39: {
                return 149;
            }
            case 40: {
                return 147;
            }
        }
        return oldOp;
    }

    private void makeLastOpGreedy(IntList compiled) {
        int newOp;
        int oldOp;
        int lastOpIndex = compiled.size() - 1;
        if (lastOpIndex > -1 && (oldOp = compiled.getQuick(lastOpIndex)) > 0 && (newOp = this.makeGreedy(oldOp)) != oldOp) {
            compiled.setQuick(lastOpIndex, newOp);
        }
    }

    private void parseDigits(int assertRemainingIndex, int parseIntIndex, int digitCount, int target) {
        this.asm.iload(12);
        if (digitCount > 1) {
            this.asm.iconst(digitCount - 1);
            this.asm.iadd();
        }
        this.asm.iload(3);
        this.asm.invokeStatic(assertRemainingIndex);
        this.asm.aload(1);
        this.asm.iload(12);
        this.asm.iinc(12, digitCount);
        this.asm.iload(12);
        this.asm.invokeStatic(parseIntIndex);
        if (target > -1) {
            this.asm.istore(target);
        } else {
            this.asm.pop();
        }
    }

    private void parseDigitsSub1(int assertRemainingIndex, int parseIntIndex, int digitCount) {
        this.asm.iload(12);
        if (digitCount > 1) {
            this.asm.iconst(digitCount - 1);
            this.asm.iadd();
        }
        this.asm.iload(3);
        this.asm.invokeStatic(assertRemainingIndex);
        this.asm.aload(1);
        this.asm.iload(12);
        this.asm.iinc(12, digitCount);
        this.asm.iload(12);
        this.asm.invokeStatic(parseIntIndex);
        this.asm.iconst(1);
        this.asm.isub();
        this.asm.istore(8);
    }

    private void parseTwoDigits(int assertRemainingIndex, int parseIntIndex, int target) {
        this.parseDigits(assertRemainingIndex, parseIntIndex, 2, target);
    }

    private void setHourType(int stackState) {
        this.asm.iload(18);
        this.asm.iconst(2);
        int branch = this.asm.if_icmpne();
        this.asm.iconst(0);
        this.asm.istore(18);
        int p = this.asm.position();
        this.frameOffsets.add(Numbers.encodeLowHighInts(stackState, p));
        this.asm.setJmp(branch, p);
    }

    static {
        TimestampFormatCompiler.addOp("G", 1);
        TimestampFormatCompiler.addOp("y", 2);
        TimestampFormatCompiler.addOp("yy", 3);
        TimestampFormatCompiler.addOp("yyy", 148);
        TimestampFormatCompiler.addOp("yyyy", 4);
        TimestampFormatCompiler.addOp("M", 5);
        TimestampFormatCompiler.addOp("MM", 6);
        TimestampFormatCompiler.addOp("MMM", 7);
        TimestampFormatCompiler.addOp("MMMM", 8);
        TimestampFormatCompiler.addOp("d", 9);
        TimestampFormatCompiler.addOp("dd", 10);
        TimestampFormatCompiler.addOp("E", 11);
        TimestampFormatCompiler.addOp("EE", 12);
        TimestampFormatCompiler.addOp("u", 13);
        TimestampFormatCompiler.addOp("D", 36);
        TimestampFormatCompiler.addOp("w", 37);
        TimestampFormatCompiler.addOp("W", 38);
        TimestampFormatCompiler.addOp("a", 14);
        TimestampFormatCompiler.addOp("H", 15);
        TimestampFormatCompiler.addOp("HH", 32);
        TimestampFormatCompiler.addOp("k", 16);
        TimestampFormatCompiler.addOp("kk", 33);
        TimestampFormatCompiler.addOp("K", 17);
        TimestampFormatCompiler.addOp("KK", 34);
        TimestampFormatCompiler.addOp("h", 18);
        TimestampFormatCompiler.addOp("hh", 35);
        TimestampFormatCompiler.addOp("m", 19);
        TimestampFormatCompiler.addOp("mm", 29);
        TimestampFormatCompiler.addOp("s", 20);
        TimestampFormatCompiler.addOp("ss", 30);
        TimestampFormatCompiler.addOp("S", 21);
        TimestampFormatCompiler.addOp("SSS", 31);
        TimestampFormatCompiler.addOp("N", 40);
        TimestampFormatCompiler.addOp("NNN", 50);
        TimestampFormatCompiler.addOp("z", 23);
        TimestampFormatCompiler.addOp("zz", 22);
        TimestampFormatCompiler.addOp("zzz", 24);
        TimestampFormatCompiler.addOp("Z", 25);
        TimestampFormatCompiler.addOp("x", 26);
        TimestampFormatCompiler.addOp("xx", 27);
        TimestampFormatCompiler.addOp("merge_copy_var_column", 28);
        TimestampFormatCompiler.addOp("U", 39);
        TimestampFormatCompiler.addOp("UUU", 49);
    }
}

