/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.datetime;

import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.FixedTimeZoneRule;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.microtime.TimeZoneRulesMicros;
import io.questdb.std.datetime.millitime.Dates;
import io.questdb.std.datetime.millitime.TimeZoneRulesMillis;
import java.time.ZoneId;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesProvider;
import java.util.Map;

public class TimeZoneRuleFactory {
    public static final int RESOLUTION_MILLIS = 0;
    public static final int RESOLUTION_MICROS = 1;
    public static final TimeZoneRuleFactory INSTANCE = new TimeZoneRuleFactory();
    private final CharSequenceIntHashMap ruleMap = new CharSequenceIntHashMap();
    private final ObjList<TimeZoneRules> ruleList = new ObjList();

    public TimeZoneRuleFactory() {
        int index = 0;
        for (String string : ZoneRulesProvider.getAvailableZoneIds()) {
            ZoneRules rules = ZoneRulesProvider.getRules(string, true);
            this.ruleList.add(new TimeZoneRulesMillis(rules));
            this.ruleList.add(new TimeZoneRulesMicros(rules));
            this.ruleMap.put(string, index++);
        }
        for (Map.Entry entry : ZoneId.SHORT_IDS.entrySet()) {
            String key = (String)entry.getKey();
            String alias = (String)entry.getValue();
            int i = this.ruleMap.get(key);
            if (i != -1) continue;
            i = this.ruleMap.get(alias);
            if (i == -1) {
                long offset = Dates.parseOffset(alias, 0, alias.length());
                if (offset == Long.MIN_VALUE) continue;
                this.ruleList.add(new FixedTimeZoneRule((long)Numbers.decodeLowInt(offset) * 60000L));
                this.ruleList.add(new FixedTimeZoneRule((long)Numbers.decodeLowInt(offset) * 60000000L));
                this.ruleMap.put(key, index++);
                continue;
            }
            this.ruleMap.put(key, i);
        }
    }

    public int getTimeZoneRulesIndex(CharSequence id) {
        return this.ruleMap.get(id);
    }

    public TimeZoneRules getTimeZoneRulesQuick(int index, int resolution) {
        return this.ruleList.getQuick(2 * index + resolution);
    }
}

