/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.datetime;

import io.questdb.std.LongList;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.TransitionRule;
import java.time.ZoneOffset;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneRules;

public abstract class AbstractTimeZoneRules
implements TimeZoneRules {
    public static final long SAVING_INSTANT_TRANSITION = Unsafe.getFieldOffset(ZoneRules.class, "savingsInstantTransitions");
    public static final long STANDARD_OFFSETS = Unsafe.getFieldOffset(ZoneRules.class, "standardOffsets");
    public static final long LAST_RULES = Unsafe.getFieldOffset(ZoneRules.class, "lastRules");
    public static final long WALL_OFFSETS = Unsafe.getFieldOffset(ZoneRules.class, "wallOffsets");
    private final long cutoffTransition;
    private final LongList historicTransitions = new LongList();
    private final ObjList<TransitionRule> rules;
    private final int ruleCount;
    private final int[] wallOffsets;
    private final long firstWall;
    private final long lastWall;
    private final long standardOffset;
    private final long multiplier;

    public AbstractTimeZoneRules(ZoneRules rules, long multiplier) {
        this.multiplier = multiplier;
        long[] savingsInstantTransition = (long[])Unsafe.getUnsafe().getObject(rules, SAVING_INSTANT_TRANSITION);
        if (savingsInstantTransition.length == 0) {
            ZoneOffset[] standardOffsets = (ZoneOffset[])Unsafe.getUnsafe().getObject(rules, STANDARD_OFFSETS);
            this.standardOffset = (long)standardOffsets[0].getTotalSeconds() * multiplier;
        } else {
            this.standardOffset = Long.MIN_VALUE;
            int n = savingsInstantTransition.length;
            for (int i = 0; i < n; ++i) {
                this.historicTransitions.add(savingsInstantTransition[i] * multiplier);
            }
        }
        this.cutoffTransition = this.historicTransitions.getLast();
        ZoneOffsetTransitionRule[] lastRules = (ZoneOffsetTransitionRule[])Unsafe.getUnsafe().getObject(rules, LAST_RULES);
        this.rules = new ObjList(lastRules.length);
        int n = lastRules.length;
        for (int i = 0; i < n; ++i) {
            ZoneOffsetTransitionRule zr = lastRules[i];
            TransitionRule tr = new TransitionRule();
            tr.offsetBefore = zr.getOffsetBefore().getTotalSeconds();
            tr.offsetAfter = zr.getOffsetAfter().getTotalSeconds();
            tr.standardOffset = zr.getStandardOffset().getTotalSeconds();
            tr.dow = zr.getDayOfWeek() == null ? -1 : zr.getDayOfWeek().getValue();
            tr.dom = zr.getDayOfMonthIndicator();
            tr.month = zr.getMonth().getValue();
            tr.midnightEOD = zr.isMidnightEndOfDay();
            tr.hour = zr.getLocalTime().getHour();
            tr.minute = zr.getLocalTime().getMinute();
            tr.second = zr.getLocalTime().getSecond();
            switch (zr.getTimeDefinition()) {
                case UTC: {
                    tr.timeDef = 0;
                    break;
                }
                case STANDARD: {
                    tr.timeDef = 1;
                    break;
                }
                default: {
                    tr.timeDef = 2;
                }
            }
            this.rules.add(tr);
        }
        this.ruleCount = lastRules.length;
        ZoneOffset[] wallOffsets = (ZoneOffset[])Unsafe.getUnsafe().getObject(rules, WALL_OFFSETS);
        this.wallOffsets = new int[wallOffsets.length];
        int n2 = wallOffsets.length;
        for (int i = 0; i < n2; ++i) {
            this.wallOffsets[i] = wallOffsets[i].getTotalSeconds();
        }
        this.firstWall = (long)this.wallOffsets[0] * multiplier;
        this.lastWall = (long)this.wallOffsets[wallOffsets.length - 1] * multiplier;
    }

    @Override
    public long getOffset(long utcEpoch, int year, boolean leap) {
        if (this.standardOffset != Long.MIN_VALUE) {
            return this.standardOffset;
        }
        if (this.ruleCount > 0 && utcEpoch > this.cutoffTransition) {
            return this.offsetFromRules(utcEpoch, year, leap);
        }
        if (utcEpoch > this.cutoffTransition) {
            return this.lastWall;
        }
        return this.offsetFromHistory(utcEpoch);
    }

    @Override
    public long getOffset(long utcEpoch) {
        int y = this.getYear(utcEpoch);
        return this.getOffset(utcEpoch, y, this.isLeapYear(y));
    }

    @Override
    public long getNextDST(long utcEpoch, int year, boolean leap) {
        if (this.standardOffset != Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        if (this.ruleCount > 0 && utcEpoch >= this.cutoffTransition) {
            return this.dstFromRules(utcEpoch, year, leap);
        }
        if (utcEpoch < this.cutoffTransition) {
            return this.dstFromHistory(utcEpoch);
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long getNextDST(long utcEpoch) {
        int y = this.getYear(utcEpoch);
        return this.getNextDST(utcEpoch, y, this.isLeapYear(y));
    }

    protected abstract long addDays(long var1, int var3);

    private long dstFromHistory(long epoch) {
        int index = this.historicTransitions.binarySearch(epoch, -1);
        if (index == -1) {
            return Long.MAX_VALUE;
        }
        if (index < 0) {
            index = -index - 2;
        }
        return this.historicTransitions.getQuick(index + 1);
    }

    private long dstFromRules(long epoch, int year, boolean leap) {
        for (int i = 0; i < this.ruleCount; ++i) {
            long date = this.getDSTFromRule(year, leap, i);
            if (epoch >= date) continue;
            return date;
        }
        if (this.ruleCount > 0) {
            return this.getDSTFromRule(year + 1, this.isLeapYear(year + 1), 0);
        }
        return Long.MAX_VALUE;
    }

    private long getDSTFromRule(int year, boolean leap, int i) {
        long date;
        TransitionRule zr = this.rules.getQuick(i);
        int offsetBefore = zr.offsetBefore;
        int dom = zr.dom;
        int month = zr.month;
        int dow = zr.dow;
        if (dom < 0) {
            date = this.toEpoch(year, leap, month, this.getDaysPerMonth(month, leap) + 1 + dom, zr.hour, zr.minute) + (long)zr.second * this.multiplier;
            if (dow > -1) {
                date = this.previousOrSameDayOfWeek(date, dow);
            }
        } else {
            assert (month > 0);
            date = this.toEpoch(year, leap, month, dom, zr.hour, zr.minute) + (long)zr.second * this.multiplier;
            if (dow > -1) {
                date = this.nextOrSameDayOfWeek(date, dow);
            }
        }
        if (zr.midnightEOD) {
            date = this.addDays(date, 1);
        }
        switch (zr.timeDef) {
            case 0: {
                date += (long)(offsetBefore - ZoneOffset.UTC.getTotalSeconds()) * this.multiplier;
                break;
            }
            case 1: {
                date += (long)(offsetBefore - zr.standardOffset) * this.multiplier;
                break;
            }
        }
        return date -= (long)offsetBefore * this.multiplier;
    }

    protected abstract int getDaysPerMonth(int var1, boolean var2);

    protected abstract int getYear(long var1);

    protected abstract boolean isLeapYear(int var1);

    protected abstract long nextOrSameDayOfWeek(long var1, int var3);

    private long offsetFromHistory(long epoch) {
        int index = this.historicTransitions.binarySearch(epoch, -1);
        if (index == -1) {
            return this.firstWall;
        }
        if (index < 0) {
            index = -index - 2;
        }
        return (long)this.wallOffsets[index + 1] * this.multiplier;
    }

    private long offsetFromRules(long epoch, int year, boolean leap) {
        int offsetAfter = 0;
        for (int i = 0; i < this.ruleCount; ++i) {
            long date;
            TransitionRule zr = this.rules.getQuick(i);
            int offsetBefore = zr.offsetBefore;
            offsetAfter = zr.offsetAfter;
            int dom = zr.dom;
            int month = zr.month;
            int dow = zr.dow;
            if (dom < 0) {
                date = this.toEpoch(year, leap, month, this.getDaysPerMonth(month, leap) + 1 + dom, zr.hour, zr.minute) + (long)zr.second * this.multiplier;
                if (dow > -1) {
                    date = this.previousOrSameDayOfWeek(date, dow);
                }
            } else {
                assert (month > 0);
                date = this.toEpoch(year, leap, month, dom, zr.hour, zr.minute) + (long)zr.second * this.multiplier;
                if (dow > -1) {
                    date = this.nextOrSameDayOfWeek(date, dow);
                }
            }
            if (zr.midnightEOD) {
                date = this.addDays(date, 1);
            }
            switch (zr.timeDef) {
                case 0: {
                    date += (long)(offsetBefore - ZoneOffset.UTC.getTotalSeconds()) * this.multiplier;
                    break;
                }
                case 1: {
                    date += (long)(offsetBefore - zr.standardOffset) * this.multiplier;
                    break;
                }
            }
            if (epoch >= (date -= (long)offsetBefore * this.multiplier)) continue;
            return (long)offsetBefore * this.multiplier;
        }
        return (long)offsetAfter * this.multiplier;
    }

    protected abstract long previousOrSameDayOfWeek(long var1, int var3);

    protected abstract long toEpoch(int var1, boolean var2, int var3, int var4, int var5, int var6);
}

