/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Misc;
import io.questdb.std.ObjectFactory;
import io.questdb.std.WeakObjectPoolBase;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class WeakClosableObjectPool<T extends Closeable>
extends WeakObjectPoolBase<T>
implements Closeable {
    private final ObjectFactory<T> factory;

    public WeakClosableObjectPool(@NotNull ObjectFactory<T> factory, int initSize) {
        super(initSize);
        this.factory = factory;
        this.fill();
    }

    @Override
    public boolean push(T obj) {
        return super.push(obj);
    }

    @Override
    public void close() {
        while (this.cache.size() > 0) {
            Misc.free(this.cache.pop());
        }
    }

    @Override
    void close(T obj) {
        Misc.free(obj);
    }

    @Override
    T newInstance() {
        return (T)((Closeable)this.factory.newInstance());
    }
}

