/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Mutable;
import io.questdb.std.ReadOnlyObjList;
import io.questdb.std.Sinkable;
import io.questdb.std.str.CharSink;
import java.util.Arrays;
import java.util.Comparator;

public class ObjList<T>
implements Mutable,
Sinkable,
ReadOnlyObjList<T> {
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private T[] buffer;
    private int pos = 0;

    public ObjList() {
        this.buffer = new Object[16];
    }

    public ObjList(ObjList<? extends T> other) {
        this.buffer = new Object[Math.max(other.size(), 16)];
        this.setPos(other.size());
        System.arraycopy(other.buffer, 0, this.buffer, 0, this.pos);
    }

    public ObjList(T ... other) {
        this.buffer = new Object[Math.max(other.length, 16)];
        this.setPos(other.length);
        System.arraycopy(other, 0, this.buffer, 0, this.pos);
    }

    public ObjList(int capacity) {
        this.buffer = new Object[Math.max(capacity, 16)];
    }

    public void add(T value) {
        this.ensureCapacity(this.pos + 1);
        this.buffer[this.pos++] = value;
    }

    public void addAll(ObjList<T> that) {
        int n = that.size();
        this.ensureCapacity(this.pos + n);
        for (int i = 0; i < n; ++i) {
            this.buffer[this.pos++] = that.getQuick(i);
        }
    }

    @Override
    public void clear() {
        if (this.pos > 0) {
            Arrays.fill(this.buffer, null);
        }
        this.pos = 0;
    }

    public void ensureCapacity(int capacity) {
        int l = this.buffer.length;
        if (capacity > l) {
            int newCap = Math.max(l << 1, capacity);
            Object[] buf = new Object[newCap];
            System.arraycopy(this.buffer, 0, buf, 0, l);
            this.buffer = buf;
        }
    }

    public void extendAndSet(int index, T value) {
        this.ensureCapacity(index + 1);
        if (index >= this.pos) {
            this.pos = index + 1;
        }
        this.buffer[index] = value;
    }

    public void extendPos(int capacity) {
        this.ensureCapacity(capacity);
        this.pos = Math.max(this.pos, capacity);
    }

    @Override
    public T get(int index) {
        if (index < this.pos) {
            return this.buffer[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public T getAndSetQuick(int index, T value) {
        assert (index < this.pos);
        T v = this.buffer[index];
        this.buffer[index] = value;
        return v;
    }

    @Override
    public T getLast() {
        if (this.pos > 0) {
            return this.buffer[this.pos - 1];
        }
        return null;
    }

    @Override
    public T getQuick(int index) {
        assert (index < this.pos);
        return this.buffer[index];
    }

    @Override
    public T getQuiet(int index) {
        if (index < this.pos) {
            return this.buffer[index];
        }
        return null;
    }

    public int hashCode() {
        int hashCode = 1;
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            T o = this.getQuick(i);
            hashCode = 31 * hashCode + (o == null ? 0 : o.hashCode());
        }
        return hashCode;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof ObjList && this.equals((ObjList)that);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.setLength(0);
        b.append('[');
        int k = this.size();
        for (int i = 0; i < k; ++i) {
            if (i > 0) {
                b.append(',');
            }
            b.append(this.getQuick(i));
        }
        b.append(']');
        return b.toString();
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            return this.indexOfNull();
        }
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            if (!o.equals(this.getQuick(i))) continue;
            return i;
        }
        return -1;
    }

    public void insert(int index, int length, T defaultValue) {
        this.ensureCapacity(this.pos + length);
        if (this.pos > index) {
            System.arraycopy(this.buffer, index, this.buffer, index + length, this.pos - index);
        }
        Arrays.fill(this.buffer, index, index + length, defaultValue);
        this.pos += length;
    }

    public void remove(int index) {
        if (this.pos < 1 || index >= this.pos) {
            return;
        }
        int move = this.pos - index - 1;
        if (move > 0) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, move);
        }
        this.buffer[--this.pos] = null;
    }

    public void remove(int from, int to) {
        assert (from <= to);
        int move = this.pos - from - (to - from) - 1;
        if (move > 0) {
            System.arraycopy(this.buffer, to + 1, this.buffer, from, move);
        }
        this.pos = Math.max(0, this.pos - (to - from + 1));
        Arrays.fill(this.buffer, this.pos, this.buffer.length - 1, null);
    }

    public int remove(Object o) {
        if (this.pos == 0) {
            return -1;
        }
        int index = this.indexOf(o);
        if (index > -1) {
            this.remove(index);
            return index;
        }
        return -1;
    }

    public void set(int from, int to, T value) {
        Arrays.fill(this.buffer, from, Math.min(this.buffer.length, to), value);
    }

    public void set(int index, T value) {
        this.buffer[index] = value;
    }

    public void setAll(int capacity, T value) {
        this.ensureCapacity(capacity);
        this.pos = capacity;
        Arrays.fill(this.buffer, value);
    }

    public void setPos(int capacity) {
        this.ensureCapacity(capacity);
        this.pos = capacity;
    }

    public void setQuick(int index, T value) {
        assert (index < this.pos);
        this.buffer[index] = value;
    }

    @Override
    public int size() {
        return this.pos;
    }

    public void sort(Comparator<T> cmp) {
        this.sort(0, this.pos, cmp);
    }

    public void sort(int from, int to, Comparator<T> cmp) {
        Arrays.sort(this.buffer, from, to, cmp);
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('[');
        int k = this.size();
        for (int i = 0; i < k; ++i) {
            T obj;
            if (i > 0) {
                sink.put(',');
            }
            if ((obj = this.getQuick(i)) instanceof Sinkable) {
                sink.put((Sinkable)obj);
                continue;
            }
            if (obj == null) {
                sink.put("null");
                continue;
            }
            sink.put(obj.toString());
        }
        sink.put(']');
    }

    private boolean equals(ObjList<?> that) {
        if (this.pos == that.pos) {
            int n = this.pos;
            for (int i = 0; i < n; ++i) {
                T lhs = this.getQuick(i);
                if (!(lhs == null ? that.getQuick(i) != null : !lhs.equals(that.getQuick(i)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private int indexOfNull() {
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            if (null != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }
}

