/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ThreadLocal;
import io.questdb.std.ex.FatalError;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;

public final class Misc {
    public static final String EOL = "\r\n";
    public static final int CACHE_LINE_SIZE = 64;
    private static final ThreadLocal<StringSink> tlBuilder = new ThreadLocal<StringSink>(StringSink::new);

    private Misc() {
    }

    public static <T> T free(T object) {
        if (object instanceof Closeable) {
            try {
                ((Closeable)object).close();
            }
            catch (IOException e) {
                throw new FatalError(e);
            }
        }
        return null;
    }

    public static StringSink getThreadLocalBuilder() {
        StringSink b = tlBuilder.get();
        b.clear();
        return b;
    }

    public static <T> void freeObjList(ObjList<T> list) {
        if (list != null) {
            Misc.freeObjList0(list);
        }
    }

    public static int[] getWorkerAffinity(int workerCount) {
        int[] res = new int[workerCount];
        Arrays.fill(res, -1);
        return res;
    }

    private static <T> void freeObjList0(ObjList<T> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.setQuick(i, Misc.free(list.getQuick(i)));
        }
    }

    public static <T> void freeObjListAndClear(ObjList<T> list) {
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Misc.free(list.getQuick(i));
            }
            list.clear();
        }
    }

    public static <T> void free(T[] list) {
        if (list != null) {
            int n = list.length;
            for (int i = 0; i < n; ++i) {
                list[i] = Misc.free(list[i]);
            }
        }
    }

    public static <T> void freeObjListAndKeepObjects(ObjList<T> list) {
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Misc.free(list.getQuick(i));
            }
        }
    }

    public static void clearObjList(ObjList<? extends Mutable> args) {
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            Mutable m = args.getQuick(i);
            if (m == null) continue;
            m.clear();
        }
    }
}

