/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractLowerCaseCharSequenceHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Numbers;
import java.util.Arrays;
import java.util.Objects;

public class LowerCaseCharSequenceObjHashMap<T>
extends AbstractLowerCaseCharSequenceHashMap {
    private T[] values;

    public LowerCaseCharSequenceObjHashMap() {
        this(8);
    }

    public LowerCaseCharSequenceObjHashMap(int initialCapacity) {
        this(initialCapacity, 0.5);
    }

    public LowerCaseCharSequenceObjHashMap(int initialCapacity, double loadFactor) {
        super(initialCapacity, loadFactor);
        this.values = new Object[this.keys.length];
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.values, null);
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = noEntryKey;
        this.values[index] = null;
    }

    public T get(CharSequence key) {
        return this.valueAt(this.keyIndex(key));
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }

    public boolean put(CharSequence key, T value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public boolean putAt(int index, CharSequence key, T value) {
        if (index < 0) {
            this.values[-index - 1] = value;
            return false;
        }
        this.putAt0(index, key, value);
        return true;
    }

    public void putIfAbsent(CharSequence key, T value) {
        int index = this.keyIndex(key);
        if (index > -1) {
            this.putAt0(index, key, value);
        }
    }

    public T valueAt(int index) {
        return index < 0 ? (T)this.valueAtQuick(index) : null;
    }

    public T valueAtQuick(int index) {
        return this.values[-index - 1];
    }

    private void putAt0(int index, CharSequence key, T value) {
        this.values[index] = value;
        this.putAt0(index, key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LowerCaseCharSequenceObjHashMap that = (LowerCaseCharSequenceObjHashMap)o;
        if (this.size() != that.size()) {
            return false;
        }
        for (CharSequence key : this.keys) {
            T thatValue;
            if (key == null) continue;
            if (that.excludes(key)) {
                return false;
            }
            T value = this.get(key);
            if (value == null || Objects.equals(value, thatValue = that.get(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        int n = this.keys.length;
        for (int i = 0; i < n; ++i) {
            if (this.keys[i] == noEntryKey) continue;
            hashCode += Chars.hashCode(this.keys[i]) ^ Objects.hashCode(this.values[i]);
        }
        return hashCode;
    }

    @Override
    protected void rehash() {
        int newCapacity;
        int size = this.size();
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int arrayCapacity = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        T[] oldValues = this.values;
        CharSequence[] oldKeys = this.keys;
        this.keys = new CharSequence[arrayCapacity];
        this.values = new Object[arrayCapacity];
        Arrays.fill(this.keys, null);
        this.mask = arrayCapacity - 1;
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            CharSequence key = oldKeys[i];
            if (key == null) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.values[index] = oldValues[i];
        }
    }

    public void putAll(LowerCaseCharSequenceObjHashMap<T> other) {
        CharSequence[] otherKeys = other.keys;
        T[] otherValues = other.values;
        int n = otherKeys.length;
        for (int i = 0; i < n; ++i) {
            if (otherKeys[i] == noEntryKey) continue;
            this.put(otherKeys[i], otherValues[i]);
        }
    }
}

