/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractLowerCaseCharSequenceHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Numbers;
import java.util.Arrays;

public class LowerCaseCharSequenceIntHashMap
extends AbstractLowerCaseCharSequenceHashMap {
    private static final int NO_ENTRY_VALUE = -1;
    private final int noEntryValue;
    private int[] values;

    public LowerCaseCharSequenceIntHashMap() {
        this(8);
    }

    public LowerCaseCharSequenceIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.5, -1);
    }

    public LowerCaseCharSequenceIntHashMap(int initialCapacity, double loadFactor, int noEntryValue) {
        super(initialCapacity, loadFactor);
        this.noEntryValue = noEntryValue;
        this.values = new int[this.keys.length];
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.values, this.noEntryValue);
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = noEntryKey;
        this.values[index] = this.noEntryValue;
    }

    public int valueAt(int index) {
        return index < 0 ? this.values[-index - 1] : this.noEntryValue;
    }

    public int get(CharSequence key) {
        return this.valueAt(this.keyIndex(key));
    }

    public boolean put(CharSequence key, int value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public boolean putAt(int index, CharSequence key, int value) {
        if (index < 0) {
            this.values[-index - 1] = value;
            return false;
        }
        String keyString = Chars.toString(key);
        this.putAt0(index, keyString, value);
        return true;
    }

    public boolean putIfAbsent(CharSequence key, int value) {
        int index = this.keyIndex(key);
        if (index > -1) {
            String keyStr = Chars.toString(key);
            this.putAt0(index, keyStr, value);
            return true;
        }
        return false;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }

    private void putAt0(int index, CharSequence key, int value) {
        this.values[index] = value;
        this.putAt0(index, key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LowerCaseCharSequenceIntHashMap that = (LowerCaseCharSequenceIntHashMap)o;
        if (this.size() != that.size()) {
            return false;
        }
        for (CharSequence key : this.keys) {
            int thatValue;
            if (key == null) continue;
            if (that.excludes(key)) {
                return false;
            }
            int value = this.get(key);
            if (value == this.noEntryValue || value == (thatValue = that.get(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        int n = this.keys.length;
        for (int i = 0; i < n; ++i) {
            if (this.keys[i] == noEntryKey) continue;
            hashCode += Chars.hashCode(this.keys[i]) ^ this.values[i];
        }
        return hashCode;
    }

    @Override
    protected void rehash() {
        int newCapacity;
        int size = this.size();
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        int[] oldValues = this.values;
        CharSequence[] oldKeys = this.keys;
        this.keys = new CharSequence[len];
        this.values = new int[len];
        Arrays.fill(this.keys, null);
        this.mask = len - 1;
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            CharSequence key = oldKeys[i];
            if (key == null) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.values[index] = oldValues[i];
        }
    }

    public int removeEntry(CharSequence key) {
        int index = this.keyIndex(key);
        int value = this.valueAt(index);
        this.removeAt(index);
        return value;
    }
}

