/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Long256;

public class Long256Util {
    public static int compare(Long256 a, Long256 b) {
        if (a.getLong3() < b.getLong3()) {
            return -1;
        }
        if (a.getLong3() > b.getLong3()) {
            return 1;
        }
        if (a.getLong2() < b.getLong2()) {
            return -1;
        }
        if (a.getLong2() > b.getLong2()) {
            return 1;
        }
        if (a.getLong1() < b.getLong1()) {
            return -1;
        }
        if (a.getLong1() > b.getLong1()) {
            return 1;
        }
        return Long.compare(a.getLong0(), b.getLong0());
    }

    public static void add(Long256 dst, long v0, long v1, long v2, long v3) {
        boolean isNull;
        boolean bl = isNull = v0 == Long.MIN_VALUE && v1 == Long.MIN_VALUE && v2 == Long.MIN_VALUE && v3 == Long.MIN_VALUE;
        if (isNull) {
            dst.setAll(Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE);
        } else {
            long carry = 0L;
            long l0 = v0 + dst.getLong0() + carry;
            carry = (v0 & dst.getLong0() | (v0 | dst.getLong0()) & (l0 ^ 0xFFFFFFFFFFFFFFFFL)) >>> 63;
            long l1 = v1 + dst.getLong1() + carry;
            carry = (v1 & dst.getLong1() | (v1 | dst.getLong1()) & (l1 ^ 0xFFFFFFFFFFFFFFFFL)) >>> 63;
            long l2 = v2 + dst.getLong2() + carry;
            carry = (v2 & dst.getLong2() | (v2 | dst.getLong2()) & (l2 ^ 0xFFFFFFFFFFFFFFFFL)) >>> 63;
            long l3 = v3 + dst.getLong3() + carry;
            dst.setAll(l0, l1, l2, l3);
        }
    }

    public static void add(Long256 acc, Long256 incr) {
        Long256Util.add(acc, incr.getLong0(), incr.getLong1(), incr.getLong2(), incr.getLong3());
    }
}

