/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import java.util.Arrays;

public class IntStack
implements Mutable {
    private static final int noEntryValue = -1;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private int[] elements;
    private int head;
    private int tail;
    private int mask;

    public IntStack() {
        this(16);
    }

    public IntStack(int initialCapacity) {
        this.allocateElements(initialCapacity);
    }

    @Override
    public void clear() {
        if (this.head != this.tail) {
            this.tail = 0;
            this.head = 0;
            Arrays.fill(this.elements, -1);
        }
    }

    public boolean notEmpty() {
        return this.head != this.tail;
    }

    public int peek() {
        return this.elements[this.head];
    }

    public int pop() {
        int h = this.head;
        int result = this.elements[h];
        if (result == -1) {
            return -1;
        }
        this.elements[h] = -1;
        this.head = h + 1 & this.mask;
        return result;
    }

    public int pollLast() {
        int[] es = this.elements;
        int t = this.dec(this.tail);
        int e = es[t];
        this.tail = t;
        es[t] = -1;
        return e;
    }

    private int dec(int i) {
        if (this.head != this.tail && --i < 0) {
            i = this.mask;
        }
        return i;
    }

    public void push(int e) {
        this.head = this.head - 1 & this.mask;
        this.elements[this.head] = e;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    public void copyTo(IntStack there, int count) {
        int n = Math.min(count, this.size());
        while (n-- > 0) {
            there.push(this.pop());
        }
    }

    public int size() {
        return this.tail - this.head & this.mask;
    }

    public void update(int e) {
        this.elements[this.head] = e;
    }

    private void allocateElements(int capacity) {
        capacity = capacity < 8 ? 8 : Numbers.ceilPow2(capacity);
        this.elements = new int[capacity];
        this.mask = capacity - 1;
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int h = this.head;
        int n = this.elements.length;
        int r = n - h;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Stack is too big");
        }
        int[] next = new int[newCapacity];
        System.arraycopy(this.elements, h, next, 0, r);
        System.arraycopy(this.elements, 0, next, r, h);
        Arrays.fill(next, r + h, newCapacity, -1);
        this.elements = next;
        this.head = 0;
        this.tail = n;
        this.mask = newCapacity - 1;
    }
}

