/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.cairo.CairoException;
import io.questdb.std.Files;
import io.questdb.std.IOURing;
import io.questdb.std.IOURingFacade;
import io.questdb.std.IOUringAccessor;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;

public class IOURingImpl
implements IOURing {
    private final long ringAddr;
    private final int ringFd;
    private final long sqesAddr;
    private final long sqKheadAddr;
    private final int sqKringMask;
    private final int sqKringEntries;
    private final long cqesAddr;
    private final long cqKheadAddr;
    private final long cqKtailAddr;
    private final int cqKringMask;
    private final IOURingFacade facade;
    private final long[] cachedCqes;
    private int cachedIndex;
    private int cachedSize;
    private long idSeq;
    private boolean closed = false;

    public IOURingImpl(IOURingFacade facade, int capacity) {
        assert (Numbers.isPow2(capacity));
        this.facade = facade;
        long res = facade.create(capacity);
        if (res < 0L) {
            throw CairoException.critical((int)(-res)).put("Cannot create io_uring instance");
        }
        this.ringAddr = res;
        this.ringFd = Unsafe.getUnsafe().getInt(this.ringAddr + (long)IOUringAccessor.RING_FD_OFFSET);
        this.sqesAddr = Unsafe.getUnsafe().getLong(this.ringAddr + (long)IOUringAccessor.SQ_SQES_OFFSET);
        this.sqKheadAddr = Unsafe.getUnsafe().getLong(this.ringAddr + (long)IOUringAccessor.SQ_KHEAD_OFFSET);
        long sqMaskAddr = Unsafe.getUnsafe().getLong(this.ringAddr + (long)IOUringAccessor.SQ_KRING_MASK_OFFSET);
        this.sqKringMask = Unsafe.getUnsafe().getInt(sqMaskAddr);
        long sqEntriesAddr = Unsafe.getUnsafe().getLong(this.ringAddr + (long)IOUringAccessor.SQ_KRING_ENTRIES_OFFSET);
        this.sqKringEntries = Unsafe.getUnsafe().getInt(sqEntriesAddr);
        this.cqesAddr = Unsafe.getUnsafe().getLong(this.ringAddr + (long)IOUringAccessor.CQ_CQES_OFFSET);
        this.cqKheadAddr = Unsafe.getUnsafe().getLong(this.ringAddr + (long)IOUringAccessor.CQ_KHEAD_OFFSET);
        this.cqKtailAddr = Unsafe.getUnsafe().getLong(this.ringAddr + (long)IOUringAccessor.CQ_KTAIL_OFFSET);
        long cqMaskAddr = Unsafe.getUnsafe().getLong(this.ringAddr + (long)IOUringAccessor.CQ_KRING_MASK_OFFSET);
        this.cqKringMask = Unsafe.getUnsafe().getInt(cqMaskAddr);
        long cqEntriesAddr = Unsafe.getUnsafe().getLong(this.ringAddr + (long)IOUringAccessor.CQ_KRING_ENTRIES_OFFSET);
        int cqKringEntries = Unsafe.getUnsafe().getInt(cqEntriesAddr);
        this.cachedCqes = new long[2 * cqKringEntries];
        Files.bumpFileCount(this.ringFd);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        Files.decrementFileCount(this.ringFd);
        this.facade.close(this.ringAddr);
        this.closed = true;
    }

    @Override
    public long enqueueRead(long fd, long offset, long bufAddr, int len) {
        return this.enqueueSqe((byte)22, fd, offset, bufAddr, len);
    }

    @Override
    public long getCqeId() {
        if (this.cachedIndex < this.cachedSize) {
            return this.cachedCqes[2 * this.cachedIndex];
        }
        return -1L;
    }

    @Override
    public int getCqeRes() {
        if (this.cachedIndex < this.cachedSize) {
            return (int)this.cachedCqes[2 * this.cachedIndex + 1];
        }
        return -1;
    }

    @Override
    public boolean nextCqe() {
        if (++this.cachedIndex < this.cachedSize) {
            return true;
        }
        int tail = Unsafe.getUnsafe().getInt(this.cqKtailAddr);
        Unsafe.getUnsafe().loadFence();
        int head = Unsafe.getUnsafe().getInt(this.cqKheadAddr);
        if (tail == head) {
            return false;
        }
        for (int i = head; i < tail; ++i) {
            long cqeAddr = this.cqesAddr + (long)(i & this.cqKringMask) * (long)IOUringAccessor.SIZEOF_CQE;
            this.cachedCqes[2 * (i - head)] = Unsafe.getUnsafe().getLong(cqeAddr + (long)IOUringAccessor.CQE_USER_DATA_OFFSET);
            this.cachedCqes[2 * (i - head) + 1] = Unsafe.getUnsafe().getInt(cqeAddr + (long)IOUringAccessor.CQE_RES_OFFSET);
        }
        this.cachedSize = tail - head;
        this.cachedIndex = 0;
        Unsafe.getUnsafe().putInt(this.cqKheadAddr, tail);
        Unsafe.getUnsafe().storeFence();
        return true;
    }

    @Override
    public int submit() {
        return this.facade.submit(this.ringAddr);
    }

    @Override
    public int submitAndWait() {
        return this.facade.submitAndWait(this.ringAddr, 1);
    }

    @Override
    public long enqueueNop() {
        return this.enqueueSqe((byte)0, 0L, 0L, 0L, 0);
    }

    private long enqueueSqe(byte op, long fd, long offset, long bufAddr, int len) {
        long sqeAddr = this.nextSqe();
        if (sqeAddr == 0L) {
            return -1L;
        }
        Unsafe.getUnsafe().putByte(sqeAddr + (long)IOUringAccessor.SQE_OPCODE_OFFSET, op);
        Unsafe.getUnsafe().putInt(sqeAddr + (long)IOUringAccessor.SQE_FD_OFFSET, (int)fd);
        Unsafe.getUnsafe().putLong(sqeAddr + (long)IOUringAccessor.SQE_OFF_OFFSET, offset);
        Unsafe.getUnsafe().putLong(sqeAddr + (long)IOUringAccessor.SQE_ADDR_OFFSET, bufAddr);
        Unsafe.getUnsafe().putInt(sqeAddr + (long)IOUringAccessor.SQE_LEN_OFFSET, len);
        long id = this.idSeq++;
        Unsafe.getUnsafe().putLong(sqeAddr + (long)IOUringAccessor.SQE_USER_DATA_OFFSET, id);
        return id;
    }

    private long nextSqe() {
        int head = Unsafe.getUnsafe().getInt(this.sqKheadAddr);
        Unsafe.getUnsafe().loadFence();
        int tail = Unsafe.getUnsafe().getInt(this.ringAddr + (long)IOUringAccessor.SQ_SQE_TAIL_OFFSET);
        if (tail - head < this.sqKringEntries) {
            long addr = this.sqesAddr + (long)(tail & this.sqKringMask) * (long)IOUringAccessor.SIZEOF_SQE;
            Unsafe.getUnsafe().putInt(this.ringAddr + (long)IOUringAccessor.SQ_SQE_TAIL_OFFSET, tail + 1);
            return addr;
        }
        return 0L;
    }
}

