/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.griffin.SqlException;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.ImmutableIterator;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.IntStack;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.StringSink;
import java.util.ArrayDeque;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericLexer
implements ImmutableIterator<CharSequence> {
    public static final LenComparator COMPARATOR = new LenComparator();
    public static final CharSequenceHashSet WHITESPACE = new CharSequenceHashSet();
    public static final IntHashSet WHITESPACE_CH = new IntHashSet();
    private final IntObjHashMap<ObjList<CharSequence>> symbols = new IntObjHashMap();
    private final CharSequence flyweightSequence = new InternalFloatingSequence();
    private final ObjectPool<FloatingSequence> csPool;
    private final ObjectPool<FloatingSequencePair> csPairPool;
    private final ArrayDeque<CharSequence> unparsed = new ArrayDeque();
    private final IntStack unparsedPosition = new IntStack();
    private final ArrayDeque<CharSequence> parkedUnparsed = new ArrayDeque();
    private final IntStack parkedPosition = new IntStack();
    private CharSequence next = null;
    private int _lo;
    private int _hi;
    private int _pos;
    private int _len;
    private CharSequence content;
    private CharSequence last;
    private int _start;

    public GenericLexer(int poolCapacity) {
        this.csPool = new ObjectPool<FloatingSequence>(() -> new FloatingSequence(), poolCapacity);
        this.csPairPool = new ObjectPool<FloatingSequencePair>(FloatingSequencePair::new, poolCapacity);
        int n = WHITESPACE.size();
        for (int i = 0; i < n; ++i) {
            this.defineSymbol(Chars.toString(WHITESPACE.get(i)));
        }
    }

    public CharSequence immutablePairOf(CharSequence value0, CharSequence value1) {
        return this.immutablePairOf(value0, '\u0000', value1);
    }

    public CharSequence immutablePairOf(CharSequence value0, char separator, CharSequence value1) {
        if (!(value0 instanceof FloatingSequence) || !(value1 instanceof InternalFloatingSequence)) {
            throw new UnsupportedOperationException("only pairs of floating sequences are allowed");
        }
        FloatingSequencePair seqPair = this.csPairPool.next();
        seqPair.cs0 = (FloatingSequence)value0;
        seqPair.cs1 = (FloatingSequence)GenericLexer.immutableOf(value1);
        seqPair.sep = separator;
        return seqPair;
    }

    public static CharSequence immutableOf(CharSequence value) {
        if (value instanceof InternalFloatingSequence) {
            GenericLexer lexer = ((InternalFloatingSequence)value).getParent();
            FloatingSequence that = lexer.csPool.next();
            that.lo = lexer._lo;
            that.hi = lexer._hi;
            assert (that.lo < that.hi);
            return that;
        }
        return value;
    }

    public static CharSequence assertNoDots(CharSequence value, int position) throws SqlException {
        int len = value.length();
        if (len == 1 && value.charAt(0) == '.') {
            throw SqlException.position(position).put("'.' is an invalid table name");
        }
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c != '.' || i >= len - 1 || value.charAt(i + 1) != '.') continue;
            throw SqlException.position(position + i).put('\'').put(c).put("' is not allowed");
        }
        return value;
    }

    public static CharSequence assertNoDotsAndSlashes(CharSequence value, int position) throws SqlException {
        int len = value.length();
        if (len == 1 && value.charAt(0) == '.') {
            throw SqlException.position(position).put("'.' is an invalid table name");
        }
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c != '/' && c != '\\' && (c != '.' || i >= len - 1 || value.charAt(i + 1) != '.')) continue;
            throw SqlException.position(position + i).put('\'').put(c).put("' is not allowed");
        }
        return value;
    }

    public static CharSequence unquote(CharSequence value) {
        if (Chars.isQuoted(value)) {
            return value.subSequence(1, value.length() - 1);
        }
        return GenericLexer.immutableOf(value);
    }

    public final void defineSymbol(String token) {
        ObjList<Object> l;
        char c0 = token.charAt(0);
        int index = this.symbols.keyIndex(c0);
        if (index > -1) {
            l = new ObjList();
            this.symbols.putAt(index, c0, l);
        } else {
            l = this.symbols.valueAtQuick(index);
        }
        l.add(token);
        l.sort(COMPARATOR);
    }

    public CharSequence getContent() {
        return this.content;
    }

    public CharSequence peek() {
        return this.next;
    }

    public int getPosition() {
        return this._pos;
    }

    public int getTokenHi() {
        return this._hi;
    }

    public void stash() {
        int count = 0;
        while (this.unparsed.size() > 0) {
            this.parkedUnparsed.push(this.unparsed.pop());
            this.parkedPosition.push(this.unparsedPosition.pop());
            this.parkedPosition.push(this.unparsedPosition.pop());
            ++count;
        }
        this.parkedPosition.push(this.getPosition());
        this.parkedPosition.push(count);
        this.next = null;
    }

    public void unstash() {
        this._pos = this.parkedPosition.pop();
        this.unparsed.clear();
        this.unparsedPosition.clear();
        for (int count = this.parkedPosition.pop(); count > 0; --count) {
            this.unparsed.push(this.parkedUnparsed.pop());
            this.unparsedPosition.push(this.parkedPosition.pop());
            this.unparsedPosition.push(this.parkedPosition.pop());
        }
        this.next = null;
    }

    public boolean hasUnparsed() {
        return this.unparsed.size() > 0;
    }

    public void goToPosition(int position) {
        assert (position <= this._len);
        this._pos = position;
    }

    @Override
    public boolean hasNext() {
        boolean n;
        boolean bl = n = this.next != null || this.hasUnparsed() || this.content != null && this._pos < this._len;
        if (!n && this.last != null) {
            this.last = null;
        }
        return n;
    }

    @Override
    public CharSequence next() {
        if (this.unparsed.size() > 0) {
            this._lo = this.unparsedPosition.pollLast();
            this._pos = this.unparsedPosition.pollLast();
            this.last = this.unparsed.pollLast();
            return this.last;
        }
        this._lo = this._hi;
        if (this.next != null) {
            CharSequence result = this.next;
            this.next = null;
            this.last = result;
            return this.last;
        }
        this._lo = this._hi = this._pos;
        int term = 0;
        int openTermIdx = -1;
        while (this._pos < this._len) {
            char c = this.content.charAt(this._pos++);
            block0 : switch (term) {
                case 0: {
                    switch (c) {
                        case '\'': {
                            term = 39;
                            openTermIdx = this._pos - 1;
                            break block0;
                        }
                        case '\"': {
                            term = 34;
                            openTermIdx = this._pos - 1;
                            break block0;
                        }
                        case '`': {
                            term = 96;
                            openTermIdx = this._pos - 1;
                            break block0;
                        }
                    }
                    CharSequence token = this.token(c);
                    if (token != null) {
                        this.last = token;
                        return this.last;
                    }
                    ++this._hi;
                    break;
                }
                case 39: {
                    if (c == '\'') {
                        this._hi += 2;
                        if (this._pos < this._len && this.content.charAt(this._pos) == '\'') {
                            ++this._pos;
                            break;
                        }
                        this.last = this.flyweightSequence;
                        return this.last;
                    }
                    ++this._hi;
                    break;
                }
                case 34: {
                    if (c == '\"') {
                        this._hi += 2;
                        if (this._pos < this._len && this.content.charAt(this._pos) == '\"') {
                            ++this._pos;
                            break;
                        }
                        this.last = this.flyweightSequence;
                        return this.last;
                    }
                    ++this._hi;
                    break;
                }
                case 96: {
                    if (c == '`') {
                        this._hi += 2;
                        this.last = this.flyweightSequence;
                        return this.last;
                    }
                    ++this._hi;
                    break;
                }
            }
        }
        if (openTermIdx != -1) {
            if (this._len == 1) {
                ++this._hi;
            } else if (openTermIdx == this._lo) {
                this._pos = this._hi = this._lo + 1;
            } else if (openTermIdx == this._len - 1) {
                FloatingSequence termFs = this.csPool.next();
                termFs.lo = this._hi;
                termFs.hi = this._hi + 1;
                this.next = termFs;
            } else {
                this._hi = openTermIdx;
                this._pos = openTermIdx;
            }
        }
        this.last = this.flyweightSequence;
        return this.last;
    }

    public CharSequence immutableBetween(int lo, int hi) {
        FloatingSequence that = this.csPool.next();
        that.lo = lo;
        that.hi = hi;
        assert (that.lo < that.hi);
        return that;
    }

    public int lastTokenPosition() {
        return this._lo;
    }

    public void of(CharSequence cs) {
        this.of(cs, 0, cs == null ? 0 : cs.length());
    }

    public void of(CharSequence cs, int lo, int hi) {
        this.csPool.clear();
        this.csPairPool.clear();
        this.content = cs;
        this._start = lo;
        this._pos = lo;
        this._len = hi;
        this.next = null;
        this.unparsed.clear();
        this.unparsedPosition.clear();
        this.last = null;
    }

    public void restart() {
        this.csPool.clear();
        this.csPairPool.clear();
        this._pos = this._start;
        this.next = null;
        this.unparsed.clear();
        this.unparsedPosition.clear();
        this.last = null;
        this.parkedPosition.clear();
        this.parkedUnparsed.clear();
    }

    public void unparseLast() {
        if (this.last != null) {
            this.unparsed.push(GenericLexer.immutableOf(this.last));
            this.unparsedPosition.push(this.lastTokenPosition());
            this.unparsedPosition.push(this.getPosition());
        }
    }

    public void unparse(CharSequence what, int last, int pos) {
        this.unparsed.push(what);
        this.unparsedPosition.push(last);
        this.unparsedPosition.push(pos);
    }

    public void backTo(int position, CharSequence lastSeen) {
        if (position < 0 || position > this._len) {
            throw new IndexOutOfBoundsException();
        }
        this._pos = position;
        this.last = lastSeen;
        this.next = null;
    }

    private static CharSequence findToken0(char c, CharSequence content, int _pos, int _len, IntObjHashMap<ObjList<CharSequence>> symbols) {
        int index = symbols.keyIndex(c);
        return index > -1 ? null : GenericLexer.findToken00(content, _pos, _len, symbols, index);
    }

    @Nullable
    private static CharSequence findToken00(CharSequence content, int _pos, int _len, IntObjHashMap<ObjList<CharSequence>> symbols, int index) {
        ObjList<CharSequence> l = symbols.valueAt(index);
        int sz = l.size();
        for (int i = 0; i < sz; ++i) {
            boolean match;
            CharSequence txt = l.getQuick(i);
            int n = txt.length();
            boolean bl = match = n - 2 < _len - _pos;
            if (match) {
                for (int k = 1; k < n; ++k) {
                    if (content.charAt(_pos + (k - 1)) == txt.charAt(k)) continue;
                    match = false;
                    break;
                }
            }
            if (!match) continue;
            return txt;
        }
        return null;
    }

    private CharSequence token(char c) {
        CharSequence t = GenericLexer.findToken0(c, this.content, this._pos, this._len, this.symbols);
        if (t != null) {
            this._pos = this._pos + t.length() - 1;
            if (this._lo == this._hi) {
                return t;
            }
            this.next = t;
            return this.flyweightSequence;
        }
        return null;
    }

    static {
        WHITESPACE.add(" ");
        WHITESPACE.add("\t");
        WHITESPACE.add("\n");
        WHITESPACE.add("\r");
        WHITESPACE_CH.add(32);
        WHITESPACE_CH.add(9);
        WHITESPACE_CH.add(10);
        WHITESPACE_CH.add(13);
    }

    public static class FloatingSequencePair
    extends AbstractCharSequence
    implements Mutable {
        public static final char NO_SEPARATOR = '\u0000';
        FloatingSequence cs0;
        FloatingSequence cs1;
        char sep = '\u0000';

        @Override
        public int length() {
            return this.cs0.length() + this.cs1.length() + (this.sep != '\u0000' ? 1 : 0);
        }

        @Override
        public char charAt(int index) {
            int cs0Len = this.cs0.length();
            if (index < cs0Len) {
                return this.cs0.charAt(index);
            }
            if (this.sep == '\u0000') {
                return this.cs1.charAt(index - cs0Len);
            }
            return index == cs0Len ? this.sep : this.cs1.charAt(index - cs0Len - 1);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String toString() {
            StringSink b = Misc.getThreadLocalBuilder();
            b.put(this.cs0);
            if (this.sep != '\u0000') {
                b.put(this.sep);
            }
            b.put(this.cs1);
            return ((Object)b).toString();
        }

        @Override
        public void clear() {
        }
    }

    public class FloatingSequence
    extends AbstractCharSequence
    implements Mutable {
        int lo;
        int hi;

        @Override
        public void clear() {
        }

        public int getHi() {
            return this.hi;
        }

        public int getLo() {
            return this.lo;
        }

        public void setHi(int hi) {
            this.hi = hi;
        }

        public void setLo(int lo) {
            this.lo = lo;
        }

        @Override
        public int length() {
            return this.hi - this.lo;
        }

        @Override
        public char charAt(int index) {
            return GenericLexer.this.content.charAt(this.lo + index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            FloatingSequence that = (FloatingSequence)GenericLexer.this.csPool.next();
            that.lo = this.lo + start;
            that.hi = this.lo + end;
            assert (that.lo < that.hi);
            return that;
        }
    }

    public class InternalFloatingSequence
    extends AbstractCharSequence {
        @Override
        public int length() {
            return GenericLexer.this._hi - GenericLexer.this._lo;
        }

        @Override
        public char charAt(int index) {
            return GenericLexer.this.content.charAt(GenericLexer.this._lo + index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            FloatingSequence next = (FloatingSequence)GenericLexer.this.csPool.next();
            next.lo = GenericLexer.this._lo + start;
            next.hi = GenericLexer.this._lo + end;
            assert (next.lo <= next.hi);
            return next;
        }

        GenericLexer getParent() {
            return GenericLexer.this;
        }
    }

    public static class LenComparator
    implements Comparator<CharSequence> {
        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            return o2.length() - o1.length();
        }
    }
}

