/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Chars;
import io.questdb.std.LongHashSet;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicLong;

public final class Files {
    public static final Charset UTF_8;
    public static final long PAGE_SIZE;
    public static final int DT_FILE = 8;
    public static final int DT_DIR = 4;
    public static final int MAP_RO = 1;
    public static final int MAP_RW = 2;
    public static final char SEPARATOR;
    public static final int POSIX_FADV_SEQUENTIAL;
    public static final int POSIX_FADV_RANDOM;
    public static final int FILES_RENAME_OK = 0;
    public static final int FILES_RENAME_ERR_EXDEV = 1;
    public static final int FILES_RENAME_ERR_OTHER = 2;
    static final AtomicLong OPEN_FILE_COUNT;
    private static LongHashSet openFds;
    public static final int WINDOWS_ERROR_FILE_EXISTS = 80;

    private Files() {
    }

    public static native boolean allocate(long var0, long var2);

    public static native long append(long var0, long var2, long var4);

    public static synchronized boolean auditClose(long fd) {
        if (fd < 0L) {
            throw new IllegalStateException("Invalid fd " + fd);
        }
        if (openFds.remove(fd) == -1) {
            throw new IllegalStateException("fd " + fd + " is already closed!");
        }
        return true;
    }

    public static synchronized boolean auditOpen(long fd) {
        if (null == openFds) {
            openFds = new LongHashSet();
        }
        if (fd < 0L) {
            throw new IllegalStateException("Invalid fd " + fd);
        }
        if (openFds.contains(fd)) {
            throw new IllegalStateException("fd " + fd + " is already open");
        }
        openFds.add(fd);
        return true;
    }

    public static long bumpFileCount(long fd) {
        if (fd != -1L) {
            assert (Files.auditOpen(fd));
            OPEN_FILE_COUNT.incrementAndGet();
        }
        return fd;
    }

    public static long ceilPageSize(long size) {
        return (size + PAGE_SIZE - 1L) / PAGE_SIZE * PAGE_SIZE;
    }

    public static int close(long fd) {
        assert (Files.auditClose(fd));
        int res = Files.close0(fd);
        if (res == 0) {
            OPEN_FILE_COUNT.decrementAndGet();
        }
        return res;
    }

    public static native int copy(long var0, long var2);

    public static int copy(LPSZ from, LPSZ to) {
        return Files.copy(from.address(), to.address());
    }

    public static void decrementFileCount(long fd) {
        assert (Files.auditClose(fd));
        OPEN_FILE_COUNT.decrementAndGet();
    }

    public static native boolean exists(long var0);

    public static boolean exists(LPSZ lpsz) {
        return lpsz != null && Files.exists0(lpsz.address());
    }

    public static void fadvise(long fd, long offset, long len, int advise) {
        if (Os.type == 2 || Os.type == 4) {
            Files.fadvise0(fd, offset, len, advise);
        }
    }

    public static native void fadvise0(long var0, long var2, long var4, int var6);

    public static native void findClose(long var0);

    public static long findFirst(LPSZ lpsz) {
        return Files.findFirst(lpsz.address());
    }

    public static native long findName(long var0);

    public static native int findNext(long var0);

    public static native int findType(long var0);

    public static long floorPageSize(long size) {
        return size - size % PAGE_SIZE;
    }

    public static native int fsync(long var0);

    public static int getFileSystemStatus(LPSZ lpszName) {
        assert (lpszName.capacity() > 127);
        return Files.getFileSystemStatus(lpszName.address());
    }

    public static long getLastModified(LPSZ lpsz) {
        return Files.getLastModified(lpsz.address());
    }

    public static String getOpenFdDebugInfo() {
        if (openFds != null) {
            return openFds.toString();
        }
        return null;
    }

    public static long getOpenFileCount() {
        return OPEN_FILE_COUNT.get();
    }

    public static native long getStdOutFd();

    public static native int hardLink(long var0, long var2);

    public static int hardLink(LPSZ src, LPSZ hardLink) {
        return Files.hardLink(src.address(), hardLink.address());
    }

    public static boolean isDir(long pUtf8NameZ, long type, StringSink nameSink) {
        if (type == 4L) {
            nameSink.clear();
            Chars.utf8DecodeZ(pUtf8NameZ, nameSink);
            return Files.notDots(nameSink);
        }
        return false;
    }

    public static boolean isDir(long pUtf8NameZ, long type) {
        return type == 4L && Files.notDots(pUtf8NameZ);
    }

    public static boolean isDots(CharSequence name) {
        return Chars.equals(name, '.') || Chars.equals(name, "..");
    }

    public static long length(LPSZ lpsz) {
        return Files.length0(lpsz.address());
    }

    public static native long length(long var0);

    public static native int lock(long var0);

    public static int mkdir(Path path, int mode) {
        return Files.mkdir(path.address(), mode);
    }

    public static int mkdirs(Path path, int mode) {
        int n = path.length();
        for (int i = 0; i < n; ++i) {
            int r;
            char c = path.charAt(i);
            if (c != SEPARATOR || i == 0 && Os.type != 3 || i == 2 && Os.type == 3 && path.charAt(1) == ':') continue;
            path.$at(i);
            if (path.length() > 0 && !Files.exists(path) && (r = Files.mkdir(path, mode)) != 0) {
                path.put(i, SEPARATOR);
                return r;
            }
            path.put(i, SEPARATOR);
        }
        return 0;
    }

    public static long mmap(long fd, long len, long offset, int flags, int memoryTag) {
        long address = Files.mmap0(fd, len, offset, flags, 0L);
        if (address != -1L) {
            Unsafe.recordMemAlloc(len, memoryTag);
        }
        return address;
    }

    public static long mremap(long fd, long address, long previousSize, long newSize, long offset, int flags, int memoryTag) {
        Unsafe.recordMemAlloc(-previousSize, memoryTag);
        address = Files.mremap0(fd, address, previousSize, newSize, offset, flags);
        if (address != -1L) {
            Unsafe.recordMemAlloc(newSize, memoryTag);
        }
        return address;
    }

    public static native int msync(long var0, long var2, boolean var4);

    public static void munmap(long address, long len, int memoryTag) {
        if (address != 0L && Files.munmap0(address, len) != -1) {
            Unsafe.recordMemAlloc(-len, memoryTag);
        }
    }

    public static boolean notDots(CharSequence value) {
        int len = value.length();
        if (len > 2) {
            return true;
        }
        if (value.charAt(0) != '.') {
            return true;
        }
        return len == 2 && value.charAt(1) != '.';
    }

    public static boolean notDots(long pUtf8NameZ) {
        byte b0 = Unsafe.getUnsafe().getByte(pUtf8NameZ);
        if (b0 != 46) {
            return true;
        }
        byte b1 = Unsafe.getUnsafe().getByte(pUtf8NameZ + 1L);
        return b1 != 0 && (b1 != 46 || Unsafe.getUnsafe().getByte(pUtf8NameZ + 2L) != 0);
    }

    public static long openAppend(LPSZ lpsz) {
        return Files.bumpFileCount(Files.openAppend(lpsz.address()));
    }

    public static long openCleanRW(LPSZ lpsz, long size) {
        return Files.bumpFileCount(Files.openCleanRW(lpsz.address(), size));
    }

    public static native long openCleanRW(long var0, long var2);

    public static long openRO(LPSZ lpsz) {
        return Files.bumpFileCount(Files.openRO(lpsz.address()));
    }

    public static long openRW(LPSZ lpsz) {
        return Files.bumpFileCount(Files.openRW(lpsz.address()));
    }

    public static long openRW(LPSZ lpsz, long opts) {
        return Files.bumpFileCount(Files.openRWOpts(lpsz.address(), opts));
    }

    public static native long read(long var0, long var2, long var4, long var6);

    public static native long readULong(long var0, long var2);

    public static boolean remove(LPSZ lpsz) {
        return Files.remove(lpsz.address());
    }

    public static int rename(LPSZ oldName, LPSZ newName) {
        return Files.rename(oldName.address(), newName.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int rmdir(Path path) {
        long p = Files.findFirst(path.address());
        int len = path.length();
        int errno = -1;
        if (p > 0L) {
            try {
                do {
                    long lpszName = Files.findName(p);
                    path.trimTo(len).concat(lpszName).$();
                    if (Files.findType(p) == 4) {
                        if (Files.strcmp(lpszName, "..") || Files.strcmp(lpszName, ".") || (errno = Files.rmdir(path)) == 0) {
                            continue;
                        }
                    } else {
                        if (Files.remove(path.address())) continue;
                        errno = Os.errno();
                    }
                    int n = errno;
                    return n;
                } while (Files.findNext(p) > 0);
            }
            finally {
                Files.findClose(p);
            }
            if (Files.rmdir(path.trimTo(len).$().address())) {
                return 0;
            }
            return Os.errno();
        }
        return errno;
    }

    public static boolean setLastModified(LPSZ lpsz, long millis) {
        return Files.setLastModified(lpsz.address(), millis);
    }

    public static native int sync();

    public static boolean touch(LPSZ lpsz) {
        boolean result;
        long fd = Files.openRW(lpsz);
        boolean bl = result = fd > 0L;
        if (result) {
            Files.close(fd);
        }
        return result;
    }

    public static native boolean truncate(long var0, long var2);

    public static native long write(long var0, long var2, long var4, long var6);

    private static native int getPosixFadvRandom();

    private static native int getPosixFadvSequential();

    private static native int getFileSystemStatus(long var0);

    private static native int close0(long var0);

    private static native boolean exists0(long var0);

    private static boolean strcmp(long lpsz, CharSequence s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            byte b = Unsafe.getUnsafe().getByte(lpsz + (long)i);
            if (b != 0 && b == (byte)s.charAt(i)) continue;
            return false;
        }
        return Unsafe.getUnsafe().getByte(lpsz + (long)len) == 0;
    }

    private static native int munmap0(long var0, long var2);

    private static native long mremap0(long var0, long var2, long var4, long var6, long var8, int var10);

    private static native long mmap0(long var0, long var2, long var4, int var6, long var7);

    private static native long getPageSize();

    private static native boolean remove(long var0);

    private static native boolean rmdir(long var0);

    private static native long getLastModified(long var0);

    private static native long length0(long var0);

    private static native int mkdir(long var0, int var2);

    private static native long openRO(long var0);

    private static native long openRW(long var0);

    private static native long openRWOpts(long var0, long var2);

    private static native long openAppend(long var0);

    private static native long findFirst(long var0);

    private static native boolean setLastModified(long var0, long var2);

    private static native int rename(long var0, long var2);

    static {
        OPEN_FILE_COUNT = new AtomicLong();
        Os.init();
        UTF_8 = StandardCharsets.UTF_8;
        PAGE_SIZE = Files.getPageSize();
        SEPARATOR = File.separatorChar;
        if (Os.type == 2 || Os.type == 4) {
            POSIX_FADV_RANDOM = Files.getPosixFadvRandom();
            POSIX_FADV_SEQUENTIAL = Files.getPosixFadvSequential();
        } else {
            POSIX_FADV_SEQUENTIAL = 0;
            POSIX_FADV_RANDOM = 0;
        }
    }
}

