/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.ObjIntHashMap;
import io.questdb.std.Unsafe;
import io.questdb.std.ex.BytecodeException;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jetbrains.annotations.Nullable;

public class BytecodeAssembler {
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final Log LOG = LogFactory.getLog(BytecodeAssembler.class);
    private static final int aload = 25;
    private static final int aload_0 = 42;
    private static final int aload_1 = 43;
    private static final int aload_2 = 44;
    private static final int aload_3 = 45;
    private static final int istore = 54;
    private static final int istore_0 = 59;
    private static final int istore_1 = 60;
    private static final int istore_2 = 61;
    private static final int istore_3 = 62;
    private static final int lstore = 55;
    private static final int lstore_0 = 63;
    private static final int lstore_1 = 64;
    private static final int lstore_2 = 65;
    private static final int lstore_3 = 66;
    private static final int iinc = 132;
    private static final int lload = 22;
    private static final int lload_0 = 30;
    private static final int lload_1 = 31;
    private static final int lload_2 = 32;
    private static final int lload_3 = 33;
    private static final int iload = 21;
    private static final int iload_0 = 26;
    private static final int iload_1 = 27;
    private static final int iload_2 = 28;
    private static final int iload_3 = 29;
    private static final int iconst_m1 = 2;
    private static final int iconst_0 = 3;
    private static final int bipush = 16;
    private static final int sipush = 17;
    private static final int invokespecial = 183;
    private static final int O_POOL_COUNT = 8;
    private final Utf8Appender utf8Appender = new Utf8Appender();
    private final CharSequenceIntHashMap utf8Cache = new CharSequenceIntHashMap();
    private final ObjIntHashMap<Class<?>> classCache = new ObjIntHashMap();
    private ByteBuffer buf = ByteBuffer.allocate(0x100000).order(ByteOrder.BIG_ENDIAN);
    private int poolCount = 1;
    private int objectClassIndex;
    private int defaultConstructorNameIndex;
    private int defaultConstructorDescIndex;
    private int defaultConstructorMethodIndex;
    private int codeAttributeIndex;
    private int codeAttributeStart;
    private int codeStart;
    private int stackMapTableCut;
    private Class<?> host;

    public void aload(int value) {
        this.optimisedIO(42, 43, 44, 45, 25, value);
    }

    public void append_frame(int itemCount, int offset) {
        this.putByte(252 + itemCount - 1);
        this.putShort(offset);
    }

    public void athrow() {
        this.putByte(191);
    }

    public void d2f() {
        this.putShort(144);
    }

    public void d2i() {
        this.putShort(142);
    }

    public void d2l() {
        this.putShort(143);
    }

    public void dcmpg() {
        this.putByte(152);
    }

    public void defineClass(int thisClassIndex) {
        this.defineClass(thisClassIndex, this.objectClassIndex);
    }

    public void defineClass(int thisClassIndex, int superclassIndex) {
        this.putShort(1);
        this.putShort(thisClassIndex);
        this.putShort(superclassIndex);
    }

    public void defineDefaultConstructor() {
        this.defineDefaultConstructor(this.defaultConstructorMethodIndex);
    }

    public void defineDefaultConstructor(int superIndex) {
        this.startMethod(this.defaultConstructorNameIndex, this.defaultConstructorDescIndex, 1, 1);
        this.aload(0);
        this.putByte(183);
        this.putShort(superIndex);
        this.return_();
        this.endMethodCode();
        this.putShort(0);
        this.putShort(0);
        this.endMethod();
    }

    public void defineField(int nameIndex, int typeIndex) {
        this.putShort(2);
        this.putShort(nameIndex);
        this.putShort(typeIndex);
        this.putShort(0);
    }

    public void dump(String path) {
        try (FileOutputStream fos = new FileOutputStream(path);){
            int p = this.buf.position();
            int l = this.buf.limit();
            this.buf.flip();
            fos.getChannel().write(this.buf);
            this.buf.limit(l);
            this.buf.position(p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dup() {
        this.putByte(89);
    }

    public void dup2() {
        this.putByte(92);
    }

    public void endMethod() {
        this.putInt(this.codeAttributeStart - 4, this.position() - this.codeAttributeStart);
    }

    public void endMethodCode() {
        int len = this.position() - this.codeStart;
        if (len > 65536) {
            LOG.error().$("Too much input to generate ").$(this.host.getName()).$(". Bytecode is too long").$();
            throw BytecodeException.INSTANCE;
        }
        this.putInt(this.codeStart - 4, this.position() - this.codeStart);
    }

    public void endStackMapTables() {
        this.putInt(this.stackMapTableCut, this.position() - this.stackMapTableCut - 4);
    }

    public void f2d() {
        this.putShort(141);
    }

    public void f2i() {
        this.putShort(139);
    }

    public void f2l() {
        this.putShort(140);
    }

    public void fieldCount(int count) {
        this.putShort(count);
    }

    public void finishPool() {
        this.putShort(8, this.poolCount);
    }

    public void full_frame(int offset) {
        this.putByte(255);
        this.putShort(offset);
    }

    public int getCodeStart() {
        return this.codeStart;
    }

    public int getPoolCount() {
        return this.poolCount;
    }

    public void getfield(int index) {
        this.putByte(180);
        this.putShort(index);
    }

    public int goto_() {
        return this.genericGoto(167);
    }

    public void i2b() {
        this.putShort(145);
    }

    public void i2d() {
        this.putShort(135);
    }

    public void i2f() {
        this.putShort(134);
    }

    public void i2l() {
        this.putShort(133);
    }

    public void i2s() {
        this.putShort(147);
    }

    public void iadd() {
        this.putByte(96);
    }

    public void iconst(int v) {
        if (v == -1) {
            this.putByte(2);
        } else if (v > -1 && v < 6) {
            this.putByte(3 + v);
        } else if (v < 0 && v >= Short.MIN_VALUE) {
            this.putByte(17);
            this.putShort(v);
        } else if (v < 128 && v >= Short.MIN_VALUE) {
            this.putByte(16);
            this.putByte(v);
        } else {
            this.putByte(17);
            assert (v >= Short.MIN_VALUE && v <= Short.MAX_VALUE);
            this.putShort(v);
        }
    }

    public int if_icmpge() {
        return this.genericGoto(162);
    }

    public int if_icmpne() {
        return this.genericGoto(160);
    }

    public int ifle() {
        return this.genericGoto(158);
    }

    public int iflt() {
        return this.genericGoto(155);
    }

    public int ifne() {
        return this.genericGoto(154);
    }

    public void iinc(int index, int inc) {
        this.putByte(132);
        this.putByte(index);
        this.putByte(inc);
    }

    public void iload(int value) {
        this.optimisedIO(26, 27, 28, 29, 21, value);
    }

    public void ineg() {
        this.putByte(116);
    }

    public void init(Class<?> host) {
        this.host = host;
        this.buf.clear();
        this.poolCount = 1;
        this.utf8Cache.clear();
        this.classCache.clear();
    }

    public void interfaceCount(int count) {
        this.putShort(count);
    }

    public void invokeInterface(int interfaceIndex, int argCount) {
        this.putByte(185);
        this.putShort(interfaceIndex);
        this.putByte(argCount + 1);
        this.putByte(0);
    }

    public void invokeInterface(int interfaceIndex) {
        this.invokeInterface(interfaceIndex, 1);
    }

    public void invokeStatic(int index) {
        this.putByte(184);
        this.putShort(index);
    }

    public void invokeVirtual(int index) {
        this.putByte(182);
        this.putShort(index);
    }

    public void irem() {
        this.putByte(112);
    }

    public void ireturn() {
        this.putByte(172);
    }

    public void istore(int value) {
        this.optimisedIO(59, 60, 61, 62, 54, value);
    }

    public void isub() {
        this.putByte(100);
    }

    public void l2d() {
        this.putShort(138);
    }

    public void l2f() {
        this.putShort(137);
    }

    public void l2i() {
        this.putShort(136);
    }

    public void lcmp() {
        this.putByte(148);
    }

    public void lconst_0() {
        this.putByte(9);
    }

    public void ldc(int index) {
        if (index < 256) {
            this.putByte(18);
            this.putByte(index);
        } else {
            this.ldc_w(index);
        }
    }

    public void ldc2_w(int index) {
        this.putByte(20);
        this.putShort(index);
    }

    public void ldc_w(int index) {
        this.putByte(19);
        this.putShort(index);
    }

    public void lload(int value) {
        this.optimisedIO(30, 31, 32, 33, 22, value);
    }

    public void lmul() {
        this.putByte(105);
    }

    @Nullable
    public <T> Class<T> loadClass(Class<?> host) {
        byte[] b = new byte[this.position()];
        System.arraycopy(this.buf.array(), 0, b, 0, b.length);
        return Unsafe.defineAnonymousClass(host, b);
    }

    public void lreturn() {
        this.putByte(173);
    }

    public void lstore(int value) {
        this.optimisedIO(63, 64, 65, 66, 55, value);
    }

    public void methodCount(int count) {
        this.putShort(count);
    }

    public <T> T newInstance() {
        Class<T> x = this.loadClass(this.host);
        assert (x != null);
        try {
            return x.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.critical().$("could not create an instance of ").$(this.host.getName()).$(", cause: ").$(e).$();
            throw BytecodeException.INSTANCE;
        }
    }

    public int poolClass(int classIndex) {
        this.putByte(7);
        this.putShort(classIndex);
        return this.poolCount++;
    }

    public int poolClass(Class<?> clazz) {
        int index = this.classCache.keyIndex(clazz);
        if (index > -1) {
            String name = clazz.getName();
            this.putByte(1);
            int n = name.length();
            this.putShort(n);
            for (int i = 0; i < n; ++i) {
                char c = name.charAt(i);
                if (c == '.') {
                    this.putByte(47);
                    continue;
                }
                this.putByte(c);
            }
            int result = this.poolClass(this.poolCount++);
            this.classCache.putAt(index, clazz, result);
            return result;
        }
        return this.classCache.valueAt(index);
    }

    public int poolDoubleConst(double value) {
        this.putByte(6);
        this.putDouble(value);
        int index = this.poolCount;
        this.poolCount += 2;
        return index;
    }

    public int poolField(int classIndex, int nameAndTypeIndex) {
        return this.poolRef(9, classIndex, nameAndTypeIndex);
    }

    public int poolIntConst(int value) {
        this.putByte(3);
        this.putInt(value);
        int index = this.poolCount++;
        return index;
    }

    public int poolInterfaceMethod(Class<?> clazz, String name, String sig) {
        return this.poolInterfaceMethod(this.poolClass(clazz), this.poolNameAndType(this.poolUtf8(name), this.poolUtf8(sig)));
    }

    public int poolInterfaceMethod(int classIndex, String name, String sig) {
        return this.poolInterfaceMethod(classIndex, this.poolNameAndType(this.poolUtf8(name), this.poolUtf8(sig)));
    }

    public int poolLongConst(long value) {
        this.putByte(5);
        this.putLong(value);
        int index = this.poolCount;
        this.poolCount += 2;
        return index;
    }

    public int poolMethod(int classIndex, int nameAndTypeIndex) {
        return this.poolRef(10, classIndex, nameAndTypeIndex);
    }

    public int poolMethod(int classIndex, CharSequence methodName, CharSequence signature) {
        return this.poolMethod(classIndex, this.poolNameAndType(this.poolUtf8(methodName), this.poolUtf8(signature)));
    }

    public int poolMethod(Class<?> clazz, CharSequence methodName, CharSequence signature) {
        return this.poolMethod(this.poolClass(clazz), this.poolNameAndType(this.poolUtf8(methodName), this.poolUtf8(signature)));
    }

    public int poolNameAndType(int nameIndex, int typeIndex) {
        return this.poolRef(12, nameIndex, typeIndex);
    }

    public int poolStringConst(int utf8Index) {
        this.putByte(8);
        this.putShort(utf8Index);
        return this.poolCount++;
    }

    public Utf8Appender poolUtf8() {
        this.putByte(1);
        this.utf8Appender.lenpos = this.position();
        this.utf8Appender.utf8len = 0;
        this.putShort(0);
        return this.utf8Appender;
    }

    public int poolUtf8(CharSequence cs) {
        int index = this.utf8Cache.keyIndex(cs);
        if (index > -1) {
            this.putByte(1);
            int n = cs.length();
            int pos = this.buf.position();
            this.putShort(0);
            int i = 0;
            while (i < n) {
                char c;
                if ((c = cs.charAt(i++)) < '\u0080') {
                    this.putByte(c);
                    continue;
                }
                if (c < '\u0800') {
                    this.putByte((char)(0xC0 | c >> 6));
                    this.putByte((char)(0x80 | c & 0x3F));
                    continue;
                }
                if (Character.isSurrogate(c)) {
                    i = this.encodeSurrogate(c, cs, i, n);
                    continue;
                }
                this.putByte((char)(0xE0 | c >> 12));
                this.putByte((char)(0x80 | c >> 6 & 0x3F));
                this.putByte((char)(0x80 | c & 0x3F));
            }
            this.buf.putShort(pos, (short)(this.buf.position() - pos - 2));
            this.utf8Cache.putAt(index, cs, this.poolCount);
            return this.poolCount++;
        }
        return this.utf8Cache.valueAt(index);
    }

    public void pop() {
        this.putByte(87);
    }

    public int position() {
        return this.buf.position();
    }

    public void putByte(int b) {
        if (this.buf.remaining() == 0) {
            this.resize();
        }
        this.buf.put((byte)b);
    }

    public void putDouble(double value) {
        if (this.buf.remaining() < 4) {
            this.resize();
        }
        this.buf.putDouble(value);
    }

    public void putITEM_Integer() {
        this.putByte(1);
    }

    public void putITEM_Long() {
        this.putByte(4);
    }

    public void putITEM_Object(int classIndex) {
        this.putByte(7);
        this.putShort(classIndex);
    }

    public void putITEM_Top() {
        this.putByte(0);
    }

    public void putLong(long value) {
        if (this.buf.remaining() < 4) {
            this.resize();
        }
        this.buf.putLong(value);
    }

    public void putShort(int v) {
        this.putShort((short)v);
    }

    public void putShort(int pos, int v) {
        this.buf.putShort(pos, (short)v);
    }

    public void putfield(int index) {
        this.putByte(181);
        this.putShort(index);
    }

    public void return_() {
        this.putByte(177);
    }

    public void same_frame(int offset) {
        if (offset < 64) {
            this.putByte(offset);
        } else {
            this.putByte(251);
            this.putShort(offset);
        }
    }

    public void setJmp(int branch, int target) {
        this.putShort(branch, target - branch + 1);
    }

    public void setupPool() {
        this.putInt(-889275714);
        this.putInt(51);
        this.putShort(0);
        this.objectClassIndex = this.poolClass(Object.class);
        this.defaultConstructorNameIndex = this.poolUtf8("<init>");
        this.defaultConstructorDescIndex = this.poolUtf8("()V");
        this.defaultConstructorMethodIndex = this.poolMethod(this.objectClassIndex, this.poolNameAndType(this.defaultConstructorNameIndex, this.defaultConstructorDescIndex));
        this.codeAttributeIndex = this.poolUtf8("Code");
    }

    public void startMethod(int nameIndex, int descriptorIndex, int maxStack, int maxLocal) {
        this.putShort(1);
        this.putShort(nameIndex);
        this.putShort(descriptorIndex);
        this.putShort(1);
        this.putShort(this.codeAttributeIndex);
        this.putInt(0);
        this.codeAttributeStart = this.position();
        this.putShort(maxStack);
        this.putShort(maxLocal);
        this.putInt(0);
        this.codeStart = this.position();
    }

    public void startStackMapTables(int attributeNameIndex, int frameCount) {
        this.putShort(attributeNameIndex);
        this.stackMapTableCut = this.position();
        this.putInt(0);
        this.putShort(frameCount);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int encodeSurrogate(char c, CharSequence in, int pos, int hi) {
        int dword;
        if (Character.isHighSurrogate((char)c)) {
            char c2;
            if (hi - pos < 1) {
                this.putByte(63);
                return pos;
            }
            if (!Character.isLowSurrogate(c2 = in.charAt(pos++))) {
                this.putByte(63);
                return pos;
            }
            dword = Character.toCodePoint((char)c, c2);
        } else {
            if (Character.isLowSurrogate((char)c)) {
                this.putByte(63);
                return pos;
            }
            dword = c;
        }
        this.putByte((char)(0xF0 | dword >> 18));
        this.putByte((char)(0x80 | dword >> 12 & 0x3F));
        this.putByte((char)(0x80 | dword >> 6 & 0x3F));
        this.putByte((char)(0x80 | dword & 0x3F));
        return pos;
    }

    private int genericGoto(int cmd) {
        this.putByte(cmd);
        int pos = this.position();
        this.putShort(0);
        return pos;
    }

    private void optimisedIO(int code0, int code1, int code2, int code3, int code, int value) {
        switch (value) {
            case 0: {
                this.putByte(code0);
                break;
            }
            case 1: {
                this.putByte(code1);
                break;
            }
            case 2: {
                this.putByte(code2);
                break;
            }
            case 3: {
                this.putByte(code3);
                break;
            }
            default: {
                this.putByte(code);
                this.putByte(value);
            }
        }
    }

    private int poolInterfaceMethod(int classIndex, int nameAndTypeIndex) {
        return this.poolRef(11, classIndex, nameAndTypeIndex);
    }

    private int poolRef(int op, int name, int type) {
        this.putByte(op);
        this.putShort(name);
        this.putShort(type);
        return this.poolCount++;
    }

    private void putInt(int pos, int v) {
        this.buf.putInt(pos, v);
    }

    private void putInt(int v) {
        if (this.buf.remaining() < 4) {
            this.resize();
        }
        this.buf.putInt(v);
    }

    private void putShort(short v) {
        if (this.buf.remaining() < 2) {
            this.resize();
        }
        this.buf.putShort(v);
    }

    private void resize() {
        ByteBuffer b = ByteBuffer.allocate(this.buf.capacity() * 2).order(ByteOrder.BIG_ENDIAN);
        System.arraycopy(this.buf.array(), 0, b.array(), 0, this.buf.capacity());
        b.position(this.buf.position());
        this.buf = b;
    }

    public class Utf8Appender
    extends AbstractCharSink
    implements CharSink {
        private int utf8len = 0;
        private int lenpos;

        public int $() {
            BytecodeAssembler.this.putShort(this.lenpos, this.utf8len);
            return BytecodeAssembler.this.poolCount++;
        }

        @Override
        public Utf8Appender put(CharSequence cs) {
            int n = cs.length();
            for (int i = 0; i < n; ++i) {
                BytecodeAssembler.this.putByte(cs.charAt(i));
            }
            this.utf8len += n;
            return this;
        }

        @Override
        public Utf8Appender put(char c) {
            BytecodeAssembler.this.putByte(c);
            ++this.utf8len;
            return this;
        }

        @Override
        public Utf8Appender put(int value) {
            super.put(value);
            return this;
        }

        @Override
        public CharSink put(char[] chars, int start, int len) {
            for (int i = 0; i < len; ++i) {
                BytecodeAssembler.this.putByte(chars[i + start]);
            }
            this.utf8len += len;
            return this;
        }
    }
}

