/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.Net;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.Sinkable;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class NetworkError
extends Error
implements Sinkable,
FlyweightMessageContainer {
    private static final ThreadLocal<NetworkError> tlException = new ThreadLocal<NetworkError>(NetworkError::new);
    private final StringSink message = new StringSink();
    private int errno;

    public static NetworkError instance(int errno, CharSequence message) {
        NetworkError ex = tlException.get();
        ex.errno = errno;
        ex.message.clear();
        ex.message.put(message);
        return ex;
    }

    public static NetworkError instance(int errno) {
        NetworkError ex = tlException.get();
        ex.errno = errno;
        ex.message.clear();
        return ex;
    }

    @Override
    public CharSequence getFlyweightMessage() {
        return this.message;
    }

    public NetworkError couldNotBindSocket(CharSequence who, int ipv4, int port) {
        return this.put("could not bind socket [who=").put(who).put(", bindTo=").ip(ipv4).put(':').put(port).put(']');
    }

    @Override
    public String getMessage() {
        return "[" + this.errno + "] " + this.message;
    }

    public NetworkError ip(int ipv4) {
        Net.appendIP4(this.message, ipv4);
        return this;
    }

    public NetworkError put(char c) {
        this.message.put(c);
        return this;
    }

    public NetworkError put(int value) {
        this.message.put(value);
        return this;
    }

    public NetworkError put(long value) {
        this.message.put(value);
        return this;
    }

    public NetworkError put(CharSequence cs) {
        this.message.put(cs);
        return this;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("[errno=").put(this.errno).put("] ").put(this.message);
    }
}

