/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.NetworkError;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.StdoutSink;
import java.util.concurrent.atomic.AtomicInteger;

public final class Net {
    public static final long MMSGHDR_SIZE;
    public static final long MMSGHDR_BUFFER_ADDRESS_OFFSET;
    public static final long MMSGHDR_BUFFER_LENGTH_OFFSET;
    public static final int EWOULDBLOCK;
    public static final int ERETRY = 0;
    public static final int EPEERDISCONNECT = -1;
    public static final int EOTHERDISCONNECT = -2;
    public static final int SHUT_WR = 1;
    private static final AtomicInteger ADDR_INFO_COUNTER;
    private static final AtomicInteger SOCK_ADDR_COUNTER;

    private Net() {
    }

    public static native int abortAccept(long var0);

    public static long accept(long fd) {
        return Files.bumpFileCount(Net.accept0(fd));
    }

    public static void appendIP4(CharSink sink, long ip) {
        sink.put(ip >> 24 & 0xFFL).put('.').put(ip >> 16 & 0xFFL).put('.').put(ip >> 8 & 0xFFL).put('.').put(ip & 0xFFL);
    }

    public static native boolean bindTcp(long var0, int var2, int var3);

    public static boolean bindTcp(long fd, CharSequence ipv4address, int port) {
        return Net.bindTcp(fd, Net.parseIPv4(ipv4address), port);
    }

    public static native boolean bindUdp(long var0, int var2, int var3);

    public static int close(long fd) {
        return Files.close(fd);
    }

    public static native int configureLinger(long var0, int var2);

    public static int configureNoLinger(long fd) {
        return Net.configureLinger(fd, 0);
    }

    public static native int configureNonBlocking(long var0);

    public static native int connect(long var0, long var2);

    public static native int connectAddrInfo(long var0, long var2);

    public static void dump(long buffer, int len) {
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                Numbers.appendHex(StdoutSink.INSTANCE, Unsafe.getUnsafe().getByte(buffer + (long)i) & 0xFF);
            }
            StdoutSink.INSTANCE.put('\n');
            StdoutSink.INSTANCE.flush();
        }
    }

    private static native void freeAddrInfo0(long var0);

    public static void freeAddrInfo(long pAddrInfo) {
        if (pAddrInfo != 0L) {
            ADDR_INFO_COUNTER.decrementAndGet();
        }
        Net.freeAddrInfo0(pAddrInfo);
    }

    public static native void freeMsgHeaders(long var0);

    private static native void freeSockAddr0(long var0);

    public static void freeSockAddr(long sockaddr) {
        if (sockaddr != 0L) {
            SOCK_ADDR_COUNTER.decrementAndGet();
        }
        Net.freeSockAddr0(sockaddr);
    }

    public static long getAddrInfo(LPSZ host, int port) {
        return Net.getAddrInfo(host.address(), port);
    }

    public static long getAddrInfo(CharSequence host, int port) {
        try (Path p = new Path().of(host).$();){
            long l = Net.getAddrInfo(p, port);
            return l;
        }
    }

    private static native long getAddrInfo0(long var0, int var2);

    public static long getAddrInfo(long lpszHost, int port) {
        long addrInfo = Net.getAddrInfo0(lpszHost, port);
        if (addrInfo != -1L) {
            ADDR_INFO_COUNTER.incrementAndGet();
        }
        return addrInfo;
    }

    public static int getAllocatedAddrInfoCount() {
        return ADDR_INFO_COUNTER.get();
    }

    public static int getAllocatedSockAddrCount() {
        return SOCK_ADDR_COUNTER.get();
    }

    public static long getMMsgBuf(long msgPtr) {
        return Unsafe.getUnsafe().getLong(Unsafe.getUnsafe().getLong(msgPtr + MMSGHDR_BUFFER_ADDRESS_OFFSET));
    }

    public static int getMMsgBufLen(long msgPtr) {
        return Unsafe.getUnsafe().getInt(msgPtr + MMSGHDR_BUFFER_LENGTH_OFFSET);
    }

    public static native int getPeerIP(long var0);

    public static native int getPeerPort(long var0);

    public static native int getRcvBuf(long var0);

    public static native int getSndBuf(long var0);

    public static native int getTcpNoDelay(long var0);

    public static native boolean isDead(long var0);

    public static boolean join(long fd, CharSequence bindIPv4Address, CharSequence groupIPv4Address) {
        return Net.join(fd, Net.parseIPv4(bindIPv4Address), Net.parseIPv4(groupIPv4Address));
    }

    public static native boolean join(long var0, int var2, int var3);

    public static native void listen(long var0, int var2);

    public static native long msgHeaders(int var0, int var1);

    public static int parseIPv4(CharSequence ipv4Address) {
        int ip = 0;
        int count = 0;
        int lo = 0;
        try {
            int hi;
            while ((hi = Chars.indexOf(ipv4Address, lo, '.')) > -1) {
                int n = Numbers.parseInt(ipv4Address, lo, hi);
                ip = ip << 8 | n;
                ++count;
                lo = hi + 1;
            }
            if (count != 3) {
                throw NetworkError.instance(0, "invalid address [").put(ipv4Address).put(']');
            }
            return ip << 8 | Numbers.parseInt(ipv4Address, lo, ipv4Address.length());
        }
        catch (NumericException e) {
            throw NetworkError.instance(0, "invalid address [").put(ipv4Address).put(']');
        }
    }

    public static native int peek(long var0, long var2, int var4);

    public static native int recv(long var0, long var2, int var4);

    public static native int recvmmsg(long var0, long var2, int var4);

    public static native int resolvePort(long var0);

    public static native int send(long var0, long var2, int var4);

    public static native int sendTo(long var0, long var2, int var4, long var5);

    public static native int setMulticastInterface(long var0, int var2);

    public static native int setMulticastLoop(long var0, boolean var2);

    public static native int setMulticastTtl(long var0, int var2);

    public static native int setRcvBuf(long var0, int var2);

    public static native int setReuseAddress(long var0);

    public static native int setReusePort(long var0);

    public static native int setSndBuf(long var0, int var2);

    public static native int setTcpNoDelay(long var0, boolean var2);

    public static native int shutdown(long var0, int var2);

    public static long sockaddr(CharSequence ipv4address, int port) {
        return Net.sockaddr(Net.parseIPv4(ipv4address), port);
    }

    public static long sockaddr(int ipv4address, int port) {
        SOCK_ADDR_COUNTER.incrementAndGet();
        return Net.sockaddr0(ipv4address, port);
    }

    private static native long sockaddr0(int var0, int var1);

    public static long socketTcp(boolean blocking) {
        return Files.bumpFileCount(Net.socketTcp0(blocking));
    }

    public static long socketUdp() {
        return Files.bumpFileCount(Net.socketUdp0());
    }

    private static native long accept0(long var0);

    private static native long socketTcp0(boolean var0);

    private static native long socketUdp0();

    private static native long getMsgHeaderSize();

    private static native long getMsgHeaderBufferAddressOffset();

    private static native long getMsgHeaderBufferLengthOffset();

    private static native int getEwouldblock();

    static {
        ADDR_INFO_COUNTER = new AtomicInteger();
        SOCK_ADDR_COUNTER = new AtomicInteger();
        Os.init();
        EWOULDBLOCK = Net.getEwouldblock();
        if (Os.type == 2) {
            MMSGHDR_SIZE = Net.getMsgHeaderSize();
            MMSGHDR_BUFFER_ADDRESS_OFFSET = Net.getMsgHeaderBufferAddressOffset();
            MMSGHDR_BUFFER_LENGTH_OFFSET = Net.getMsgHeaderBufferLengthOffset();
        } else {
            MMSGHDR_SIZE = -1L;
            MMSGHDR_BUFFER_ADDRESS_OFFSET = -1L;
            MMSGHDR_BUFFER_LENGTH_OFFSET = -1L;
        }
    }
}

