/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.AbstractIODispatcher;
import io.questdb.network.IOContext;
import io.questdb.network.IOContextFactory;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.network.IOEvent;
import io.questdb.network.Kqueue;
import io.questdb.network.KqueueAccessor;
import io.questdb.network.NetworkError;
import io.questdb.std.Os;

public class IODispatcherOsx<C extends IOContext>
extends AbstractIODispatcher<C> {
    private static final int M_ID = 2;
    private final Kqueue kqueue;
    private final int capacity;
    private long fdid = 1L;

    public IODispatcherOsx(IODispatcherConfiguration configuration, IOContextFactory<C> ioContextFactory) {
        super(configuration, ioContextFactory);
        this.capacity = configuration.getEventCapacity();
        this.kqueue = new Kqueue(this.capacity);
        this.registerListenerFd();
    }

    private void enqueuePending(int watermark) {
        int index = 0;
        int i = watermark;
        int sz = this.pending.size();
        int offset = 0;
        while (i < sz) {
            this.kqueue.setWriteOffset(offset);
            int fd = (int)this.pending.get(i, 1);
            if (this.initialBias == 1) {
                this.kqueue.readFD(fd, this.pending.get(i, 2));
                this.LOG.debug().$("kq [op=1, fd=").$(fd).$(", index=").$(index).$(", offset=").$(offset).$(']').$();
            } else {
                this.kqueue.writeFD(fd, this.pending.get(i, 2));
                this.LOG.debug().$("kq [op=2, fd=").$(fd).$(", index=").$(index).$(", offset=").$(offset).$(']').$();
            }
            if (++index > this.capacity - 1) {
                this.registerWithKQueue(index);
                index = 0;
                offset = 0;
            }
            ++i;
            offset += KqueueAccessor.SIZEOF_KEVENT;
        }
        if (index > 0) {
            this.registerWithKQueue(index);
        }
    }

    @Override
    public void close() {
        super.close();
        this.kqueue.close();
        this.LOG.info().$("closed").$();
    }

    @Override
    protected void pendingAdded(int index) {
        this.pending.set(index, 2, this.fdid++);
    }

    private int findPending(long ts) {
        return this.pending.binarySearch(ts, 2);
    }

    private void processIdleConnections(long deadline) {
        int count = 0;
        int i = 0;
        int n = this.pending.size();
        while (i < n && this.pending.get(i, 0) < deadline) {
            this.doDisconnect((IOContext)this.pending.get(i), 1);
            ++i;
            ++count;
        }
        this.pending.zapTop(count);
    }

    private boolean processRegistrations(long timestamp) {
        long cursor;
        boolean useful = false;
        int count = 0;
        int offset = 0;
        while ((cursor = this.interestSubSeq.next()) > -1L) {
            long id;
            useful = true;
            IOEvent evt = (IOEvent)this.interestQueue.get(cursor);
            Object context = evt.context;
            int operation = evt.operation;
            this.interestSubSeq.done(cursor);
            ++this.fdid;
            int fd = (int)context.getFd();
            this.LOG.debug().$("registered [fd=").$(fd).$(", op=").$(operation).$(']').$();
            this.kqueue.setWriteOffset(offset);
            if (operation == 1) {
                this.kqueue.readFD(fd, id);
            } else {
                this.kqueue.writeFD(fd, id);
            }
            offset += KqueueAccessor.SIZEOF_KEVENT;
            ++count;
            int r = this.pending.addRow();
            this.pending.set(r, 0, timestamp);
            this.pending.set(r, 1, fd);
            this.pending.set(r, 2, id);
            this.pending.set(r, context);
            if (count <= this.capacity - 1) continue;
            this.registerWithKQueue(count);
            count = 0;
            offset = 0;
        }
        if (count > 0) {
            this.registerWithKQueue(count);
        }
        return useful;
    }

    private void registerWithKQueue(int changeCount) {
        if (this.kqueue.register(changeCount) != 0) {
            throw NetworkError.instance(Os.errno()).put("could not register [changeCount=").put(changeCount).put(']');
        }
        this.LOG.debug().$("kqueued [count=").$(changeCount).$(']').$();
    }

    @Override
    protected boolean runSerially() {
        long timestamp = this.clock.getTicks();
        this.processDisconnects(timestamp);
        boolean useful = false;
        int n = this.kqueue.poll();
        int watermark = this.pending.size();
        int offset = 0;
        if (n > 0) {
            this.LOG.debug().$("poll [n=").$(n).$(']').$();
            for (int i = 0; i < n; ++i) {
                this.kqueue.setReadOffset(offset);
                offset += KqueueAccessor.SIZEOF_KEVENT;
                int fd = this.kqueue.getFd();
                if ((long)fd == this.serverFd) {
                    this.accept(timestamp);
                    continue;
                }
                int row = this.findPending(this.kqueue.getData());
                if (row < 0) {
                    this.findPending(this.kqueue.getData());
                    this.LOG.error().$("Internal error: unknown FD: ").$(fd).$();
                    continue;
                }
                this.publishOperation(this.kqueue.getFilter() == KqueueAccessor.EVFILT_READ ? 1 : 4, (IOContext)this.pending.get(row));
                this.pending.deleteRow(row);
                --watermark;
            }
            if (watermark < this.pending.size()) {
                this.enqueuePending(watermark);
            }
            useful = true;
        }
        long deadline = timestamp - this.idleConnectionTimeout;
        if (this.pending.size() > 0 && this.pending.get(0, 0) < deadline) {
            this.processIdleConnections(deadline);
            useful = true;
        }
        return this.processRegistrations(timestamp) || useful;
    }

    @Override
    protected void registerListenerFd() {
        if (this.kqueue.listen(this.serverFd) != 0) {
            throw NetworkError.instance(this.nf.errno(), "could not kqueue.listen()");
        }
    }

    @Override
    protected void unregisterListenerFd() {
        if (this.kqueue.removeListen(this.serverFd) != 0) {
            throw NetworkError.instance(this.nf.errno(), "could not kqueue.removeListen()");
        }
    }
}

