/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.AbstractIODispatcher;
import io.questdb.network.Epoll;
import io.questdb.network.EpollAccessor;
import io.questdb.network.IOContext;
import io.questdb.network.IOContextFactory;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.network.IOEvent;

public class IODispatcherLinux<C extends IOContext>
extends AbstractIODispatcher<C> {
    private static final int M_ID = 2;
    private final Epoll epoll;
    private long fdid = 1L;

    public IODispatcherLinux(IODispatcherConfiguration configuration, IOContextFactory<C> ioContextFactory) {
        super(configuration, ioContextFactory);
        this.epoll = new Epoll(configuration.getEpollFacade(), configuration.getEventCapacity());
        this.registerListenerFd();
    }

    private void enqueuePending(int watermark) {
        int i = watermark;
        int sz = this.pending.size();
        int offset = 0;
        while (i < sz) {
            this.epoll.setOffset(offset);
            if (this.epoll.control((int)this.pending.get(i, 1), this.pending.get(i, 2), EpollAccessor.EPOLL_CTL_ADD, this.initialBias == 1 ? EpollAccessor.EPOLLIN : EpollAccessor.EPOLLOUT) < 0) {
                this.LOG.debug().$("epoll_ctl failure ").$(this.nf.errno()).$();
            }
            ++i;
            offset += EpollAccessor.SIZEOF_EVENT;
        }
    }

    @Override
    public void close() {
        super.close();
        this.epoll.close();
        this.LOG.info().$("closed").$();
    }

    @Override
    protected void pendingAdded(int index) {
        this.pending.set(index, 2, this.fdid++);
    }

    private void processIdleConnections(long deadline) {
        int count = 0;
        int i = 0;
        int n = this.pending.size();
        while (i < n && this.pending.get(i, 0) < deadline) {
            this.doDisconnect((IOContext)this.pending.get(i), 1);
            ++i;
            ++count;
        }
        this.pending.zapTop(count);
    }

    private boolean processRegistrations(long timestamp) {
        long cursor;
        int offset = 0;
        while ((cursor = this.interestSubSeq.next()) > -1L) {
            long id;
            IOEvent evt = (IOEvent)this.interestQueue.get(cursor);
            Object context = evt.context;
            int operation = evt.operation;
            this.interestSubSeq.done(cursor);
            int fd = (int)context.getFd();
            ++this.fdid;
            this.LOG.debug().$("registered [fd=").$(fd).$(", op=").$(operation).$(", id=").$(id).$(']').$();
            this.epoll.setOffset(offset);
            if (this.epoll.control(fd, id, EpollAccessor.EPOLL_CTL_MOD, operation == 1 ? EpollAccessor.EPOLLIN : EpollAccessor.EPOLLOUT) < 0) {
                System.out.println("oops2: " + this.nf.errno());
            }
            offset += EpollAccessor.SIZEOF_EVENT;
            int r = this.pending.addRow();
            this.pending.set(r, 0, timestamp);
            this.pending.set(r, 1, fd);
            this.pending.set(r, 2, id);
            this.pending.set(r, context);
        }
        if (offset > 0) {
            this.LOG.debug().$("reg").$();
        }
        return offset > 0;
    }

    @Override
    protected boolean runSerially() {
        boolean useful = false;
        long timestamp = this.clock.getTicks();
        this.processDisconnects(timestamp);
        int n = this.epoll.poll();
        int watermark = this.pending.size();
        int offset = 0;
        if (n > 0) {
            this.LOG.debug().$("epoll [n=").$(n).$(']').$();
            for (int i = 0; i < n; ++i) {
                this.epoll.setOffset(offset);
                offset += EpollAccessor.SIZEOF_EVENT;
                long id = this.epoll.getData();
                if (id == 0L) {
                    this.accept(timestamp);
                    continue;
                }
                int row = this.pending.binarySearch(id, 2);
                if (row < 0) {
                    this.LOG.error().$("internal error: epoll returned unexpected id [id=").$(id).$(']').$();
                    continue;
                }
                this.publishOperation((this.epoll.getEvent() & EpollAccessor.EPOLLIN) > 0 ? 1 : 4, (IOContext)this.pending.get(row));
                this.pending.deleteRow(row);
                --watermark;
            }
            if (watermark < this.pending.size()) {
                this.enqueuePending(watermark);
            }
            useful = true;
        }
        long deadline = timestamp - this.idleConnectionTimeout;
        if (this.pending.size() > 0 && this.pending.get(0, 0) < deadline) {
            this.processIdleConnections(deadline);
            useful = true;
        }
        return this.processRegistrations(timestamp) || useful;
    }

    @Override
    protected void registerListenerFd() {
        this.epoll.listen(this.serverFd);
    }

    @Override
    protected void unregisterListenerFd() {
        this.epoll.removeListen(this.serverFd);
    }
}

