/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.EagerThreadSetup;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.QueueConsumer;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SPSequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.network.IOContext;
import io.questdb.network.IOContextFactory;
import io.questdb.network.IODispatcher;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.network.IOEvent;
import io.questdb.network.IORequestProcessor;
import io.questdb.network.Net;
import io.questdb.network.NetworkError;
import io.questdb.network.NetworkFacade;
import io.questdb.std.LongMatrix;
import io.questdb.std.Os;
import io.questdb.std.datetime.millitime.MillisecondClock;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractIODispatcher<C extends IOContext>
extends SynchronizedJob
implements IODispatcher<C>,
EagerThreadSetup {
    protected static final int M_TIMESTAMP = 0;
    protected static final int M_FD = 1;
    protected static final int DISCONNECT_SRC_QUEUE = 0;
    protected static final int DISCONNECT_SRC_IDLE = 1;
    protected static final int DISCONNECT_SRC_SHUTDOWN = 2;
    private static final String[] DISCONNECT_SOURCES = new String[]{"queue", "idle", "shutdown"};
    protected final Log LOG;
    private final IODispatcherConfiguration configuration;
    protected final RingQueue<IOEvent<C>> interestQueue;
    protected final MPSequence interestPubSeq;
    protected final SCSequence interestSubSeq;
    protected long serverFd;
    protected final RingQueue<IOEvent<C>> ioEventQueue;
    protected final SPSequence ioEventPubSeq;
    protected final MCSequence ioEventSubSeq;
    protected final MillisecondClock clock;
    protected final int activeConnectionLimit;
    protected final IOContextFactory<C> ioContextFactory;
    protected final NetworkFacade nf;
    protected final int initialBias;
    private final AtomicInteger connectionCount = new AtomicInteger();
    protected final RingQueue<IOEvent<C>> disconnectQueue;
    protected final MPSequence disconnectPubSeq;
    protected final SCSequence disconnectSubSeq;
    protected final QueueConsumer<IOEvent<C>> disconnectContextRef = this::disconnectContext;
    protected final long idleConnectionTimeout;
    protected final LongMatrix<C> pending = new LongMatrix(4);
    private final int sndBufSize;
    private final int rcvBufSize;
    private volatile boolean listening;
    private final long queuedConnectionTimeoutMs;
    private long closeListenFdEpochMs;
    private final boolean peerNoLinger;
    private int port;

    public AbstractIODispatcher(IODispatcherConfiguration configuration, IOContextFactory<C> ioContextFactory) {
        this.LOG = LogFactory.getLog(configuration.getDispatcherLogName());
        this.configuration = configuration;
        this.nf = configuration.getNetworkFacade();
        this.interestQueue = new RingQueue<IOEvent>(IOEvent::new, configuration.getInterestQueueCapacity());
        this.interestPubSeq = new MPSequence(this.interestQueue.getCycle());
        this.interestSubSeq = new SCSequence();
        this.interestPubSeq.then(this.interestSubSeq).then(this.interestPubSeq);
        this.ioEventQueue = new RingQueue<IOEvent>(IOEvent::new, configuration.getIOQueueCapacity());
        this.ioEventPubSeq = new SPSequence(configuration.getIOQueueCapacity());
        this.ioEventSubSeq = new MCSequence(configuration.getIOQueueCapacity());
        this.ioEventPubSeq.then(this.ioEventSubSeq).then(this.ioEventPubSeq);
        this.disconnectQueue = new RingQueue<IOEvent>(IOEvent::new, configuration.getIOQueueCapacity());
        this.disconnectPubSeq = new MPSequence(this.disconnectQueue.getCycle());
        this.disconnectSubSeq = new SCSequence();
        this.disconnectPubSeq.then(this.disconnectSubSeq).then(this.disconnectPubSeq);
        this.clock = configuration.getClock();
        this.activeConnectionLimit = configuration.getLimit();
        this.ioContextFactory = ioContextFactory;
        this.initialBias = configuration.getInitialBias();
        this.idleConnectionTimeout = configuration.getTimeout() > 0L ? configuration.getTimeout() : Long.MIN_VALUE;
        this.queuedConnectionTimeoutMs = configuration.getQueueTimeout() > 0L ? configuration.getQueueTimeout() : 0L;
        this.sndBufSize = configuration.getSndBufSize();
        this.rcvBufSize = configuration.getRcvBufSize();
        this.peerNoLinger = configuration.getPeerNoLinger();
        this.port = 0;
        this.createListenFd();
        this.listening = true;
    }

    private void createListenFd() throws NetworkError {
        this.serverFd = this.nf.socketTcp(false);
        int backlog = this.configuration.getListenBacklog();
        if (this.port == 0) {
            this.port = this.configuration.getBindPort();
        }
        if (this.nf.bindTcp(this.serverFd, this.configuration.getBindIPv4Address(), this.port)) {
            if (this.port == 0) {
                this.port = this.nf.resolvePort(this.serverFd);
            }
        } else {
            throw NetworkError.instance(this.nf.errno()).couldNotBindSocket(this.configuration.getDispatcherLogName(), this.configuration.getBindIPv4Address(), this.port);
        }
        this.nf.listen(this.serverFd, backlog);
        this.LOG.advisory().$("listening on ").$ip(this.configuration.getBindIPv4Address()).$(':').$(this.configuration.getBindPort()).$(" [fd=").$(this.serverFd).$(" backlog=").$(backlog).I$();
    }

    @Override
    public void close() {
        this.processDisconnects(Long.MAX_VALUE);
        int n = this.pending.size();
        for (int i = 0; i < n; ++i) {
            this.doDisconnect((IOContext)this.pending.get(i), 2);
        }
        this.interestSubSeq.consumeAll(this.interestQueue, this.disconnectContextRef);
        this.ioEventSubSeq.consumeAll(this.ioEventQueue, this.disconnectContextRef);
        if (this.serverFd > 0L) {
            this.nf.close(this.serverFd, this.LOG);
            this.serverFd = -1L;
        }
    }

    @Override
    public int getConnectionCount() {
        return this.connectionCount.get();
    }

    @Override
    public void registerChannel(C context, int operation) {
        long cursor = this.interestPubSeq.nextBully();
        IOEvent<C> evt = this.interestQueue.get(cursor);
        evt.context = context;
        evt.operation = operation;
        this.LOG.debug().$("queuing [fd=").$(context.getFd()).$(", op=").$(operation).$(']').$();
        this.interestPubSeq.done(cursor);
    }

    @Override
    public boolean processIOQueue(IORequestProcessor<C> processor) {
        long cursor = this.ioEventSubSeq.next();
        while (cursor == -2L) {
            Os.pause();
            cursor = this.ioEventSubSeq.next();
        }
        if (cursor > -1L) {
            IOEvent<C> event = this.ioEventQueue.get(cursor);
            Object connectionContext = event.context;
            int operation = event.operation;
            this.ioEventSubSeq.done(cursor);
            processor.onRequest(operation, connectionContext);
            return true;
        }
        return false;
    }

    @Override
    public void disconnect(C context, int reason) {
        this.LOG.info().$("scheduling disconnect [fd=").$(context.getFd()).$(", reason=").$(reason).I$();
        long cursor = this.disconnectPubSeq.nextBully();
        assert (cursor > -1L);
        this.disconnectQueue.get((long)cursor).context = context;
        this.disconnectPubSeq.done(cursor);
    }

    @Override
    public void setup() {
        if (this.ioContextFactory instanceof EagerThreadSetup) {
            ((EagerThreadSetup)((Object)this.ioContextFactory)).setup();
        }
    }

    protected void accept(long timestamp) {
        int tlConCount = this.connectionCount.get();
        while (tlConCount < this.activeConnectionLimit) {
            long fd = this.nf.accept(this.serverFd);
            if (fd < 0L) {
                if (this.nf.errno() == Net.EWOULDBLOCK) break;
                this.LOG.error().$("could not accept [ret=").$(fd).$(", errno=").$(this.nf.errno()).$(']').$();
                break;
            }
            if (this.nf.configureNonBlocking(fd) < 0) {
                this.LOG.error().$("could not configure non-blocking [fd=").$(fd).$(", errno=").$(this.nf.errno()).$(']').$();
                this.nf.close(fd, this.LOG);
                break;
            }
            if (this.nf.setTcpNoDelay(fd, true) < 0) {
                this.LOG.info().$("could not turn off Nagle's algorithm [fd=").$(fd).$(", errno=").$(this.nf.errno()).$(']').$();
            }
            if (this.peerNoLinger) {
                this.nf.configureNoLinger(fd);
            }
            if (this.sndBufSize > 0) {
                this.nf.setSndBuf(fd, this.sndBufSize);
            }
            if (this.rcvBufSize > 0) {
                this.nf.setRcvBuf(fd, this.rcvBufSize);
            }
            this.LOG.info().$("connected [ip=").$ip(this.nf.getPeerIP(fd)).$(", fd=").$(fd).$(']').$();
            tlConCount = this.connectionCount.incrementAndGet();
            this.addPending(fd, timestamp);
        }
        if (tlConCount >= this.activeConnectionLimit && this.connectionCount.get() >= this.activeConnectionLimit) {
            this.unregisterListenerFd();
            this.listening = false;
            this.closeListenFdEpochMs = timestamp + this.queuedConnectionTimeoutMs;
            this.LOG.info().$("max connection limit reached, unregistered listener [serverFd=").$(this.serverFd).I$();
        }
    }

    private void addPending(long fd, long timestamp) {
        int r = this.pending.addRow();
        this.LOG.debug().$("pending [row=").$(r).$(", fd=").$(fd).$(']').$();
        this.pending.set(r, 0, timestamp);
        this.pending.set(r, 1, fd);
        this.pending.set(r, this.ioContextFactory.newInstance(fd, this));
        this.pendingAdded(r);
    }

    private void disconnectContext(IOEvent<C> event) {
        this.doDisconnect(event.context, 0);
    }

    protected void doDisconnect(C context, int src) {
        if (context == null || context.invalid()) {
            return;
        }
        long fd = context.getFd();
        this.LOG.info().$("disconnected [ip=").$ip(this.nf.getPeerIP(fd)).$(", fd=").$(fd).$(", src=").$(DISCONNECT_SOURCES[src]).$(']').$();
        this.nf.close(fd, this.LOG);
        this.ioContextFactory.done(context);
        if (this.connectionCount.getAndDecrement() >= this.activeConnectionLimit && this.connectionCount.get() < this.activeConnectionLimit) {
            if (this.serverFd < 0L) {
                this.createListenFd();
            }
            this.registerListenerFd();
            this.listening = true;
            this.LOG.info().$("below maximum connection limit, registered listener [serverFd=").$(this.serverFd).I$();
        }
    }

    protected abstract void pendingAdded(int var1);

    protected abstract void registerListenerFd();

    protected abstract void unregisterListenerFd();

    protected void processDisconnects(long epochMs) {
        this.disconnectSubSeq.consumeAll(this.disconnectQueue, this.disconnectContextRef);
        if (!this.listening && this.serverFd >= 0L && epochMs >= this.closeListenFdEpochMs) {
            this.LOG.error().$("been unable to accept connections for ").$(this.queuedConnectionTimeoutMs).$("ms, closing listener [serverFd=").$(this.serverFd).I$();
            this.nf.close(this.serverFd);
            this.serverFd = -1L;
        }
    }

    protected void publishOperation(int operation, C context) {
        long cursor = this.ioEventPubSeq.nextBully();
        IOEvent<C> evt = this.ioEventQueue.get(cursor);
        evt.context = context;
        evt.operation = operation;
        this.ioEventPubSeq.done(cursor);
        this.LOG.debug().$("fired [fd=").$(context.getFd()).$(", op=").$(operation).$(", pos=").$(cursor).$(']').$();
    }

    @Override
    public boolean isListening() {
        return this.listening;
    }

    @Override
    public int getPort() {
        return this.port;
    }
}

