/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.metrics;

import io.questdb.metrics.Gauge;
import io.questdb.metrics.PrometheusFormatUtils;
import io.questdb.std.str.CharSink;

public class VirtualGauge
implements Gauge {
    private final CharSequence name;
    private final StatProvider provider;

    public VirtualGauge(CharSequence name, StatProvider statProvider) {
        this.name = name;
        this.provider = statProvider;
    }

    @Override
    public void inc() {
    }

    @Override
    public void dec() {
    }

    @Override
    public void add(long value) {
    }

    @Override
    public long getValue() {
        return this.provider.getValue();
    }

    private CharSequence getName() {
        return this.name;
    }

    @Override
    public void scrapeIntoPrometheus(CharSink sink) {
        this.appendType(sink);
        this.appendMetricName(sink);
        PrometheusFormatUtils.appendSampleLineSuffix(sink, this.getValue());
        PrometheusFormatUtils.appendNewLine(sink);
    }

    private void appendType(CharSink sink) {
        sink.put(PrometheusFormatUtils.TYPE_PREFIX);
        sink.put(this.getName());
        sink.put(" gauge\n");
    }

    private void appendMetricName(CharSink sink) {
        sink.put(PrometheusFormatUtils.METRIC_NAME_PREFIX);
        sink.put(this.getName());
    }

    @FunctionalInterface
    public static interface StatProvider {
        public long getValue();
    }
}

