/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.jit;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.GeoHashUtil;
import io.questdb.griffin.PostOrderTreeTraversalAlgo;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.engine.functions.bind.CompiledFilterSymbolBindVariable;
import io.questdb.griffin.engine.functions.bind.IndexedParameterLinkFunction;
import io.questdb.griffin.engine.functions.bind.NamedParameterLinkFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.std.Chars;
import io.questdb.std.LongObjHashMap;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import java.util.Arrays;

public class CompiledFilterIRSerializer
implements PostOrderTreeTraversalAlgo.Visitor,
Mutable {
    static final int UNDEFINED_CODE = -1;
    static final int RET = 0;
    static final int IMM = 1;
    static final int MEM = 2;
    static final int VAR = 3;
    static final int NEG = 4;
    static final int NOT = 5;
    static final int AND = 6;
    static final int OR = 7;
    static final int EQ = 8;
    static final int NE = 9;
    static final int LT = 10;
    static final int LE = 11;
    static final int GT = 12;
    static final int GE = 13;
    static final int ADD = 14;
    static final int SUB = 15;
    static final int MUL = 16;
    static final int DIV = 17;
    static final int REM = 18;
    static final int I1_TYPE = 0;
    static final int I2_TYPE = 1;
    static final int I4_TYPE = 2;
    static final int F4_TYPE = 3;
    static final int I8_TYPE = 4;
    static final int F8_TYPE = 5;
    private final PostOrderTreeTraversalAlgo traverseAlgo = new PostOrderTreeTraversalAlgo();
    private final PredicateContext predicateContext = new PredicateContext();
    private final LongObjHashMap<ExpressionNode> backfillNodes = new LongObjHashMap();
    private final LongObjHashMap.LongObjConsumer<ExpressionNode> backfillNodeConsumer = this::backfillNode;
    private boolean forceScalarMode;
    private MemoryCARW memory;
    private SqlExecutionContext executionContext;
    private RecordMetadata metadata;
    private PageFrameCursor pageFrameCursor;
    private ObjList<Function> bindVarFunctions;

    public CompiledFilterIRSerializer of(MemoryCARW memory, SqlExecutionContext executionContext, RecordMetadata metadata, PageFrameCursor pageFrameCursor, ObjList<Function> bindVarFunctions) {
        this.memory = memory;
        this.executionContext = executionContext;
        this.metadata = metadata;
        this.pageFrameCursor = pageFrameCursor;
        this.bindVarFunctions = bindVarFunctions;
        return this;
    }

    public int serialize(ExpressionNode node, boolean scalar, boolean debug, boolean nullChecks) throws SqlException {
        this.traverseAlgo.traverse(node, this);
        this.putOperator(0);
        TypesObserver typesObserver = this.predicateContext.globalTypesObserver;
        int options = debug ? 1 : 0;
        int typeSize = typesObserver.maxSize();
        if (typeSize > 0) {
            int log2 = Integer.numberOfTrailingZeros(typeSize);
            options |= log2 << 1;
        }
        if (!scalar && !this.forceScalarMode) {
            int executionHint = typesObserver.hasMixedSizes() ? 2 : 1;
            options |= executionHint << 3;
        }
        return options |= (nullChecks ? 1 : 0) << 5;
    }

    @Override
    public void clear() {
        this.memory = null;
        this.metadata = null;
        this.pageFrameCursor = null;
        this.forceScalarMode = false;
        this.predicateContext.clear();
        this.backfillNodes.clear();
    }

    @Override
    public boolean descend(ExpressionNode node) throws SqlException {
        if (node.token == null) {
            throw SqlException.position(node.position).put("non-null token expected: ").put(node.token);
        }
        this.predicateContext.onNodeDescended(node);
        if (node.type == 1 && node.paramCount == 1 && Chars.equals(node.token, "-")) {
            ExpressionNode nextNode;
            ExpressionNode expressionNode = nextNode = node.lhs != null ? node.lhs : node.rhs;
            if (nextNode != null && nextNode.paramCount == 0 && nextNode.type == 2) {
                this.serializeConstantStub(node);
                return false;
            }
        }
        return true;
    }

    @Override
    public void visit(ExpressionNode node) throws SqlException {
        block9: {
            int argCount;
            block8: {
                argCount = node.paramCount;
                if (argCount != 0) break block8;
                switch (node.type) {
                    case 4: {
                        this.serializeColumn(node.position, node.token);
                        break block9;
                    }
                    case 6: {
                        this.serializeBindVariable(node);
                        break block9;
                    }
                    case 2: {
                        this.serializeConstantStub(node);
                        break block9;
                    }
                    default: {
                        throw SqlException.position(node.position).put("unsupported token: ").put(node.token);
                    }
                }
            }
            this.serializeOperator(node.position, node.token, argCount);
        }
        boolean predicateLeft = this.predicateContext.onNodeVisited(node);
        if (predicateLeft) {
            this.forceScalarMode |= this.predicateContext.hasArithmeticOperations && this.predicateContext.localTypesObserver.maxSize() <= 2;
            try {
                this.backfillNodes.forEach(this.backfillNodeConsumer);
                this.backfillNodes.clear();
            }
            catch (SqlWrapperException e) {
                throw e.wrappedException;
            }
        }
    }

    private void backfillNode(long key, ExpressionNode value) {
        try {
            switch (value.type) {
                case 1: 
                case 2: {
                    this.backfillConstant(key, value);
                    break;
                }
                case 6: {
                    this.backfillSymbolBindVariable(key, value);
                    break;
                }
                default: {
                    throw SqlException.position(value.position).put("unexpected backfill token: ").put(value.token);
                }
            }
        }
        catch (SqlException e) {
            throw new SqlWrapperException(e);
        }
    }

    private void putOperator(int opcode) {
        this.memory.putInt(opcode);
        this.memory.putInt(0);
        this.memory.putLong(0L);
    }

    private void putOperand(int opcode, int type, long payload) {
        this.memory.putInt(opcode);
        this.memory.putInt(type);
        this.memory.putLong(payload);
    }

    private void putOperand(long offset, int opcode, int type, long payload) {
        this.memory.putInt(offset, opcode);
        this.memory.putInt(offset + 4L, type);
        this.memory.putLong(offset + 8L, payload);
    }

    private void putDoubleOperand(long offset, int type, double payload) {
        this.memory.putInt(offset, 1);
        this.memory.putInt(offset + 4L, type);
        this.memory.putDouble(offset + 8L, payload);
    }

    private void serializeColumn(int position, CharSequence token) throws SqlException {
        if (!this.predicateContext.isActive()) {
            throw SqlException.position(position).put("non-boolean column outside of predicate: ").put(token);
        }
        int index = this.metadata.getColumnIndexQuiet(token);
        if (index == -1) {
            throw SqlException.invalidColumn(position, token);
        }
        int columnType = this.metadata.getColumnType(index);
        short columnTypeTag = ColumnType.tagOf(columnType);
        int typeCode = CompiledFilterIRSerializer.columnTypeCode(columnTypeTag);
        if (typeCode == -1) {
            throw SqlException.position(position).put("unsupported column type: ").put(ColumnType.nameOf(columnTypeTag));
        }
        if (this.predicateContext.singleBooleanColumn && columnTypeTag == 1) {
            this.putOperand(1, 0, 1L);
            this.putOperand(2, typeCode, index);
            this.putOperator(8);
            return;
        }
        this.putOperand(2, typeCode, index);
    }

    private void serializeBindVariable(ExpressionNode node) throws SqlException {
        if (!this.predicateContext.isActive()) {
            throw SqlException.position(node.position).put("bind variable outside of predicate: ").put(node.token);
        }
        Function varFunction = this.getBindVariableFunction(node.position, node.token);
        int columnType = varFunction.getType();
        if (columnType == 11) {
            long offset = this.memory.getAppendOffset();
            this.backfillNodes.put(offset, node);
            this.putOperand(-1, -1, 0L);
            return;
        }
        short columnTypeTag = ColumnType.tagOf(columnType);
        byte typeCode = CompiledFilterIRSerializer.bindVariableTypeCode(columnTypeTag);
        if (typeCode == -1) {
            throw SqlException.position(node.position).put("unsupported bind variable type: ").put(ColumnType.nameOf(columnTypeTag));
        }
        this.bindVarFunctions.add(varFunction);
        int index = this.bindVarFunctions.size() - 1;
        this.putOperand(3, typeCode, index);
    }

    private void backfillSymbolBindVariable(long offset, ExpressionNode node) throws SqlException {
        if (this.predicateContext.symbolColumnIndex == -1) {
            throw SqlException.position(node.position).put("symbol column index is missing for bind variable: ").put(node.token);
        }
        Function varFunction = this.getBindVariableFunction(node.position, node.token);
        int columnType = varFunction.getType();
        if (columnType != 11) {
            throw SqlException.position(node.position).put("unexpected symbol bind variable type: ").put(ColumnType.nameOf(columnType));
        }
        byte typeCode = CompiledFilterIRSerializer.bindVariableTypeCode(columnType);
        if (typeCode == -1) {
            throw SqlException.position(node.position).put("unsupported bind variable type: ").put(ColumnType.nameOf(columnType));
        }
        this.bindVarFunctions.add(new CompiledFilterSymbolBindVariable(varFunction, this.predicateContext.symbolColumnIndex));
        int index = this.bindVarFunctions.size() - 1;
        this.putOperand(offset, 3, typeCode, index);
    }

    private Function getBindVariableFunction(int position, CharSequence token) throws SqlException {
        ScalarFunction varFunction;
        if (token.charAt(0) == ':') {
            Function bindFunction = this.getBindVariableService().getFunction(token);
            if (bindFunction == null) {
                throw SqlException.position(position).put("failed to find function for bind variable: ").put(token);
            }
            varFunction = new NamedParameterLinkFunction(Chars.toString(token), bindFunction.getType());
        } else {
            try {
                int variableIndex = Numbers.parseInt(token, 1, token.length());
                if (variableIndex < 1) {
                    throw SqlException.$(position, "invalid bind variable index [value=").put(variableIndex).put(']');
                }
                Function bindFunction = this.getBindVariableService().getFunction(variableIndex - 1);
                if (bindFunction == null) {
                    throw SqlException.position(position).put("failed to find function for bind variable: ").put(token);
                }
                varFunction = new IndexedParameterLinkFunction(variableIndex - 1, bindFunction.getType(), position);
            }
            catch (NumericException e) {
                throw SqlException.$(position, "invalid bind variable index [value=").put(token).put(']');
            }
        }
        return varFunction;
    }

    private BindVariableService getBindVariableService() throws SqlException {
        BindVariableService bindVariableService = this.executionContext.getBindVariableService();
        if (bindVariableService == null) {
            throw SqlException.$(0, "bind variable service is not provided");
        }
        return bindVariableService;
    }

    private void serializeConstantStub(ExpressionNode node) throws SqlException {
        if (!this.predicateContext.isActive()) {
            throw SqlException.position(node.position).put("constant outside of predicate: ").put(node.token);
        }
        long offset = this.memory.getAppendOffset();
        this.backfillNodes.put(offset, node);
        this.putOperand(-1, -1, 0L);
    }

    private void backfillConstant(long offset, ExpressionNode node) throws SqlException {
        int position = node.position;
        CharSequence token = node.token;
        boolean negate = false;
        if (node.type == 1) {
            ExpressionNode nextNode;
            ExpressionNode expressionNode = nextNode = node.lhs != null ? node.lhs : node.rhs;
            if (nextNode != null) {
                position = nextNode.position;
                token = nextNode.token;
                negate = true;
            }
        }
        this.serializeConstant(offset, position, token, negate);
    }

    private void serializeConstant(long offset, int position, CharSequence token, boolean negated) throws SqlException {
        int len = token.length();
        int typeCode = this.predicateContext.localTypesObserver.constantTypeCode();
        if (typeCode == -1) {
            throw SqlException.position(position).put("all constants expression: ").put(token);
        }
        if (SqlKeywords.isNullKeyword(token)) {
            boolean geoHashExpression = PredicateType.GEO_HASH == this.predicateContext.type;
            this.serializeNull(offset, position, typeCode, geoHashExpression);
            return;
        }
        if (PredicateType.SYMBOL == this.predicateContext.type) {
            this.serializeSymbolConstant(offset, position, token);
            return;
        }
        if (Chars.isQuoted(token)) {
            if (PredicateType.CHAR != this.predicateContext.type) {
                throw SqlException.position(position).put("char constant in non-char expression: ").put(token);
            }
            if (len == 3) {
                this.putOperand(offset, 1, 1, token.charAt(1));
                return;
            }
            throw SqlException.position(position).put("unsupported string constant: ").put(token);
        }
        if (SqlKeywords.isTrueKeyword(token)) {
            if (PredicateType.BOOLEAN != this.predicateContext.type) {
                throw SqlException.position(position).put("boolean constant in non-boolean expression: ").put(token);
            }
            this.putOperand(offset, 1, 0, 1L);
            return;
        }
        if (SqlKeywords.isFalseKeyword(token)) {
            if (PredicateType.BOOLEAN != this.predicateContext.type) {
                throw SqlException.position(position).put("boolean constant in non-boolean expression: ").put(token);
            }
            this.putOperand(offset, 1, 0, 0L);
            return;
        }
        if (len > 1 && token.charAt(0) == '#') {
            if (PredicateType.GEO_HASH != this.predicateContext.type) {
                throw SqlException.position(position).put("geo hash constant in non-geo hash expression: ").put(token);
            }
            ConstantFunction geoConstant = GeoHashUtil.parseGeoHashConstant(position, token, len);
            if (geoConstant != null) {
                this.serializeGeoHash(offset, position, geoConstant, typeCode);
                return;
            }
        }
        if (PredicateType.NUMERIC != this.predicateContext.type) {
            throw SqlException.position(position).put("numeric constant in non-numeric expression: ").put(token);
        }
        if (this.predicateContext.localTypesObserver.hasMixedSizes()) {
            this.serializeUntypedNumber(offset, position, token, negated);
        } else {
            this.serializeNumber(offset, position, token, typeCode, negated);
        }
    }

    private void serializeNull(long offset, int position, int typeCode, boolean geoHashPredicate) throws SqlException {
        switch (typeCode) {
            case 0: {
                if (!geoHashPredicate) {
                    throw SqlException.position(position).put("byte type is not nullable");
                }
                this.putOperand(offset, 1, typeCode, -1L);
                break;
            }
            case 1: {
                if (!geoHashPredicate) {
                    throw SqlException.position(position).put("short type is not nullable");
                }
                this.putOperand(offset, 1, typeCode, -1L);
                break;
            }
            case 2: {
                this.putOperand(offset, 1, typeCode, geoHashPredicate ? -1L : Integer.MIN_VALUE);
                break;
            }
            case 4: {
                this.putOperand(offset, 1, typeCode, geoHashPredicate ? -1L : Long.MIN_VALUE);
                break;
            }
            case 3: {
                this.putDoubleOperand(offset, typeCode, Double.NaN);
                break;
            }
            case 5: {
                this.putDoubleOperand(offset, typeCode, Double.NaN);
                break;
            }
            default: {
                throw SqlException.position(position).put("unexpected null type: ").put(typeCode);
            }
        }
    }

    private void serializeSymbolConstant(long offset, int position, CharSequence token) throws SqlException {
        int len = token.length();
        CharSequence symbol = token;
        if (Chars.isQuoted(token)) {
            if (len < 3) {
                throw SqlException.position(position).put("unsupported symbol constant: ").put(token);
            }
            symbol = symbol.subSequence(1, len - 1);
        }
        if (this.predicateContext.symbolTable == null || this.predicateContext.symbolColumnIndex == -1) {
            throw SqlException.position(position).put("reader or column index is missing for symbol constant: ").put(token);
        }
        int key = this.predicateContext.symbolTable.keyOf(symbol);
        if (key != -2) {
            this.putOperand(offset, 1, 2, key);
            return;
        }
        SymbolConstant function = SymbolConstant.newInstance(symbol);
        this.bindVarFunctions.add(new CompiledFilterSymbolBindVariable(function, this.predicateContext.symbolColumnIndex));
        int index = this.bindVarFunctions.size() - 1;
        byte typeCode = CompiledFilterIRSerializer.bindVariableTypeCode(11);
        this.putOperand(offset, 3, typeCode, index);
    }

    private void serializeGeoHash(long offset, int position, ConstantFunction geoHashConstant, int typeCode) throws SqlException {
        try {
            switch (typeCode) {
                case 0: {
                    this.putOperand(offset, 1, typeCode, geoHashConstant.getGeoByte(null));
                    break;
                }
                case 1: {
                    this.putOperand(offset, 1, typeCode, geoHashConstant.getGeoShort(null));
                    break;
                }
                case 2: {
                    this.putOperand(offset, 1, typeCode, geoHashConstant.getGeoInt(null));
                    break;
                }
                case 4: {
                    this.putOperand(offset, 1, typeCode, geoHashConstant.getGeoLong(null));
                    break;
                }
                default: {
                    throw SqlException.position(position).put("unexpected type code for geo hash: ").put(typeCode);
                }
            }
        }
        catch (UnsupportedOperationException e) {
            throw SqlException.position(position).put("unexpected type for geo hash: ").put(typeCode);
        }
    }

    private void serializeNumber(long offset, int position, CharSequence token, int typeCode, boolean negated) throws SqlException {
        long sign = negated ? -1L : 1L;
        try {
            switch (typeCode) {
                case 0: {
                    byte b = (byte)Numbers.parseInt(token);
                    this.putOperand(offset, 1, 0, sign * (long)b);
                    break;
                }
                case 1: {
                    short s = (short)Numbers.parseInt(token);
                    this.putOperand(offset, 1, 1, sign * (long)s);
                    break;
                }
                case 2: 
                case 3: {
                    try {
                        int i = Numbers.parseInt(token);
                        this.putOperand(offset, 1, 2, sign * (long)i);
                    }
                    catch (NumericException e) {
                        float fi = Numbers.parseFloat(token);
                        this.putDoubleOperand(offset, 3, (float)sign * fi);
                    }
                    break;
                }
                case 4: 
                case 5: {
                    try {
                        long l = Numbers.parseLong(token);
                        this.putOperand(offset, 1, 4, sign * l);
                    }
                    catch (NumericException e) {
                        double dl = Numbers.parseDouble(token);
                        this.putDoubleOperand(offset, 5, (double)sign * dl);
                    }
                    break;
                }
                default: {
                    throw SqlException.position(position).put("unexpected non-numeric constant: ").put(token).put(", expected type: ").put(typeCode);
                }
            }
        }
        catch (NumericException e) {
            throw SqlException.position(position).put("could not parse constant: ").put(token).put(", expected type: ").put(typeCode);
        }
    }

    private void serializeUntypedNumber(long offset, int position, CharSequence token, boolean negated) throws SqlException {
        long sign = negated ? -1L : 1L;
        try {
            int i = Numbers.parseInt(token);
            this.putOperand(offset, 1, 2, sign * (long)i);
            return;
        }
        catch (NumericException i) {
            try {
                long l = Numbers.parseLong(token);
                this.putOperand(offset, 1, 4, sign * l);
                return;
            }
            catch (NumericException l) {
                try {
                    double d = Numbers.parseDouble(token);
                    this.putDoubleOperand(offset, 5, (double)sign * d);
                    return;
                }
                catch (NumericException d) {
                    try {
                        float f = Numbers.parseFloat(token);
                        this.putDoubleOperand(offset, 3, (float)sign * f);
                        return;
                    }
                    catch (NumericException numericException) {
                        throw SqlException.position(position).put("unexpected non-numeric constant: ").put(token);
                    }
                }
            }
        }
    }

    private void serializeOperator(int position, CharSequence token, int argCount) throws SqlException {
        if (SqlKeywords.isNotKeyword(token)) {
            this.putOperator(5);
            return;
        }
        if (SqlKeywords.isAndKeyword(token)) {
            this.putOperator(6);
            return;
        }
        if (SqlKeywords.isOrKeyword(token)) {
            this.putOperator(7);
            return;
        }
        if (Chars.equals(token, "=")) {
            this.putOperator(8);
            return;
        }
        if (Chars.equals(token, "<>") || Chars.equals(token, "!=")) {
            this.putOperator(9);
            return;
        }
        if (Chars.equals(token, "<")) {
            this.putOperator(10);
            return;
        }
        if (Chars.equals(token, "<=")) {
            this.putOperator(11);
            return;
        }
        if (Chars.equals(token, ">")) {
            this.putOperator(12);
            return;
        }
        if (Chars.equals(token, ">=")) {
            this.putOperator(13);
            return;
        }
        if (Chars.equals(token, "+")) {
            if (argCount == 2) {
                this.putOperator(14);
            }
            return;
        }
        if (Chars.equals(token, "-")) {
            if (argCount == 2) {
                this.putOperator(15);
            } else if (argCount == 1) {
                this.putOperator(4);
            }
            return;
        }
        if (Chars.equals(token, "*")) {
            this.putOperator(16);
            return;
        }
        if (Chars.equals(token, "/")) {
            this.putOperator(17);
            return;
        }
        throw SqlException.position(position).put("invalid operator: ").put(token);
    }

    private static int columnTypeCode(int columnTypeTag) {
        switch (columnTypeTag) {
            case 1: 
            case 2: 
            case 14: {
                return 0;
            }
            case 3: 
            case 4: 
            case 15: {
                return 1;
            }
            case 5: 
            case 12: 
            case 16: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                return 4;
            }
            case 10: {
                return 5;
            }
        }
        return -1;
    }

    private static byte bindVariableTypeCode(int columnTypeTag) {
        switch (columnTypeTag) {
            case 1: 
            case 2: 
            case 14: {
                return 0;
            }
            case 3: 
            case 4: 
            case 15: {
                return 1;
            }
            case 5: 
            case 11: 
            case 16: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                return 4;
            }
            case 10: {
                return 5;
            }
        }
        return -1;
    }

    private static boolean isTopLevelOperation(ExpressionNode node) {
        CharSequence token = node.token;
        if (SqlKeywords.isNotKeyword(token)) {
            return true;
        }
        if (node.paramCount < 2) {
            return false;
        }
        if (Chars.equals(token, "=")) {
            return true;
        }
        if (Chars.equals(token, "<>") || Chars.equals(token, "!=")) {
            return true;
        }
        if (Chars.equals(token, "<")) {
            return true;
        }
        if (Chars.equals(token, "<=")) {
            return true;
        }
        if (Chars.equals(token, ">")) {
            return true;
        }
        return Chars.equals(token, ">=");
    }

    private boolean isTopLevelBooleanColumn(ExpressionNode node) {
        if (node.type == 4 && this.isBooleanColumn(node)) {
            return true;
        }
        CharSequence token = node.token;
        if (SqlKeywords.isNotKeyword(token)) {
            ExpressionNode columnNode = node.lhs != null ? node.lhs : node.rhs;
            return columnNode != null && this.isBooleanColumn(columnNode);
        }
        return false;
    }

    private boolean isBooleanColumn(ExpressionNode node) {
        if (node.type != 4) {
            return false;
        }
        int index = this.metadata.getColumnIndexQuiet(node.token);
        if (index == -1) {
            return false;
        }
        int columnType = this.metadata.getColumnType(index);
        short columnTypeTag = ColumnType.tagOf(columnType);
        return columnTypeTag == 1;
    }

    private static boolean isArithmeticOperation(ExpressionNode node) {
        CharSequence token = node.token;
        if (node.paramCount < 2) {
            return false;
        }
        if (Chars.equals(token, "+")) {
            return true;
        }
        if (Chars.equals(token, "-")) {
            return true;
        }
        if (Chars.equals(token, "*")) {
            return true;
        }
        return Chars.equals(token, "/");
    }

    private static enum PredicateType {
        NUMERIC,
        CHAR,
        SYMBOL,
        BOOLEAN,
        GEO_HASH;

    }

    private static class SqlWrapperException
    extends RuntimeException {
        final SqlException wrappedException;

        SqlWrapperException(SqlException wrappedException) {
            this.wrappedException = wrappedException;
        }
    }

    private static class TypesObserver
    implements Mutable {
        private static final int I1_INDEX = 0;
        private static final int I2_INDEX = 1;
        private static final int I4_INDEX = 2;
        private static final int F4_INDEX = 3;
        private static final int I8_INDEX = 4;
        private static final int F8_INDEX = 5;
        private static final int TYPES_COUNT = 6;
        private final byte[] sizes = new byte[6];

        private TypesObserver() {
        }

        public void observe(int code) {
            switch (code) {
                case 0: {
                    this.sizes[0] = 1;
                    break;
                }
                case 1: {
                    this.sizes[1] = 2;
                    break;
                }
                case 2: {
                    this.sizes[2] = 4;
                    break;
                }
                case 3: {
                    this.sizes[3] = 4;
                    break;
                }
                case 4: {
                    this.sizes[4] = 8;
                    break;
                }
                case 5: {
                    this.sizes[5] = 8;
                }
            }
        }

        public int constantTypeCode() {
            for (int i = this.sizes.length - 1; i > -1; --i) {
                byte size = this.sizes[i];
                if (size <= 0) continue;
                if (i == 4 && this.sizes[3] > 0) {
                    return 5;
                }
                return this.indexToTypeCode(i);
            }
            return -1;
        }

        private int indexToTypeCode(int index) {
            switch (index) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
            }
            return -1;
        }

        public int maxSize() {
            for (int i = this.sizes.length - 1; i > -1; --i) {
                byte size = this.sizes[i];
                if (size <= 0) continue;
                return size;
            }
            return 0;
        }

        public boolean hasMixedSizes() {
            byte prevSize = 0;
            for (byte size : this.sizes) {
                byte by = prevSize = prevSize == 0 ? size : prevSize;
                if (prevSize > 0) {
                    if (size <= 0 || size == prevSize) continue;
                    return true;
                }
                prevSize = size;
            }
            return false;
        }

        @Override
        public void clear() {
            Arrays.fill(this.sizes, (byte)0);
        }
    }

    private class PredicateContext
    implements Mutable {
        private ExpressionNode rootNode;
        PredicateType type;
        StaticSymbolTable symbolTable;
        int symbolColumnIndex;
        boolean singleBooleanColumn;
        boolean hasArithmeticOperations;
        final TypesObserver localTypesObserver = new TypesObserver();
        final TypesObserver globalTypesObserver = new TypesObserver();

        private PredicateContext() {
        }

        @Override
        public void clear() {
            this.reset();
            this.globalTypesObserver.clear();
        }

        private void reset() {
            this.rootNode = null;
            this.type = null;
            this.symbolTable = null;
            this.symbolColumnIndex = -1;
            this.singleBooleanColumn = false;
            this.hasArithmeticOperations = false;
            this.localTypesObserver.clear();
        }

        public boolean isActive() {
            return this.rootNode != null;
        }

        public void onNodeDescended(ExpressionNode node) {
            if (this.rootNode == null) {
                boolean topLevelOperation = CompiledFilterIRSerializer.isTopLevelOperation(node);
                boolean topLevelBooleanColumn = CompiledFilterIRSerializer.this.isTopLevelBooleanColumn(node);
                if (topLevelOperation || topLevelBooleanColumn) {
                    this.reset();
                    this.rootNode = node;
                }
                if (topLevelBooleanColumn) {
                    this.type = PredicateType.BOOLEAN;
                    this.singleBooleanColumn = true;
                }
            }
        }

        public boolean onNodeVisited(ExpressionNode node) throws SqlException {
            boolean predicateLeft = false;
            if (node == this.rootNode) {
                this.rootNode = null;
                predicateLeft = true;
            }
            switch (node.type) {
                case 4: {
                    this.handleColumn(node);
                    break;
                }
                case 6: {
                    this.handleBindVariable(node);
                    break;
                }
                case 1: {
                    this.handleOperation(node);
                }
            }
            return predicateLeft;
        }

        private void handleColumn(ExpressionNode node) throws SqlException {
            int columnIndex = CompiledFilterIRSerializer.this.metadata.getColumnIndexQuiet(node.token);
            if (columnIndex == -1) {
                throw SqlException.invalidColumn(node.position, node.token);
            }
            int columnType = CompiledFilterIRSerializer.this.metadata.getColumnType(columnIndex);
            short columnTypeTag = ColumnType.tagOf(columnType);
            if (columnTypeTag == 12) {
                this.symbolTable = (StaticSymbolTable)CompiledFilterIRSerializer.this.pageFrameCursor.getSymbolTable(columnIndex);
                this.symbolColumnIndex = columnIndex;
            }
            this.updateType(node.position, columnTypeTag);
            int typeCode = CompiledFilterIRSerializer.columnTypeCode(columnTypeTag);
            this.localTypesObserver.observe(typeCode);
            this.globalTypesObserver.observe(typeCode);
        }

        private void handleBindVariable(ExpressionNode node) throws SqlException {
            Function varFunction = CompiledFilterIRSerializer.this.getBindVariableFunction(node.position, node.token);
            int columnType = varFunction.getType();
            int columnTypeTag = ColumnType.tagOf(columnType);
            if (columnTypeTag == 11) {
                columnTypeTag = 12;
            }
            this.updateType(node.position, columnTypeTag);
            int code = CompiledFilterIRSerializer.columnTypeCode(columnTypeTag);
            this.localTypesObserver.observe(code);
            this.globalTypesObserver.observe(code);
        }

        private void handleOperation(ExpressionNode node) {
            this.hasArithmeticOperations |= CompiledFilterIRSerializer.isArithmeticOperation(node);
        }

        private void updateType(int position, int columnTypeTag) throws SqlException {
            switch (columnTypeTag) {
                case 1: {
                    if (this.type != null && this.type != PredicateType.BOOLEAN) {
                        throw SqlException.position(position).put("non-boolean column in boolean expression: ").put(ColumnType.nameOf(columnTypeTag));
                    }
                    this.type = PredicateType.BOOLEAN;
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    if (this.type != null && this.type != PredicateType.GEO_HASH) {
                        throw SqlException.position(position).put("non-geohash column in geohash expression: ").put(ColumnType.nameOf(columnTypeTag));
                    }
                    this.type = PredicateType.GEO_HASH;
                    break;
                }
                case 4: {
                    if (this.type != null && this.type != PredicateType.CHAR) {
                        throw SqlException.position(position).put("non-char column in char expression: ").put(ColumnType.nameOf(columnTypeTag));
                    }
                    this.type = PredicateType.CHAR;
                    break;
                }
                case 12: {
                    if (this.type != null && this.type != PredicateType.SYMBOL) {
                        throw SqlException.position(position).put("non-symbol column in symbol expression: ").put(ColumnType.nameOf(columnTypeTag));
                    }
                    this.type = PredicateType.SYMBOL;
                    break;
                }
                default: {
                    if (this.type != null && this.type != PredicateType.NUMERIC) {
                        throw SqlException.position(position).put("non-numeric column in numeric expression: ").put(ColumnType.nameOf(columnTypeTag));
                    }
                    this.type = PredicateType.NUMERIC;
                }
            }
        }
    }
}

