/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.model;

import io.questdb.griffin.model.ExpressionNode;
import io.questdb.std.Mutable;
import io.questdb.std.ObjectFactory;
import java.util.Objects;

public class QueryColumn
implements Mutable {
    public static final ObjectFactory<QueryColumn> FACTORY = QueryColumn::new;
    private CharSequence alias;
    private ExpressionNode ast;
    private boolean includeIntoWildcard = true;

    protected QueryColumn() {
    }

    @Override
    public void clear() {
        this.alias = null;
        this.ast = null;
        this.includeIntoWildcard = true;
    }

    public CharSequence getAlias() {
        return this.alias;
    }

    public void setAlias(CharSequence alias) {
        this.alias = alias;
    }

    public ExpressionNode getAst() {
        return this.ast;
    }

    public CharSequence getName() {
        return this.alias != null ? this.alias : this.ast.token;
    }

    public boolean isIncludeIntoWildcard() {
        return this.includeIntoWildcard;
    }

    public QueryColumn of(CharSequence alias, ExpressionNode ast) {
        return this.of(alias, ast, true);
    }

    public QueryColumn of(CharSequence alias, ExpressionNode ast, boolean includeIntoWildcard) {
        this.alias = alias;
        this.ast = ast;
        this.includeIntoWildcard = includeIntoWildcard;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryColumn that = (QueryColumn)o;
        return this.includeIntoWildcard == that.includeIntoWildcard && Objects.equals(this.alias, that.alias) && Objects.equals(this.ast, that.ast);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.ast, this.includeIntoWildcard);
    }
}

