/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.model;

import io.questdb.griffin.SqlException;
import io.questdb.griffin.model.ExecutionModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.LowerCaseCharSequenceHashSet;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;
import io.questdb.std.Sinkable;
import io.questdb.std.str.CharSink;

public class InsertModel
implements ExecutionModel,
Mutable,
Sinkable {
    public static final ObjectFactory<InsertModel> FACTORY = InsertModel::new;
    private final LowerCaseCharSequenceHashSet columnNameSet = new LowerCaseCharSequenceHashSet();
    private final ObjList<CharSequence> columnNameList = new ObjList();
    private final ObjList<ObjList<ExpressionNode>> rowTupleValues = new ObjList();
    private final IntList endOfRowTupleValuesPositions = new IntList();
    private final IntList columnPositions = new IntList();
    private ExpressionNode tableName;
    private QueryModel queryModel;
    private int selectKeywordPosition;
    private long batchSize = -1L;
    private long commitLag = 0L;

    private InsertModel() {
    }

    public void addColumn(CharSequence columnName, int columnPosition) throws SqlException {
        int keyIndex = this.columnNameSet.keyIndex(columnName);
        if (keyIndex > -1) {
            String name = Chars.toString(columnName);
            this.columnNameSet.addAt(keyIndex, name);
            this.columnPositions.add(columnPosition);
            this.columnNameList.add(name);
            return;
        }
        throw SqlException.duplicateColumn(columnPosition, columnName);
    }

    public void addRowTupleValues(ObjList<ExpressionNode> row) {
        this.rowTupleValues.add(row);
    }

    @Override
    public void clear() {
        this.tableName = null;
        this.queryModel = null;
        this.columnNameSet.clear();
        this.columnPositions.clear();
        this.columnNameList.clear();
        int n = this.rowTupleValues.size();
        for (int i = 0; i < n; ++i) {
            this.rowTupleValues.get(i).clear();
        }
        this.rowTupleValues.clear();
        this.selectKeywordPosition = 0;
        this.endOfRowTupleValuesPositions.clear();
        this.batchSize = -1L;
        this.commitLag = 0L;
    }

    public int getColumnPosition(int columnIndex) {
        return this.columnPositions.getQuick(columnIndex);
    }

    public ObjList<CharSequence> getColumnNameList() {
        return this.columnNameList;
    }

    public ObjList<ExpressionNode> getRowTupleValues(int index) {
        return this.rowTupleValues.get(index);
    }

    public int getSelectKeywordPosition() {
        return this.selectKeywordPosition;
    }

    public void setSelectKeywordPosition(int selectKeywordPosition) {
        this.selectKeywordPosition = selectKeywordPosition;
    }

    @Override
    public int getModelType() {
        return 4;
    }

    public QueryModel getQueryModel() {
        return this.queryModel;
    }

    public void setQueryModel(QueryModel queryModel) {
        this.queryModel = queryModel;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(long batchSize) {
        this.batchSize = batchSize;
    }

    public long getCommitLag() {
        return this.commitLag;
    }

    public void setCommitLag(long lag) {
        this.commitLag = lag;
    }

    public int getRowTupleCount() {
        return this.rowTupleValues.size();
    }

    public ExpressionNode getTableName() {
        return this.tableName;
    }

    public void setTableName(ExpressionNode tableName) {
        this.tableName = tableName;
    }

    public int getEndOfRowTupleValuesPosition(int index) {
        return this.endOfRowTupleValuesPositions.get(index);
    }

    public void addEndOfRowTupleValuesPosition(int endOfValuesPosition) {
        this.endOfRowTupleValuesPositions.add(endOfValuesPosition);
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("insert");
        if (this.batchSize != -1L) {
            sink.put(" batch ").put(this.batchSize);
        }
        if (this.commitLag != 0L) {
            sink.put(" lag ").put(this.commitLag);
        }
        sink.put(" into ").put(this.tableName.token).put(' ');
        int n = this.columnNameList.size();
        if (n > 0) {
            sink.put('(');
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sink.put(", ");
                }
                sink.put(this.columnNameList.getQuick(i));
            }
            sink.put(") ");
        }
        if (this.queryModel != null) {
            this.queryModel.toSink(sink);
        } else {
            sink.put("values ");
            int s = this.rowTupleValues.size();
            for (int t = 0; t < s; ++t) {
                ObjList<ExpressionNode> rowValues = this.rowTupleValues.get(t);
                sink.put('(');
                int m = rowValues.size();
                for (int i = 0; i < m; ++i) {
                    if (i > 0) {
                        sink.put(", ");
                    }
                    sink.put(rowValues.getQuick(i));
                }
                sink.put(')');
            }
        }
    }
}

