/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.union;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.union.AbstractSetRecordCursor;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

abstract class AbstractSetRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory factoryA;
    private final RecordCursorFactory factoryB;
    private final ObjList<Function> castFunctionsA;
    private final ObjList<Function> castFunctionsB;
    protected AbstractSetRecordCursor cursor;

    public AbstractSetRecordCursorFactory(RecordMetadata metadata, RecordCursorFactory factoryA, RecordCursorFactory factoryB, ObjList<Function> castFunctionsA, ObjList<Function> castFunctionsB) {
        super(metadata);
        this.factoryA = factoryA;
        this.factoryB = factoryB;
        this.castFunctionsB = castFunctionsB;
        this.castFunctionsA = castFunctionsA;
    }

    @Override
    protected void _close() {
        Misc.free(this.factoryA);
        Misc.free(this.factoryB);
        Misc.freeObjListAndClear(this.castFunctionsA);
        Misc.freeObjListAndClear(this.castFunctionsB);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor cursorA = null;
        RecordCursor cursorB = null;
        try {
            cursorA = this.factoryA.getCursor(executionContext);
            cursorB = this.factoryB.getCursor(executionContext);
            Function.initNc(this.castFunctionsA, cursorA, executionContext);
            Function.initNc(this.castFunctionsB, cursorB, executionContext);
            this.cursor.of(cursorA, cursorB, executionContext.getCircuitBreaker());
            return this.cursor;
        }
        catch (Throwable ex) {
            Misc.free(cursorA);
            Misc.free(cursorB);
            throw ex;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.factoryA.recordCursorSupportsRandomAccess();
    }
}

