/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.VirtualFunctionDirectSymbolRecordCursor;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class VirtualRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final VirtualFunctionDirectSymbolRecordCursor cursor;
    private final ObjList<Function> functions;
    private final RecordCursorFactory baseFactory;
    private final boolean supportsRandomAccess;

    public VirtualRecordCursorFactory(RecordMetadata metadata, ObjList<Function> functions, RecordCursorFactory baseFactory) {
        super(metadata);
        this.functions = functions;
        boolean supportsRandomAccess = baseFactory.recordCursorSupportsRandomAccess();
        int n = functions.size();
        for (int i = 0; i < n; ++i) {
            if (functions.getQuick(i).supportsRandomAccess()) continue;
            supportsRandomAccess = false;
            break;
        }
        this.supportsRandomAccess = supportsRandomAccess;
        this.cursor = new VirtualFunctionDirectSymbolRecordCursor(functions, supportsRandomAccess);
        this.baseFactory = baseFactory;
    }

    @Override
    protected void _close() {
        Misc.freeObjList(this.functions);
        Misc.free(this.baseFactory);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.baseFactory.usesCompiledFilter();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor cursor = this.baseFactory.getCursor(executionContext);
        try {
            Function.init(this.functions, cursor, executionContext);
            this.cursor.of(cursor);
            return this.cursor;
        }
        catch (Throwable th) {
            cursor.close();
            throw th;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.supportsRandomAccess;
    }

    @Override
    public boolean supportsUpdateRowId(CharSequence tableName) {
        return this.baseFactory.supportsUpdateRowId(tableName);
    }

    @Override
    public boolean hasDescendingOrder() {
        return this.baseFactory.hasDescendingOrder();
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("VirtualRecordCursorFactory");
        sink.attr("supportsRandomAccess");
        sink.val(this.supportsRandomAccess);
        sink.attr("functions");
        sink.val(this.functions);
        sink.child(this.baseFactory);
    }
}

