/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.griffin.engine.table.SymbolFunctionRowCursorFactory;

public class SymbolIndexRowCursorFactory
implements SymbolFunctionRowCursorFactory {
    private final int columnIndex;
    private int symbolKey;
    private final boolean cachedIndexReaderCursor;
    private final int indexDirection;
    private final Function symbolFunction;

    public SymbolIndexRowCursorFactory(int columnIndex, int symbolKey, boolean cachedIndexReaderCursor, int indexDirection, Function symbolFunction) {
        this.columnIndex = columnIndex;
        this.symbolKey = TableUtils.toIndexKey(symbolKey);
        this.cachedIndexReaderCursor = cachedIndexReaderCursor;
        this.indexDirection = indexDirection;
        this.symbolFunction = symbolFunction;
    }

    @Override
    public void of(int symbolKey) {
        this.symbolKey = TableUtils.toIndexKey(symbolKey);
    }

    @Override
    public RowCursor getCursor(DataFrame dataFrame) {
        return dataFrame.getBitmapIndexReader(this.columnIndex, this.indexDirection).getCursor(this.cachedIndexReaderCursor, this.symbolKey, dataFrame.getRowLo(), dataFrame.getRowHi() - 1L);
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public boolean isUsingIndex() {
        return true;
    }

    @Override
    public Function getFunction() {
        return this.symbolFunction;
    }
}

