/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;

public class ShowColumnsRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final RecordMetadata METADATA;
    private static final int N_NAME_COL = 0;
    private static final int N_TYPE_COL = 1;
    private static final int N_INDEXED_COL = 2;
    private static final int N_INDEX_BLOCK_CAPACITY_COL = 3;
    private static final int N_SYMBOL_CACHED_COL = 4;
    private static final int N_SYMBOL_CAPACITY_COL = 5;
    private static final int N_DESIGNATED_COL = 6;
    private final ShowColumnsCursor cursor = new ShowColumnsCursor();
    private final CharSequence tableName;

    public ShowColumnsRecordCursorFactory(CharSequence tableName) {
        super(METADATA);
        this.tableName = tableName.toString();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        return this.cursor.of(executionContext);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("column", 1L, 11));
        metadata.add(new TableColumnMetadata("type", 2L, 11));
        metadata.add(new TableColumnMetadata("indexed", 3L, 1));
        metadata.add(new TableColumnMetadata("indexBlockCapacity", 4L, 5));
        metadata.add(new TableColumnMetadata("symbolCached", 5L, 1));
        metadata.add(new TableColumnMetadata("symbolCapacity", 6L, 5));
        metadata.add(new TableColumnMetadata("designated", 7L, 1));
        METADATA = metadata;
    }

    private class ShowColumnsCursor
    implements RecordCursor {
        private final ShowColumnsRecord record = new ShowColumnsRecord();
        private TableReader reader;
        private int columnIndex;

        private ShowColumnsCursor() {
        }

        @Override
        public void close() {
            if (null != this.reader) {
                this.reader.close();
                this.reader = null;
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            ++this.columnIndex;
            if (this.columnIndex < this.reader.getMetadata().getColumnCount()) {
                return true;
            }
            --this.columnIndex;
            return false;
        }

        @Override
        public Record getRecordB() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toTop() {
            this.columnIndex = -1;
        }

        @Override
        public long size() {
            return -1L;
        }

        private ShowColumnsCursor of(SqlExecutionContext executionContext) {
            this.reader = executionContext.getCairoEngine().getReader(executionContext.getCairoSecurityContext(), ShowColumnsRecordCursorFactory.this.tableName);
            this.toTop();
            return this;
        }

        public class ShowColumnsRecord
        implements Record {
            @Override
            public boolean getBool(int col) {
                if (col == 2) {
                    return ShowColumnsCursor.this.reader.getMetadata().isColumnIndexed(ShowColumnsCursor.this.columnIndex);
                }
                if (col == 4) {
                    if (ColumnType.isSymbol(ShowColumnsCursor.this.reader.getMetadata().getColumnType(ShowColumnsCursor.this.columnIndex))) {
                        return ShowColumnsCursor.this.reader.getSymbolMapReader(ShowColumnsCursor.this.columnIndex).isCached();
                    }
                    return false;
                }
                if (col == 6) {
                    return ShowColumnsCursor.this.reader.getMetadata().getTimestampIndex() == ShowColumnsCursor.this.columnIndex;
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public int getInt(int col) {
                if (col == 3) {
                    return ShowColumnsCursor.this.reader.getMetadata().getIndexValueBlockCapacity(ShowColumnsCursor.this.columnIndex);
                }
                if (col == 5) {
                    if (ColumnType.isSymbol(ShowColumnsCursor.this.reader.getMetadata().getColumnType(ShowColumnsCursor.this.columnIndex))) {
                        return ShowColumnsCursor.this.reader.getSymbolMapReader(ShowColumnsCursor.this.columnIndex).getSymbolCapacity();
                    }
                    return 0;
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public CharSequence getStr(int col) {
                if (col == 0) {
                    return ShowColumnsCursor.this.reader.getMetadata().getColumnName(ShowColumnsCursor.this.columnIndex);
                }
                if (col == 1) {
                    return ColumnType.nameOf(ShowColumnsCursor.this.reader.getMetadata().getColumnType(ShowColumnsCursor.this.columnIndex));
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStr(col);
            }

            @Override
            public int getStrLen(int col) {
                return this.getStr(col).length();
            }
        }
    }
}

