/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.StringLongTuplesRecordCursor;
import io.questdb.std.MemoryTag;
import io.questdb.std.Unsafe;

public final class MemoryMetricsRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final RecordMetadata METADATA;
    private static final int METRIC_COUNT = 43;
    private static final String[] KEYS;
    private final StringLongTuplesRecordCursor cursor = new StringLongTuplesRecordCursor();
    private final long[] values = new long[43];

    public MemoryMetricsRecordCursorFactory() {
        super(METADATA);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        MemoryMetricsRecordCursorFactory.collectMetrics(this.values);
        this.cursor.of(KEYS, this.values);
        return this.cursor;
    }

    private static void collectMetrics(long[] collector) {
        assert (collector.length == 43);
        collector[0] = Unsafe.getMemUsed();
        for (int i = 0; i < 42; ++i) {
            collector[i + 1] = Unsafe.getMemUsedByTag(i);
        }
    }

    static {
        KEYS = new String[43];
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(0, new TableColumnMetadata("memory_tag", 0L, 11));
        metadata.add(1, new TableColumnMetadata("bytes", 1L, 6));
        METADATA = metadata;
        MemoryMetricsRecordCursorFactory.KEYS[0] = "TOTAL_USED";
        for (int i = 0; i < 42; ++i) {
            MemoryMetricsRecordCursorFactory.KEYS[i + 1] = MemoryTag.nameOf(i);
        }
    }
}

