/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.std.IntList;
import org.jetbrains.annotations.NotNull;

class LatestByValueFilteredRecordCursor
extends AbstractDataFrameRecordCursor {
    private final int columnIndex;
    private final int symbolKey;
    private final Function filter;
    private boolean empty;
    private boolean hasNext;

    public LatestByValueFilteredRecordCursor(int columnIndex, int symbolKey, @NotNull Function filter, @NotNull IntList columnIndexes) {
        super(columnIndexes);
        this.columnIndex = columnIndex;
        this.symbolKey = symbolKey;
        this.filter = filter;
    }

    @Override
    public void close() {
        this.dataFrameCursor.close();
    }

    @Override
    public void toTop() {
        this.hasNext = !this.empty;
        this.filter.toTop();
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext) {
            this.hasNext = false;
            return true;
        }
        return false;
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    void of(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.dataFrameCursor = dataFrameCursor;
        this.recordA.of(dataFrameCursor.getTableReader());
        this.recordB.of(dataFrameCursor.getTableReader());
        this.filter.init(this, executionContext);
        this.findRecord();
        this.hasNext = !this.empty;
    }

    private void findRecord() {
        DataFrame frame;
        this.empty = true;
        block0: while ((frame = this.dataFrameCursor.next()) != null) {
            long rowLo = frame.getRowLo();
            long rowHi = frame.getRowHi() - 1L;
            this.recordA.jumpTo(frame.getPartitionIndex(), rowHi);
            for (long row = rowHi; row >= rowLo; --row) {
                int key;
                this.recordA.setRecordIndex(row);
                if (!this.filter.getBool(this.recordA) || (key = this.recordA.getInt(this.columnIndex)) != this.symbolKey) continue;
                this.empty = false;
                break block0;
            }
        }
    }
}

