/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.DirectLongList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class LatestByRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final int RECORD_INDEX_VALUE_IDX = 0;
    private static final int TIMESTAMP_VALUE_IDX = 1;
    private final RecordCursorFactory base;
    private final int timestampIndex;
    private final LatestByRecordCursor cursor;
    private final RecordSink recordSink;
    private final DirectLongList rowIndexes;
    private final long rowIndexesInitialCapacity;

    public LatestByRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordCursorFactory base, @NotNull RecordSink recordSink, @NotNull ColumnTypes columnTypes, int timestampIndex) {
        super(base.getMetadata());
        assert (!base.recordCursorSupportsRandomAccess());
        this.base = base;
        this.recordSink = recordSink;
        ArrayColumnTypes mapValueTypes = new ArrayColumnTypes();
        mapValueTypes.add(0, 6);
        mapValueTypes.add(1, 8);
        Map latestByMap = MapFactory.createMap(configuration, columnTypes, mapValueTypes);
        this.cursor = new LatestByRecordCursor(latestByMap);
        this.timestampIndex = timestampIndex;
        this.rowIndexesInitialCapacity = configuration.getSqlLatestByRowCount();
        this.rowIndexes = new DirectLongList(this.rowIndexesInitialCapacity, 19);
    }

    @Override
    protected void _close() {
        this.base.close();
        this.rowIndexes.close();
        this.cursor.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        if (!this.cursor.isOpen) {
            this.cursor.isOpen = true;
            this.cursor.latestByMap.reopen();
        }
        SqlExecutionCircuitBreaker circuitBreaker = executionContext.getCircuitBreaker();
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            Record baseRecord = baseCursor.getRecord();
            this.buildMap(circuitBreaker, baseCursor, baseRecord);
            try (RecordCursor mapCursor = this.cursor.latestByMap.getCursor();){
                MapRecord mapRecord = (MapRecord)mapCursor.getRecord();
                while (mapCursor.hasNext()) {
                    circuitBreaker.statefulThrowExceptionIfTripped();
                    MapValue value = mapRecord.getValue();
                    long rowId = value.getLong(0);
                    this.rowIndexes.add(rowId);
                }
            }
            this.rowIndexes.sortAsUnsigned();
            baseCursor.toTop();
            this.cursor.latestByMap.close();
            this.cursor.of(baseCursor, this.rowIndexes, this.rowIndexesInitialCapacity, circuitBreaker);
            return this.cursor;
        }
        catch (Throwable e) {
            baseCursor.close();
            throw e;
        }
    }

    private void buildMap(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor baseCursor, Record baseRecord) {
        long index = 0L;
        while (baseCursor.hasNext()) {
            circuitBreaker.statefulThrowExceptionIfTripped();
            MapKey key = this.cursor.latestByMap.withKey();
            this.recordSink.copy(baseRecord, key);
            MapValue value = key.createValue();
            if (value.isNew()) {
                value.putLong(0, index);
                value.putTimestamp(1, baseRecord.getTimestamp(this.timestampIndex));
            } else {
                long prevTimestamp = value.getTimestamp(1);
                long newTimestamp = baseRecord.getTimestamp(this.timestampIndex);
                if (newTimestamp >= prevTimestamp) {
                    value.putLong(0, index);
                    value.putTimestamp(1, newTimestamp);
                }
            }
            ++index;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    private static class LatestByRecordCursor
    implements NoRandomAccessRecordCursor {
        private final Map latestByMap;
        private RecordCursor baseCursor;
        private Record baseRecord;
        private long index = 0L;
        private DirectLongList rowIndexes;
        private long rowIndexesPos = 0L;
        private long rowIndexesCapacityThreshold;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean isOpen;

        public LatestByRecordCursor(Map latestByMap) {
            this.latestByMap = latestByMap;
            this.isOpen = true;
        }

        public void of(RecordCursor baseCursor, DirectLongList rowIndexes, long rowIndexesCapacityThreshold, SqlExecutionCircuitBreaker circuitBreaker) {
            this.baseCursor = baseCursor;
            this.baseRecord = baseCursor.getRecord();
            this.rowIndexes = rowIndexes;
            this.circuitBreaker = circuitBreaker;
            this.index = 0L;
            this.rowIndexesPos = 0L;
            this.rowIndexesCapacityThreshold = rowIndexesCapacityThreshold;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                Misc.free(this.baseCursor);
                this.rowIndexes.clear();
                if (this.rowIndexes.getCapacity() > this.rowIndexesCapacityThreshold) {
                    this.rowIndexes.setCapacity(this.rowIndexesCapacityThreshold);
                }
                this.latestByMap.close();
            }
        }

        @Override
        public Record getRecord() {
            return this.baseRecord;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.baseCursor.getSymbolTable(columnIndex);
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.baseCursor.newSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() {
            if (this.rowIndexesPos == this.rowIndexes.size()) {
                return false;
            }
            long nextIndex = this.rowIndexes.get(this.rowIndexesPos++);
            while (this.baseCursor.hasNext()) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                if (this.index++ != nextIndex) continue;
                return true;
            }
            return false;
        }

        @Override
        public void toTop() {
            this.baseCursor.toTop();
            this.index = 0L;
            this.rowIndexesPos = 0L;
        }

        @Override
        public long size() {
            return this.rowIndexes.size();
        }
    }
}

